/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.generator;

import com.google.common.base.Preconditions;
import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.craftbukkit.v1_21_R7.CraftHeightMap;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBiome;
import org.bukkit.craftbukkit.v1_21_R7.generator.CraftChunkData;
import org.bukkit.craftbukkit.v1_21_R7.generator.InternalChunkGenerator;
import org.bukkit.craftbukkit.v1_21_R7.generator.OldCraftChunkData;
import org.bukkit.craftbukkit.v1_21_R7.util.RandomSourceWrapper;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.generator.WorldInfo;

public class CustomChunkGenerator
extends InternalChunkGenerator {
    private final eqg delegate;
    private final ChunkGenerator generator;
    private final axf world;
    private final Random random = new Random();
    private boolean newApi;
    private boolean implementBaseHeight = true;

    public CustomChunkGenerator(axf world, eqg delegate, ChunkGenerator generator) {
        super(delegate.d(), delegate.d);
        this.world = world;
        this.delegate = delegate;
        this.generator = generator;
    }

    public eqg getDelegate() {
        return this.delegate;
    }

    private static evp getSeededRandom() {
        return new evp(new eur(0L));
    }

    @Override
    public dxs d() {
        return this.delegate.d();
    }

    @Override
    public int g() {
        return this.delegate.g();
    }

    @Override
    public int f() {
        return this.delegate.f();
    }

    @Override
    public void a(jr iregistrycustom, eqh chunkgeneratorstructurestate, dxk structuremanager, eqf ichunkaccess, fjr structuretemplatemanager, amt<dwo> resourcekey) {
        evp random = CustomChunkGenerator.getSeededRandom();
        int x2 = ichunkaccess.f().h;
        int z2 = ichunkaccess.f().i;
        random.b(bgj.b(x2, "should-structures".hashCode(), z2) ^ this.world.J());
        if (this.generator.shouldGenerateStructures((WorldInfo)this.world.getWorld(), (Random)new RandomSourceWrapper.RandomWrapper(random), x2, z2)) {
            super.a(iregistrycustom, chunkgeneratorstructurestate, structuremanager, ichunkaccess, structuretemplatemanager, resourcekey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void a(axn regionlimitedworldaccess, dxk structuremanager, eve randomstate, eqf ichunkaccess) {
        ChunkGenerator.ChunkData data;
        int z2;
        int x2;
        block15: {
            evp random = CustomChunkGenerator.getSeededRandom();
            x2 = ichunkaccess.f().h;
            z2 = ichunkaccess.f().i;
            random.b(bgj.b(x2, "should-surface".hashCode(), z2) ^ regionlimitedworldaccess.J());
            if (this.generator.shouldGenerateSurface((WorldInfo)this.world.getWorld(), (Random)new RandomSourceWrapper.RandomWrapper(random), x2, z2)) {
                this.delegate.a(regionlimitedworldaccess, structuremanager, randomstate, ichunkaccess);
            }
            CraftChunkData chunkData = new CraftChunkData(this.world.getWorld(), ichunkaccess);
            random.b((long)x2 * 341873128712L + (long)z2 * 132897987541L);
            this.generator.generateSurface((WorldInfo)this.world.getWorld(), (Random)new RandomSourceWrapper.RandomWrapper(random), x2, z2, (ChunkGenerator.ChunkData)chunkData);
            if (this.generator.shouldGenerateBedrock()) {
                random = CustomChunkGenerator.getSeededRandom();
                random.b((long)x2 * 341873128712L + (long)z2 * 132897987541L);
            }
            random = CustomChunkGenerator.getSeededRandom();
            random.b((long)x2 * 341873128712L + (long)z2 * 132897987541L);
            this.generator.generateBedrock((WorldInfo)this.world.getWorld(), (Random)new RandomSourceWrapper.RandomWrapper(random), x2, z2, (ChunkGenerator.ChunkData)chunkData);
            chunkData.breakLink();
            if (this.newApi) {
                return;
            }
            this.random.setSeed((long)x2 * 341873128712L + (long)z2 * 132897987541L);
            CustomBiomeGrid biomegrid = new CustomBiomeGrid(ichunkaccess);
            try {
                if (this.generator.isParallelCapable()) {
                    data = this.generator.generateChunkData((World)this.world.getWorld(), this.random, x2, z2, (ChunkGenerator.BiomeGrid)biomegrid);
                    break block15;
                }
                CustomChunkGenerator customChunkGenerator = this;
                synchronized (customChunkGenerator) {
                    data = this.generator.generateChunkData((World)this.world.getWorld(), this.random, x2, z2, (ChunkGenerator.BiomeGrid)biomegrid);
                }
            }
            catch (UnsupportedOperationException exception) {
                this.newApi = true;
                return;
            }
        }
        Preconditions.checkArgument((boolean)(data instanceof OldCraftChunkData), (String)"Plugins must use createChunkData(World) rather than implementing ChunkData: %s", (Object)data);
        OldCraftChunkData craftData = (OldCraftChunkData)data;
        eqr[] sections = craftData.getRawChunkData();
        eqr[] csect = ichunkaccess.d();
        int scnt = Math.min(csect.length, sections.length);
        for (int sec = 0; sec < scnt; ++sec) {
            if (sections[sec] == null) continue;
            eqr section = sections[sec];
            eqr oldSection = csect[sec];
            for (int biomeX = 0; biomeX < 4; ++biomeX) {
                for (int biomeY = 0; biomeY < 4; ++biomeY) {
                    for (int biomeZ = 0; biomeZ < 4; ++biomeZ) {
                        section.setBiome(biomeX, biomeY, biomeZ, oldSection.c(biomeX, biomeY, biomeZ));
                    }
                }
            }
            csect[sec] = section;
        }
        if (craftData.getTiles() != null) {
            for (is pos : craftData.getTiles()) {
                int tz2;
                int ty2;
                int tx2 = pos.u();
                eoh block = craftData.getTypeId(tx2, ty2 = pos.v(), tz2 = pos.w());
                if (!block.x()) continue;
                elb tile = ((ecn)((Object)block.b())).a(new is((x2 << 4) + tx2, ty2, (z2 << 4) + tz2), block);
                ichunkaccess.a(tile);
            }
        }
    }

    @Override
    public void a(axn regionlimitedworldaccess, long seed, eve randomstate, dxq biomemanager, dxk structuremanager, eqf ichunkaccess) {
        evp random = CustomChunkGenerator.getSeededRandom();
        int x2 = ichunkaccess.f().h;
        int z2 = ichunkaccess.f().i;
        random.b(bgj.b(x2, "should-caves".hashCode(), z2) ^ regionlimitedworldaccess.J());
        if (this.generator.shouldGenerateCaves((WorldInfo)this.world.getWorld(), (Random)new RandomSourceWrapper.RandomWrapper(random), x2, z2)) {
            this.delegate.a(regionlimitedworldaccess, seed, randomstate, biomemanager, structuremanager, ichunkaccess);
        }
        CraftChunkData chunkData = new CraftChunkData(this.world.getWorld(), ichunkaccess);
        random.a(seed, 0, 0);
        this.generator.generateCaves((WorldInfo)this.world.getWorld(), (Random)new RandomSourceWrapper.RandomWrapper(random), x2, z2, (ChunkGenerator.ChunkData)chunkData);
        chunkData.breakLink();
    }

    @Override
    public CompletableFuture<eqf> a(evs blender, eve randomstate, dxk structuremanager, eqf ichunkaccess) {
        CompletableFuture<eqf> future = null;
        evp random = CustomChunkGenerator.getSeededRandom();
        int x2 = ichunkaccess.f().h;
        int z2 = ichunkaccess.f().i;
        random.b(bgj.b(x2, "should-noise".hashCode(), z2) ^ this.world.J());
        if (this.generator.shouldGenerateNoise((WorldInfo)this.world.getWorld(), (Random)new RandomSourceWrapper.RandomWrapper(random), x2, z2)) {
            future = this.delegate.a(blender, randomstate, structuremanager, ichunkaccess);
        }
        Function<eqf, eqf> function = ichunkaccess1 -> {
            CraftChunkData chunkData = new CraftChunkData(this.world.getWorld(), (eqf)ichunkaccess1);
            random.b((long)x2 * 341873128712L + (long)z2 * 132897987541L);
            this.generator.generateNoise((WorldInfo)this.world.getWorld(), (Random)new RandomSourceWrapper.RandomWrapper(random), x2, z2, (ChunkGenerator.ChunkData)chunkData);
            chunkData.breakLink();
            return ichunkaccess1;
        };
        return future == null ? CompletableFuture.supplyAsync(() -> (eqf)function.apply(ichunkaccess), bhs.h()) : future.thenApply(function);
    }

    @Override
    public int a(int i2, int j2, euq.a heightmap_type, dwq levelheightaccessor, eve randomstate) {
        if (this.implementBaseHeight) {
            try {
                evp random = CustomChunkGenerator.getSeededRandom();
                int xChunk = i2 >> 4;
                int zChunk = j2 >> 4;
                random.b((long)xChunk * 341873128712L + (long)zChunk * 132897987541L);
                return this.generator.getBaseHeight((WorldInfo)this.world.getWorld(), (Random)new RandomSourceWrapper.RandomWrapper(random), i2, j2, CraftHeightMap.fromNMS(heightmap_type));
            }
            catch (UnsupportedOperationException exception) {
                this.implementBaseHeight = false;
            }
        }
        return this.delegate.a(i2, j2, heightmap_type, levelheightaccessor, randomstate);
    }

    @Override
    public void a(dxn generatoraccessseed, eqf ichunkaccess, dxk structuremanager) {
        evp random = CustomChunkGenerator.getSeededRandom();
        int x2 = ichunkaccess.f().h;
        int z2 = ichunkaccess.f().i;
        random.b(bgj.b(x2, "should-decoration".hashCode(), z2) ^ generatoraccessseed.J());
        super.applyBiomeDecoration(generatoraccessseed, ichunkaccess, structuremanager, this.generator.shouldGenerateDecorations((WorldInfo)this.world.getWorld(), (Random)new RandomSourceWrapper.RandomWrapper(random), x2, z2));
    }

    @Override
    public void a(List<String> list, eve randomstate, is blockposition) {
        this.delegate.a(list, randomstate, blockposition);
    }

    @Override
    public void a(axn regionlimitedworldaccess) {
        evp random = CustomChunkGenerator.getSeededRandom();
        int x2 = regionlimitedworldaccess.b().h;
        int z2 = regionlimitedworldaccess.b().i;
        random.b(bgj.b(x2, "should-mobs".hashCode(), z2) ^ regionlimitedworldaccess.J());
        if (this.generator.shouldGenerateMobs((WorldInfo)this.world.getWorld(), (Random)new RandomSourceWrapper.RandomWrapper(random), x2, z2)) {
            this.delegate.a(regionlimitedworldaccess);
        }
    }

    @Override
    public int a(dwq levelheightaccessor) {
        return this.delegate.a(levelheightaccessor);
    }

    @Override
    public int e() {
        return this.delegate.e();
    }

    @Override
    public dxa a(int i2, int j2, dwq levelheightaccessor, eve randomstate) {
        return this.delegate.a(i2, j2, levelheightaccessor, randomstate);
    }

    @Override
    protected MapCodec<? extends eqg> b() {
        return MapCodec.unit(null);
    }

    @Deprecated
    private class CustomBiomeGrid
    implements ChunkGenerator.BiomeGrid {
        private final eqf biome;

        public CustomBiomeGrid(eqf biome) {
            this.biome = biome;
        }

        public Biome getBiome(int x2, int z2) {
            return this.getBiome(x2, 0, z2);
        }

        public void setBiome(int x2, int z2, Biome bio2) {
            for (int y2 = CustomChunkGenerator.this.world.getWorld().getMinHeight(); y2 < CustomChunkGenerator.this.world.getWorld().getMaxHeight(); y2 += 4) {
                this.setBiome(x2, y2, z2, bio2);
            }
        }

        public Biome getBiome(int x2, int y2, int z2) {
            return CraftBiome.minecraftHolderToBukkit(this.biome.getNoiseBiome(x2 >> 2, y2 >> 2, z2 >> 2));
        }

        public void setBiome(int x2, int y2, int z2, Biome bio2) {
            Preconditions.checkArgument((bio2 != Biome.CUSTOM ? 1 : 0) != 0, (String)"Cannot set the biome to %s", (Object)bio2);
            this.biome.setBiome(x2 >> 2, y2 >> 2, z2 >> 2, CraftBiome.bukkitToMinecraftHolder(bio2));
        }
    }
}

