/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.generator.structure;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import org.bukkit.craftbukkit.v1_21_R7.generator.structure.CraftStructure;
import org.bukkit.craftbukkit.v1_21_R7.generator.structure.CraftStructurePiece;
import org.bukkit.generator.structure.GeneratedStructure;
import org.bukkit.generator.structure.Structure;
import org.bukkit.generator.structure.StructurePiece;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.util.BoundingBox;

public class CraftGeneratedStructure
implements GeneratedStructure {
    private final ffw handle;
    private List<StructurePiece> pieces;

    public CraftGeneratedStructure(ffw handle) {
        this.handle = handle;
    }

    public BoundingBox getBoundingBox() {
        ffg bb2 = this.handle.a();
        return new BoundingBox((double)bb2.h(), (double)bb2.i(), (double)bb2.j(), (double)bb2.k(), (double)bb2.l(), (double)bb2.m());
    }

    public Structure getStructure() {
        return CraftStructure.minecraftToBukkit(this.handle.h());
    }

    public Collection<StructurePiece> getPieces() {
        if (this.pieces == null) {
            ImmutableList.Builder builder = new ImmutableList.Builder();
            for (ffs piece : this.handle.i()) {
                builder.add((Object)new CraftStructurePiece(piece));
            }
            this.pieces = builder.build();
        }
        return this.pieces;
    }

    public PersistentDataContainer getPersistentDataContainer() {
        return this.handle.persistentDataContainer;
    }
}

