/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.inventory;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemStack;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;

public class CraftInventoryCrafting
extends CraftInventory
implements CraftingInventory {
    private final ccv resultInventory;

    public CraftInventoryCrafting(dib inventory, ccv resultInventory) {
        super(inventory);
        this.resultInventory = resultInventory;
    }

    public ccv getResultInventory() {
        return this.resultInventory;
    }

    public dib getMatrixInventory() {
        return (dib)this.inventory;
    }

    @Override
    public int getSize() {
        return this.getResultInventory().b() + this.getMatrixInventory().b();
    }

    @Override
    public void setContents(ItemStack[] items) {
        Preconditions.checkArgument((items.length <= this.getSize() ? 1 : 0) != 0, (String)"Invalid inventory size (%s); expected %s or less", (int)items.length, (int)this.getSize());
        this.setContents(items[0], Arrays.copyOfRange(items, 1, items.length));
    }

    @Override
    public ItemStack[] getContents() {
        ItemStack[] items = new ItemStack[this.getSize()];
        List<dlt> mcResultItems = this.getResultInventory().getContents();
        int i2 = 0;
        for (i2 = 0; i2 < mcResultItems.size(); ++i2) {
            items[i2] = CraftItemStack.asCraftMirror(mcResultItems.get(i2));
        }
        List<dlt> mcItems = this.getMatrixInventory().getContents();
        for (int j2 = 0; j2 < mcItems.size(); ++j2) {
            items[i2 + j2] = CraftItemStack.asCraftMirror(mcItems.get(j2));
        }
        return items;
    }

    public void setContents(ItemStack result, ItemStack[] contents) {
        this.setResult(result);
        this.setMatrix(contents);
    }

    @Override
    public CraftItemStack getItem(int index) {
        if (index < this.getResultInventory().b()) {
            dlt item = this.getResultInventory().a(index);
            return item.f() ? null : CraftItemStack.asCraftMirror(item);
        }
        dlt item = this.getMatrixInventory().a(index - this.getResultInventory().b());
        return item.f() ? null : CraftItemStack.asCraftMirror(item);
    }

    @Override
    public void setItem(int index, ItemStack item) {
        if (index < this.getResultInventory().b()) {
            this.getResultInventory().a(index, CraftItemStack.asNMSCopy(item));
        } else {
            this.getMatrixInventory().a(index - this.getResultInventory().b(), CraftItemStack.asNMSCopy(item));
        }
    }

    public ItemStack[] getMatrix() {
        List<dlt> matrix = this.getMatrixInventory().getContents();
        return this.asCraftMirror(matrix);
    }

    public ItemStack getResult() {
        dlt item = this.getResultInventory().a(0);
        if (!item.f()) {
            return CraftItemStack.asCraftMirror(item);
        }
        return null;
    }

    public void setMatrix(ItemStack[] contents) {
        Preconditions.checkArgument((contents.length <= this.getMatrixInventory().b() ? 1 : 0) != 0, (String)"Invalid inventory size (%s); expected %s or less", (int)contents.length, (int)this.getMatrixInventory().b());
        for (int i2 = 0; i2 < this.getMatrixInventory().b(); ++i2) {
            if (i2 < contents.length) {
                this.getMatrixInventory().a(i2, CraftItemStack.asNMSCopy(contents[i2]));
                continue;
            }
            this.getMatrixInventory().a(i2, dlt.l);
        }
    }

    public void setResult(ItemStack item) {
        List<dlt> contents = this.getResultInventory().getContents();
        contents.set(0, CraftItemStack.asNMSCopy(item));
    }

    public Recipe getRecipe() {
        dqx<?> recipe = this.getMatrixInventory().getCurrentRecipe();
        return recipe == null ? null : recipe.toBukkitRecipe();
    }
}

