/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.inventory;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.craftbukkit.v1_21_R7.enchantments.CraftEnchantment;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemFactory;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemType;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftMetaItem;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftLegacy;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftMagicNumbers;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.material.MaterialData;
import org.jetbrains.annotations.ApiStatus;

@DelegateDeserialization(value=ItemStack.class)
public final class CraftItemStack
extends ItemStack {
    dlt handle;
    private boolean isForInventoryDrop;

    public static dlt asNMSCopy(ItemStack original) {
        if (original instanceof CraftItemStack) {
            CraftItemStack stack = (CraftItemStack)original;
            return stack.handle == null ? dlt.l : stack.handle.v();
        }
        if (original == null || original.getType() == Material.AIR) {
            return dlt.l;
        }
        dlp item = CraftItemType.bukkitToMinecraft(original.getType());
        if (item == null) {
            return dlt.l;
        }
        dlt stack = new dlt(item, original.getAmount());
        if (original.hasItemMeta()) {
            CraftItemStack.setItemMeta(stack, original.getItemMeta());
        }
        return stack;
    }

    public static dlt copyNMSStack(dlt original, int amount) {
        dlt stack = original.v();
        stack.e(amount);
        return stack;
    }

    public static ItemStack asBukkitCopy(dlt original) {
        if (original.f()) {
            return new ItemStack(Material.AIR);
        }
        ItemStack stack = new ItemStack(CraftItemType.minecraftToBukkit(original.h()), original.N());
        if (CraftItemStack.hasItemMeta(original)) {
            stack.setItemMeta(CraftItemStack.getItemMeta(original));
        }
        return stack;
    }

    public static CraftItemStack asCraftMirror(dlt original) {
        return new CraftItemStack(original == null || original.f() ? null : original);
    }

    public static CraftItemStack asCraftCopy(ItemStack original) {
        if (original instanceof CraftItemStack) {
            CraftItemStack stack = (CraftItemStack)original;
            return new CraftItemStack(stack.handle == null ? null : stack.handle.v());
        }
        return new CraftItemStack(original);
    }

    public static CraftItemStack asNewCraftStack(dlp item) {
        return CraftItemStack.asNewCraftStack(item, 1);
    }

    public static CraftItemStack asNewCraftStack(dlp item, int amount) {
        return new CraftItemStack(CraftItemType.minecraftToBukkit(item), amount, 0, null);
    }

    public static cg asCriterionConditionItem(ItemStack original) {
        dlt nms = CraftItemStack.asNMSCopy(original);
        kc predicate = kc.a(kj.a(kf.a, nms.d()));
        return new cg(Optional.of(jh.a(nms.i())), cq.d.c, new bh(predicate, Collections.emptyMap()));
    }

    private CraftItemStack(dlt item) {
        this.handle = item;
    }

    private CraftItemStack(ItemStack item) {
        this(item.getType(), item.getAmount(), item.getDurability(), item.hasItemMeta() ? item.getItemMeta() : null);
    }

    private CraftItemStack(Material type, int amount, short durability, ItemMeta itemMeta) {
        this.setType(type);
        this.setAmount(amount);
        this.setDurability(durability);
        this.setItemMeta(itemMeta);
    }

    @ApiStatus.Internal
    public boolean isForInventoryDrop() {
        return this.isForInventoryDrop;
    }

    @ApiStatus.Internal
    public ItemStack markForInventoryDrop() {
        this.isForInventoryDrop = true;
        return this;
    }

    public MaterialData getData() {
        return this.handle != null ? CraftMagicNumbers.getMaterialData(this.handle.h()) : super.getData();
    }

    public Material getType() {
        return this.handle != null ? CraftItemType.minecraftToBukkit(this.handle.h()) : Material.AIR;
    }

    public void setType(Material type) {
        if (this.getType() == type) {
            return;
        }
        if (type == Material.AIR) {
            this.handle = null;
        } else if (CraftItemType.bukkitToMinecraft(type) == null) {
            this.handle = null;
        } else if (this.handle == null) {
            this.handle = new dlt(CraftItemType.bukkitToMinecraft(type), 1);
        } else {
            this.handle.setItem(CraftItemType.bukkitToMinecraft(type));
            if (this.hasItemMeta()) {
                CraftItemStack.setItemMeta(this.handle, CraftItemStack.getItemMeta(this.handle));
            }
        }
        this.setData(null);
    }

    public int getAmount() {
        return this.handle != null ? this.handle.N() : 0;
    }

    public void setAmount(int amount) {
        if (this.handle == null) {
            return;
        }
        this.handle.e(amount);
        if (amount == 0) {
            this.handle = null;
        }
    }

    public void setDurability(short durability) {
        if (this.handle != null) {
            this.handle.b(durability);
        }
    }

    public short getDurability() {
        if (this.handle != null) {
            return (short)this.handle.o();
        }
        return -1;
    }

    public int getMaxStackSize() {
        return this.handle == null ? Material.AIR.getMaxStackSize() : this.handle.k();
    }

    public void addUnsafeEnchantment(Enchantment ench, int level) {
        Preconditions.checkArgument((ench != null ? 1 : 0) != 0, (Object)"Enchantment cannot be null");
        if (!CraftItemStack.makeTag(this.handle)) {
            return;
        }
        dsu list = CraftItemStack.getEnchantmentList(this.handle);
        if (list == null) {
            list = dsu.a;
        }
        dsu.a listCopy = new dsu.a(list);
        listCopy.a(CraftEnchantment.bukkitToMinecraftHolder(ench), level);
        this.handle.b(ki.o, listCopy.b());
    }

    static boolean makeTag(dlt item) {
        return item != null;
    }

    public boolean containsEnchantment(Enchantment ench) {
        return this.getEnchantmentLevel(ench) > 0;
    }

    public int getEnchantmentLevel(Enchantment ench) {
        Preconditions.checkArgument((ench != null ? 1 : 0) != 0, (Object)"Enchantment cannot be null");
        if (this.handle == null) {
            return 0;
        }
        return dsq.a(CraftEnchantment.bukkitToMinecraftHolder(ench), this.handle);
    }

    public int removeEnchantment(Enchantment ench) {
        Preconditions.checkArgument((ench != null ? 1 : 0) != 0, (Object)"Enchantment cannot be null");
        dsu list = CraftItemStack.getEnchantmentList(this.handle);
        if (list == null) {
            return 0;
        }
        int level = this.getEnchantmentLevel(ench);
        if (level <= 0) {
            return 0;
        }
        int size = list.c();
        if (size == 1) {
            this.handle.e(ki.o);
            return level;
        }
        dsu.a listCopy = new dsu.a(list);
        listCopy.a(CraftEnchantment.bukkitToMinecraftHolder(ench), -1);
        this.handle.b(ki.o, listCopy.b());
        return level;
    }

    public void removeEnchantments() {
        this.handle.e(ki.o);
    }

    public Map<Enchantment, Integer> getEnchantments() {
        return CraftItemStack.getEnchantments(this.handle);
    }

    static Map<Enchantment, Integer> getEnchantments(dlt item) {
        dsu list;
        dsu dsu2 = list = item != null && item.F() ? item.a(ki.o) : null;
        if (list == null || list.c() == 0) {
            return ImmutableMap.of();
        }
        ImmutableMap.Builder result = ImmutableMap.builder();
        list.b().forEach(entry -> {
            jd id2 = (jd)entry.getKey();
            int level = entry.getIntValue();
            Enchantment enchant = CraftEnchantment.minecraftHolderToBukkit(id2);
            if (enchant != null) {
                result.put((Object)enchant, (Object)level);
            }
        });
        return result.build();
    }

    static dsu getEnchantmentList(dlt item) {
        return item != null && item.F() ? item.a(ki.o) : null;
    }

    public CraftItemStack clone() {
        CraftItemStack itemStack = (CraftItemStack)super.clone();
        if (this.handle != null) {
            itemStack.handle = this.handle.v();
        }
        return itemStack;
    }

    public ItemMeta getItemMeta() {
        return CraftItemStack.getItemMeta(this.handle);
    }

    public static ItemMeta getItemMeta(dlt item) {
        if (!CraftItemStack.hasItemMeta(item)) {
            return CraftItemFactory.instance().getItemMeta(CraftItemStack.getType(item));
        }
        return ((CraftItemType)CraftItemType.minecraftToBukkitNew(item.h())).getItemMeta(item);
    }

    static Material getType(dlt item) {
        return item == null ? Material.AIR : CraftItemType.minecraftToBukkit(item.h());
    }

    public boolean setItemMeta(ItemMeta itemMeta) {
        return CraftItemStack.setItemMeta(this.handle, itemMeta);
    }

    public static boolean setItemMeta(dlt item, ItemMeta itemMeta) {
        if (item == null) {
            return false;
        }
        if (CraftItemFactory.instance().equals(itemMeta, null)) {
            item.restorePatch(kg.a);
            return true;
        }
        if (!CraftItemFactory.instance().isApplicable(itemMeta, CraftItemStack.getType(item))) {
            return false;
        }
        itemMeta = CraftItemFactory.instance().asMetaFor(itemMeta, CraftItemStack.getType(item));
        if (itemMeta == null) {
            return true;
        }
        if (!((CraftMetaItem)itemMeta).isEmpty()) {
            CraftMetaItem.Applicator tag = new CraftMetaItem.Applicator();
            ((CraftMetaItem)itemMeta).applyToItem(tag);
            item.restorePatch(tag.build());
        }
        if (item.h() != null && item.p() > 0) {
            item.b(item.o());
        }
        return true;
    }

    public boolean isSimilar(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (stack == this) {
            return true;
        }
        if (!(stack instanceof CraftItemStack)) {
            return stack.getClass() == ItemStack.class && stack.isSimilar((ItemStack)this);
        }
        CraftItemStack that = (CraftItemStack)stack;
        if (this.handle == that.handle) {
            return true;
        }
        if (this.handle == null || that.handle == null) {
            return false;
        }
        Material comparisonType = CraftLegacy.fromLegacy(that.getType());
        if (comparisonType != this.getType() || this.getDurability() != that.getDurability()) {
            return false;
        }
        return this.hasItemMeta() ? that.hasItemMeta() && this.handle.a().equals(that.handle.a()) : !that.hasItemMeta();
    }

    public boolean hasItemMeta() {
        return CraftItemStack.hasItemMeta(this.handle) && !CraftItemFactory.instance().equals(this.getItemMeta(), null);
    }

    static boolean hasItemMeta(dlt item) {
        return item != null && !item.d().d();
    }
}

