/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.inventory;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.Map;
import java.util.Set;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlockStates;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftMetaItem;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftMetaShield;
import org.bukkit.craftbukkit.v1_21_R7.inventory.SerializableMeta;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.util.BlockVector;

@DelegateDeserialization(value=SerializableMeta.class)
public class CraftMetaBlockState
extends CraftMetaItem
implements BlockStateMeta {
    private static final Set<Material> SHULKER_BOX_MATERIALS = Sets.newHashSet((Object[])new Material[]{Material.SHULKER_BOX, Material.WHITE_SHULKER_BOX, Material.ORANGE_SHULKER_BOX, Material.MAGENTA_SHULKER_BOX, Material.LIGHT_BLUE_SHULKER_BOX, Material.YELLOW_SHULKER_BOX, Material.LIME_SHULKER_BOX, Material.PINK_SHULKER_BOX, Material.GRAY_SHULKER_BOX, Material.LIGHT_GRAY_SHULKER_BOX, Material.CYAN_SHULKER_BOX, Material.PURPLE_SHULKER_BOX, Material.BLUE_SHULKER_BOX, Material.BROWN_SHULKER_BOX, Material.GREEN_SHULKER_BOX, Material.RED_SHULKER_BOX, Material.BLACK_SHULKER_BOX});
    static final CraftMetaItem.ItemMetaKeyType<dpf<eld<?>>> BLOCK_ENTITY_TAG = new CraftMetaItem.ItemMetaKeyType(ki.ah, "BlockEntityTag");
    static final Codec<dpf<eld<?>>> BLOCK_ENTITY_TAG_CODEC = dpf.a(mi.k.q());
    final Material material;
    private CraftBlockEntityState<?> blockEntityTag;
    private BlockVector position;
    private uz internalTag;

    CraftMetaBlockState(CraftMetaItem meta, Material material) {
        super(meta);
        this.material = material;
        if (!(meta instanceof CraftMetaBlockState) || ((CraftMetaBlockState)meta).material != material) {
            this.blockEntityTag = null;
            return;
        }
        CraftMetaBlockState te = (CraftMetaBlockState)meta;
        this.blockEntityTag = te.blockEntityTag;
        this.position = te.position;
    }

    CraftMetaBlockState(kg tag, Material material) {
        super(tag);
        this.material = material;
        CraftMetaBlockState.getOrEmpty(tag, BLOCK_ENTITY_TAG).ifPresent(blockTag -> {
            uz nbt = (uz)BLOCK_ENTITY_TAG_CODEC.encodeStart((DynamicOps)vn.a, blockTag).getOrThrow();
            this.blockEntityTag = CraftMetaBlockState.getBlockState(material, nbt);
            if (nbt.b("x") && nbt.b("y") && nbt.b("z")) {
                this.position = new BlockVector(nbt.b("x", 0), nbt.b("y", 0), nbt.b("z", 0));
            }
        });
        if (!tag.d()) {
            CraftBlockEntityState<?> blockEntityTag = this.blockEntityTag;
            if (blockEntityTag == null) {
                blockEntityTag = CraftMetaBlockState.getBlockState(material, null);
            }
            kj map = new kj(kf.a);
            map.a(tag);
            Set<kh<?>> applied = blockEntityTag.applyComponents(map, tag);
            for (kh<?> seen : applied) {
                this.unhandledTags.clear(seen);
            }
            if (!applied.isEmpty()) {
                this.blockEntityTag = blockEntityTag;
            }
        }
    }

    CraftMetaBlockState(Map<String, Object> map) {
        super(map);
        String matName = SerializableMeta.getString(map, "blockMaterial", true);
        Material m2 = Material.getMaterial((String)matName);
        this.material = m2 != null ? m2 : Material.AIR;
        if (this.internalTag != null) {
            this.blockEntityTag = CraftMetaBlockState.getBlockState(this.material, this.internalTag);
            this.internalTag = null;
        }
        this.position = SerializableMeta.getObject(BlockVector.class, map, "blockPosition", true);
    }

    @Override
    void applyToItem(CraftMetaItem.Applicator tag) {
        super.applyToItem(tag);
        fnp nbt = null;
        if (this.blockEntityTag != null) {
            nbt = this.blockEntityTag.getItemNBT();
            for (kk<?> component : this.blockEntityTag.collectComponents()) {
                if (CraftMetaBlockState.getHandledTags().contains(component.a())) continue;
                tag.putIfAbsent(component);
            }
        }
        if (this.position != null) {
            if (nbt == null) {
                nbt = fnp.a(bgp.a);
            }
            nbt.a("x", this.position.getBlockX());
            nbt.a("y", this.position.getBlockY());
            nbt.a("z", this.position.getBlockZ());
        }
        if (nbt != null && !nbt.a()) {
            tag.put(BLOCK_ENTITY_TAG, dpf.a(this.blockEntityTag.getEntityType(), nbt.b()));
        }
    }

    @Override
    void deserializeInternal(uz tag, Object context) {
        super.deserializeInternal(tag, context);
        this.internalTag = tag.m(CraftMetaBlockState.BLOCK_ENTITY_TAG.NBT).orElse(this.internalTag);
    }

    @Override
    void serializeInternal(Map<String, vz> internalTags) {
        if (this.blockEntityTag != null) {
            internalTags.put(CraftMetaBlockState.BLOCK_ENTITY_TAG.NBT, this.blockEntityTag.getSnapshotNBT());
        }
    }

    @Override
    ImmutableMap.Builder<String, Object> serialize(ImmutableMap.Builder<String, Object> builder) {
        super.serialize(builder);
        builder.put((Object)"blockMaterial", (Object)this.material.name());
        if (this.position != null) {
            builder.put((Object)"blockPosition", (Object)this.position);
        }
        return builder;
    }

    @Override
    int applyHash() {
        int original;
        int hash = original = super.applyHash();
        if (this.blockEntityTag != null) {
            hash = 61 * hash + this.blockEntityTag.hashCode();
        }
        if (this.position != null) {
            hash = 61 * hash + this.position.hashCode();
        }
        return original != hash ? CraftMetaBlockState.class.hashCode() ^ hash : hash;
    }

    @Override
    public boolean equalsCommon(CraftMetaItem meta) {
        if (!super.equalsCommon(meta)) {
            return false;
        }
        if (meta instanceof CraftMetaBlockState) {
            CraftMetaBlockState that = (CraftMetaBlockState)meta;
            return Objects.equal(this.blockEntityTag, that.blockEntityTag) && Objects.equal((Object)this.position, (Object)that.position);
        }
        return true;
    }

    boolean isBlockStateEmpty() {
        return this.blockEntityTag == null && this.position == null;
    }

    @Override
    boolean notUncommon(CraftMetaItem meta) {
        return super.notUncommon(meta) && (meta instanceof CraftMetaBlockState || this.isBlockStateEmpty());
    }

    @Override
    boolean isEmpty() {
        return super.isEmpty() && this.isBlockStateEmpty();
    }

    @Override
    public CraftMetaBlockState clone() {
        CraftMetaBlockState meta = (CraftMetaBlockState)super.clone();
        if (this.blockEntityTag != null) {
            meta.blockEntityTag = this.blockEntityTag.copy();
        }
        if (this.position != null) {
            meta.position = this.position.clone();
        }
        return meta;
    }

    public boolean hasBlockState() {
        return this.blockEntityTag != null;
    }

    public BlockState getBlockState() {
        return this.blockEntityTag != null ? this.blockEntityTag.copy() : CraftMetaBlockState.getBlockState(this.material, null);
    }

    private static CraftBlockEntityState<?> getBlockState(Material material, uz blockEntityTag) {
        Material stateMaterial;
        is pos = is.c;
        Material material2 = stateMaterial = material != Material.SHIELD ? material : CraftMetaBlockState.shieldToBannerHack(blockEntityTag);
        if (blockEntityTag != null) {
            if (material == Material.SHIELD) {
                blockEntityTag.a("id", "minecraft:banner");
            } else if (material == Material.BEE_NEST || material == Material.BEEHIVE) {
                blockEntityTag.a("id", "minecraft:beehive");
            } else if (SHULKER_BOX_MATERIALS.contains(material)) {
                blockEntityTag.a("id", "minecraft:shulker_box");
            }
            pos = elb.a(null, blockEntityTag);
        }
        return (CraftBlockEntityState)CraftBlockStates.getBlockState(pos, stateMaterial, blockEntityTag);
    }

    public void setBlockState(BlockState blockState) {
        Preconditions.checkArgument((blockState != null ? 1 : 0) != 0, (Object)"blockState must not be null");
        Material stateMaterial = this.material != Material.SHIELD ? this.material : CraftMetaBlockState.shieldToBannerHack(null);
        Class<? extends CraftBlockState> blockStateType = CraftBlockStates.getBlockStateType(stateMaterial);
        Preconditions.checkArgument((blockStateType == blockState.getClass() && blockState instanceof CraftBlockEntityState ? 1 : 0) != 0, (String)"Invalid blockState for %s", (Object)this.material);
        this.blockEntityTag = (CraftBlockEntityState)blockState;
    }

    private static Material shieldToBannerHack(uz tag) {
        if (tag != null) {
            tag.m("components").flatMap(components -> components.i("minecraft:base_color").map(baseColor -> {
                DyeColor color = DyeColor.getByWoolData((byte)((byte)dkr.a(baseColor, dkr.a).a()));
                return CraftMetaShield.shieldToBannerHack(color);
            })).orElse(Material.WHITE_BANNER);
        }
        return Material.WHITE_BANNER;
    }
}

