/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.inventory;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.Map;
import org.bukkit.DyeColor;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftTropicalFish;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftMetaItem;
import org.bukkit.craftbukkit.v1_21_R7.inventory.ItemMetaKey;
import org.bukkit.craftbukkit.v1_21_R7.inventory.SerializableMeta;
import org.bukkit.entity.TropicalFish;
import org.bukkit.inventory.meta.TropicalFishBucketMeta;

@DelegateDeserialization(value=SerializableMeta.class)
class CraftMetaTropicalFishBucket
extends CraftMetaItem
implements TropicalFishBucketMeta {
    static final ItemMetaKey VARIANT = new ItemMetaKey("BucketVariantTag", "fish-variant");
    static final CraftMetaItem.ItemMetaKeyType<dpf<cgu<?>>> ENTITY_TAG = new CraftMetaItem.ItemMetaKeyType(ki.af, "entity-tag");
    static final CraftMetaItem.ItemMetaKeyType<doe> BUCKET_ENTITY_TAG = new CraftMetaItem.ItemMetaKeyType<doe>(ki.ag, "bucket-entity-tag");
    static final Codec<dpf<cgu<?>>> ENTITY_TAG_CODEC = dpf.a(cgu.a);
    private Integer variant;
    private dpf<cgu<?>> entityTag;
    private uz bucketEntityTag;

    CraftMetaTropicalFishBucket(CraftMetaItem meta) {
        super(meta);
        if (!(meta instanceof CraftMetaTropicalFishBucket)) {
            return;
        }
        CraftMetaTropicalFishBucket bucket = (CraftMetaTropicalFishBucket)meta;
        this.variant = bucket.variant;
        this.entityTag = bucket.entityTag;
        this.bucketEntityTag = bucket.bucketEntityTag;
    }

    CraftMetaTropicalFishBucket(kg tag) {
        super(tag);
        CraftMetaTropicalFishBucket.getOrEmpty(tag, ENTITY_TAG).ifPresent(nbt -> {
            this.entityTag = nbt;
            this.entityTag.c().e(CraftMetaTropicalFishBucket.VARIANT.NBT).ifPresent(variant -> {
                this.variant = variant;
            });
        });
        CraftMetaTropicalFishBucket.getOrEmpty(tag, BUCKET_ENTITY_TAG).ifPresent(nbt -> {
            this.bucketEntityTag = nbt.b();
            this.bucketEntityTag.e(CraftMetaTropicalFishBucket.VARIANT.NBT).ifPresent(variant -> {
                this.variant = variant;
            });
        });
    }

    CraftMetaTropicalFishBucket(Map<String, Object> map) {
        super(map);
        Integer variant = SerializableMeta.getObject(Integer.class, map, CraftMetaTropicalFishBucket.VARIANT.BUKKIT, true);
        if (variant != null) {
            this.variant = variant;
        }
    }

    @Override
    void deserializeInternal(uz tag, Object context) {
        super.deserializeInternal(tag, context);
        ENTITY_TAG_CODEC.decode((DynamicOps)vn.a, (Object)tag).ifSuccess(result -> {
            this.entityTag = (dpf)result.getFirst();
        });
        this.bucketEntityTag = tag.m(CraftMetaTropicalFishBucket.BUCKET_ENTITY_TAG.NBT).orElse(this.bucketEntityTag);
    }

    @Override
    void serializeInternal(Map<String, vz> internalTags) {
        if (this.entityTag != null) {
            internalTags.put(CraftMetaTropicalFishBucket.ENTITY_TAG.NBT, (vz)ENTITY_TAG_CODEC.encodeStart((DynamicOps)vn.a, this.entityTag).getOrThrow());
        }
        if (this.bucketEntityTag != null && !this.bucketEntityTag.j()) {
            internalTags.put(CraftMetaTropicalFishBucket.BUCKET_ENTITY_TAG.NBT, this.bucketEntityTag);
        }
    }

    @Override
    void applyToItem(CraftMetaItem.Applicator tag) {
        uz bucketEntityTag;
        super.applyToItem(tag);
        if (this.entityTag != null) {
            tag.put(ENTITY_TAG, this.entityTag);
        }
        uz uz2 = bucketEntityTag = this.bucketEntityTag != null ? this.bucketEntityTag.l() : null;
        if (this.hasVariant()) {
            if (bucketEntityTag == null) {
                bucketEntityTag = new uz();
            }
            bucketEntityTag.a(CraftMetaTropicalFishBucket.VARIANT.NBT, this.variant);
        }
        if (bucketEntityTag != null) {
            tag.put(BUCKET_ENTITY_TAG, doe.a(bucketEntityTag));
        }
    }

    @Override
    boolean isEmpty() {
        return super.isEmpty() && this.isBucketEmpty();
    }

    boolean isBucketEmpty() {
        return !this.hasVariant() && this.entityTag == null && this.bucketEntityTag == null;
    }

    public DyeColor getPatternColor() {
        return CraftTropicalFish.getPatternColor(this.variant);
    }

    public void setPatternColor(DyeColor color) {
        if (this.variant == null) {
            this.variant = 0;
        }
        this.variant = CraftTropicalFish.getData(color, this.getPatternColor(), this.getPattern());
    }

    public DyeColor getBodyColor() {
        return CraftTropicalFish.getBodyColor(this.variant);
    }

    public void setBodyColor(DyeColor color) {
        if (this.variant == null) {
            this.variant = 0;
        }
        this.variant = CraftTropicalFish.getData(this.getPatternColor(), color, this.getPattern());
    }

    public TropicalFish.Pattern getPattern() {
        return CraftTropicalFish.getPattern(this.variant);
    }

    public void setPattern(TropicalFish.Pattern pattern) {
        if (this.variant == null) {
            this.variant = 0;
        }
        this.variant = CraftTropicalFish.getData(this.getPatternColor(), this.getBodyColor(), pattern);
    }

    public boolean hasVariant() {
        return this.variant != null;
    }

    @Override
    boolean equalsCommon(CraftMetaItem meta) {
        if (!super.equalsCommon(meta)) {
            return false;
        }
        if (meta instanceof CraftMetaTropicalFishBucket) {
            CraftMetaTropicalFishBucket that = (CraftMetaTropicalFishBucket)meta;
            return (this.hasVariant() ? that.hasVariant() && this.variant.equals(that.variant) : !that.hasVariant()) && (this.entityTag != null ? that.entityTag != null && this.entityTag.equals(that.entityTag) : that.entityTag == null) && (this.bucketEntityTag != null ? that.bucketEntityTag != null && this.bucketEntityTag.equals(that.bucketEntityTag) : that.bucketEntityTag == null);
        }
        return true;
    }

    @Override
    boolean notUncommon(CraftMetaItem meta) {
        return super.notUncommon(meta) && (meta instanceof CraftMetaTropicalFishBucket || this.isBucketEmpty());
    }

    @Override
    int applyHash() {
        int original;
        int hash = original = super.applyHash();
        if (this.hasVariant()) {
            hash = 61 * hash + this.variant;
        }
        if (this.entityTag != null) {
            hash = 61 * hash + this.entityTag.hashCode();
        }
        if (this.bucketEntityTag != null) {
            hash = 61 * hash + this.bucketEntityTag.hashCode();
        }
        return original != hash ? CraftMetaTropicalFishBucket.class.hashCode() ^ hash : hash;
    }

    @Override
    public CraftMetaTropicalFishBucket clone() {
        CraftMetaTropicalFishBucket clone = (CraftMetaTropicalFishBucket)super.clone();
        if (this.entityTag != null) {
            clone.entityTag = dpf.a(this.entityTag.a(), this.entityTag.c());
        }
        if (this.bucketEntityTag != null) {
            clone.bucketEntityTag = this.bucketEntityTag.l();
        }
        return clone;
    }

    @Override
    ImmutableMap.Builder<String, Object> serialize(ImmutableMap.Builder<String, Object> builder) {
        super.serialize(builder);
        if (this.hasVariant()) {
            builder.put((Object)CraftMetaTropicalFishBucket.VARIANT.BUKKIT, (Object)this.variant);
        }
        return builder;
    }
}

