/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.inventory;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemType;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftNamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.recipe.CookingBookCategory;
import org.bukkit.inventory.recipe.CraftingBookCategory;

public interface CraftRecipe
extends Recipe {
    public void addToCraftingManager();

    default public Optional<dqo> toNMSOptional(RecipeChoice bukkit, boolean requireNotEmpty) {
        return bukkit == null ? Optional.empty() : Optional.of(this.toNMS(bukkit, requireNotEmpty));
    }

    default public dqo toNMS(RecipeChoice bukkit, boolean requireNotEmpty) {
        dqo stack;
        if (bukkit == null) {
            stack = dqo.a(new dwn[0]);
        } else if (bukkit instanceof RecipeChoice.MaterialChoice) {
            stack = dqo.a(((RecipeChoice.MaterialChoice)bukkit).getChoices().stream().map(mat -> CraftItemType.bukkitToMinecraft(mat)));
        } else if (bukkit instanceof RecipeChoice.ExactChoice) {
            stack = dqo.ofStacks(((RecipeChoice.ExactChoice)bukkit).getChoices().stream().map(mat -> CraftItemStack.asNMSCopy(mat)).toList());
        } else {
            throw new IllegalArgumentException("Unknown recipe stack instance " + String.valueOf(bukkit));
        }
        if (requireNotEmpty) {
            Preconditions.checkArgument((!stack.b() ? 1 : 0) != 0, (Object)"Recipe requires at least one non-air choice");
        }
        return stack;
    }

    default public drv toNMS(ItemStack stack) {
        dlt nms = CraftItemStack.asNMSCopy(stack);
        return new drv(nms.i(), nms.N(), nms.d());
    }

    public static RecipeChoice toBukkit(Optional<dqo> list) {
        return list.map(CraftRecipe::toBukkit).orElse(null);
    }

    public static RecipeChoice toBukkit(dqo list) {
        if (list.b()) {
            return null;
        }
        if (list.isExact()) {
            ArrayList<ItemStack> choices = new ArrayList<ItemStack>(list.itemStacks().size());
            for (dlt i3 : list.itemStacks()) {
                choices.add(CraftItemStack.asBukkitCopy(i3));
            }
            return new RecipeChoice.ExactChoice(choices);
        }
        List<Material> choices = list.a().map(i2 -> CraftItemType.minecraftToBukkit((dlp)i2.a())).toList();
        return new RecipeChoice.MaterialChoice(choices);
    }

    public static ItemStack toBukkit(drv transmute) {
        dlt nms = new dlt(transmute.b(), transmute.c(), transmute.d());
        return CraftItemStack.asBukkitCopy(nms);
    }

    public static dqf getCategory(CraftingBookCategory bukkit) {
        return dqf.valueOf(bukkit.name());
    }

    public static CraftingBookCategory getCategory(dqf nms) {
        return CraftingBookCategory.valueOf((String)nms.name());
    }

    public static dqe getCategory(CookingBookCategory bukkit) {
        return dqe.valueOf(bukkit.name());
    }

    public static CookingBookCategory getCategory(dqe nms) {
        return CookingBookCategory.valueOf((String)nms.name());
    }

    public static amt<dqs<?>> toMinecraft(NamespacedKey key) {
        return amt.a(mj.bK, CraftNamespacedKey.toMinecraft(key));
    }
}

