/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.inventory.components;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.bukkit.configuration.serialization.SerializableAs;
import org.bukkit.craftbukkit.v1_21_R7.inventory.SerializableMeta;
import org.bukkit.inventory.meta.components.AttackRangeComponent;

@SerializableAs(value="AttackRange")
public final class CraftAttackRangeComponent
implements AttackRangeComponent {
    private dnu handle;

    public CraftAttackRangeComponent(dnu handle) {
        this.handle = handle;
    }

    public CraftAttackRangeComponent(CraftAttackRangeComponent craft) {
        this.handle = craft.handle;
    }

    public CraftAttackRangeComponent(Map<String, Object> map) {
        Float minReach = SerializableMeta.getObject(Float.class, map, "min-reach", true);
        Float maxReach = SerializableMeta.getObject(Float.class, map, "max-reach", true);
        Float minCreativeReach = SerializableMeta.getObject(Float.class, map, "min-creative-reach", true);
        Float maxCreativeReach = SerializableMeta.getObject(Float.class, map, "max-creative-reach", true);
        Float hitboxMargin = SerializableMeta.getObject(Float.class, map, "hitbox-margin", true);
        Float mobFactor = SerializableMeta.getObject(Float.class, map, "mob-factor", true);
        this.handle = new dnu(minReach != null ? minReach.floatValue() : 0.0f, maxReach != null ? maxReach.floatValue() : 3.0f, minCreativeReach != null ? minCreativeReach.floatValue() : 0.0f, maxCreativeReach != null ? maxCreativeReach.floatValue() : 3.0f, hitboxMargin != null ? hitboxMargin.floatValue() : 0.3f, mobFactor != null ? mobFactor.floatValue() : 1.0f);
    }

    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("min-reach", Float.valueOf(this.getMinReach()));
        result.put("max-reach", Float.valueOf(this.getMaxReach()));
        result.put("min-creative-reach", Float.valueOf(this.getMinCreativeReach()));
        result.put("max-creative-reach", Float.valueOf(this.getMaxCreativeReach()));
        result.put("hitbox-margin", Float.valueOf(this.getHitboxMargin()));
        result.put("mob-factor", Float.valueOf(this.getMobFactor()));
        return result;
    }

    public dnu getHandle() {
        return this.handle;
    }

    public float getMinReach() {
        return this.handle.a();
    }

    public void setMinReach(float reach) {
        this.handle = new dnu(reach, this.handle.b(), this.handle.c(), this.handle.d(), this.handle.e(), this.handle.f());
    }

    public float getMaxReach() {
        return this.handle.b();
    }

    public void setMaxReach(float reach) {
        this.handle = new dnu(this.handle.a(), reach, this.handle.c(), this.handle.d(), this.handle.e(), this.handle.f());
    }

    public float getMinCreativeReach() {
        return this.handle.c();
    }

    public void setMinCreativeReach(float reach) {
        this.handle = new dnu(this.handle.a(), this.handle.b(), reach, this.handle.d(), this.handle.e(), this.handle.f());
    }

    public float getMaxCreativeReach() {
        return this.handle.d();
    }

    public void setMaxCreativeReach(float reach) {
        this.handle = new dnu(this.handle.a(), this.handle.b(), this.handle.c(), reach, this.handle.e(), this.handle.f());
    }

    public float getHitboxMargin() {
        return this.handle.e();
    }

    public void setHitboxMargin(float margin) {
        this.handle = new dnu(this.handle.a(), this.handle.b(), this.handle.c(), this.handle.d(), margin, this.handle.f());
    }

    public float getMobFactor() {
        return this.handle.f();
    }

    public void setMobFactor(float factor) {
        this.handle = new dnu(this.handle.a(), this.handle.b(), this.handle.c(), this.handle.d(), this.handle.e(), this.handle.f());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CraftAttackRangeComponent other = (CraftAttackRangeComponent)obj;
        return Objects.equals(this.handle, other.handle);
    }

    public int hashCode() {
        int hash = 7;
        hash = 19 * hash + Objects.hashCode(this.handle);
        return hash;
    }

    public String toString() {
        return "CraftAttackRangeComponent{handle=" + String.valueOf(this.handle) + "}";
    }
}

