/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.inventory.components.consumable;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.Sound;
import org.bukkit.configuration.serialization.SerializableAs;
import org.bukkit.craftbukkit.v1_21_R7.CraftSound;
import org.bukkit.craftbukkit.v1_21_R7.inventory.SerializableMeta;
import org.bukkit.craftbukkit.v1_21_R7.inventory.components.consumable.effects.CraftConsumableEffect;
import org.bukkit.inventory.meta.components.consumable.ConsumableComponent;
import org.bukkit.inventory.meta.components.consumable.effects.ConsumableEffect;

@SerializableAs(value="Consumable")
public class CraftConsumableComponent
implements ConsumableComponent {
    private dob handle;

    public CraftConsumableComponent(dob consumable) {
        this.handle = consumable;
    }

    public CraftConsumableComponent(CraftConsumableComponent consumable) {
        this.handle = consumable.handle;
    }

    public CraftConsumableComponent(Map<String, Object> map) {
        Float consumeSeconds = SerializableMeta.getObject(Float.class, map, "consume-seconds", false);
        ConsumableComponent.Animation animation = ConsumableComponent.Animation.valueOf((String)SerializableMeta.getString(map, "animation", false));
        Boolean hasConsumeParticles = SerializableMeta.getBoolean(map, "has-consume-particles");
        Sound sound = (Sound)Registry.SOUNDS.get(NamespacedKey.fromString((String)SerializableMeta.getString(map, "sound", false)));
        List<ConsumableEffect> consumableEffects = SerializableMeta.getList(ConsumableEffect.class, map, "effects");
        List<dpp> consumeEffects = consumableEffects.stream().map(consumableEffect -> CraftConsumableEffect.bukkitToMinecraftSpecific((CraftConsumableEffect)consumableEffect)).toList();
        this.handle = new dob(consumeSeconds.floatValue(), CraftAnimation.bukkitToMinecraft(animation), CraftSound.bukkitToMinecraftHolder(sound), hasConsumeParticles, consumeEffects);
    }

    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("consume-seconds", Float.valueOf(this.getConsumeSeconds()));
        result.put("animation", this.getAnimation().name());
        result.put("sound", this.getSound().getKey().toString());
        result.put("has-consume-particles", this.hasConsumeParticles());
        result.put("effects", this.getEffects());
        return result;
    }

    public dob getHandle() {
        return this.handle;
    }

    public float getConsumeSeconds() {
        return this.handle.c();
    }

    public void setConsumeSeconds(float consumeSeconds) {
        this.handle = new dob(consumeSeconds, this.handle.d(), this.handle.e(), this.handle.f(), this.handle.g());
    }

    public ConsumableComponent.Animation getAnimation() {
        return CraftAnimation.minecraftToBukkit(this.handle.d());
    }

    public void setAnimation(ConsumableComponent.Animation animation) {
        Preconditions.checkArgument((animation != null ? 1 : 0) != 0, (Object)"Animation cannot be null");
        this.handle = new dob(this.handle.c(), CraftAnimation.bukkitToMinecraft(animation), this.handle.e(), this.handle.f(), this.handle.g());
    }

    public Sound getSound() {
        return CraftSound.minecraftHolderToBukkit(this.handle.e());
    }

    public void setSound(Sound sound) {
        jd<bcz> soundEffectHolder = sound != null ? CraftSound.bukkitToMinecraftHolder(sound) : bda.lR;
        this.handle = new dob(this.handle.c(), this.handle.d(), soundEffectHolder, this.handle.f(), this.handle.g());
    }

    public boolean hasConsumeParticles() {
        return this.handle.f();
    }

    public void setConsumeParticles(boolean consumeParticles) {
        this.handle = new dob(this.handle.c(), this.handle.d(), this.handle.e(), consumeParticles, this.handle.g());
    }

    public List<ConsumableEffect> getEffects() {
        return this.getHandle().g().stream().map(CraftConsumableEffect::minecraftToBukkitSpecific).map(o2 -> (ConsumableEffect)o2).toList();
    }

    public void setEffects(List<ConsumableEffect> effects) {
        this.handle = new dob(this.handle.c(), this.handle.d(), this.handle.e(), this.handle.f(), effects.stream().map(consumableEffect -> CraftConsumableEffect.bukkitToMinecraftSpecific((CraftConsumableEffect)consumableEffect)).toList());
    }

    public ConsumableEffect addEffect(ConsumableEffect consumableEffect) {
        ArrayList<dpp> effects = new ArrayList<dpp>(this.handle.g());
        Object newEffect = CraftConsumableEffect.bukkitToMinecraftSpecific((CraftConsumableEffect)consumableEffect);
        effects.add((dpp)newEffect);
        this.handle = new dob(this.handle.c(), this.handle.d(), this.handle.e(), this.handle.f(), effects);
        return consumableEffect;
    }

    public static class CraftAnimation {
        public static ConsumableComponent.Animation minecraftToBukkit(dlv minecraft) {
            return ConsumableComponent.Animation.valueOf((String)minecraft.name());
        }

        public static dlv bukkitToMinecraft(ConsumableComponent.Animation bukkit) {
            return dlv.valueOf(bukkit.name());
        }
    }
}

