/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.inventory.view;

import com.google.common.base.Preconditions;
import org.bukkit.craftbukkit.v1_21_R7.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R7.enchantments.CraftEnchantment;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftInventoryView;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.enchantments.EnchantmentOffer;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.EnchantingInventory;
import org.bukkit.inventory.view.EnchantmentView;
import org.jetbrains.annotations.NotNull;

public class CraftEnchantmentView
extends CraftInventoryView<dif, EnchantingInventory>
implements EnchantmentView {
    public CraftEnchantmentView(HumanEntity player, EnchantingInventory viewing, dif container) {
        super(player, viewing, container);
    }

    public int getEnchantmentSeed() {
        return ((dif)this.container).m();
    }

    @NotNull
    public EnchantmentOffer[] getOffers() {
        ji<jd<dso>> registry = CraftRegistry.getMinecraftRegistry().f(mj.bf).t();
        EnchantmentOffer[] offers = new EnchantmentOffer[3];
        for (int i2 = 0; i2 < 3; ++i2) {
            Enchantment enchantment = ((dif)this.container).n[i2] >= 0 ? CraftEnchantment.minecraftHolderToBukkit(registry.a(((dif)this.container).n[i2])) : null;
            offers[i2] = enchantment != null ? new EnchantmentOffer(enchantment, ((dif)this.container).o[i2], ((dif)this.container).m[i2]) : null;
        }
        return offers;
    }

    public void setOffers(@NotNull EnchantmentOffer[] offers) {
        Preconditions.checkArgument((offers.length != 3 ? 1 : 0) != 0, (Object)"There must be 3 offers given");
        ji<jd<dso>> registry = CraftRegistry.getMinecraftRegistry().f(mj.bf).t();
        for (int i2 = 0; i2 < offers.length; ++i2) {
            EnchantmentOffer offer = offers[i2];
            if (offer == null) {
                ((dif)this.container).n[i2] = -1;
                ((dif)this.container).o[i2] = -1;
                ((dif)this.container).m[i2] = 0;
                continue;
            }
            ((dif)this.container).n[i2] = registry.c(CraftEnchantment.bukkitToMinecraftHolder(offer.getEnchantment()));
            ((dif)this.container).o[i2] = offer.getEnchantmentLevel();
            ((dif)this.container).m[i2] = offer.getCost();
        }
    }
}

