/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.packs;

import java.io.IOException;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.FeatureFlag;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_21_R7.CraftFeatureFlag;
import org.bukkit.craftbukkit.v1_21_R7.CraftServer;
import org.bukkit.craftbukkit.v1_21_R7.packs.CraftDataPackFormat;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftChatMessage;
import org.bukkit.packs.DataPack;
import org.bukkit.packs.DataPackFormat;

public class CraftDataPack
implements DataPack {
    private final bah handle;
    private final baa resourcePackInfo;

    public CraftDataPack(bah handler) {
        this.handle = handler;
        try (azl iresourcepack = this.handle.c.a(this.handle.a());){
            baa resourcepackinfo = iresourcepack.a(baa.b);
            if (resourcepackinfo == null) {
                resourcepackinfo = iresourcepack.a(baa.c);
            }
            this.resourcePackInfo = resourcepackinfo;
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    public bah getHandle() {
        return this.handle;
    }

    public String getRawId() {
        return this.getHandle().g();
    }

    public String getTitle() {
        return CraftChatMessage.fromComponent(this.getHandle().b());
    }

    public String getDescription() {
        return CraftChatMessage.fromComponent(this.getHandle().c());
    }

    public int getPackFormat() {
        return this.getMaxSupportedPackFormat();
    }

    public int getMinSupportedPackFormat() {
        return this.resourcePackInfo.b().a().b();
    }

    public int getMaxSupportedPackFormat() {
        return this.resourcePackInfo.b().b().b();
    }

    public DataPackFormat getMinSupportedFormat() {
        return new CraftDataPackFormat(this.resourcePackInfo.b().a());
    }

    public DataPackFormat getMaxSupportedFormat() {
        return new CraftDataPackFormat(this.resourcePackInfo.b().b());
    }

    public boolean isRequired() {
        return this.getHandle().i();
    }

    public DataPack.Compatibility getCompatibility() {
        return switch (this.getHandle().d()) {
            default -> throw new MatchException(null, null);
            case bai.d -> DataPack.Compatibility.COMPATIBLE;
            case bai.b -> DataPack.Compatibility.NEW;
            case bai.a -> DataPack.Compatibility.OLD;
            case bai.c -> DataPack.Compatibility.UNKNOWN;
        };
    }

    public boolean isEnabled() {
        return ((CraftServer)Bukkit.getServer()).getServer().aE().e().contains(this.getRawId());
    }

    public DataPack.Source getSource() {
        if (this.getHandle().l() == bal.c) {
            return DataPack.Source.BUILT_IN;
        }
        if (this.getHandle().l() == bal.d) {
            return DataPack.Source.FEATURE;
        }
        if (this.getHandle().l() == bal.e) {
            return DataPack.Source.WORLD;
        }
        if (this.getHandle().l() == bal.f) {
            return DataPack.Source.SERVER;
        }
        return DataPack.Source.DEFAULT;
    }

    public Set<FeatureFlag> getRequestedFeatures() {
        return CraftFeatureFlag.getFromNMS(this.getHandle().e()).stream().map(FeatureFlag.class::cast).collect(Collectors.toUnmodifiableSet());
    }

    public NamespacedKey getKey() {
        return NamespacedKey.fromString((String)this.getRawId());
    }

    public String toString() {
        String requestedFeatures = this.getRequestedFeatures().stream().map(featureFlag -> featureFlag.getKey().toString()).collect(Collectors.joining(","));
        return "CraftDataPack{rawId=" + this.getRawId() + ",id=" + String.valueOf(this.getKey()) + ",title=" + this.getTitle() + ",description=" + this.getDescription() + ",packformat=" + this.getPackFormat() + ",minSupportedPackFormat=" + this.getMinSupportedPackFormat() + ",maxSupportedPackFormat=" + this.getMaxSupportedPackFormat() + ",compatibility=" + String.valueOf(this.getCompatibility()) + ",source=" + String.valueOf(this.getSource()) + ",enabled=" + this.isEnabled() + ",requestedFeatures=[" + requestedFeatures + "]}";
    }
}

