/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.projectiles;

import com.google.common.base.Preconditions;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.AbstractWindCharge;
import org.bukkit.entity.BreezeWindCharge;
import org.bukkit.entity.DragonFireball;
import org.bukkit.entity.Egg;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Firework;
import org.bukkit.entity.LargeFireball;
import org.bukkit.entity.LingeringPotion;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Snowball;
import org.bukkit.entity.SpectralArrow;
import org.bukkit.entity.ThrownExpBottle;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.TippedArrow;
import org.bukkit.entity.WitherSkull;
import org.bukkit.projectiles.BlockProjectileSource;
import org.bukkit.util.Vector;

public class CraftBlockProjectileSource
implements BlockProjectileSource {
    private final elx dispenserBlock;

    public CraftBlockProjectileSource(elx dispenserBlock) {
        this.dispenserBlock = dispenserBlock;
    }

    public Block getBlock() {
        return this.dispenserBlock.j().getWorld().getBlockAt(this.dispenserBlock.aD_().u(), this.dispenserBlock.aD_().v(), this.dispenserBlock.aD_().w());
    }

    public <T extends Projectile> T launchProjectile(Class<? extends T> projectile) {
        return this.launchProjectile(projectile, null);
    }

    public <T extends Projectile> T launchProjectile(Class<? extends T> projectile, Vector velocity) {
        Preconditions.checkArgument((this.getBlock().getType() == Material.DISPENSER ? 1 : 0) != 0, (Object)"Block is no longer dispenser");
        ld sourceblock = new ld((axf)this.dispenserBlock.j(), this.dispenserBlock.aD_(), this.dispenserBlock.o(), this.dispenserBlock);
        iz enumdirection = sourceblock.d().c(eby.b);
        dwo world = this.dispenserBlock.j();
        dlp item = null;
        if (Snowball.class.isAssignableFrom(projectile)) {
            item = dlx.so;
        } else if (Egg.class.isAssignableFrom(projectile)) {
            item = dlx.sD;
        } else if (EnderPearl.class.isAssignableFrom(projectile)) {
            item = dlx.uj;
        } else if (ThrownExpBottle.class.isAssignableFrom(projectile)) {
            item = dlx.wh;
        } else if (ThrownPotion.class.isAssignableFrom(projectile)) {
            item = LingeringPotion.class.isAssignableFrom(projectile) ? dlx.xG : dlx.xD;
        } else if (AbstractArrow.class.isAssignableFrom(projectile)) {
            item = TippedArrow.class.isAssignableFrom(projectile) ? dlx.xF : (SpectralArrow.class.isAssignableFrom(projectile) ? dlx.xE : dlx.pX);
        } else if (Fireball.class.isAssignableFrom(projectile)) {
            item = AbstractWindCharge.class.isAssignableFrom(projectile) ? dlx.wj : dlx.wi;
        } else if (Firework.class.isAssignableFrom(projectile)) {
            item = dlx.wG;
        }
        Preconditions.checkArgument((boolean)(item instanceof dmn), (Object)"Projectile not supported");
        dlt itemstack = new dlt(item);
        dmn projectileItem = (dmn)((Object)item);
        dmn.a dispenseConfig = projectileItem.a();
        jn iposition = dispenseConfig.b().getDispensePosition(sourceblock, enumdirection);
        dec launch = projectileItem.a(world, iposition, itemstack, enumdirection);
        if (Fireball.class.isAssignableFrom(projectile)) {
            dem customFireball = null;
            if (WitherSkull.class.isAssignableFrom(projectile)) {
                customFireball = cgu.bT.a(world, cgt.k);
                launch = customFireball;
            } else if (DragonFireball.class.isAssignableFrom(projectile)) {
                launch = cgu.N.a(world, cgt.k);
            } else if (BreezeWindCharge.class.isAssignableFrom(projectile)) {
                customFireball = cgu.u.a(world, cgt.k);
                launch = customFireball;
            } else if (LargeFireball.class.isAssignableFrom(projectile)) {
                customFireball = cgu.ac.a(world, cgt.k);
                launch = customFireball;
            }
            if (customFireball != null) {
                customFireball.a_(iposition.a(), iposition.b(), iposition.c());
                bgr randomsource = world.G_();
                double d0 = randomsource.a((double)enumdirection.j(), 0.11485000000000001);
                double d1 = randomsource.a((double)enumdirection.k(), 0.11485000000000001);
                double d2 = randomsource.a((double)enumdirection.l(), 0.11485000000000001);
                ftm vec3d = new ftm(d0, d1, d2);
                customFireball.a(vec3d, 0.1);
            }
        }
        if (launch instanceof deh) {
            deh arrow = (deh)launch;
            arrow.c = deh.a.b;
        }
        launch.projectileSource = this;
        projectileItem.a(launch, enumdirection.j(), enumdirection.k(), enumdirection.l(), dispenseConfig.d(), dispenseConfig.c());
        if (velocity != null) {
            ((Projectile)launch.getBukkitEntity()).setVelocity(velocity);
        }
        world.b(launch);
        return (T)((Projectile)launch.getBukkitEntity());
    }
}

