/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.structure;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.RegionAccessor;
import org.bukkit.World;
import org.bukkit.block.structure.Mirror;
import org.bukkit.block.structure.StructureRotation;
import org.bukkit.craftbukkit.v1_21_R7.CraftRegionAccessor;
import org.bukkit.craftbukkit.v1_21_R7.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R7.structure.CraftPalette;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftBlockVector;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftLocation;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftStructureTransformer;
import org.bukkit.craftbukkit.v1_21_R7.util.RandomSourceWrapper;
import org.bukkit.craftbukkit.v1_21_R7.util.TransformerGeneratorAccess;
import org.bukkit.entity.Entity;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.structure.Palette;
import org.bukkit.structure.Structure;
import org.bukkit.util.BlockTransformer;
import org.bukkit.util.BlockVector;
import org.bukkit.util.EntityTransformer;

public class CraftStructure
implements Structure {
    private final fjq structure;
    private final jr registry;

    public CraftStructure(fjq structure, jr registry) {
        this.structure = structure;
        this.registry = registry;
    }

    public void place(Location location, boolean includeEntities, StructureRotation structureRotation, Mirror mirror, int palette, float integrity, Random random) {
        this.place(location, includeEntities, structureRotation, mirror, palette, integrity, random, Collections.emptyList(), Collections.emptyList());
    }

    public void place(Location location, boolean includeEntities, StructureRotation structureRotation, Mirror mirror, int palette, float integrity, Random random, Collection<BlockTransformer> blockTransformers, Collection<EntityTransformer> entityTransformers) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        location.checkFinite();
        World world = location.getWorld();
        Preconditions.checkArgument((world != null ? 1 : 0) != 0, (Object)"The World of Location cannot be null");
        BlockVector blockVector = new BlockVector(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        this.place((RegionAccessor)world, blockVector, includeEntities, structureRotation, mirror, palette, integrity, random, blockTransformers, entityTransformers);
    }

    public void place(RegionAccessor regionAccessor, BlockVector location, boolean includeEntities, StructureRotation structureRotation, Mirror mirror, int palette, float integrity, Random random) {
        this.place(regionAccessor, location, includeEntities, structureRotation, mirror, palette, integrity, random, Collections.emptyList(), Collections.emptyList());
    }

    public void place(RegionAccessor regionAccessor, BlockVector location, boolean includeEntities, StructureRotation structureRotation, Mirror mirror, int palette, float integrity, Random random, Collection<BlockTransformer> blockTransformers, Collection<EntityTransformer> entityTransformers) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((regionAccessor != null ? 1 : 0) != 0, (Object)"RegionAccessor cannot be null");
        Preconditions.checkArgument((blockTransformers != null ? 1 : 0) != 0, (Object)"BlockTransformers cannot be null");
        Preconditions.checkArgument((entityTransformers != null ? 1 : 0) != 0, (Object)"EntityTransformers cannot be null");
        location.checkFinite();
        Preconditions.checkArgument((integrity >= 0.0f && integrity <= 1.0f ? 1 : 0) != 0, (String)"Integrity value (%S) must be between 0 and 1 inclusive", (Object)Float.valueOf(integrity));
        RandomSourceWrapper randomSource = new RandomSourceWrapper(random);
        fjm definedstructureinfo = new fjm().a(eev.valueOf(mirror.name())).a(egm.valueOf(structureRotation.name())).a(!includeEntities).a(new fit(integrity)).a(randomSource);
        definedstructureinfo.h = palette;
        is blockPosition = CraftBlockVector.toBlockPosition(location);
        dxn handle = ((CraftRegionAccessor)regionAccessor).getHandle();
        TransformerGeneratorAccess access = new TransformerGeneratorAccess();
        access.setHandle(handle);
        access.setStructureTransformer(new CraftStructureTransformer(handle, new dvu(blockPosition), blockTransformers, entityTransformers));
        this.structure.a(access, blockPosition, blockPosition, definedstructureinfo, randomSource, 2);
        access.getStructureTransformer().discard();
    }

    public void fill(Location corner1, Location corner2, boolean includeEntities) {
        Preconditions.checkArgument((corner1 != null ? 1 : 0) != 0, (Object)"Location corner1 cannot be null");
        Preconditions.checkArgument((corner2 != null ? 1 : 0) != 0, (Object)"Location corner2 cannot be null");
        World world = corner1.getWorld();
        Preconditions.checkArgument((world != null ? 1 : 0) != 0, (Object)"World of corner1 Location cannot be null");
        Location origin = new Location(world, (double)Math.min(corner1.getBlockX(), corner2.getBlockX()), (double)Math.min(corner1.getBlockY(), corner2.getBlockY()), (double)Math.min(corner1.getBlockZ(), corner2.getBlockZ()));
        BlockVector size = new BlockVector(Math.abs(corner1.getBlockX() - corner2.getBlockX()), Math.abs(corner1.getBlockY() - corner2.getBlockY()), Math.abs(corner1.getBlockZ() - corner2.getBlockZ()));
        this.fill(origin, size, includeEntities);
    }

    public void fill(Location origin, BlockVector size, boolean includeEntities) {
        Preconditions.checkArgument((origin != null ? 1 : 0) != 0, (Object)"Location origin cannot be null");
        World world = origin.getWorld();
        Preconditions.checkArgument((world != null ? 1 : 0) != 0, (Object)"World of Location origin cannot be null");
        Preconditions.checkArgument((size != null ? 1 : 0) != 0, (Object)"BlockVector size cannot be null");
        Preconditions.checkArgument((size.getBlockX() >= 1 && size.getBlockY() >= 1 && size.getBlockZ() >= 1 ? 1 : 0) != 0, (String)"Size must be at least 1x1x1 but was %sx%sx%s", (Object)size.getBlockX(), (Object)size.getBlockY(), (Object)size.getBlockZ());
        this.structure.a(((CraftWorld)world).getHandle(), CraftLocation.toBlockPosition(origin), CraftBlockVector.toBlockPosition(size), includeEntities, Arrays.asList(dzs.lJ));
    }

    public BlockVector getSize() {
        return CraftBlockVector.toBukkit(this.structure.a());
    }

    public List<Entity> getEntities() {
        ArrayList entities = new ArrayList();
        for (fjq.e entity : this.structure.n) {
            cgu.a(fno.a(bgp.a, (jf.a)this.registry, entity.c), (dwo)((CraftWorld)Bukkit.getServer().getWorlds().get(0)).getHandle(), cgt.d).ifPresent(dummyEntity -> {
                dummyEntity.a_(entity.a.g, entity.a.h, entity.a.i);
                entities.add(dummyEntity.getBukkitEntity());
            });
        }
        return Collections.unmodifiableList(entities);
    }

    public int getEntityCount() {
        return this.structure.n.size();
    }

    public List<Palette> getPalettes() {
        return this.structure.m.stream().map(palette -> new CraftPalette((fjq.b)palette, this.registry)).collect(Collectors.toList());
    }

    public int getPaletteCount() {
        return this.structure.m.size();
    }

    public PersistentDataContainer getPersistentDataContainer() {
        return this.getHandle().persistentDataContainer;
    }

    public fjq getHandle() {
        return this.structure;
    }
}

