/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.structure;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_21_R7.structure.CraftStructure;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftNamespacedKey;
import org.bukkit.structure.Structure;
import org.bukkit.structure.StructureManager;

public class CraftStructureManager
implements StructureManager {
    private final fjr structureManager;
    private final jr registry;

    public CraftStructureManager(fjr structureManager, jr registry) {
        this.structureManager = structureManager;
        this.registry = registry;
    }

    public Map<NamespacedKey, Structure> getStructures() {
        HashMap cachedStructures = new HashMap();
        for (Map.Entry<amo, Optional<fjq>> entry : this.structureManager.f.entrySet()) {
            entry.getValue().ifPresent(definedStructure -> cachedStructures.put(CraftNamespacedKey.fromMinecraft((amo)entry.getKey()), new CraftStructure((fjq)definedStructure, this.registry)));
        }
        return Collections.unmodifiableMap(cachedStructures);
    }

    public Structure getStructure(NamespacedKey structureKey) {
        Preconditions.checkArgument((structureKey != null ? 1 : 0) != 0, (Object)"NamespacedKey structureKey cannot be null");
        Optional<fjq> definedStructure = this.structureManager.f.get(CraftNamespacedKey.toMinecraft(structureKey));
        if (definedStructure == null) {
            return null;
        }
        return definedStructure.map(s2 -> new CraftStructure((fjq)s2, this.registry)).orElse(null);
    }

    public Structure loadStructure(NamespacedKey structureKey, boolean register) {
        amo minecraftKey = this.createAndValidateMinecraftStructureKey(structureKey);
        Optional<fjq> structure = this.structureManager.f.get(minecraftKey);
        structure = structure == null ? Optional.empty() : structure;
        structure = structure.isPresent() ? structure : this.structureManager.h(minecraftKey);
        Optional<fjq> optional = structure = structure.isPresent() ? structure : this.structureManager.f(minecraftKey);
        if (register) {
            this.structureManager.f.put(minecraftKey, structure);
        }
        return structure.map(s2 -> new CraftStructure((fjq)s2, this.registry)).orElse(null);
    }

    public Structure loadStructure(NamespacedKey structureKey) {
        return this.loadStructure(structureKey, true);
    }

    public void saveStructure(NamespacedKey structureKey) {
        amo minecraftKey = this.createAndValidateMinecraftStructureKey(structureKey);
        this.structureManager.c(minecraftKey);
    }

    public void saveStructure(NamespacedKey structureKey, Structure structure) throws IOException {
        Preconditions.checkArgument((structureKey != null ? 1 : 0) != 0, (Object)"NamespacedKey structure cannot be null");
        Preconditions.checkArgument((structure != null ? 1 : 0) != 0, (Object)"Structure cannot be null");
        File structureFile = this.getStructureFile(structureKey);
        Files.createDirectories(structureFile.toPath().getParent(), new FileAttribute[0]);
        this.saveStructure(structureFile, structure);
    }

    public Structure registerStructure(NamespacedKey structureKey, Structure structure) {
        Preconditions.checkArgument((structureKey != null ? 1 : 0) != 0, (Object)"NamespacedKey structureKey cannot be null");
        Preconditions.checkArgument((structure != null ? 1 : 0) != 0, (Object)"Structure cannot be null");
        amo minecraftKey = this.createAndValidateMinecraftStructureKey(structureKey);
        Optional<fjq> optionalDefinedStructure = Optional.of(((CraftStructure)structure).getHandle());
        Optional<fjq> previousStructure = this.structureManager.f.put(minecraftKey, optionalDefinedStructure);
        return previousStructure == null ? null : (Structure)previousStructure.map(s2 -> new CraftStructure((fjq)s2, this.registry)).orElse(null);
    }

    public Structure unregisterStructure(NamespacedKey structureKey) {
        Preconditions.checkArgument((structureKey != null ? 1 : 0) != 0, (Object)"NamespacedKey structureKey cannot be null");
        amo minecraftKey = this.createAndValidateMinecraftStructureKey(structureKey);
        Optional<fjq> previousStructure = this.structureManager.f.remove(minecraftKey);
        return previousStructure == null ? null : (Structure)previousStructure.map(s2 -> new CraftStructure((fjq)s2, this.registry)).orElse(null);
    }

    public void deleteStructure(NamespacedKey structureKey) throws IOException {
        this.deleteStructure(structureKey, true);
    }

    public void deleteStructure(NamespacedKey structureKey, boolean unregister) throws IOException {
        amo key = CraftNamespacedKey.toMinecraft(structureKey);
        if (unregister) {
            this.structureManager.f.remove(key);
        }
        Path path = this.structureManager.a(key, ".nbt");
        Files.deleteIfExists(path);
    }

    public File getStructureFile(NamespacedKey structureKey) {
        amo minecraftKey = this.createAndValidateMinecraftStructureKey(structureKey);
        return this.structureManager.a(minecraftKey, ".nbt").toFile();
    }

    public Structure loadStructure(File file) throws IOException {
        Preconditions.checkArgument((file != null ? 1 : 0) != 0, (Object)"File cannot be null");
        FileInputStream fileinputstream = new FileInputStream(file);
        return this.loadStructure(fileinputstream);
    }

    public Structure loadStructure(InputStream inputStream) throws IOException {
        Preconditions.checkArgument((inputStream != null ? 1 : 0) != 0, (Object)"inputStream cannot be null");
        return new CraftStructure(this.structureManager.a(inputStream), this.registry);
    }

    public void saveStructure(File file, Structure structure) throws IOException {
        Preconditions.checkArgument((file != null ? 1 : 0) != 0, (Object)"file cannot be null");
        Preconditions.checkArgument((structure != null ? 1 : 0) != 0, (Object)"structure cannot be null");
        FileOutputStream fileoutputstream = new FileOutputStream(file);
        this.saveStructure(fileoutputstream, structure);
    }

    public void saveStructure(OutputStream outputStream, Structure structure) throws IOException {
        Preconditions.checkArgument((outputStream != null ? 1 : 0) != 0, (Object)"outputStream cannot be null");
        Preconditions.checkArgument((structure != null ? 1 : 0) != 0, (Object)"structure cannot be null");
        uz nbttagcompound = ((CraftStructure)structure).getHandle().a(new uz());
        vm.a(nbttagcompound, outputStream);
    }

    public Structure createStructure() {
        return new CraftStructure(new fjq(), this.registry);
    }

    private amo createAndValidateMinecraftStructureKey(NamespacedKey structureKey) {
        Preconditions.checkArgument((structureKey != null ? 1 : 0) != 0, (Object)"NamespacedKey structureKey cannot be null");
        amo minecraftkey = CraftNamespacedKey.toMinecraft(structureKey);
        Preconditions.checkArgument((!minecraftkey.a().contains("//") ? 1 : 0) != 0, (Object)"Resource key for Structures can not contain \"//\"");
        return minecraftkey;
    }

    public Structure copy(Structure structure) {
        Preconditions.checkArgument((structure != null ? 1 : 0) != 0, (Object)"Structure cannot be null");
        return new CraftStructure(this.structureManager.a(((CraftStructure)structure).getHandle().a(new uz())), this.registry);
    }
}

