/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.util;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.mojang.serialization.JsonOps;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.md_5.bungee.chat.ChatVersion;
import net.md_5.bungee.chat.VersionedComponentSerializer;
import net.minecraft.server.MinecraftServer;
import org.bukkit.ChatColor;

public final class CraftChatMessage {
    private static final Pattern LINK_PATTERN = Pattern.compile("((?:(?:https?):\\/\\/)?(?:[-\\w_\\.]{2,}\\.[a-z]{2,4}.*?(?=[\\.\\?!,;:]?(?:[" + String.valueOf('\u00a7') + " \\n]|$))))");
    private static final Map<Character, l> formatMap;

    public static VersionedComponentSerializer getBungee() {
        return VersionedComponentSerializer.forVersion((ChatVersion)ChatVersion.V1_21_5);
    }

    public static l getColor(ChatColor color) {
        return formatMap.get(Character.valueOf(color.getChar()));
    }

    public static ChatColor getColor(l format) {
        return ChatColor.getByChar((char)format.C);
    }

    public static Optional<yh> fromStringOrOptional(String message) {
        return Optional.ofNullable(CraftChatMessage.fromStringOrNull(message));
    }

    public static Optional<yh> fromStringOrOptional(String message, boolean keepNewlines) {
        return Optional.ofNullable(CraftChatMessage.fromStringOrNull(message, keepNewlines));
    }

    public static yh fromStringOrNull(String message) {
        return CraftChatMessage.fromStringOrNull(message, false);
    }

    public static yh fromStringOrNull(String message, boolean keepNewlines) {
        return message == null || message.isEmpty() ? null : CraftChatMessage.fromString(message, keepNewlines)[0];
    }

    public static yh fromStringOrEmpty(String message) {
        return CraftChatMessage.fromStringOrEmpty(message, false);
    }

    public static yh fromStringOrEmpty(String message, boolean keepNewlines) {
        return CraftChatMessage.fromString(message, keepNewlines)[0];
    }

    public static yh[] fromString(String message) {
        return CraftChatMessage.fromString(message, false);
    }

    public static yh[] fromString(String message, boolean keepNewlines) {
        return CraftChatMessage.fromString(message, keepNewlines, false);
    }

    public static yh[] fromString(String message, boolean keepNewlines, boolean plain) {
        return new StringMessage(message, keepNewlines, plain).getOutput();
    }

    public static String toJSON(yh component) {
        return ChatSerializer.toJson(component, MinecraftServer.getDefaultRegistryAccess());
    }

    public static String toJSONOrNull(yh component) {
        if (component == null) {
            return null;
        }
        return CraftChatMessage.toJSON(component);
    }

    public static yh fromJSON(String jsonMessage) throws JsonParseException {
        return ChatSerializer.fromJson(jsonMessage, MinecraftServer.getDefaultRegistryAccess());
    }

    public static yh fromJSONOrNull(String jsonMessage) {
        if (jsonMessage == null) {
            return null;
        }
        try {
            return CraftChatMessage.fromJSON(jsonMessage);
        }
        catch (JsonParseException ex2) {
            return null;
        }
    }

    public static yh fromJSONOrString(String message) {
        return CraftChatMessage.fromJSONOrString(message, false);
    }

    public static yh fromJSONOrString(String message, boolean keepNewlines) {
        return CraftChatMessage.fromJSONOrString(message, false, keepNewlines);
    }

    public static yh fromJSONOrString(String message, boolean nullable, boolean keepNewlines) {
        return CraftChatMessage.fromJSONOrString(message, nullable, keepNewlines, Integer.MAX_VALUE, false);
    }

    public static yh fromJSONOrString(String message, boolean nullable, boolean keepNewlines, int maxLength, boolean checkJsonContentLength) {
        if (message == null) {
            message = "";
        }
        if (nullable && message.isEmpty()) {
            return null;
        }
        yh component = CraftChatMessage.fromJSONOrNull(message);
        if (component != null) {
            String trimmedContent;
            String content;
            if (checkJsonContentLength && (content = CraftChatMessage.fromComponent(component)) != (trimmedContent = CraftChatMessage.trimMessage(content, maxLength))) {
                return CraftChatMessage.fromString(trimmedContent, keepNewlines)[0];
            }
            return component;
        }
        message = CraftChatMessage.trimMessage(message, maxLength);
        return CraftChatMessage.fromString(message, keepNewlines)[0];
    }

    public static String trimMessage(String message, int maxLength) {
        if (message != null && message.length() > maxLength) {
            return message.substring(0, maxLength);
        }
        return message;
    }

    public static String fromComponent(yh component) {
        if (component == null) {
            return "";
        }
        StringBuilder out = new StringBuilder();
        boolean hadFormat = false;
        for (yh c2 : component) {
            zf modi = c2.a();
            zh color = modi.a();
            if (c2.b() != zn.b || color != null) {
                if (color != null) {
                    if (color.format != null) {
                        out.append(color.format);
                    } else {
                        out.append('\u00a7').append("x");
                        for (char magic : color.b().substring(1).toCharArray()) {
                            out.append('\u00a7').append(magic);
                        }
                    }
                    hadFormat = true;
                } else if (hadFormat) {
                    out.append(ChatColor.RESET);
                    hadFormat = false;
                }
            }
            if (modi.c()) {
                out.append(l.r);
                hadFormat = true;
            }
            if (modi.d()) {
                out.append(l.u);
                hadFormat = true;
            }
            if (modi.f()) {
                out.append(l.t);
                hadFormat = true;
            }
            if (modi.e()) {
                out.append(l.s);
                hadFormat = true;
            }
            if (modi.g()) {
                out.append(l.q);
                hadFormat = true;
            }
            c2.b().a(x2 -> {
                out.append(x2);
                return Optional.empty();
            });
        }
        return out.toString();
    }

    public static yh fixComponent(yw component) {
        Matcher matcher = LINK_PATTERN.matcher("");
        return CraftChatMessage.fixComponent(component, matcher);
    }

    private static yh fixComponent(yw component, Matcher matcher) {
        zn text;
        String msg;
        if (component.b() instanceof zn && matcher.reset(msg = (text = (zn)component.b()).b()).find()) {
            matcher.reset();
            zf modifier = component.a();
            ArrayList<yh> extras = new ArrayList<yh>();
            ArrayList<yh> extrasOld = new ArrayList<yh>(component.c());
            component = yh.i();
            int pos = 0;
            while (matcher.find()) {
                Object match = matcher.group();
                if (!((String)match).startsWith("http://") && !((String)match).startsWith("https://")) {
                    match = "http://" + (String)match;
                }
                yw prev = yh.b(msg.substring(pos, matcher.start()));
                prev.b(modifier);
                extras.add(prev);
                yw link = yh.b(matcher.group());
                try {
                    zf linkModi = modifier.a(new yf.f(bhs.a((String)match)));
                    link.b(linkModi);
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
                extras.add(link);
                pos = matcher.end();
            }
            yw prev = yh.b(msg.substring(pos));
            prev.b(modifier);
            extras.add(prev);
            extras.addAll(extrasOld);
            for (yh c2 : extras) {
                component.b(c2);
            }
        }
        List<yh> extras = component.c();
        for (int i2 = 0; i2 < extras.size(); ++i2) {
            yh comp = extras.get(i2);
            if (comp.a() == null || comp.a().i() != null) continue;
            extras.set(i2, CraftChatMessage.fixComponent(comp.f(), matcher));
        }
        if (component.b() instanceof zq) {
            Object[] subs = ((zq)component.b()).d();
            for (int i3 = 0; i3 < subs.length; ++i3) {
                Object comp = subs[i3];
                if (comp instanceof yh) {
                    yh c3 = (yh)comp;
                    if (c3.a() == null || c3.a().i() != null) continue;
                    subs[i3] = CraftChatMessage.fixComponent(c3.f(), matcher);
                    continue;
                }
                if (!(comp instanceof String) || !matcher.reset((String)comp).find()) continue;
                subs[i3] = CraftChatMessage.fixComponent(yh.b((String)comp), matcher);
            }
        }
        return component;
    }

    private CraftChatMessage() {
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (l format : l.values()) {
            builder.put((Object)Character.valueOf(Character.toLowerCase(format.toString().charAt(1))), (Object)format);
        }
        formatMap = builder.build();
    }

    private static final class StringMessage {
        private static final Pattern INCREMENTAL_PATTERN = Pattern.compile("(" + String.valueOf('\u00a7') + "[0-9a-fk-orx])|((?:(?:https?):\\/\\/)?(?:[-\\w_\\.]{2,}\\.[a-z]{2,4}.*?(?=[\\.\\?!,;:]?(?:[" + String.valueOf('\u00a7') + " \\n]|$))))|(\\n)", 2);
        private static final Pattern INCREMENTAL_PATTERN_KEEP_NEWLINES = Pattern.compile("(" + String.valueOf('\u00a7') + "[0-9a-fk-orx])|((?:(?:https?):\\/\\/)?(?:[-\\w_\\.]{2,}\\.[a-z]{2,4}.*?(?=[\\.\\?!,;:]?(?:[" + String.valueOf('\u00a7') + " ]|$))))", 2);
        private static final zf RESET = zf.a.a(false).b(false).c(false).d(false).e(false);
        private final List<yh> list = new ArrayList<yh>();
        private yw currentChatComponent = yh.i();
        private zf modifier = zf.a;
        private final yh[] output;
        private int currentIndex;
        private StringBuilder hex;
        private final String message;

        /*
         * Unable to fully structure code
         */
        private StringMessage(String message, boolean keepNewlines, boolean plain) {
            super();
            this.message = message;
            if (message == null) {
                this.output = new yh[]{this.currentChatComponent};
                return;
            }
            this.list.add(this.currentChatComponent);
            matcher = (keepNewlines != false ? StringMessage.INCREMENTAL_PATTERN_KEEP_NEWLINES : StringMessage.INCREMENTAL_PATTERN).matcher(message);
            match = null;
            needsAdd = false;
            while (matcher.find()) {
                groupId = 0;
                while ((match = matcher.group(++groupId)) == null) {
                }
                index = matcher.start(groupId);
                if (index > this.currentIndex) {
                    needsAdd = false;
                    this.appendNewComponent(index);
                }
                switch (groupId) {
                    case 1: {
                        c = match.toLowerCase(Locale.ROOT).charAt(1);
                        format = CraftChatMessage.formatMap.get(Character.valueOf(c));
                        if (c != 'x') ** GOTO lbl29
                        this.hex = new StringBuilder("#");
                        ** GOTO lbl56
lbl29:
                        // 1 sources

                        if (this.hex == null) ** GOTO lbl36
                        this.hex.append(c);
                        if (this.hex.length() == 7) {
                            this.modifier = StringMessage.RESET.a((zh)zh.a(this.hex.toString()).result().get());
                            this.hex = null;
                        }
                        ** GOTO lbl56
lbl36:
                        // 1 sources

                        if (!format.d() || format == l.v) ** GOTO lbl55
                        switch (1.$SwitchMap$net$minecraft$EnumChatFormat[format.ordinal()]) {
                            case 1: {
                                this.modifier = this.modifier.a(Boolean.TRUE);
                                ** GOTO lbl56
                            }
                            case 2: {
                                this.modifier = this.modifier.b(Boolean.TRUE);
                                ** GOTO lbl56
                            }
                            case 3: {
                                this.modifier = this.modifier.d(Boolean.TRUE);
                                ** GOTO lbl56
                            }
                            case 4: {
                                this.modifier = this.modifier.c(Boolean.TRUE);
                                ** GOTO lbl56
                            }
                            case 5: {
                                this.modifier = this.modifier.e(Boolean.TRUE);
                                ** GOTO lbl56
                            }
                            default: {
                                throw new AssertionError((Object)"Unexpected message format");
                            }
                        }
lbl55:
                        // 1 sources

                        this.modifier = StringMessage.RESET.a(format);
lbl56:
                        // 8 sources

                        needsAdd = true;
                        break;
                    }
                    case 2: {
                        if (plain) {
                            this.appendNewComponent(matcher.end(groupId));
                            break;
                        }
                        if (!match.startsWith("http://") && !match.startsWith("https://")) {
                            match = "http://" + (String)match;
                        }
                        try {
                            this.modifier = this.modifier.a(new yf.f(bhs.a((String)match)));
                        }
                        catch (URISyntaxException var11_11) {
                            // empty catch block
                        }
                        this.appendNewComponent(matcher.end(groupId));
                        this.modifier = this.modifier.a((yf)null);
                        break;
                    }
                    case 3: {
                        if (needsAdd) {
                            this.appendNewComponent(index);
                        }
                        this.currentChatComponent = null;
                    }
                }
                this.currentIndex = matcher.end(groupId);
            }
            if (this.currentIndex < message.length() || needsAdd) {
                this.appendNewComponent(message.length());
            }
            this.output = this.list.toArray(new yh[this.list.size()]);
        }

        private void appendNewComponent(int index) {
            yw addition = yh.b(this.message.substring(this.currentIndex, index)).b(this.modifier);
            this.currentIndex = index;
            if (this.currentChatComponent == null) {
                this.currentChatComponent = yh.i();
                this.list.add(this.currentChatComponent);
            }
            this.currentChatComponent.b(addition);
        }

        private yh[] getOutput() {
            return this.output;
        }
    }

    public static class ChatSerializer {
        private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().create();

        private ChatSerializer() {
        }

        private static yw deserialize(JsonElement jsonelement, jf.a holderlookup_a) {
            return (yw)yj.a.parse(holderlookup_a.a(JsonOps.INSTANCE), (Object)jsonelement).getOrThrow(JsonParseException::new);
        }

        private static JsonElement serialize(yh ichatbasecomponent, jf.a holderlookup_a) {
            return (JsonElement)yj.a.encodeStart(holderlookup_a.a(JsonOps.INSTANCE), (Object)ichatbasecomponent).getOrThrow(JsonParseException::new);
        }

        public static String toJson(yh ichatbasecomponent, jf.a holderlookup_a) {
            return GSON.toJson(ChatSerializer.serialize(ichatbasecomponent, holderlookup_a));
        }

        @Nullable
        public static yw fromJson(String s2, jf.a holderlookup_a) {
            JsonElement jsonelement = JsonParser.parseString((String)s2);
            return jsonelement == null ? null : ChatSerializer.deserialize(jsonelement, holderlookup_a);
        }
    }
}

