/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.math;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.math.MatrixUtil;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.SystemUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.jspecify.annotations.Nullable;

public final class Transformation {
    private final Matrix4fc c;
    public static final Codec<Transformation> a = RecordCodecBuilder.create(var02 -> var02.group((App)ExtraCodecs.e.fieldOf("translation").forGetter(var0 -> var0.e), (App)ExtraCodecs.j.fieldOf("left_rotation").forGetter(var0 -> var0.f), (App)ExtraCodecs.e.fieldOf("scale").forGetter(var0 -> var0.g), (App)ExtraCodecs.j.fieldOf("right_rotation").forGetter(var0 -> var0.h)).apply((Applicative)var02, Transformation::new));
    public static final Codec<Transformation> b = Codec.withAlternative(a, (Codec)ExtraCodecs.k.xmap(Transformation::new, Transformation::c));
    private boolean d;
    private @Nullable Vector3fc e;
    private @Nullable Quaternionfc f;
    private @Nullable Vector3fc g;
    private @Nullable Quaternionfc h;
    private static final Transformation i = SystemUtils.a(() -> {
        Transformation var0 = new Transformation((Matrix4fc)new Matrix4f());
        var0.e = new Vector3f();
        var0.f = new Quaternionf();
        var0.g = new Vector3f(1.0f, 1.0f, 1.0f);
        var0.h = new Quaternionf();
        var0.d = true;
        return var0;
    });

    public Transformation(@Nullable Matrix4fc var0) {
        this.c = var0 == null ? new Matrix4f() : var0;
    }

    public Transformation(@Nullable Vector3fc var0, @Nullable Quaternionfc var1, @Nullable Vector3fc var2, @Nullable Quaternionfc var3) {
        this.c = Transformation.a(var0, var1, var2, var3);
        this.e = var0 != null ? var0 : new Vector3f();
        this.f = var1 != null ? var1 : new Quaternionf();
        this.g = var2 != null ? var2 : new Vector3f(1.0f, 1.0f, 1.0f);
        this.h = var3 != null ? var3 : new Quaternionf();
        this.d = true;
    }

    public static Transformation a() {
        return i;
    }

    public Transformation a(Transformation var0) {
        Matrix4f var1 = this.d();
        var1.mul(var0.c());
        return new Transformation((Matrix4fc)var1);
    }

    public @Nullable Transformation b() {
        if (this == i) {
            return this;
        }
        Matrix4f var0 = this.d().invertAffine();
        if (var0.isFinite()) {
            return new Transformation((Matrix4fc)var0);
        }
        return null;
    }

    private void i() {
        if (!this.d) {
            float var0 = 1.0f / this.c.m33();
            Triple<Quaternionf, Vector3f, Quaternionf> var1 = MatrixUtil.a(new Matrix3f(this.c).scale(var0));
            this.e = this.c.getTranslation(new Vector3f()).mul(var0);
            this.f = new Quaternionf((Quaternionfc)var1.getLeft());
            this.g = new Vector3f((Vector3fc)var1.getMiddle());
            this.h = new Quaternionf((Quaternionfc)var1.getRight());
            this.d = true;
        }
    }

    private static Matrix4f a(@Nullable Vector3fc var0, @Nullable Quaternionfc var1, @Nullable Vector3fc var2, @Nullable Quaternionfc var3) {
        Matrix4f var4 = new Matrix4f();
        if (var0 != null) {
            var4.translation(var0);
        }
        if (var1 != null) {
            var4.rotate(var1);
        }
        if (var2 != null) {
            var4.scale(var2);
        }
        if (var3 != null) {
            var4.rotate(var3);
        }
        return var4;
    }

    public Matrix4fc c() {
        return this.c;
    }

    public Matrix4f d() {
        return new Matrix4f(this.c);
    }

    public Vector3fc e() {
        this.i();
        return this.e;
    }

    public Quaternionfc f() {
        this.i();
        return this.f;
    }

    public Vector3fc g() {
        this.i();
        return this.g;
    }

    public Quaternionfc h() {
        this.i();
        return this.h;
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (var0 == null || this.getClass() != var0.getClass()) {
            return false;
        }
        Transformation var1 = (Transformation)var0;
        return Objects.equals(this.c, var1.c);
    }

    public int hashCode() {
        return Objects.hash(this.c);
    }

    public Transformation a(Transformation var0, float var1) {
        return new Transformation((Vector3fc)this.e().lerp(var0.e(), var1, new Vector3f()), (Quaternionfc)this.f().slerp(var0.f(), var1, new Quaternionf()), (Vector3fc)this.g().lerp(var0.g(), var1, new Vector3f()), (Quaternionfc)this.h().slerp(var0.h(), var1, new Quaternionf()));
    }
}

