/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BinaryOperator;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.EnumChatFormat;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.commands.CommandResultCallback;
import net.minecraft.commands.CommandSigningContext;
import net.minecraft.commands.ExecutionCommandSource;
import net.minecraft.commands.ICommandListener;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.commands.execution.TraceCallbacks;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.OutgoingChatMessage;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.permissions.Permission;
import net.minecraft.server.permissions.PermissionSet;
import net.minecraft.server.permissions.Permissions;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.util.MathHelper;
import net.minecraft.util.TaskChainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.level.World;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_21_R7.command.VanillaCommandWrapper;
import org.jspecify.annotations.Nullable;
import org.spigotmc.SpigotConfig;

public class CommandListenerWrapper
implements ExecutionCommandSource<CommandListenerWrapper>,
ICompletionProvider {
    public static final SimpleCommandExceptionType a = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("permissions.requires.player"));
    public static final SimpleCommandExceptionType b = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("permissions.requires.entity"));
    public final ICommandListener d;
    private final Vec3D e;
    private final WorldServer f;
    private final PermissionSet g;
    private final String h;
    private final IChatBaseComponent i;
    private final MinecraftServer j;
    private final boolean k;
    private final @Nullable Entity l;
    private final CommandResultCallback m;
    private final ArgumentAnchor.Anchor n;
    private final Vec2F o;
    private final CommandSigningContext p;
    private final TaskChainer q;
    private final PermissionSet bukkitPermissions;
    public volatile CommandNode currentCommand;

    public CommandListenerWrapper(ICommandListener icommandlistener, Vec3D vec3d, Vec2F vec2f, WorldServer worldserver, PermissionSet permissionset, String s2, IChatBaseComponent ichatbasecomponent, MinecraftServer minecraftserver, @Nullable Entity entity) {
        this(icommandlistener, vec3d, vec2f, worldserver, permissionset, s2, ichatbasecomponent, minecraftserver, entity, false, CommandResultCallback.a, ArgumentAnchor.Anchor.a, CommandSigningContext.a, TaskChainer.immediate(minecraftserver));
    }

    private CommandListenerWrapper(ICommandListener icommandlistener, Vec3D vec3d, Vec2F vec2f, WorldServer worldserver, PermissionSet permissionset, String s2, IChatBaseComponent ichatbasecomponent, MinecraftServer minecraftserver, @Nullable Entity entity, boolean flag, CommandResultCallback commandresultcallback, ArgumentAnchor.Anchor argumentanchor_anchor, CommandSigningContext commandsigningcontext, TaskChainer taskchainer) {
        this.d = icommandlistener;
        this.e = vec3d;
        this.f = worldserver;
        this.k = flag;
        this.l = entity;
        this.g = permissionset;
        this.h = s2;
        this.i = ichatbasecomponent;
        this.j = minecraftserver;
        this.m = commandresultcallback;
        this.n = argumentanchor_anchor;
        this.o = vec2f;
        this.p = commandsigningcontext;
        this.q = taskchainer;
        this.bukkitPermissions = new DelegatePermissionSet(this.g);
    }

    public CommandListenerWrapper a(ICommandListener icommandlistener) {
        return this.d == icommandlistener ? this : new CommandListenerWrapper(icommandlistener, this.e, this.o, this.f, this.g, this.h, this.i, this.j, this.l, this.k, this.m, this.n, this.p, this.q);
    }

    public CommandListenerWrapper a(Entity entity) {
        return this.l == entity ? this : new CommandListenerWrapper(this.d, this.e, this.o, this.f, this.g, entity.aq(), entity.R_(), this.j, entity, this.k, this.m, this.n, this.p, this.q);
    }

    public CommandListenerWrapper a(Vec3D vec3d) {
        return this.e.equals(vec3d) ? this : new CommandListenerWrapper(this.d, vec3d, this.o, this.f, this.g, this.h, this.i, this.j, this.l, this.k, this.m, this.n, this.p, this.q);
    }

    public CommandListenerWrapper a(Vec2F vec2f) {
        return this.o.c(vec2f) ? this : new CommandListenerWrapper(this.d, this.e, vec2f, this.f, this.g, this.h, this.i, this.j, this.l, this.k, this.m, this.n, this.p, this.q);
    }

    public CommandListenerWrapper a(CommandResultCallback commandresultcallback) {
        return Objects.equals(this.m, commandresultcallback) ? this : new CommandListenerWrapper(this.d, this.e, this.o, this.f, this.g, this.h, this.i, this.j, this.l, this.k, commandresultcallback, this.n, this.p, this.q);
    }

    public CommandListenerWrapper a(CommandResultCallback commandresultcallback, BinaryOperator<CommandResultCallback> binaryoperator) {
        CommandResultCallback commandresultcallback1 = (CommandResultCallback)binaryoperator.apply(this.m, commandresultcallback);
        return this.a(commandresultcallback1);
    }

    public CommandListenerWrapper a() {
        return !this.k && !this.d.o_() ? new CommandListenerWrapper(this.d, this.e, this.o, this.f, this.g, this.h, this.i, this.j, this.l, true, this.m, this.n, this.p, this.q) : this;
    }

    public CommandListenerWrapper a(PermissionSet permissionset) {
        return permissionset == this.g ? this : new CommandListenerWrapper(this.d, this.e, this.o, this.f, permissionset, this.h, this.i, this.j, this.l, this.k, this.m, this.n, this.p, this.q);
    }

    public CommandListenerWrapper b(PermissionSet permissionset) {
        return this.a(this.g.a(permissionset));
    }

    public CommandListenerWrapper a(ArgumentAnchor.Anchor argumentanchor_anchor) {
        return argumentanchor_anchor == this.n ? this : new CommandListenerWrapper(this.d, this.e, this.o, this.f, this.g, this.h, this.i, this.j, this.l, this.k, this.m, argumentanchor_anchor, this.p, this.q);
    }

    public CommandListenerWrapper a(WorldServer worldserver) {
        if (worldserver == this.f) {
            return this;
        }
        double d0 = DimensionManager.a(this.f.F_(), worldserver.F_());
        Vec3D vec3d = new Vec3D(this.e.g * d0, this.e.h, this.e.i * d0);
        return new CommandListenerWrapper(this.d, vec3d, this.o, worldserver, this.g, this.h, this.i, this.j, this.l, this.k, this.m, this.n, this.p, this.q);
    }

    public CommandListenerWrapper a(Entity entity, ArgumentAnchor.Anchor argumentanchor_anchor) {
        return this.b(argumentanchor_anchor.a(entity));
    }

    public CommandListenerWrapper b(Vec3D vec3d) {
        Vec3D vec3d1 = this.n.a(this);
        double d0 = vec3d.g - vec3d1.g;
        double d1 = vec3d.h - vec3d1.h;
        double d2 = vec3d.i - vec3d1.i;
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        float f2 = MathHelper.f((float)(-(MathHelper.d(d1, d3) * 57.2957763671875)));
        float f1 = MathHelper.f((float)(MathHelper.d(d2, d0) * 57.2957763671875) - 90.0f);
        return this.a(new Vec2F(f2, f1));
    }

    public CommandListenerWrapper a(CommandSigningContext commandsigningcontext, TaskChainer taskchainer) {
        return commandsigningcontext == this.p && taskchainer == this.q ? this : new CommandListenerWrapper(this.d, this.e, this.o, this.f, this.g, this.h, this.i, this.j, this.l, this.k, this.m, this.n, commandsigningcontext, taskchainer);
    }

    public IChatBaseComponent b() {
        return this.i;
    }

    public String c() {
        return this.h;
    }

    @Override
    public PermissionSet d() {
        return this.bukkitPermissions;
    }

    public Vec3D e() {
        return this.e;
    }

    public WorldServer f() {
        return this.f;
    }

    public @Nullable Entity g() {
        return this.l;
    }

    public Entity h() throws CommandSyntaxException {
        if (this.l == null) {
            throw b.create();
        }
        return this.l;
    }

    public EntityPlayer i() throws CommandSyntaxException {
        Entity entity = this.l;
        if (entity instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)entity;
            return entityplayer;
        }
        throw a.create();
    }

    public @Nullable EntityPlayer j() {
        EntityPlayer entityplayer1;
        Entity entity = this.l;
        EntityPlayer entityplayer = entity instanceof EntityPlayer ? (entityplayer1 = (EntityPlayer)entity) : null;
        return entityplayer;
    }

    public boolean k() {
        return this.l instanceof EntityPlayer;
    }

    public Vec2F l() {
        return this.o;
    }

    public MinecraftServer m() {
        return this.j;
    }

    public ArgumentAnchor.Anchor n() {
        return this.n;
    }

    public CommandSigningContext o() {
        return this.p;
    }

    public TaskChainer p() {
        return this.q;
    }

    public boolean a(EntityPlayer entityplayer) {
        EntityPlayer entityplayer1 = this.j();
        return entityplayer == entityplayer1 ? false : entityplayer1 != null && entityplayer1.Z() || entityplayer.Z();
    }

    public void a(OutgoingChatMessage outgoingchatmessage, boolean flag, ChatMessageType.a chatmessagetype_a) {
        if (!this.k) {
            EntityPlayer entityplayer = this.j();
            if (entityplayer != null) {
                entityplayer.a(outgoingchatmessage, flag, chatmessagetype_a);
            } else {
                this.d.a(chatmessagetype_a.a(outgoingchatmessage.a()));
            }
        }
    }

    public void a(IChatBaseComponent ichatbasecomponent) {
        if (!this.k) {
            EntityPlayer entityplayer = this.j();
            if (entityplayer != null) {
                entityplayer.a(ichatbasecomponent);
            } else {
                this.d.a(ichatbasecomponent);
            }
        }
    }

    public void a(Supplier<IChatBaseComponent> supplier, boolean flag) {
        boolean flag2;
        boolean flag1 = this.d.x_() && !this.k;
        boolean bl = flag2 = flag && this.d.c() && !this.k;
        if (flag1 || flag2) {
            IChatBaseComponent ichatbasecomponent = supplier.get();
            if (flag1) {
                this.d.a(ichatbasecomponent);
            }
            if (flag2) {
                this.c(ichatbasecomponent);
            }
        }
    }

    private void c(IChatBaseComponent ichatbasecomponent) {
        IChatMutableComponent ichatbasecomponent1 = IChatBaseComponent.a("chat.type.admin", this.b(), ichatbasecomponent).a(EnumChatFormat.h, EnumChatFormat.u);
        GameRules gamerules = this.f.U();
        if (gamerules.a(GameRules.R).booleanValue()) {
            for (EntityPlayer entityplayer : this.j.aj().t()) {
                if (entityplayer.B() == this.d || !entityplayer.getBukkitEntity().hasPermission("minecraft.admin.command_feedback")) continue;
                entityplayer.a(ichatbasecomponent1);
            }
        }
        if (this.d != this.j && gamerules.a(GameRules.w).booleanValue() && !SpigotConfig.silentCommandBlocks) {
            this.j.a(ichatbasecomponent1);
        }
    }

    public void b(IChatBaseComponent ichatbasecomponent) {
        if (this.d.y_() && !this.k) {
            this.d.a(IChatBaseComponent.i().b(ichatbasecomponent).a(EnumChatFormat.m));
        }
    }

    @Override
    public CommandResultCallback q() {
        return this.m;
    }

    @Override
    public Collection<String> r() {
        return Lists.newArrayList((Object[])this.j.S());
    }

    @Override
    public Collection<String> s() {
        return this.j.aK().e();
    }

    @Override
    public Stream<MinecraftKey> t() {
        return BuiltInRegistries.b.s().map(SoundEffect::a);
    }

    @Override
    public CompletableFuture<Suggestions> a(CommandContext<?> commandcontext) {
        return Suggestions.empty();
    }

    @Override
    public CompletableFuture<Suggestions> a(ResourceKey<? extends IRegistry<?>> resourcekey, ICompletionProvider.a icompletionprovider_a, SuggestionsBuilder suggestionsbuilder, CommandContext<?> commandcontext) {
        if (resourcekey == Registries.bK) {
            return ICompletionProvider.a(this.j.aJ().d().stream().map(recipeholder -> recipeholder.a().a()), suggestionsbuilder);
        }
        if (resourcekey == Registries.bJ) {
            Collection<AdvancementHolder> collection = this.j.aB().b();
            return ICompletionProvider.a(collection.stream().map(AdvancementHolder::a), suggestionsbuilder);
        }
        return this.a(resourcekey).map(holderlookup -> {
            this.a((HolderLookup<?>)holderlookup, icompletionprovider_a, suggestionsbuilder);
            return suggestionsbuilder.buildFuture();
        }).orElseGet(Suggestions::empty);
    }

    private Optional<? extends HolderLookup<?>> a(ResourceKey<? extends IRegistry<?>> resourcekey) {
        Optional optional = this.v().a(resourcekey);
        return optional.isPresent() ? optional : this.j.be().a().a(resourcekey);
    }

    @Override
    public Set<ResourceKey<World>> u() {
        return this.j.O();
    }

    @Override
    public IRegistryCustom v() {
        return this.j.bc();
    }

    @Override
    public FeatureFlagSet w() {
        return this.f.Q();
    }

    @Override
    public CommandDispatcher<CommandListenerWrapper> x() {
        return this.m().aC().a();
    }

    @Override
    public void a(CommandExceptionType commandexceptiontype, Message message, boolean flag, @Nullable TraceCallbacks tracecallbacks) {
        if (tracecallbacks != null) {
            tracecallbacks.a(message.getString());
        }
        if (!flag) {
            this.b(ChatComponentUtils.a(message));
        }
    }

    @Override
    public boolean y() {
        return this.k;
    }

    public CommandSender getBukkitSender() {
        return this.d.getBukkitSender(this);
    }

    private class DelegatePermissionSet
    implements PermissionSet {
        private final PermissionSet handle;

        public DelegatePermissionSet(PermissionSet handle) {
            this.handle = handle;
        }

        @Override
        public boolean hasPermission(Permission permission) {
            boolean hasPermission = this.handle.hasPermission(permission);
            CommandNode currentCommand = CommandListenerWrapper.this.currentCommand;
            if (currentCommand != null) {
                return this.hasPermission(hasPermission, VanillaCommandWrapper.getPermission(currentCommand));
            }
            if (permission.equals(Permissions.e)) {
                return this.hasPermission(hasPermission, "minecraft.command.selector");
            }
            return hasPermission;
        }

        public boolean hasPermission(boolean hasPermission, String bukkitPermission) {
            return (CommandListenerWrapper.this.f() == null || !CommandListenerWrapper.this.f().getCraftServer().ignoreVanillaPermissions) && hasPermission || CommandListenerWrapper.this.getBukkitSender().hasPermission(bukkitPermission);
        }
    }
}

