/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SystemUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3D;
import org.jetbrains.annotations.Contract;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.jspecify.annotations.Nullable;

public final class EnumDirection
extends Enum<EnumDirection>
implements INamable {
    public static final /* enum */ EnumDirection a = new EnumDirection(0, 1, -1, "down", EnumAxisDirection.b, EnumAxis.b, new BaseBlockPosition(0, -1, 0));
    public static final /* enum */ EnumDirection b = new EnumDirection(1, 0, -1, "up", EnumAxisDirection.a, EnumAxis.b, new BaseBlockPosition(0, 1, 0));
    public static final /* enum */ EnumDirection c = new EnumDirection(2, 3, 2, "north", EnumAxisDirection.b, EnumAxis.c, new BaseBlockPosition(0, 0, -1));
    public static final /* enum */ EnumDirection d = new EnumDirection(3, 2, 0, "south", EnumAxisDirection.a, EnumAxis.c, new BaseBlockPosition(0, 0, 1));
    public static final /* enum */ EnumDirection e = new EnumDirection(4, 5, 1, "west", EnumAxisDirection.b, EnumAxis.a, new BaseBlockPosition(-1, 0, 0));
    public static final /* enum */ EnumDirection f = new EnumDirection(5, 4, 3, "east", EnumAxisDirection.a, EnumAxis.a, new BaseBlockPosition(1, 0, 0));
    public static final INamable.a<EnumDirection> g;
    public static final Codec<EnumDirection> h;
    public static final IntFunction<EnumDirection> i;
    public static final StreamCodec<ByteBuf, EnumDirection> j;
    @Deprecated
    public static final Codec<EnumDirection> k;
    @Deprecated
    public static final Codec<EnumDirection> l;
    private static final ImmutableList<EnumAxis> m;
    private static final ImmutableList<EnumAxis> n;
    private final int o;
    private final int p;
    private final int q;
    private final String r;
    private final EnumAxis s;
    private final EnumAxisDirection t;
    private final BaseBlockPosition u;
    private final Vec3D v;
    private final Vector3fc w;
    private static final EnumDirection[] x;
    private static final EnumDirection[] y;
    private static final EnumDirection[] z;
    private static final /* synthetic */ EnumDirection[] A;

    public static EnumDirection[] values() {
        return (EnumDirection[])A.clone();
    }

    public static EnumDirection valueOf(String var0) {
        return Enum.valueOf(EnumDirection.class, var0);
    }

    private EnumDirection(int var2, int var3, int var4, String var5, EnumAxisDirection var6, EnumAxis var7, BaseBlockPosition var8) {
        this.o = var2;
        this.q = var4;
        this.p = var3;
        this.r = var5;
        this.s = var7;
        this.t = var6;
        this.u = var8;
        this.v = Vec3D.a(var8);
        this.w = new Vector3f((float)var8.u(), (float)var8.v(), (float)var8.w());
    }

    public static EnumDirection[] a(Entity var0) {
        EnumDirection var17;
        float var1 = var0.i(1.0f) * ((float)Math.PI / 180);
        float var2 = -var0.j(1.0f) * ((float)Math.PI / 180);
        float var3 = MathHelper.a((double)var1);
        float var4 = MathHelper.b((double)var1);
        float var5 = MathHelper.a((double)var2);
        float var6 = MathHelper.b((double)var2);
        boolean var7 = var5 > 0.0f;
        boolean var8 = var3 < 0.0f;
        boolean var9 = var6 > 0.0f;
        float var10 = var7 ? var5 : -var5;
        float var11 = var8 ? -var3 : var3;
        float var12 = var9 ? var6 : -var6;
        float var13 = var10 * var4;
        float var14 = var12 * var4;
        EnumDirection var15 = var7 ? f : e;
        EnumDirection var16 = var8 ? b : a;
        EnumDirection enumDirection = var17 = var9 ? d : c;
        if (var10 > var12) {
            if (var11 > var13) {
                return EnumDirection.a(var16, var15, var17);
            }
            if (var14 > var11) {
                return EnumDirection.a(var15, var17, var16);
            }
            return EnumDirection.a(var15, var16, var17);
        }
        if (var11 > var14) {
            return EnumDirection.a(var16, var17, var15);
        }
        if (var13 > var11) {
            return EnumDirection.a(var17, var15, var16);
        }
        return EnumDirection.a(var17, var16, var15);
    }

    private static EnumDirection[] a(EnumDirection var0, EnumDirection var1, EnumDirection var2) {
        return new EnumDirection[]{var0, var1, var2, var2.g(), var1.g(), var0.g()};
    }

    public static EnumDirection a(Matrix4fc var0, EnumDirection var1) {
        Vector3f var2 = var0.transformDirection(var1.w, new Vector3f());
        return EnumDirection.a(var2.x(), var2.y(), var2.z());
    }

    public static Collection<EnumDirection> a(RandomSource var0) {
        return SystemUtils.b(EnumDirection.values(), var0);
    }

    public static Stream<EnumDirection> a() {
        return Stream.of(x);
    }

    public static float a(EnumDirection var0) {
        return switch (var0.ordinal()) {
            case 2 -> 180.0f;
            case 3 -> 0.0f;
            case 4 -> 90.0f;
            case 5 -> -90.0f;
            default -> throw new IllegalStateException("No y-Rot for vertical axis: " + String.valueOf(var0));
        };
    }

    public Quaternionf b() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> new Quaternionf().rotationX((float)Math.PI);
            case 1 -> new Quaternionf();
            case 2 -> new Quaternionf().rotationXYZ(1.5707964f, 0.0f, (float)Math.PI);
            case 3 -> new Quaternionf().rotationX(1.5707964f);
            case 4 -> new Quaternionf().rotationXYZ(1.5707964f, 0.0f, 1.5707964f);
            case 5 -> new Quaternionf().rotationXYZ(1.5707964f, 0.0f, -1.5707964f);
        };
    }

    public int d() {
        return this.o;
    }

    public int e() {
        return this.q;
    }

    public EnumAxisDirection f() {
        return this.t;
    }

    public static EnumDirection a(Entity var0, EnumAxis var1) {
        return switch (var1.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (f.a(var0.j(1.0f))) {
                    yield f;
                }
                yield e;
            }
            case 2 -> {
                if (d.a(var0.j(1.0f))) {
                    yield d;
                }
                yield c;
            }
            case 1 -> var0.i(1.0f) < 0.0f ? b : a;
        };
    }

    public EnumDirection g() {
        return EnumDirection.a(this.p);
    }

    public EnumDirection a(EnumAxis var0) {
        return switch (var0.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (this == e || this == f) {
                    yield this;
                }
                yield this.t();
            }
            case 1 -> {
                if (this == b || this == a) {
                    yield this;
                }
                yield this.h();
            }
            case 2 -> this == c || this == d ? this : this.v();
        };
    }

    public EnumDirection b(EnumAxis var0) {
        return switch (var0.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (this == e || this == f) {
                    yield this;
                }
                yield this.u();
            }
            case 1 -> {
                if (this == b || this == a) {
                    yield this;
                }
                yield this.i();
            }
            case 2 -> this == c || this == d ? this : this.w();
        };
    }

    public EnumDirection h() {
        return switch (this.ordinal()) {
            case 2 -> f;
            case 5 -> d;
            case 3 -> e;
            case 4 -> c;
            default -> throw new IllegalStateException("Unable to get Y-rotated facing of " + String.valueOf(this));
        };
    }

    private EnumDirection t() {
        return switch (this.ordinal()) {
            case 1 -> c;
            case 2 -> a;
            case 0 -> d;
            case 3 -> b;
            default -> throw new IllegalStateException("Unable to get X-rotated facing of " + String.valueOf(this));
        };
    }

    private EnumDirection u() {
        return switch (this.ordinal()) {
            case 1 -> d;
            case 3 -> a;
            case 0 -> c;
            case 2 -> b;
            default -> throw new IllegalStateException("Unable to get X-rotated facing of " + String.valueOf(this));
        };
    }

    private EnumDirection v() {
        return switch (this.ordinal()) {
            case 1 -> f;
            case 5 -> a;
            case 0 -> e;
            case 4 -> b;
            default -> throw new IllegalStateException("Unable to get Z-rotated facing of " + String.valueOf(this));
        };
    }

    private EnumDirection w() {
        return switch (this.ordinal()) {
            case 1 -> e;
            case 4 -> a;
            case 0 -> f;
            case 5 -> b;
            default -> throw new IllegalStateException("Unable to get Z-rotated facing of " + String.valueOf(this));
        };
    }

    public EnumDirection i() {
        return switch (this.ordinal()) {
            case 2 -> e;
            case 5 -> c;
            case 3 -> f;
            case 4 -> d;
            default -> throw new IllegalStateException("Unable to get CCW facing of " + String.valueOf(this));
        };
    }

    public int j() {
        return this.u.u();
    }

    public int k() {
        return this.u.v();
    }

    public int l() {
        return this.u.w();
    }

    public Vector3f m() {
        return new Vector3f(this.w);
    }

    public String n() {
        return this.r;
    }

    public EnumAxis o() {
        return this.s;
    }

    public static @Nullable EnumDirection a(String var0) {
        return g.a(var0);
    }

    public static EnumDirection a(int var0) {
        return y[MathHelper.a(var0 % y.length)];
    }

    public static EnumDirection b(int var0) {
        return z[MathHelper.a(var0 % z.length)];
    }

    public static EnumDirection a(double var0) {
        return EnumDirection.b(MathHelper.c(var0 / 90.0 + 0.5) & 3);
    }

    public static EnumDirection a(EnumAxis var0, EnumAxisDirection var1) {
        return switch (var0.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (var1 == EnumAxisDirection.a) {
                    yield f;
                }
                yield e;
            }
            case 1 -> {
                if (var1 == EnumAxisDirection.a) {
                    yield b;
                }
                yield a;
            }
            case 2 -> var1 == EnumAxisDirection.a ? d : c;
        };
    }

    public float p() {
        return (this.q & 3) * 90;
    }

    public static EnumDirection b(RandomSource var0) {
        return SystemUtils.a(x, var0);
    }

    public static EnumDirection a(double var0, double var2, double var4) {
        return EnumDirection.a((float)var0, (float)var2, (float)var4);
    }

    public static EnumDirection a(float var0, float var1, float var2) {
        EnumDirection var3 = c;
        float var4 = Float.MIN_VALUE;
        for (EnumDirection var8 : x) {
            float var9 = var0 * (float)var8.u.u() + var1 * (float)var8.u.v() + var2 * (float)var8.u.w();
            if (!(var9 > var4)) continue;
            var4 = var9;
            var3 = var8;
        }
        return var3;
    }

    public static EnumDirection a(Vec3D var0) {
        return EnumDirection.a(var0.g, var0.h, var0.i);
    }

    @Contract(value="_,_,_,!null->!null;_,_,_,_->_")
    public static @Nullable EnumDirection a(int var0, int var1, int var2, @Nullable EnumDirection var3) {
        int var4 = Math.abs(var0);
        int var5 = Math.abs(var1);
        int var6 = Math.abs(var2);
        if (var4 > var6 && var4 > var5) {
            return var0 < 0 ? e : f;
        }
        if (var6 > var4 && var6 > var5) {
            return var2 < 0 ? c : d;
        }
        if (var5 > var4 && var5 > var6) {
            return var1 < 0 ? a : b;
        }
        return var3;
    }

    @Contract(value="_,!null->!null;_,_->_")
    public static @Nullable EnumDirection a(BaseBlockPosition var0, @Nullable EnumDirection var1) {
        return EnumDirection.a(var0.u(), var0.v(), var0.w(), var1);
    }

    public String toString() {
        return this.r;
    }

    @Override
    public String c() {
        return this.r;
    }

    private static DataResult<EnumDirection> b(EnumDirection var0) {
        return var0.o().b() ? DataResult.success((Object)var0) : DataResult.error(() -> "Expected a vertical direction");
    }

    public static EnumDirection a(EnumAxisDirection var0, EnumAxis var1) {
        for (EnumDirection var5 : x) {
            if (var5.f() != var0 || var5.o() != var1) continue;
            return var5;
        }
        throw new IllegalArgumentException("No such direction: " + String.valueOf((Object)var0) + " " + String.valueOf(var1));
    }

    public static ImmutableList<EnumAxis> b(Vec3D var0) {
        if (Math.abs(var0.g) < Math.abs(var0.i)) {
            return n;
        }
        return m;
    }

    public BaseBlockPosition q() {
        return this.u;
    }

    public Vec3D r() {
        return this.v;
    }

    public Vector3fc s() {
        return this.w;
    }

    public boolean a(float var0) {
        float var1 = var0 * ((float)Math.PI / 180);
        float var2 = -MathHelper.a((double)var1);
        float var3 = MathHelper.b((double)var1);
        return (float)this.u.u() * var2 + (float)this.u.w() * var3 > 0.0f;
    }

    private static /* synthetic */ EnumDirection[] y() {
        return new EnumDirection[]{a, b, c, d, e, f};
    }

    static {
        A = EnumDirection.y();
        g = INamable.a(EnumDirection::values);
        h = g.validate(EnumDirection::b);
        i = ByIdMap.a(EnumDirection::d, EnumDirection.values(), ByIdMap.a.b);
        j = ByteBufCodecs.a(i, EnumDirection::d);
        k = Codec.BYTE.xmap(EnumDirection::a, var0 -> (byte)var0.d());
        l = Codec.BYTE.xmap(EnumDirection::b, var0 -> (byte)var0.e());
        m = ImmutableList.of((Object)EnumAxis.b, (Object)EnumAxis.a, (Object)EnumAxis.c);
        n = ImmutableList.of((Object)EnumAxis.b, (Object)EnumAxis.c, (Object)EnumAxis.a);
        x = EnumDirection.values();
        y = (EnumDirection[])Arrays.stream(x).sorted(Comparator.comparingInt(var0 -> var0.o)).toArray(EnumDirection[]::new);
        z = (EnumDirection[])Arrays.stream(x).filter(var0 -> var0.o().d()).sorted(Comparator.comparingInt(var0 -> var0.q)).toArray(EnumDirection[]::new);
    }

    public static abstract sealed class EnumAxis
    extends Enum<EnumAxis>
    implements INamable,
    Predicate<EnumDirection> {
        public static final /* enum */ EnumAxis a = new EnumAxis("x"){

            @Override
            public int a(int var0, int var1, int var2) {
                return var0;
            }

            @Override
            public boolean a(boolean var0, boolean var1, boolean var2) {
                return var0;
            }

            @Override
            public double a(double var0, double var2, double var4) {
                return var0;
            }

            @Override
            public EnumDirection e() {
                return EnumDirection.f;
            }

            @Override
            public EnumDirection f() {
                return EnumDirection.e;
            }

            @Override
            public /* synthetic */ boolean test(@Nullable Object object) {
                return super.a((EnumDirection)object);
            }
        };
        public static final /* enum */ EnumAxis b = new EnumAxis("y"){

            @Override
            public int a(int var0, int var1, int var2) {
                return var1;
            }

            @Override
            public double a(double var0, double var2, double var4) {
                return var2;
            }

            @Override
            public boolean a(boolean var0, boolean var1, boolean var2) {
                return var1;
            }

            @Override
            public EnumDirection e() {
                return EnumDirection.b;
            }

            @Override
            public EnumDirection f() {
                return EnumDirection.a;
            }

            @Override
            public /* synthetic */ boolean test(@Nullable Object object) {
                return super.a((EnumDirection)object);
            }
        };
        public static final /* enum */ EnumAxis c = new EnumAxis("z"){

            @Override
            public int a(int var0, int var1, int var2) {
                return var2;
            }

            @Override
            public double a(double var0, double var2, double var4) {
                return var4;
            }

            @Override
            public boolean a(boolean var0, boolean var1, boolean var2) {
                return var2;
            }

            @Override
            public EnumDirection e() {
                return EnumDirection.d;
            }

            @Override
            public EnumDirection f() {
                return EnumDirection.c;
            }

            @Override
            public /* synthetic */ boolean test(@Nullable Object object) {
                return super.a((EnumDirection)object);
            }
        };
        public static final EnumAxis[] d;
        public static final INamable.a<EnumAxis> e;
        private final String f;
        private static final /* synthetic */ EnumAxis[] g;

        public static EnumAxis[] values() {
            return (EnumAxis[])g.clone();
        }

        public static EnumAxis valueOf(String var0) {
            return Enum.valueOf(EnumAxis.class, var0);
        }

        EnumAxis(String var2) {
            this.f = var2;
        }

        public static @Nullable EnumAxis a(String var0) {
            return e.a(var0);
        }

        public String a() {
            return this.f;
        }

        public boolean b() {
            return this == b;
        }

        public boolean d() {
            return this == a || this == c;
        }

        public abstract EnumDirection e();

        public abstract EnumDirection f();

        public EnumDirection[] g() {
            return new EnumDirection[]{this.e(), this.f()};
        }

        public String toString() {
            return this.f;
        }

        public static EnumAxis a(RandomSource var0) {
            return SystemUtils.a(d, var0);
        }

        public boolean a(@Nullable EnumDirection var0) {
            return var0 != null && var0.o() == this;
        }

        public EnumDirectionLimit h() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0, 2 -> EnumDirectionLimit.a;
                case 1 -> EnumDirectionLimit.b;
            };
        }

        @Override
        public String c() {
            return this.f;
        }

        public abstract int a(int var1, int var2, int var3);

        public abstract double a(double var1, double var3, double var5);

        public abstract boolean a(boolean var1, boolean var2, boolean var3);

        @Override
        public /* synthetic */ boolean test(@Nullable Object object) {
            return this.a((EnumDirection)object);
        }

        private static /* synthetic */ EnumAxis[] i() {
            return new EnumAxis[]{a, b, c};
        }

        static {
            g = EnumAxis.i();
            d = EnumAxis.values();
            e = INamable.a(EnumAxis::values);
        }
    }

    public static final class EnumAxisDirection
    extends Enum<EnumAxisDirection> {
        public static final /* enum */ EnumAxisDirection a = new EnumAxisDirection(1, "Towards positive");
        public static final /* enum */ EnumAxisDirection b = new EnumAxisDirection(-1, "Towards negative");
        private final int c;
        private final String d;
        private static final /* synthetic */ EnumAxisDirection[] e;

        public static EnumAxisDirection[] values() {
            return (EnumAxisDirection[])e.clone();
        }

        public static EnumAxisDirection valueOf(String var0) {
            return Enum.valueOf(EnumAxisDirection.class, var0);
        }

        private EnumAxisDirection(int var2, String var3) {
            this.c = var2;
            this.d = var3;
        }

        public int a() {
            return this.c;
        }

        public String b() {
            return this.d;
        }

        public String toString() {
            return this.d;
        }

        public EnumAxisDirection c() {
            return this == a ? b : a;
        }

        private static /* synthetic */ EnumAxisDirection[] d() {
            return new EnumAxisDirection[]{a, b};
        }

        static {
            e = EnumAxisDirection.d();
        }
    }

    public static final class EnumDirectionLimit
    extends Enum<EnumDirectionLimit>
    implements Iterable<EnumDirection>,
    Predicate<EnumDirection> {
        public static final /* enum */ EnumDirectionLimit a = new EnumDirectionLimit(new EnumDirection[]{c, f, d, e}, new EnumAxis[]{EnumAxis.a, EnumAxis.c});
        public static final /* enum */ EnumDirectionLimit b = new EnumDirectionLimit(new EnumDirection[]{b, a}, new EnumAxis[]{EnumAxis.b});
        private final EnumDirection[] c;
        private final EnumAxis[] d;
        private static final /* synthetic */ EnumDirectionLimit[] e;

        public static EnumDirectionLimit[] values() {
            return (EnumDirectionLimit[])e.clone();
        }

        public static EnumDirectionLimit valueOf(String var0) {
            return Enum.valueOf(EnumDirectionLimit.class, var0);
        }

        private EnumDirectionLimit(EnumDirection[] var2, EnumAxis[] var3) {
            this.c = var2;
            this.d = var3;
        }

        public EnumDirection a(RandomSource var0) {
            return SystemUtils.a(this.c, var0);
        }

        public EnumAxis b(RandomSource var0) {
            return SystemUtils.a(this.d, var0);
        }

        public boolean a(@Nullable EnumDirection var0) {
            return var0 != null && var0.o().h() == this;
        }

        @Override
        public Iterator<EnumDirection> iterator() {
            return Iterators.forArray((Object[])this.c);
        }

        public Stream<EnumDirection> a() {
            return Arrays.stream(this.c);
        }

        public List<EnumDirection> c(RandomSource var0) {
            return SystemUtils.b(this.c, var0);
        }

        public int b() {
            return this.c.length;
        }

        @Override
        public /* synthetic */ boolean test(@Nullable Object object) {
            return this.a((EnumDirection)object);
        }

        private static /* synthetic */ EnumDirectionLimit[] c() {
            return new EnumDirectionLimit[]{a, b};
        }

        static {
            e = EnumDirectionLimit.c();
        }
    }
}

