/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.annotations.VisibleForTesting;
import net.minecraft.nbt.NbtAccounterException;

public class NBTReadLimiter {
    public static final int a = 0x200000;
    public static final int b = 0x6400000;
    private static final int c = 512;
    private final long d;
    private long e;
    private final int f;
    private int g;

    public NBTReadLimiter(long var0, int var2) {
        this.d = var0;
        this.f = var2;
    }

    public static NBTReadLimiter a(long var0) {
        return new NBTReadLimiter(var0, 512);
    }

    public static NBTReadLimiter a() {
        return new NBTReadLimiter(0x200000L, 512);
    }

    public static NBTReadLimiter b() {
        return new NBTReadLimiter(0x6400000L, 512);
    }

    public static NBTReadLimiter c() {
        return new NBTReadLimiter(Long.MAX_VALUE, 512);
    }

    public void a(long var0, long var2) {
        this.b(var0 * var2);
    }

    public void b(long var0) {
        if (var0 < 0L) {
            throw new IllegalArgumentException("Tried to account NBT tag with negative size: " + var0);
        }
        if (this.e + var0 > this.d) {
            throw new NbtAccounterException("Tried to read NBT tag that was too big; tried to allocate: " + this.e + " + " + var0 + " bytes where max allowed: " + this.d);
        }
        this.e += var0;
    }

    public void d() {
        if (this.g >= this.f) {
            throw new NbtAccounterException("Tried to read NBT tag with too high complexity, depth > " + this.f);
        }
        ++this.g;
    }

    public void e() {
        if (this.g <= 0) {
            throw new NbtAccounterException("NBT-Accounter tried to pop stack-depth at top-level");
        }
        --this.g;
    }

    @VisibleForTesting
    public long f() {
        return this.e;
    }

    @VisibleForTesting
    public int g() {
        return this.g;
    }
}

