/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import com.google.common.collect.Queues;
import com.mojang.authlib.properties.Property;
import com.mojang.logging.LogUtils;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.local.LocalChannel;
import io.netty.channel.local.LocalServerChannel;
import io.netty.handler.flow.FlowControlHandler;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.handler.timeout.TimeoutException;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.Objects;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Consumer;
import javax.crypto.Cipher;
import net.minecraft.SharedConstants;
import net.minecraft.network.BandwidthDebugMonitor;
import net.minecraft.network.ClientboundPacketListener;
import net.minecraft.network.DisconnectionDetails;
import net.minecraft.network.EnumProtocol;
import net.minecraft.network.LocalFrameDecoder;
import net.minecraft.network.LocalFrameEncoder;
import net.minecraft.network.MonitoredLocalFrameDecoder;
import net.minecraft.network.PacketBundlePacker;
import net.minecraft.network.PacketBundleUnpacker;
import net.minecraft.network.PacketCompressor;
import net.minecraft.network.PacketDecoder;
import net.minecraft.network.PacketDecompressor;
import net.minecraft.network.PacketDecrypter;
import net.minecraft.network.PacketEncoder;
import net.minecraft.network.PacketEncrypter;
import net.minecraft.network.PacketListener;
import net.minecraft.network.PacketPrepender;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.PacketSplitter;
import net.minecraft.network.ProtocolInfo;
import net.minecraft.network.ServerboundPacketListener;
import net.minecraft.network.SkipEncodeException;
import net.minecraft.network.TickablePacketListener;
import net.minecraft.network.UnconfiguredPipelineHandler;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.BundlerInfo;
import net.minecraft.network.protocol.EnumProtocolDirection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundDisconnectPacket;
import net.minecraft.network.protocol.handshake.ClientIntent;
import net.minecraft.network.protocol.handshake.HandshakeProtocols;
import net.minecraft.network.protocol.handshake.PacketHandshakingInListener;
import net.minecraft.network.protocol.handshake.PacketHandshakingInSetProtocol;
import net.minecraft.network.protocol.login.LoginProtocols;
import net.minecraft.network.protocol.login.PacketLoginOutDisconnect;
import net.minecraft.network.protocol.login.PacketLoginOutListener;
import net.minecraft.network.protocol.status.PacketStatusOutListener;
import net.minecraft.network.protocol.status.StatusProtocols;
import net.minecraft.server.CancelledPacketHandleException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.network.EventLoopGroupHolder;
import net.minecraft.util.MathHelper;
import net.minecraft.util.SystemUtils;
import net.minecraft.util.debugchart.LocalSampleLogger;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class NetworkManager
extends SimpleChannelInboundHandler<Packet<?>> {
    private static final float e = 0.75f;
    private static final Logger f = LogUtils.getLogger();
    public static final Marker a = MarkerFactory.getMarker((String)"NETWORK");
    public static final Marker b = SystemUtils.a(MarkerFactory.getMarker((String)"NETWORK_PACKETS"), (? super T marker) -> marker.add(a));
    public static final Marker c = SystemUtils.a(MarkerFactory.getMarker((String)"PACKET_RECEIVED"), (? super T marker) -> marker.add(b));
    public static final Marker d = SystemUtils.a(MarkerFactory.getMarker((String)"PACKET_SENT"), (? super T marker) -> marker.add(b));
    private static final ProtocolInfo<PacketHandshakingInListener> g = HandshakeProtocols.b;
    private final EnumProtocolDirection h;
    private volatile boolean i = true;
    private final Queue<Consumer<NetworkManager>> j = Queues.newConcurrentLinkedQueue();
    public Channel k;
    public SocketAddress l;
    public UUID spoofedUUID;
    public Property[] spoofedProfile;
    public boolean preparing = true;
    private volatile @Nullable PacketListener m;
    private volatile @Nullable PacketListener n;
    private @Nullable DisconnectionDetails o;
    private boolean p;
    private boolean q;
    private int r;
    private int s;
    private float t;
    private float u;
    private int v;
    private boolean w;
    private volatile @Nullable DisconnectionDetails x;
    @Nullable BandwidthDebugMonitor y;
    public String hostname = "";

    public NetworkManager(EnumProtocolDirection enumprotocoldirection) {
        this.h = enumprotocoldirection;
    }

    public void channelActive(ChannelHandlerContext channelhandlercontext) throws Exception {
        super.channelActive(channelhandlercontext);
        this.k = channelhandlercontext.channel();
        this.l = this.k.remoteAddress();
        this.preparing = false;
        if (this.x != null) {
            this.a(this.x);
        }
    }

    public void channelInactive(ChannelHandlerContext channelhandlercontext) {
        this.a(IChatBaseComponent.c("disconnect.endOfStream"));
    }

    public void exceptionCaught(ChannelHandlerContext channelhandlercontext, Throwable throwable) {
        if (throwable instanceof SkipEncodeException) {
            f.debug("Skipping packet due to errors", throwable.getCause());
        } else {
            boolean flag = !this.w;
            this.w = true;
            if (this.k.isOpen()) {
                if (throwable instanceof TimeoutException) {
                    f.debug("Timeout", throwable);
                    this.a(IChatBaseComponent.c("disconnect.timeout"));
                } else {
                    IChatMutableComponent ichatbasecomponent = IChatBaseComponent.a("disconnect.genericReason", new Object[]{"Internal Exception: " + String.valueOf(throwable)});
                    PacketListener packetlistener = this.n;
                    DisconnectionDetails disconnectiondetails = packetlistener != null ? packetlistener.a(ichatbasecomponent, throwable) : new DisconnectionDetails(ichatbasecomponent);
                    if (flag) {
                        f.debug("Failed to sent packet", throwable);
                        if (this.g() == EnumProtocolDirection.b) {
                            Packet packet = (Packet)((Object)(this.i ? new PacketLoginOutDisconnect(ichatbasecomponent) : new ClientboundDisconnectPacket(ichatbasecomponent)));
                            this.a(packet, PacketSendListener.a(() -> this.a(disconnectiondetails)));
                        } else {
                            this.a(disconnectiondetails);
                        }
                        this.m();
                    } else {
                        f.debug("Double fault", throwable);
                        this.a(disconnectiondetails);
                    }
                }
            }
        }
        if (MinecraftServer.getServer().isDebugging()) {
            throwable.printStackTrace();
        }
    }

    protected void a(ChannelHandlerContext channelhandlercontext, Packet<?> packet) {
        if (this.k.isOpen()) {
            PacketListener packetlistener = this.n;
            if (packetlistener == null) {
                throw new IllegalStateException("Received a packet before the packet listener was initialized");
            }
            if (packetlistener.a(packet)) {
                try {
                    NetworkManager.a(packet, packetlistener);
                }
                catch (CancelledPacketHandleException cancelledPacketHandleException) {
                }
                catch (RejectedExecutionException rejectedexecutionexception) {
                    this.a(IChatBaseComponent.c("multiplayer.disconnect.server_shutdown"));
                }
                catch (ClassCastException classcastexception) {
                    f.error("Received {} that couldn't be processed", packet.getClass(), (Object)classcastexception);
                    this.a(IChatBaseComponent.c("multiplayer.disconnect.invalid_packet"));
                }
                ++this.r;
            }
        }
    }

    private static <T extends PacketListener> void a(Packet<T> packet, PacketListener packetlistener) {
        packet.a(packetlistener);
    }

    private void b(ProtocolInfo<?> protocolinfo, PacketListener packetlistener) {
        Objects.requireNonNull(packetlistener, "packetListener");
        EnumProtocolDirection enumprotocoldirection = packetlistener.N_();
        if (enumprotocoldirection != this.h) {
            String s2 = String.valueOf((Object)this.h);
            throw new IllegalStateException("Trying to set listener for wrong side: connection is " + s2 + ", but listener is " + String.valueOf((Object)enumprotocoldirection));
        }
        EnumProtocol enumprotocol = packetlistener.b();
        if (protocolinfo.a() != enumprotocol) {
            String s1 = String.valueOf((Object)enumprotocol);
            throw new IllegalStateException("Listener protocol (" + s1 + ") does not match requested one " + String.valueOf(protocolinfo));
        }
    }

    private static void a(ChannelFuture channelfuture) {
        try {
            channelfuture.syncUninterruptibly();
        }
        catch (Exception exception) {
            if (exception instanceof ClosedChannelException) {
                f.info("Connection closed during protocol change");
            }
            throw exception;
        }
    }

    public <T extends PacketListener> void a(ProtocolInfo<T> protocolinfo, T t0) {
        this.b(protocolinfo, t0);
        if (protocolinfo.b() != this.f()) {
            throw new IllegalStateException("Invalid inbound protocol: " + String.valueOf((Object)protocolinfo.a()));
        }
        this.n = t0;
        this.m = null;
        UnconfiguredPipelineHandler.b unconfiguredpipelinehandler_b = UnconfiguredPipelineHandler.a(protocolinfo);
        BundlerInfo bundlerinfo = protocolinfo.d();
        if (bundlerinfo != null) {
            PacketBundlePacker packetbundlepacker = new PacketBundlePacker(bundlerinfo);
            unconfiguredpipelinehandler_b = unconfiguredpipelinehandler_b.andThen(channelhandlercontext -> channelhandlercontext.pipeline().addAfter("decoder", "bundler", (ChannelHandler)packetbundlepacker));
        }
        NetworkManager.a(this.k.writeAndFlush((Object)unconfiguredpipelinehandler_b));
    }

    public void a(ProtocolInfo<?> protocolinfo) {
        if (protocolinfo.b() != this.g()) {
            throw new IllegalStateException("Invalid outbound protocol: " + String.valueOf((Object)protocolinfo.a()));
        }
        UnconfiguredPipelineHandler.d unconfiguredpipelinehandler_d = UnconfiguredPipelineHandler.b(protocolinfo);
        BundlerInfo bundlerinfo = protocolinfo.d();
        if (bundlerinfo != null) {
            PacketBundleUnpacker packetbundleunpacker = new PacketBundleUnpacker(bundlerinfo);
            unconfiguredpipelinehandler_d = unconfiguredpipelinehandler_d.andThen(channelhandlercontext -> channelhandlercontext.pipeline().addAfter("encoder", "unbundler", (ChannelHandler)packetbundleunpacker));
        }
        boolean flag = protocolinfo.a() == EnumProtocol.d;
        NetworkManager.a(this.k.writeAndFlush((Object)unconfiguredpipelinehandler_d.andThen(channelhandlercontext -> {
            this.i = flag;
        })));
    }

    public void a(PacketListener packetlistener) {
        if (this.n != null) {
            throw new IllegalStateException("Listener already set");
        }
        if (this.h != EnumProtocolDirection.a || packetlistener.N_() != EnumProtocolDirection.a || packetlistener.b() != g.a()) {
            throw new IllegalStateException("Invalid initial listener");
        }
        this.n = packetlistener;
    }

    public void a(String s2, int i2, PacketStatusOutListener packetstatusoutlistener) {
        this.a(s2, i2, StatusProtocols.b, StatusProtocols.d, packetstatusoutlistener, ClientIntent.a);
    }

    public void a(String s2, int i2, PacketLoginOutListener packetloginoutlistener) {
        this.a(s2, i2, LoginProtocols.b, LoginProtocols.d, packetloginoutlistener, ClientIntent.b);
    }

    public <S extends ServerboundPacketListener, C extends ClientboundPacketListener> void a(String s2, int i2, ProtocolInfo<S> protocolinfo, ProtocolInfo<C> protocolinfo1, C c0, boolean flag) {
        this.a(s2, i2, protocolinfo, protocolinfo1, c0, flag ? ClientIntent.c : ClientIntent.b);
    }

    private <S extends ServerboundPacketListener, C extends ClientboundPacketListener> void a(String s2, int i2, ProtocolInfo<S> protocolinfo, ProtocolInfo<C> protocolinfo1, C c0, ClientIntent clientintent) {
        if (protocolinfo.a() != protocolinfo1.a()) {
            throw new IllegalStateException("Mismatched initial protocols");
        }
        this.m = c0;
        this.a((NetworkManager networkmanager) -> {
            this.a(protocolinfo1, c0);
            networkmanager.b(new PacketHandshakingInSetProtocol(SharedConstants.b().d(), s2, i2, clientintent), null, true);
            this.a(protocolinfo);
        });
    }

    public void a(Packet<?> packet) {
        this.a(packet, (ChannelFutureListener)null);
    }

    public void a(Packet<?> packet, @Nullable ChannelFutureListener channelfuturelistener) {
        this.a(packet, channelfuturelistener, true);
    }

    public void a(Packet<?> packet, @Nullable ChannelFutureListener channelfuturelistener, boolean flag) {
        if (this.i()) {
            this.r();
            this.b(packet, channelfuturelistener, flag);
        } else {
            this.j.add(networkmanager -> networkmanager.b(packet, channelfuturelistener, flag));
        }
    }

    public void a(Consumer<NetworkManager> consumer) {
        if (this.i()) {
            this.r();
            consumer.accept(this);
        } else {
            this.j.add(consumer);
        }
    }

    private void b(Packet<?> packet, @Nullable ChannelFutureListener channelfuturelistener, boolean flag) {
        ++this.s;
        if (this.k.eventLoop().inEventLoop()) {
            this.c(packet, channelfuturelistener, flag);
        } else {
            this.k.eventLoop().execute(() -> this.c(packet, channelfuturelistener, flag));
        }
    }

    private void c(Packet<?> packet, @Nullable ChannelFutureListener channelfuturelistener, boolean flag) {
        if (channelfuturelistener != null) {
            ChannelFuture channelfuture = flag ? this.k.writeAndFlush(packet) : this.k.write(packet);
            channelfuture.addListener((GenericFutureListener)channelfuturelistener);
        } else if (flag) {
            this.k.writeAndFlush(packet, this.k.voidPromise());
        } else {
            this.k.write(packet, this.k.voidPromise());
        }
    }

    public void a() {
        if (this.i()) {
            this.q();
        } else {
            this.j.add(NetworkManager::q);
        }
    }

    private void q() {
        if (this.k.eventLoop().inEventLoop()) {
            this.k.flush();
        } else {
            this.k.eventLoop().execute(() -> this.k.flush());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void r() {
        if (this.k != null && this.k.isOpen()) {
            Queue<Consumer<NetworkManager>> queue = this.j;
            synchronized (queue) {
                Consumer<NetworkManager> consumer;
                while ((consumer = this.j.poll()) != null) {
                    consumer.accept(this);
                }
            }
        }
    }

    public void b() {
        this.r();
        PacketListener packetlistener = this.n;
        if (packetlistener instanceof TickablePacketListener) {
            TickablePacketListener tickablepacketlistener = (TickablePacketListener)packetlistener;
            tickablepacketlistener.d();
        }
        if (!this.i() && !this.q) {
            this.n();
        }
        if (this.k != null) {
            this.k.flush();
        }
        if (this.v++ % 20 == 0) {
            this.c();
        }
        if (this.y != null) {
            this.y.a();
        }
    }

    protected void c() {
        this.u = MathHelper.h(0.75f, this.s, this.u);
        this.t = MathHelper.h(0.75f, this.r, this.t);
        this.s = 0;
        this.r = 0;
    }

    public SocketAddress d() {
        return this.l;
    }

    public String a(boolean flag) {
        return this.l == null ? "local" : (flag ? this.l.toString() : "IP hidden");
    }

    public void a(IChatBaseComponent ichatbasecomponent) {
        this.a(new DisconnectionDetails(ichatbasecomponent));
    }

    public void a(DisconnectionDetails disconnectiondetails) {
        this.preparing = false;
        if (this.k == null) {
            this.x = disconnectiondetails;
        }
        if (this.i()) {
            this.k.close();
            this.o = disconnectiondetails;
        }
    }

    public boolean e() {
        return this.k instanceof LocalChannel || this.k instanceof LocalServerChannel;
    }

    public EnumProtocolDirection f() {
        return this.h;
    }

    public EnumProtocolDirection g() {
        return this.h.a();
    }

    public static NetworkManager a(InetSocketAddress inetsocketaddress, EventLoopGroupHolder eventloopgroupholder, @Nullable LocalSampleLogger localsamplelogger) {
        NetworkManager networkmanager = new NetworkManager(EnumProtocolDirection.b);
        if (localsamplelogger != null) {
            networkmanager.a(localsamplelogger);
        }
        ChannelFuture channelfuture = NetworkManager.a(inetsocketaddress, eventloopgroupholder, networkmanager);
        channelfuture.syncUninterruptibly();
        return networkmanager;
    }

    public static ChannelFuture a(InetSocketAddress inetsocketaddress, EventLoopGroupHolder eventloopgroupholder, final NetworkManager networkmanager) {
        return ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(eventloopgroupholder.c())).handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel channel) {
                try {
                    channel.config().setOption(ChannelOption.TCP_NODELAY, (Object)true);
                }
                catch (ChannelException channelException) {
                    // empty catch block
                }
                ChannelPipeline channelpipeline = channel.pipeline().addLast("timeout", (ChannelHandler)new ReadTimeoutHandler(30));
                NetworkManager.a(channelpipeline, EnumProtocolDirection.b, false, networkmanager.y);
                networkmanager.a(channelpipeline);
            }
        })).channel(eventloopgroupholder.d())).connect(inetsocketaddress.getAddress(), inetsocketaddress.getPort());
    }

    private static String b(boolean flag) {
        return flag ? "encoder" : "outbound_config";
    }

    private static String c(boolean flag) {
        return flag ? "decoder" : "inbound_config";
    }

    public void a(ChannelPipeline channelpipeline) {
        channelpipeline.addLast("hackfix", (ChannelHandler)new ChannelOutboundHandlerAdapter(this){

            public void write(ChannelHandlerContext channelhandlercontext, Object object, ChannelPromise channelpromise) throws Exception {
                super.write(channelhandlercontext, object, channelpromise);
            }
        }).addLast("packet_handler", (ChannelHandler)this);
    }

    public static void a(ChannelPipeline channelpipeline, EnumProtocolDirection enumprotocoldirection, boolean flag, @Nullable BandwidthDebugMonitor bandwidthdebugmonitor) {
        EnumProtocolDirection enumprotocoldirection1 = enumprotocoldirection.a();
        boolean flag1 = enumprotocoldirection == EnumProtocolDirection.a;
        boolean flag2 = enumprotocoldirection1 == EnumProtocolDirection.a;
        channelpipeline.addLast("splitter", (ChannelHandler)NetworkManager.a(bandwidthdebugmonitor, flag)).addLast(new ChannelHandler[]{new FlowControlHandler()}).addLast(NetworkManager.c(flag1), flag1 ? new PacketDecoder<PacketHandshakingInListener>(g) : new UnconfiguredPipelineHandler.a()).addLast("prepender", (ChannelHandler)NetworkManager.d(flag)).addLast(NetworkManager.b(flag2), flag2 ? new PacketEncoder<PacketHandshakingInListener>(g) : new UnconfiguredPipelineHandler.c());
    }

    private static ChannelOutboundHandler d(boolean flag) {
        return flag ? new LocalFrameEncoder() : new PacketPrepender();
    }

    private static ChannelInboundHandler a(@Nullable BandwidthDebugMonitor bandwidthdebugmonitor, boolean flag) {
        return !flag ? new PacketSplitter(bandwidthdebugmonitor) : (bandwidthdebugmonitor != null ? new MonitoredLocalFrameDecoder(bandwidthdebugmonitor) : new LocalFrameDecoder());
    }

    public static void a(ChannelPipeline channelpipeline, EnumProtocolDirection enumprotocoldirection) {
        NetworkManager.a(channelpipeline, enumprotocoldirection, true, null);
    }

    public static NetworkManager a(SocketAddress socketaddress) {
        final NetworkManager networkmanager = new NetworkManager(EnumProtocolDirection.b);
        ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(EventLoopGroupHolder.a().c())).handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel channel) {
                ChannelPipeline channelpipeline = channel.pipeline();
                NetworkManager.a(channelpipeline, EnumProtocolDirection.b);
                networkmanager.a(channelpipeline);
            }
        })).channel(EventLoopGroupHolder.a().d())).connect(socketaddress).syncUninterruptibly();
        return networkmanager;
    }

    public void a(Cipher cipher, Cipher cipher1) {
        this.p = true;
        this.k.pipeline().addBefore("splitter", "decrypt", (ChannelHandler)new PacketDecrypter(cipher));
        this.k.pipeline().addBefore("prepender", "encrypt", (ChannelHandler)new PacketEncrypter(cipher1));
    }

    public boolean h() {
        return this.p;
    }

    public boolean i() {
        return this.k != null && this.k.isOpen();
    }

    public boolean j() {
        return this.k == null;
    }

    public @Nullable PacketListener k() {
        return this.n;
    }

    public @Nullable DisconnectionDetails l() {
        return this.o;
    }

    public void m() {
        if (this.k != null) {
            this.k.config().setAutoRead(false);
        }
    }

    public void a(int i2, boolean flag) {
        if (i2 >= 0) {
            ChannelHandler channelhandler = this.k.pipeline().get("decompress");
            if (channelhandler instanceof PacketDecompressor) {
                PacketDecompressor packetdecompressor = (PacketDecompressor)channelhandler;
                packetdecompressor.a(i2, flag);
            } else {
                this.k.pipeline().addAfter("splitter", "decompress", (ChannelHandler)new PacketDecompressor(i2, flag));
            }
            channelhandler = this.k.pipeline().get("compress");
            if (channelhandler instanceof PacketCompressor) {
                PacketCompressor packetcompressor = (PacketCompressor)channelhandler;
                packetcompressor.a(i2);
            } else {
                this.k.pipeline().addAfter("prepender", "compress", (ChannelHandler)new PacketCompressor(i2));
            }
        } else {
            if (this.k.pipeline().get("decompress") instanceof PacketDecompressor) {
                this.k.pipeline().remove("decompress");
            }
            if (this.k.pipeline().get("compress") instanceof PacketCompressor) {
                this.k.pipeline().remove("compress");
            }
        }
    }

    public void n() {
        if (this.k != null && !this.k.isOpen()) {
            if (this.q) {
                f.warn("handleDisconnection() called twice");
            } else {
                PacketListener packetlistener1;
                this.q = true;
                PacketListener packetlistener = this.k();
                PacketListener packetListener = packetlistener1 = packetlistener != null ? packetlistener : this.m;
                if (packetlistener1 != null) {
                    DisconnectionDetails disconnectiondetails = Objects.requireNonNullElseGet(this.l(), () -> new DisconnectionDetails(IChatBaseComponent.c("multiplayer.disconnect.generic")));
                    packetlistener1.a(disconnectiondetails);
                }
                this.j.clear();
            }
        }
    }

    public float o() {
        return this.t;
    }

    public float p() {
        return this.u;
    }

    public void a(LocalSampleLogger localsamplelogger) {
        this.y = new BandwidthDebugMonitor(localsamplelogger);
    }
}

