/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import io.netty.util.ByteProcessor;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.charset.Charset;
import java.security.PublicKey;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.ToIntFunction;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagEnd;
import net.minecraft.network.LpVec3;
import net.minecraft.network.Utf8String;
import net.minecraft.network.VarInt;
import net.minecraft.network.VarLong;
import net.minecraft.network.codec.StreamDecoder;
import net.minecraft.network.codec.StreamEncoder;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.CryptographyException;
import net.minecraft.util.LenientJsonParser;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MinecraftEncryption;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.jspecify.annotations.Nullable;

public class PacketDataSerializer
extends ByteBuf {
    private final ByteBuf c;
    public static final short a = Short.MAX_VALUE;
    public static final int b = 262144;
    private static final int d = 256;
    private static final int e = 256;
    private static final int f = 512;
    private static final Gson g = new Gson();

    public PacketDataSerializer(ByteBuf bytebuf) {
        this.c = bytebuf;
    }

    @Deprecated
    public <T> T a(DynamicOps<NBTBase> dynamicops, Codec<T> codec) {
        return this.a(dynamicops, codec, NBTReadLimiter.c());
    }

    @Deprecated
    public <T> T a(DynamicOps<NBTBase> dynamicops, Codec<T> codec, NBTReadLimiter nbtreadlimiter) {
        NBTBase nbtbase = this.a(nbtreadlimiter);
        return (T)codec.parse(dynamicops, (Object)nbtbase).getOrThrow(s2 -> new DecoderException("Failed to decode: " + s2 + " " + String.valueOf(nbtbase)));
    }

    @Deprecated
    public <T> PacketDataSerializer a(DynamicOps<NBTBase> dynamicops, Codec<T> codec, T t0) {
        NBTBase nbtbase = (NBTBase)codec.encodeStart(dynamicops, t0).getOrThrow(s2 -> new EncoderException("Failed to encode: " + s2 + " " + String.valueOf(t0)));
        this.a(nbtbase);
        return this;
    }

    public <T> T a(Codec<T> codec) {
        JsonElement jsonelement = LenientJsonParser.a(this.p());
        DataResult dataresult = codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonelement);
        return (T)dataresult.getOrThrow(s2 -> new DecoderException("Failed to decode JSON: " + s2));
    }

    public <T> void a(Codec<T> codec, T t0) {
        DataResult dataresult = codec.encodeStart((DynamicOps)JsonOps.INSTANCE, t0);
        this.a(g.toJson((JsonElement)dataresult.getOrThrow(s2 -> new EncoderException("Failed to encode: " + s2 + " " + String.valueOf(t0)))));
    }

    public static <T> IntFunction<T> a(IntFunction<T> intfunction, int i2) {
        return j2 -> {
            if (j2 > i2) {
                throw new DecoderException("Value " + j2 + " is larger than limit " + i2);
            }
            return intfunction.apply(j2);
        };
    }

    public <T, C extends Collection<T>> C a(IntFunction<C> intfunction, StreamDecoder<? super PacketDataSerializer, T> streamdecoder) {
        int i2 = this.l();
        Collection c0 = (Collection)intfunction.apply(i2);
        for (int j2 = 0; j2 < i2; ++j2) {
            c0.add(streamdecoder.decode(this));
        }
        return (C)c0;
    }

    public <T> void a(Collection<T> collection, StreamEncoder<? super PacketDataSerializer, T> streamencoder) {
        this.c(collection.size());
        for (T t0 : collection) {
            streamencoder.encode(this, t0);
        }
    }

    public <T> List<T> a(StreamDecoder<? super PacketDataSerializer, T> streamdecoder) {
        return (List)this.a((ByteBuf)((IntFunction<ArrayList>)Lists::newArrayListWithCapacity), (StreamDecoder)streamdecoder);
    }

    public IntList a() {
        int i2 = this.l();
        IntArrayList intlist = new IntArrayList();
        for (int j2 = 0; j2 < i2; ++j2) {
            intlist.add(this.l());
        }
        return intlist;
    }

    public void a(IntList intlist) {
        this.c(intlist.size());
        intlist.forEach(this::c);
    }

    public <K, V, M extends Map<K, V>> M a(IntFunction<M> intfunction, StreamDecoder<? super PacketDataSerializer, K> streamdecoder, StreamDecoder<? super PacketDataSerializer, V> streamdecoder1) {
        int i2 = this.l();
        Map m0 = (Map)intfunction.apply(i2);
        for (int j2 = 0; j2 < i2; ++j2) {
            K k0 = streamdecoder.decode(this);
            V v0 = streamdecoder1.decode(this);
            m0.put(k0, v0);
        }
        return (M)m0;
    }

    public <K, V> Map<K, V> a(StreamDecoder<? super PacketDataSerializer, K> streamdecoder, StreamDecoder<? super PacketDataSerializer, V> streamdecoder1) {
        return this.a(Maps::newHashMapWithExpectedSize, streamdecoder, streamdecoder1);
    }

    public <K, V> void a(Map<K, V> map, StreamEncoder<? super PacketDataSerializer, K> streamencoder, StreamEncoder<? super PacketDataSerializer, V> streamencoder1) {
        this.c(map.size());
        map.forEach((object, object1) -> {
            streamencoder.encode(this, object);
            streamencoder1.encode(this, object1);
        });
    }

    public void a(Consumer<PacketDataSerializer> consumer) {
        int i2 = this.l();
        for (int j2 = 0; j2 < i2; ++j2) {
            consumer.accept(this);
        }
    }

    public <E extends Enum<E>> void a(EnumSet<E> enumset, Class<E> oclass) {
        Enum[] ae = (Enum[])oclass.getEnumConstants();
        BitSet bitset = new BitSet(ae.length);
        for (int i2 = 0; i2 < ae.length; ++i2) {
            bitset.set(i2, enumset.contains(ae[i2]));
        }
        this.a(bitset, ae.length);
    }

    public <E extends Enum<E>> EnumSet<E> a(Class<E> oclass) {
        Enum[] ae = (Enum[])oclass.getEnumConstants();
        BitSet bitset = this.e(ae.length);
        EnumSet<Enum> enumset = EnumSet.noneOf(oclass);
        for (int i2 = 0; i2 < ae.length; ++i2) {
            if (!bitset.get(i2)) continue;
            enumset.add(ae[i2]);
        }
        return enumset;
    }

    public <T> void a(Optional<T> optional, StreamEncoder<? super PacketDataSerializer, T> streamencoder) {
        if (optional.isPresent()) {
            this.a(true);
            streamencoder.encode(this, optional.get());
        } else {
            this.a(false);
        }
    }

    public <T> Optional<T> b(StreamDecoder<? super PacketDataSerializer, T> streamdecoder) {
        return this.readBoolean() ? Optional.of(streamdecoder.decode(this)) : Optional.empty();
    }

    public <L, R> void a(Either<L, R> either, StreamEncoder<? super PacketDataSerializer, L> streamencoder, StreamEncoder<? super PacketDataSerializer, R> streamencoder1) {
        either.ifLeft(object -> {
            this.a(true);
            streamencoder.encode(this, object);
        }).ifRight(object -> {
            this.a(false);
            streamencoder1.encode(this, object);
        });
    }

    public <L, R> Either<L, R> b(StreamDecoder<? super PacketDataSerializer, L> streamdecoder, StreamDecoder<? super PacketDataSerializer, R> streamdecoder1) {
        return this.readBoolean() ? Either.left(streamdecoder.decode(this)) : Either.right(streamdecoder1.decode(this));
    }

    public <T> @Nullable T c(StreamDecoder<? super PacketDataSerializer, T> streamdecoder) {
        return PacketDataSerializer.a(this, streamdecoder);
    }

    public static <T, B extends ByteBuf> @Nullable T a(B b0, StreamDecoder<? super B, T> streamdecoder) {
        return b0.readBoolean() ? (T)streamdecoder.decode((B)b0) : null;
    }

    public <T> void a(@Nullable T t0, StreamEncoder<? super PacketDataSerializer, T> streamencoder) {
        PacketDataSerializer.a(this, t0, streamencoder);
    }

    public static <T, B extends ByteBuf> void a(B b0, @Nullable T t0, StreamEncoder<? super B, T> streamencoder) {
        if (t0 != null) {
            b0.writeBoolean(true);
            streamencoder.encode(b0, t0);
        } else {
            b0.writeBoolean(false);
        }
    }

    public byte[] b() {
        return PacketDataSerializer.a(this);
    }

    public static byte[] a(ByteBuf bytebuf) {
        return PacketDataSerializer.a(bytebuf, bytebuf.readableBytes());
    }

    public PacketDataSerializer a(byte[] abyte) {
        PacketDataSerializer.a((ByteBuf)this, abyte);
        return this;
    }

    public static void a(ByteBuf bytebuf, byte[] abyte) {
        VarInt.a(bytebuf, abyte.length);
        bytebuf.writeBytes(abyte);
    }

    public byte[] a(int i2) {
        return PacketDataSerializer.a((ByteBuf)this, i2);
    }

    public static byte[] a(ByteBuf bytebuf, int i2) {
        int j2 = VarInt.a(bytebuf);
        if (j2 > i2) {
            throw new DecoderException("ByteArray with size " + j2 + " is bigger than allowed " + i2);
        }
        byte[] abyte = new byte[j2];
        bytebuf.readBytes(abyte);
        return abyte;
    }

    public PacketDataSerializer a(int[] aint) {
        this.c(aint.length);
        for (int i2 : aint) {
            this.c(i2);
        }
        return this;
    }

    public int[] c() {
        return this.b(this.readableBytes());
    }

    public int[] b(int i2) {
        int j2 = this.l();
        if (j2 > i2) {
            throw new DecoderException("VarIntArray with size " + j2 + " is bigger than allowed " + i2);
        }
        int[] aint = new int[j2];
        for (int k2 = 0; k2 < aint.length; ++k2) {
            aint[k2] = this.l();
        }
        return aint;
    }

    public PacketDataSerializer a(long[] along) {
        PacketDataSerializer.a((ByteBuf)this, along);
        return this;
    }

    public static void a(ByteBuf bytebuf, long[] along) {
        VarInt.a(bytebuf, along.length);
        PacketDataSerializer.b(bytebuf, along);
    }

    public PacketDataSerializer b(long[] along) {
        PacketDataSerializer.b((ByteBuf)this, along);
        return this;
    }

    public static void b(ByteBuf bytebuf, long[] along) {
        for (long i2 : along) {
            bytebuf.writeLong(i2);
        }
    }

    public long[] d() {
        return PacketDataSerializer.b(this);
    }

    public long[] c(long[] along) {
        return PacketDataSerializer.c(this, along);
    }

    public static long[] b(ByteBuf bytebuf) {
        int j2;
        int i2 = VarInt.a(bytebuf);
        if (i2 > (j2 = bytebuf.readableBytes() / 8)) {
            throw new DecoderException("LongArray with size " + i2 + " is bigger than allowed " + j2);
        }
        return PacketDataSerializer.c(bytebuf, new long[i2]);
    }

    public static long[] c(ByteBuf bytebuf, long[] along) {
        for (int i2 = 0; i2 < along.length; ++i2) {
            along[i2] = bytebuf.readLong();
        }
        return along;
    }

    public BlockPosition e() {
        return PacketDataSerializer.c(this);
    }

    public static BlockPosition c(ByteBuf bytebuf) {
        return BlockPosition.d(bytebuf.readLong());
    }

    public PacketDataSerializer a(BlockPosition blockposition) {
        PacketDataSerializer.a((ByteBuf)this, blockposition);
        return this;
    }

    public static void a(ByteBuf bytebuf, BlockPosition blockposition) {
        bytebuf.writeLong(blockposition.a());
    }

    public ChunkCoordIntPair f() {
        return new ChunkCoordIntPair(this.readLong());
    }

    public PacketDataSerializer a(ChunkCoordIntPair chunkcoordintpair) {
        this.b(chunkcoordintpair.b());
        return this;
    }

    public static ChunkCoordIntPair d(ByteBuf bytebuf) {
        return new ChunkCoordIntPair(bytebuf.readLong());
    }

    public static void a(ByteBuf bytebuf, ChunkCoordIntPair chunkcoordintpair) {
        bytebuf.writeLong(chunkcoordintpair.b());
    }

    public GlobalPos g() {
        ResourceKey<World> resourcekey = this.a(Registries.bE);
        BlockPosition blockposition = this.e();
        return GlobalPos.a(resourcekey, blockposition);
    }

    public void a(GlobalPos globalpos) {
        this.b(globalpos.a());
        this.a(globalpos.b());
    }

    public Vector3f h() {
        return PacketDataSerializer.e(this);
    }

    public static Vector3f e(ByteBuf bytebuf) {
        return new Vector3f(bytebuf.readFloat(), bytebuf.readFloat(), bytebuf.readFloat());
    }

    public void a(Vector3f vector3f) {
        PacketDataSerializer.a((ByteBuf)this, (Vector3fc)vector3f);
    }

    public static void a(ByteBuf bytebuf, Vector3fc vector3fc) {
        bytebuf.writeFloat(vector3fc.x());
        bytebuf.writeFloat(vector3fc.y());
        bytebuf.writeFloat(vector3fc.z());
    }

    public Quaternionf i() {
        return PacketDataSerializer.f(this);
    }

    public static Quaternionf f(ByteBuf bytebuf) {
        return new Quaternionf(bytebuf.readFloat(), bytebuf.readFloat(), bytebuf.readFloat(), bytebuf.readFloat());
    }

    public void a(Quaternionf quaternionf) {
        PacketDataSerializer.a((ByteBuf)this, (Quaternionfc)quaternionf);
    }

    public static void a(ByteBuf bytebuf, Quaternionfc quaternionfc) {
        bytebuf.writeFloat(quaternionfc.x());
        bytebuf.writeFloat(quaternionfc.y());
        bytebuf.writeFloat(quaternionfc.z());
        bytebuf.writeFloat(quaternionfc.w());
    }

    public static Vec3D g(ByteBuf bytebuf) {
        return new Vec3D(bytebuf.readDouble(), bytebuf.readDouble(), bytebuf.readDouble());
    }

    public Vec3D j() {
        return PacketDataSerializer.g(this);
    }

    public static void a(ByteBuf bytebuf, Vec3D vec3d) {
        bytebuf.writeDouble(vec3d.a());
        bytebuf.writeDouble(vec3d.b());
        bytebuf.writeDouble(vec3d.c());
    }

    public void a(Vec3D vec3d) {
        PacketDataSerializer.a((ByteBuf)this, vec3d);
    }

    public Vec3D k() {
        return LpVec3.a(this);
    }

    public void b(Vec3D vec3d) {
        LpVec3.a(this, vec3d);
    }

    public <T extends Enum<T>> T b(Class<T> oclass) {
        return (T)((Enum[])oclass.getEnumConstants())[this.l()];
    }

    public PacketDataSerializer a(Enum<?> oenum) {
        return this.c(oenum.ordinal());
    }

    public <T> T a(IntFunction<T> intfunction) {
        int i2 = this.l();
        return intfunction.apply(i2);
    }

    public <T> PacketDataSerializer a(ToIntFunction<T> tointfunction, T t0) {
        int i2 = tointfunction.applyAsInt(t0);
        return this.c(i2);
    }

    public int l() {
        return VarInt.a(this.c);
    }

    public long m() {
        return VarLong.a(this.c);
    }

    public PacketDataSerializer a(UUID uuid) {
        PacketDataSerializer.a((ByteBuf)this, uuid);
        return this;
    }

    public static void a(ByteBuf bytebuf, UUID uuid) {
        bytebuf.writeLong(uuid.getMostSignificantBits());
        bytebuf.writeLong(uuid.getLeastSignificantBits());
    }

    public UUID n() {
        return PacketDataSerializer.h(this);
    }

    public static UUID h(ByteBuf bytebuf) {
        return new UUID(bytebuf.readLong(), bytebuf.readLong());
    }

    public PacketDataSerializer c(int i2) {
        VarInt.a(this.c, i2);
        return this;
    }

    public PacketDataSerializer a(long i2) {
        VarLong.a(this.c, i2);
        return this;
    }

    public PacketDataSerializer a(@Nullable NBTBase nbtbase) {
        PacketDataSerializer.a((ByteBuf)this, nbtbase);
        return this;
    }

    public static void a(ByteBuf bytebuf, @Nullable NBTBase nbtbase) {
        if (nbtbase == null) {
            nbtbase = NBTTagEnd.b;
        }
        try {
            NBTCompressedStreamTools.a(nbtbase, (DataOutput)new ByteBufOutputStream(bytebuf));
        }
        catch (Exception ioexception) {
            throw new EncoderException((Throwable)ioexception);
        }
    }

    public @Nullable NBTTagCompound o() {
        return PacketDataSerializer.i(this);
    }

    public static @Nullable NBTTagCompound i(ByteBuf bytebuf) {
        NBTBase nbtbase = PacketDataSerializer.a(bytebuf, NBTReadLimiter.a());
        if (nbtbase != null && !(nbtbase instanceof NBTTagCompound)) {
            throw new DecoderException("Not a compound tag: " + String.valueOf(nbtbase));
        }
        return (NBTTagCompound)nbtbase;
    }

    public static @Nullable NBTBase a(ByteBuf bytebuf, NBTReadLimiter nbtreadlimiter) {
        try {
            NBTBase nbtbase = NBTCompressedStreamTools.b((DataInput)new ByteBufInputStream(bytebuf), nbtreadlimiter);
            return nbtbase.b() == 0 ? null : nbtbase;
        }
        catch (IOException ioexception) {
            throw new EncoderException((Throwable)ioexception);
        }
    }

    public @Nullable NBTBase a(NBTReadLimiter nbtreadlimiter) {
        return PacketDataSerializer.a((ByteBuf)this, nbtreadlimiter);
    }

    public String p() {
        return this.d(Short.MAX_VALUE);
    }

    public String d(int i2) {
        return Utf8String.a(this.c, i2);
    }

    public PacketDataSerializer a(String s2) {
        return this.a(s2, Short.MAX_VALUE);
    }

    public PacketDataSerializer a(String s2, int i2) {
        Utf8String.a(this.c, s2, i2);
        return this;
    }

    public MinecraftKey q() {
        return MinecraftKey.a(this.d(Short.MAX_VALUE));
    }

    public PacketDataSerializer a(MinecraftKey minecraftkey) {
        this.a(minecraftkey.toString());
        return this;
    }

    public <T> ResourceKey<T> a(ResourceKey<? extends IRegistry<T>> resourcekey) {
        MinecraftKey minecraftkey = this.q();
        return ResourceKey.a(resourcekey, minecraftkey);
    }

    public void b(ResourceKey<?> resourcekey) {
        this.a(resourcekey.a());
    }

    public <T> ResourceKey<? extends IRegistry<T>> r() {
        MinecraftKey minecraftkey = this.q();
        return ResourceKey.a(minecraftkey);
    }

    public Instant s() {
        return Instant.ofEpochMilli(this.readLong());
    }

    public void a(Instant instant) {
        this.b(instant.toEpochMilli());
    }

    public PublicKey t() {
        try {
            return MinecraftEncryption.a(this.a(512));
        }
        catch (CryptographyException cryptographyexception) {
            throw new DecoderException("Malformed public key bytes", (Throwable)cryptographyexception);
        }
    }

    public PacketDataSerializer a(PublicKey publickey) {
        this.a(publickey.getEncoded());
        return this;
    }

    public MovingObjectPositionBlock u() {
        BlockPosition blockposition = this.e();
        EnumDirection enumdirection = this.b(EnumDirection.class);
        float f2 = this.readFloat();
        float f1 = this.readFloat();
        float f22 = this.readFloat();
        boolean flag = this.readBoolean();
        boolean flag1 = this.readBoolean();
        return new MovingObjectPositionBlock(new Vec3D((double)blockposition.u() + (double)f2, (double)blockposition.v() + (double)f1, (double)blockposition.w() + (double)f22), enumdirection, blockposition, flag, flag1);
    }

    public void a(MovingObjectPositionBlock movingobjectpositionblock) {
        BlockPosition blockposition = movingobjectpositionblock.b();
        this.a(blockposition);
        this.a(movingobjectpositionblock.c());
        Vec3D vec3d = movingobjectpositionblock.g();
        this.a((float)(vec3d.g - (double)blockposition.u()));
        this.a((float)(vec3d.h - (double)blockposition.v()));
        this.a((float)(vec3d.i - (double)blockposition.w()));
        this.a(movingobjectpositionblock.e());
        this.a(movingobjectpositionblock.f());
    }

    public BitSet v() {
        return BitSet.valueOf(this.d());
    }

    public void a(BitSet bitset) {
        this.a(bitset.toLongArray());
    }

    public BitSet e(int i2) {
        byte[] abyte = new byte[MathHelper.f(i2, 8)];
        this.b(abyte);
        return BitSet.valueOf(abyte);
    }

    public void a(BitSet bitset, int i2) {
        if (bitset.length() > i2) {
            int j2 = bitset.length();
            throw new EncoderException("BitSet is larger than expected size (" + j2 + ">" + i2 + ")");
        }
        byte[] abyte = bitset.toByteArray();
        this.c(Arrays.copyOf(abyte, MathHelper.f(i2, 8)));
    }

    public static int j(ByteBuf bytebuf) {
        return VarInt.a(bytebuf);
    }

    public int w() {
        return PacketDataSerializer.j(this.c);
    }

    public static void b(ByteBuf bytebuf, int i2) {
        VarInt.a(bytebuf, i2);
    }

    public void f(int i2) {
        PacketDataSerializer.b(this.c, i2);
    }

    public boolean isContiguous() {
        return this.c.isContiguous();
    }

    public int maxFastWritableBytes() {
        return this.c.maxFastWritableBytes();
    }

    public int capacity() {
        return this.c.capacity();
    }

    public PacketDataSerializer g(int i2) {
        this.c.capacity(i2);
        return this;
    }

    public int maxCapacity() {
        return this.c.maxCapacity();
    }

    public ByteBufAllocator alloc() {
        return this.c.alloc();
    }

    public ByteOrder order() {
        return this.c.order();
    }

    public ByteBuf order(ByteOrder byteorder) {
        return this.c.order(byteorder);
    }

    public ByteBuf unwrap() {
        return this.c;
    }

    public boolean isDirect() {
        return this.c.isDirect();
    }

    public boolean isReadOnly() {
        return this.c.isReadOnly();
    }

    public ByteBuf asReadOnly() {
        return this.c.asReadOnly();
    }

    public int readerIndex() {
        return this.c.readerIndex();
    }

    public PacketDataSerializer h(int i2) {
        this.c.readerIndex(i2);
        return this;
    }

    public int writerIndex() {
        return this.c.writerIndex();
    }

    public PacketDataSerializer i(int i2) {
        this.c.writerIndex(i2);
        return this;
    }

    public PacketDataSerializer a(int i2, int j2) {
        this.c.setIndex(i2, j2);
        return this;
    }

    public int readableBytes() {
        return this.c.readableBytes();
    }

    public int writableBytes() {
        return this.c.writableBytes();
    }

    public int maxWritableBytes() {
        return this.c.maxWritableBytes();
    }

    public boolean isReadable() {
        return this.c.isReadable();
    }

    public boolean isReadable(int i2) {
        return this.c.isReadable(i2);
    }

    public boolean isWritable() {
        return this.c.isWritable();
    }

    public boolean isWritable(int i2) {
        return this.c.isWritable(i2);
    }

    public PacketDataSerializer x() {
        this.c.clear();
        return this;
    }

    public PacketDataSerializer y() {
        this.c.markReaderIndex();
        return this;
    }

    public PacketDataSerializer z() {
        this.c.resetReaderIndex();
        return this;
    }

    public PacketDataSerializer A() {
        this.c.markWriterIndex();
        return this;
    }

    public PacketDataSerializer B() {
        this.c.resetWriterIndex();
        return this;
    }

    public PacketDataSerializer C() {
        this.c.discardReadBytes();
        return this;
    }

    public PacketDataSerializer D() {
        this.c.discardSomeReadBytes();
        return this;
    }

    public PacketDataSerializer j(int i2) {
        this.c.ensureWritable(i2);
        return this;
    }

    public int ensureWritable(int i2, boolean flag) {
        return this.c.ensureWritable(i2, flag);
    }

    public boolean getBoolean(int i2) {
        return this.c.getBoolean(i2);
    }

    public byte getByte(int i2) {
        return this.c.getByte(i2);
    }

    public short getUnsignedByte(int i2) {
        return this.c.getUnsignedByte(i2);
    }

    public short getShort(int i2) {
        return this.c.getShort(i2);
    }

    public short getShortLE(int i2) {
        return this.c.getShortLE(i2);
    }

    public int getUnsignedShort(int i2) {
        return this.c.getUnsignedShort(i2);
    }

    public int getUnsignedShortLE(int i2) {
        return this.c.getUnsignedShortLE(i2);
    }

    public int getMedium(int i2) {
        return this.c.getMedium(i2);
    }

    public int getMediumLE(int i2) {
        return this.c.getMediumLE(i2);
    }

    public int getUnsignedMedium(int i2) {
        return this.c.getUnsignedMedium(i2);
    }

    public int getUnsignedMediumLE(int i2) {
        return this.c.getUnsignedMediumLE(i2);
    }

    public int getInt(int i2) {
        return this.c.getInt(i2);
    }

    public int getIntLE(int i2) {
        return this.c.getIntLE(i2);
    }

    public long getUnsignedInt(int i2) {
        return this.c.getUnsignedInt(i2);
    }

    public long getUnsignedIntLE(int i2) {
        return this.c.getUnsignedIntLE(i2);
    }

    public long getLong(int i2) {
        return this.c.getLong(i2);
    }

    public long getLongLE(int i2) {
        return this.c.getLongLE(i2);
    }

    public char getChar(int i2) {
        return this.c.getChar(i2);
    }

    public float getFloat(int i2) {
        return this.c.getFloat(i2);
    }

    public double getDouble(int i2) {
        return this.c.getDouble(i2);
    }

    public PacketDataSerializer a(int i2, ByteBuf bytebuf) {
        this.c.getBytes(i2, bytebuf);
        return this;
    }

    public PacketDataSerializer a(int i2, ByteBuf bytebuf, int j2) {
        this.c.getBytes(i2, bytebuf, j2);
        return this;
    }

    public PacketDataSerializer a(int i2, ByteBuf bytebuf, int j2, int k2) {
        this.c.getBytes(i2, bytebuf, j2, k2);
        return this;
    }

    public PacketDataSerializer a(int i2, byte[] abyte) {
        this.c.getBytes(i2, abyte);
        return this;
    }

    public PacketDataSerializer a(int i2, byte[] abyte, int j2, int k2) {
        this.c.getBytes(i2, abyte, j2, k2);
        return this;
    }

    public PacketDataSerializer a(int i2, ByteBuffer bytebuffer) {
        this.c.getBytes(i2, bytebuffer);
        return this;
    }

    public PacketDataSerializer a(int i2, OutputStream outputstream, int j2) throws IOException {
        this.c.getBytes(i2, outputstream, j2);
        return this;
    }

    public int getBytes(int i2, GatheringByteChannel gatheringbytechannel, int j2) throws IOException {
        return this.c.getBytes(i2, gatheringbytechannel, j2);
    }

    public int getBytes(int i2, FileChannel filechannel, long j2, int k2) throws IOException {
        return this.c.getBytes(i2, filechannel, j2, k2);
    }

    public CharSequence getCharSequence(int i2, int j2, Charset charset) {
        return this.c.getCharSequence(i2, j2, charset);
    }

    public PacketDataSerializer a(int i2, boolean flag) {
        this.c.setBoolean(i2, flag);
        return this;
    }

    public PacketDataSerializer b(int i2, int j2) {
        this.c.setByte(i2, j2);
        return this;
    }

    public PacketDataSerializer c(int i2, int j2) {
        this.c.setShort(i2, j2);
        return this;
    }

    public PacketDataSerializer d(int i2, int j2) {
        this.c.setShortLE(i2, j2);
        return this;
    }

    public PacketDataSerializer e(int i2, int j2) {
        this.c.setMedium(i2, j2);
        return this;
    }

    public PacketDataSerializer f(int i2, int j2) {
        this.c.setMediumLE(i2, j2);
        return this;
    }

    public PacketDataSerializer g(int i2, int j2) {
        this.c.setInt(i2, j2);
        return this;
    }

    public PacketDataSerializer h(int i2, int j2) {
        this.c.setIntLE(i2, j2);
        return this;
    }

    public PacketDataSerializer a(int i2, long j2) {
        this.c.setLong(i2, j2);
        return this;
    }

    public PacketDataSerializer b(int i2, long j2) {
        this.c.setLongLE(i2, j2);
        return this;
    }

    public PacketDataSerializer i(int i2, int j2) {
        this.c.setChar(i2, j2);
        return this;
    }

    public PacketDataSerializer a(int i2, float f2) {
        this.c.setFloat(i2, f2);
        return this;
    }

    public PacketDataSerializer a(int i2, double d0) {
        this.c.setDouble(i2, d0);
        return this;
    }

    public PacketDataSerializer b(int i2, ByteBuf bytebuf) {
        this.c.setBytes(i2, bytebuf);
        return this;
    }

    public PacketDataSerializer b(int i2, ByteBuf bytebuf, int j2) {
        this.c.setBytes(i2, bytebuf, j2);
        return this;
    }

    public PacketDataSerializer b(int i2, ByteBuf bytebuf, int j2, int k2) {
        this.c.setBytes(i2, bytebuf, j2, k2);
        return this;
    }

    public PacketDataSerializer b(int i2, byte[] abyte) {
        this.c.setBytes(i2, abyte);
        return this;
    }

    public PacketDataSerializer b(int i2, byte[] abyte, int j2, int k2) {
        this.c.setBytes(i2, abyte, j2, k2);
        return this;
    }

    public PacketDataSerializer b(int i2, ByteBuffer bytebuffer) {
        this.c.setBytes(i2, bytebuffer);
        return this;
    }

    public int setBytes(int i2, InputStream inputstream, int j2) throws IOException {
        return this.c.setBytes(i2, inputstream, j2);
    }

    public int setBytes(int i2, ScatteringByteChannel scatteringbytechannel, int j2) throws IOException {
        return this.c.setBytes(i2, scatteringbytechannel, j2);
    }

    public int setBytes(int i2, FileChannel filechannel, long j2, int k2) throws IOException {
        return this.c.setBytes(i2, filechannel, j2, k2);
    }

    public PacketDataSerializer j(int i2, int j2) {
        this.c.setZero(i2, j2);
        return this;
    }

    public int setCharSequence(int i2, CharSequence charsequence, Charset charset) {
        return this.c.setCharSequence(i2, charsequence, charset);
    }

    public boolean readBoolean() {
        return this.c.readBoolean();
    }

    public byte readByte() {
        return this.c.readByte();
    }

    public short readUnsignedByte() {
        return this.c.readUnsignedByte();
    }

    public short readShort() {
        return this.c.readShort();
    }

    public short readShortLE() {
        return this.c.readShortLE();
    }

    public int readUnsignedShort() {
        return this.c.readUnsignedShort();
    }

    public int readUnsignedShortLE() {
        return this.c.readUnsignedShortLE();
    }

    public int readMedium() {
        return this.c.readMedium();
    }

    public int readMediumLE() {
        return this.c.readMediumLE();
    }

    public int readUnsignedMedium() {
        return this.c.readUnsignedMedium();
    }

    public int readUnsignedMediumLE() {
        return this.c.readUnsignedMediumLE();
    }

    public int readInt() {
        return this.c.readInt();
    }

    public int readIntLE() {
        return this.c.readIntLE();
    }

    public long readUnsignedInt() {
        return this.c.readUnsignedInt();
    }

    public long readUnsignedIntLE() {
        return this.c.readUnsignedIntLE();
    }

    public long readLong() {
        return this.c.readLong();
    }

    public long readLongLE() {
        return this.c.readLongLE();
    }

    public char readChar() {
        return this.c.readChar();
    }

    public float readFloat() {
        return this.c.readFloat();
    }

    public double readDouble() {
        return this.c.readDouble();
    }

    public ByteBuf readBytes(int i2) {
        return this.c.readBytes(i2);
    }

    public ByteBuf readSlice(int i2) {
        return this.c.readSlice(i2);
    }

    public ByteBuf readRetainedSlice(int i2) {
        return this.c.readRetainedSlice(i2);
    }

    public PacketDataSerializer k(ByteBuf bytebuf) {
        this.c.readBytes(bytebuf);
        return this;
    }

    public PacketDataSerializer c(ByteBuf bytebuf, int i2) {
        this.c.readBytes(bytebuf, i2);
        return this;
    }

    public PacketDataSerializer a(ByteBuf bytebuf, int i2, int j2) {
        this.c.readBytes(bytebuf, i2, j2);
        return this;
    }

    public PacketDataSerializer b(byte[] abyte) {
        this.c.readBytes(abyte);
        return this;
    }

    public PacketDataSerializer a(byte[] abyte, int i2, int j2) {
        this.c.readBytes(abyte, i2, j2);
        return this;
    }

    public PacketDataSerializer a(ByteBuffer bytebuffer) {
        this.c.readBytes(bytebuffer);
        return this;
    }

    public PacketDataSerializer a(OutputStream outputstream, int i2) throws IOException {
        this.c.readBytes(outputstream, i2);
        return this;
    }

    public int readBytes(GatheringByteChannel gatheringbytechannel, int i2) throws IOException {
        return this.c.readBytes(gatheringbytechannel, i2);
    }

    public CharSequence readCharSequence(int i2, Charset charset) {
        return this.c.readCharSequence(i2, charset);
    }

    public String readString(int i2, Charset charset) {
        return this.c.readString(i2, charset);
    }

    public int readBytes(FileChannel filechannel, long i2, int j2) throws IOException {
        return this.c.readBytes(filechannel, i2, j2);
    }

    public PacketDataSerializer k(int i2) {
        this.c.skipBytes(i2);
        return this;
    }

    public PacketDataSerializer a(boolean flag) {
        this.c.writeBoolean(flag);
        return this;
    }

    public PacketDataSerializer l(int i2) {
        this.c.writeByte(i2);
        return this;
    }

    public PacketDataSerializer m(int i2) {
        this.c.writeShort(i2);
        return this;
    }

    public PacketDataSerializer n(int i2) {
        this.c.writeShortLE(i2);
        return this;
    }

    public PacketDataSerializer o(int i2) {
        this.c.writeMedium(i2);
        return this;
    }

    public PacketDataSerializer p(int i2) {
        this.c.writeMediumLE(i2);
        return this;
    }

    public PacketDataSerializer q(int i2) {
        this.c.writeInt(i2);
        return this;
    }

    public PacketDataSerializer r(int i2) {
        this.c.writeIntLE(i2);
        return this;
    }

    public PacketDataSerializer b(long i2) {
        this.c.writeLong(i2);
        return this;
    }

    public PacketDataSerializer c(long i2) {
        this.c.writeLongLE(i2);
        return this;
    }

    public PacketDataSerializer s(int i2) {
        this.c.writeChar(i2);
        return this;
    }

    public PacketDataSerializer a(float f2) {
        this.c.writeFloat(f2);
        return this;
    }

    public PacketDataSerializer a(double d0) {
        this.c.writeDouble(d0);
        return this;
    }

    public PacketDataSerializer l(ByteBuf bytebuf) {
        this.c.writeBytes(bytebuf);
        return this;
    }

    public PacketDataSerializer d(ByteBuf bytebuf, int i2) {
        this.c.writeBytes(bytebuf, i2);
        return this;
    }

    public PacketDataSerializer b(ByteBuf bytebuf, int i2, int j2) {
        this.c.writeBytes(bytebuf, i2, j2);
        return this;
    }

    public PacketDataSerializer c(byte[] abyte) {
        this.c.writeBytes(abyte);
        return this;
    }

    public PacketDataSerializer b(byte[] abyte, int i2, int j2) {
        this.c.writeBytes(abyte, i2, j2);
        return this;
    }

    public PacketDataSerializer b(ByteBuffer bytebuffer) {
        this.c.writeBytes(bytebuffer);
        return this;
    }

    public int writeBytes(InputStream inputstream, int i2) throws IOException {
        return this.c.writeBytes(inputstream, i2);
    }

    public int writeBytes(ScatteringByteChannel scatteringbytechannel, int i2) throws IOException {
        return this.c.writeBytes(scatteringbytechannel, i2);
    }

    public int writeBytes(FileChannel filechannel, long i2, int j2) throws IOException {
        return this.c.writeBytes(filechannel, i2, j2);
    }

    public PacketDataSerializer t(int i2) {
        this.c.writeZero(i2);
        return this;
    }

    public int writeCharSequence(CharSequence charsequence, Charset charset) {
        return this.c.writeCharSequence(charsequence, charset);
    }

    public int indexOf(int i2, int j2, byte b0) {
        return this.c.indexOf(i2, j2, b0);
    }

    public int bytesBefore(byte b0) {
        return this.c.bytesBefore(b0);
    }

    public int bytesBefore(int i2, byte b0) {
        return this.c.bytesBefore(i2, b0);
    }

    public int bytesBefore(int i2, int j2, byte b0) {
        return this.c.bytesBefore(i2, j2, b0);
    }

    public int forEachByte(ByteProcessor byteprocessor) {
        return this.c.forEachByte(byteprocessor);
    }

    public int forEachByte(int i2, int j2, ByteProcessor byteprocessor) {
        return this.c.forEachByte(i2, j2, byteprocessor);
    }

    public int forEachByteDesc(ByteProcessor byteprocessor) {
        return this.c.forEachByteDesc(byteprocessor);
    }

    public int forEachByteDesc(int i2, int j2, ByteProcessor byteprocessor) {
        return this.c.forEachByteDesc(i2, j2, byteprocessor);
    }

    public ByteBuf copy() {
        return this.c.copy();
    }

    public ByteBuf copy(int i2, int j2) {
        return this.c.copy(i2, j2);
    }

    public ByteBuf slice() {
        return this.c.slice();
    }

    public ByteBuf retainedSlice() {
        return this.c.retainedSlice();
    }

    public ByteBuf slice(int i2, int j2) {
        return this.c.slice(i2, j2);
    }

    public ByteBuf retainedSlice(int i2, int j2) {
        return this.c.retainedSlice(i2, j2);
    }

    public ByteBuf duplicate() {
        return this.c.duplicate();
    }

    public ByteBuf retainedDuplicate() {
        return this.c.retainedDuplicate();
    }

    public int nioBufferCount() {
        return this.c.nioBufferCount();
    }

    public ByteBuffer nioBuffer() {
        return this.c.nioBuffer();
    }

    public ByteBuffer nioBuffer(int i2, int j2) {
        return this.c.nioBuffer(i2, j2);
    }

    public ByteBuffer internalNioBuffer(int i2, int j2) {
        return this.c.internalNioBuffer(i2, j2);
    }

    public ByteBuffer[] nioBuffers() {
        return this.c.nioBuffers();
    }

    public ByteBuffer[] nioBuffers(int i2, int j2) {
        return this.c.nioBuffers(i2, j2);
    }

    public boolean hasArray() {
        return this.c.hasArray();
    }

    public byte[] array() {
        return this.c.array();
    }

    public int arrayOffset() {
        return this.c.arrayOffset();
    }

    public boolean hasMemoryAddress() {
        return this.c.hasMemoryAddress();
    }

    public long memoryAddress() {
        return this.c.memoryAddress();
    }

    public String toString(Charset charset) {
        return this.c.toString(charset);
    }

    public String toString(int i2, int j2, Charset charset) {
        return this.c.toString(i2, j2, charset);
    }

    public int hashCode() {
        return this.c.hashCode();
    }

    public boolean equals(Object object) {
        return this.c.equals(object);
    }

    public int compareTo(ByteBuf bytebuf) {
        return this.c.compareTo(bytebuf);
    }

    public String toString() {
        return this.c.toString();
    }

    public PacketDataSerializer u(int i2) {
        this.c.retain(i2);
        return this;
    }

    public PacketDataSerializer E() {
        this.c.retain();
        return this;
    }

    public PacketDataSerializer F() {
        this.c.touch();
        return this;
    }

    public PacketDataSerializer a(Object object) {
        this.c.touch(object);
        return this;
    }

    public int refCnt() {
        return this.c.refCnt();
    }

    public boolean release() {
        return this.c.release();
    }

    public boolean release(int i2) {
        return this.c.release(i2);
    }
}

