/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.IRegistryWritable;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.RegistryMaterials;
import net.minecraft.core.RegistrySynchronization;
import net.minecraft.core.registries.Registries;
import net.minecraft.gametest.framework.GameTestInstance;
import net.minecraft.gametest.framework.TestEnvironmentDefinition;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.dialog.Dialog;
import net.minecraft.server.packs.repository.KnownPack;
import net.minecraft.server.packs.resources.IResource;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.tags.TagDataPack;
import net.minecraft.tags.TagNetworkSerialization;
import net.minecraft.util.StrictJsonParser;
import net.minecraft.util.SystemUtils;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.animal.chicken.ChickenVariant;
import net.minecraft.world.entity.animal.cow.CowVariant;
import net.minecraft.world.entity.animal.feline.CatVariant;
import net.minecraft.world.entity.animal.frog.FrogVariant;
import net.minecraft.world.entity.animal.nautilus.ZombieNautilusVariant;
import net.minecraft.world.entity.animal.pig.PigVariant;
import net.minecraft.world.entity.animal.wolf.WolfSoundVariant;
import net.minecraft.world.entity.animal.wolf.WolfVariant;
import net.minecraft.world.entity.decoration.painting.PaintingVariant;
import net.minecraft.world.item.Instrument;
import net.minecraft.world.item.JukeboxSong;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.providers.EnchantmentProvider;
import net.minecraft.world.item.equipment.trim.TrimMaterial;
import net.minecraft.world.item.equipment.trim.TrimPattern;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterList;
import net.minecraft.world.level.block.entity.EnumBannerPatternType;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerConfig;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.GeneratorSettingBase;
import net.minecraft.world.level.levelgen.carver.WorldGenCarverWrapper;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.level.levelgen.flat.FlatLevelGeneratorPreset;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureStructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorList;
import net.minecraft.world.level.levelgen.synth.NoiseGeneratorNormal;
import net.minecraft.world.timeline.Timeline;
import org.slf4j.Logger;

public class RegistryDataLoader {
    private static final Logger d = LogUtils.getLogger();
    private static final Comparator<ResourceKey<?>> e = Comparator.comparing(ResourceKey::b).thenComparing(ResourceKey::a);
    private static final RegistrationInfo f = new RegistrationInfo(Optional.empty(), Lifecycle.experimental());
    private static final Function<Optional<KnownPack>, RegistrationInfo> g = SystemUtils.b((T var02) -> {
        Lifecycle var1 = var02.map(KnownPack::a).map(var0 -> Lifecycle.stable()).orElse(Lifecycle.experimental());
        return new RegistrationInfo((Optional<KnownPack>)var02, var1);
    });
    public static final List<d<?>> a = List.of(new d<DimensionManager>(Registries.bd, DimensionManager.h), new d<BiomeBase>(Registries.aS, BiomeBase.a), new d<ChatMessageType>(Registries.aU, ChatMessageType.a), new d(Registries.aX, WorldGenCarverWrapper.a), new d(Registries.aY, WorldGenFeatureConfigured.a), new d<PlacedFeature>(Registries.bp, PlacedFeature.a), new d<Structure>(Registries.bs, Structure.a), new d<StructureSet>(Registries.br, StructureSet.a), new d<ProcessorList>(Registries.bq, DefinedStructureStructureProcessorType.c), new d<WorldGenFeatureDefinedStructurePoolTemplate>(Registries.bt, WorldGenFeatureDefinedStructurePoolTemplate.a), new d<GeneratorSettingBase>(Registries.bl, GeneratorSettingBase.a), new d<NoiseGeneratorNormal.a>(Registries.bm, NoiseGeneratorNormal.a.a), new d<DensityFunction>(Registries.bb, DensityFunction.c), new d<WorldPreset>(Registries.bD, WorldPreset.a), new d<FlatLevelGeneratorPreset>(Registries.bg, FlatLevelGeneratorPreset.a), new d<TrimPattern>(Registries.bA, TrimPattern.a), new d<TrimMaterial>(Registries.bz, TrimMaterial.a), new d<TrialSpawnerConfig>(Registries.bx, TrialSpawnerConfig.b), new d<WolfVariant>(Registries.bB, WolfVariant.a, true), new d<WolfSoundVariant>(Registries.bC, WolfSoundVariant.a, true), new d<PigVariant>(Registries.bo, PigVariant.a, true), new d<FrogVariant>(Registries.bh, FrogVariant.a, true), new d<CatVariant>(Registries.aT, CatVariant.a, true), new d<CowVariant>(Registries.aZ, CowVariant.a, true), new d<ChickenVariant>(Registries.aV, ChickenVariant.a, true), new d<ZombieNautilusVariant>(Registries.aW, ZombieNautilusVariant.a, true), new d<PaintingVariant>(Registries.bn, PaintingVariant.a, true), new d<DamageType>(Registries.ba, DamageType.a), new d<MultiNoiseBiomeSourceParameterList>(Registries.bk, MultiNoiseBiomeSourceParameterList.a), new d<EnumBannerPatternType>(Registries.aR, EnumBannerPatternType.a), new d<Enchantment>(Registries.bf, Enchantment.b), new d<EnchantmentProvider>(Registries.be, EnchantmentProvider.a), new d<JukeboxSong>(Registries.bj, JukeboxSong.a), new d<Instrument>(Registries.bi, Instrument.a), new d<TestEnvironmentDefinition>(Registries.bu, TestEnvironmentDefinition.a), new d<GameTestInstance>(Registries.bv, GameTestInstance.b), new d<Dialog>(Registries.bc, Dialog.c), new d<Timeline>(Registries.bw, Timeline.b));
    public static final List<d<?>> b = List.of(new d<WorldDimension>(Registries.bF, WorldDimension.a));
    public static final List<d<?>> c = List.of(new d<BiomeBase>(Registries.aS, BiomeBase.b), new d<ChatMessageType>(Registries.aU, ChatMessageType.a), new d<TrimPattern>(Registries.bA, TrimPattern.a), new d<TrimMaterial>(Registries.bz, TrimMaterial.a), new d<WolfVariant>(Registries.bB, WolfVariant.b, true), new d<WolfSoundVariant>(Registries.bC, WolfSoundVariant.b, true), new d<PigVariant>(Registries.bo, PigVariant.b, true), new d<FrogVariant>(Registries.bh, FrogVariant.b, true), new d<CatVariant>(Registries.aT, CatVariant.b, true), new d<CowVariant>(Registries.aZ, CowVariant.b, true), new d<ChickenVariant>(Registries.aV, ChickenVariant.b, true), new d<ZombieNautilusVariant>(Registries.aW, ZombieNautilusVariant.b, true), new d<PaintingVariant>(Registries.bn, PaintingVariant.a, true), new d<DimensionManager>(Registries.bd, DimensionManager.i), new d<DamageType>(Registries.ba, DamageType.a), new d<EnumBannerPatternType>(Registries.aR, EnumBannerPatternType.a), new d<Enchantment>(Registries.bf, Enchantment.b), new d<JukeboxSong>(Registries.bj, JukeboxSong.a), new d<Instrument>(Registries.bi, Instrument.a), new d<TestEnvironmentDefinition>(Registries.bu, TestEnvironmentDefinition.a), new d<GameTestInstance>(Registries.bv, GameTestInstance.b), new d<Dialog>(Registries.bc, Dialog.c), new d<Timeline>(Registries.bw, Timeline.c));

    public static IRegistryCustom.Dimension a(IResourceManager var0, List<HolderLookup.b<?>> var12, List<d<?>> var22) {
        return RegistryDataLoader.a((a<?> var1, RegistryOps.c var2) -> var1.a(var0, var2), var12, var22);
    }

    public static IRegistryCustom.Dimension a(Map<ResourceKey<? extends IRegistry<?>>, c> var0, ResourceProvider var1, List<HolderLookup.b<?>> var22, List<d<?>> var32) {
        return RegistryDataLoader.a((a<?> var2, RegistryOps.c var3) -> var2.a(var0, var1, var3), var22, var32);
    }

    private static IRegistryCustom.Dimension a(b var0, List<HolderLookup.b<?>> var12, List<d<?>> var22) {
        HashMap var3 = new HashMap();
        List<a<?>> var4 = var22.stream().map(var1 -> var1.a(Lifecycle.stable(), var3)).collect(Collectors.toUnmodifiableList());
        RegistryOps.c var5 = RegistryDataLoader.a(var12, var4);
        var4.forEach(var2 -> var0.apply((a<?>)var2, var5));
        var4.forEach(var1 -> {
            IRegistryWritable var2 = var1.b();
            try {
                var2.n();
            }
            catch (Exception var3) {
                var3.put(var2.g(), var3);
            }
            if (var1.a.c && var2.d() == 0) {
                var3.put(var2.g(), new IllegalStateException("Registry must be non-empty: " + String.valueOf(var2.g().a())));
            }
        });
        if (!var3.isEmpty()) {
            throw RegistryDataLoader.a(var3);
        }
        return new IRegistryCustom.c(var4.stream().map(a::b).toList()).e();
    }

    private static RegistryOps.c a(List<HolderLookup.b<?>> var0, List<a<?>> var12) {
        final HashMap var2 = new HashMap();
        var0.forEach(var1 -> var2.put(var1.g(), RegistryDataLoader.a(var1)));
        var12.forEach(var1 -> var2.put(var1.b.g(), RegistryDataLoader.a(var1.b)));
        return new RegistryOps.c(){

            @Override
            public <T> Optional<RegistryOps.b<T>> a(ResourceKey<? extends IRegistry<? extends T>> var0) {
                return Optional.ofNullable((RegistryOps.b)var2.get(var0));
            }
        };
    }

    private static <T> RegistryOps.b<T> a(IRegistryWritable<T> var0) {
        return new RegistryOps.b<T>(var0, var0.p(), var0.h());
    }

    private static <T> RegistryOps.b<T> a(HolderLookup.b<T> var0) {
        return new RegistryOps.b<T>(var0, var0, var0.h());
    }

    private static ReportedException a(Map<ResourceKey<?>, Exception> var0) {
        RegistryDataLoader.b(var0);
        return RegistryDataLoader.c(var0);
    }

    private static void b(Map<ResourceKey<?>, Exception> var02) {
        StringWriter var1 = new StringWriter();
        PrintWriter var2 = new PrintWriter(var1);
        Map<MinecraftKey, Map<MinecraftKey, Exception>> var3 = var02.entrySet().stream().collect(Collectors.groupingBy(var0 -> ((ResourceKey)var0.getKey()).b(), Collectors.toMap(var0 -> ((ResourceKey)var0.getKey()).a(), Map.Entry::getValue)));
        var3.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(var12 -> {
            var2.printf(Locale.ROOT, "> Errors in registry %s:%n", var12.getKey());
            ((Map)var12.getValue()).entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(var1 -> {
                var2.printf(Locale.ROOT, ">> Errors in element %s:%n", var1.getKey());
                ((Exception)var1.getValue()).printStackTrace(var2);
            });
        });
        var2.flush();
        d.error("Registry loading errors:\n{}", (Object)var1);
    }

    private static ReportedException c(Map<ResourceKey<?>, Exception> var0) {
        CrashReport var1 = CrashReport.a(new IllegalStateException("Failed to load registries due to errors"), "Registry Loading");
        CrashReportSystemDetails var2 = var1.a("Loading info");
        var2.a("Errors", () -> {
            StringBuilder var12 = new StringBuilder();
            var0.entrySet().stream().sorted(Map.Entry.comparingByKey(e)).forEach(var1 -> var12.append("\n\t\t").append(((ResourceKey)var1.getKey()).b()).append("/").append(((ResourceKey)var1.getKey()).a()).append(": ").append(((Exception)var1.getValue()).getMessage()));
            return var12.toString();
        });
        return new ReportedException(var1);
    }

    private static <E> void a(IRegistryWritable<E> var0, Decoder<E> var1, RegistryOps<JsonElement> var2, ResourceKey<E> var3, IResource var4, RegistrationInfo var5) throws IOException {
        try (BufferedReader var6 = var4.e();){
            JsonElement var7 = StrictJsonParser.a(var6);
            DataResult var8 = var1.parse(var2, (Object)var7);
            Object var9 = var8.getOrThrow();
            var0.a(var3, var9, var5);
        }
    }

    static <E> void a(IResourceManager var0, RegistryOps.c var1, IRegistryWritable<E> var2, Decoder<E> var3, Map<ResourceKey<?>, Exception> var4) {
        FileToIdConverter var5 = FileToIdConverter.a(var2.g());
        RegistryOps<JsonElement> var6 = RegistryOps.a(JsonOps.INSTANCE, var1);
        for (Map.Entry<MinecraftKey, IResource> var8 : var5.a(var0).entrySet()) {
            MinecraftKey var9 = var8.getKey();
            ResourceKey var10 = ResourceKey.a(var2.g(), var5.b(var9));
            IResource var11 = var8.getValue();
            RegistrationInfo var12 = g.apply(var11.c());
            try {
                RegistryDataLoader.a(var2, var3, var6, var10, var11, var12);
            }
            catch (Exception var13) {
                var4.put(var10, new IllegalStateException(String.format(Locale.ROOT, "Failed to parse %s from pack %s", var9, var11.b()), var13));
            }
        }
        TagDataPack.a(var0, var2);
    }

    static <E> void a(Map<ResourceKey<? extends IRegistry<?>>, c> var0, ResourceProvider var1, RegistryOps.c var2, IRegistryWritable<E> var3, Decoder<E> var4, Map<ResourceKey<?>, Exception> var5) {
        c var6 = var0.get(var3.g());
        if (var6 == null) {
            return;
        }
        RegistryOps<NBTBase> var7 = RegistryOps.a(DynamicOpsNBT.a, var2);
        RegistryOps<JsonElement> var8 = RegistryOps.a(JsonOps.INSTANCE, var2);
        FileToIdConverter var9 = FileToIdConverter.a(var3.g());
        for (RegistrySynchronization.a var11 : var6.a) {
            Object var15;
            MinecraftKey var14;
            ResourceKey var12 = ResourceKey.a(var3.g(), var11.a());
            Optional<NBTBase> var13 = var11.b();
            if (var13.isPresent()) {
                try {
                    var14 = var4.parse(var7, (Object)var13.get());
                    var15 = var14.getOrThrow();
                    var3.a(var12, var15, f);
                }
                catch (Exception var142) {
                    var5.put(var12, new IllegalStateException(String.format(Locale.ROOT, "Failed to parse value %s from server", var13.get()), var142));
                }
                continue;
            }
            var14 = var9.a(var11.a());
            try {
                var15 = var1.getResourceOrThrow(var14);
                RegistryDataLoader.a(var3, var4, var8, var12, (IResource)var15, f);
            }
            catch (Exception var152) {
                var5.put(var12, new IllegalStateException("Failed to parse local data", var152));
            }
        }
        TagDataPack.a(var6.b, var3);
    }

    @FunctionalInterface
    static interface b {
        public void apply(a<?> var1, RegistryOps.c var2);
    }

    public static final class c
    extends Record {
        final List<RegistrySynchronization.a> a;
        final TagNetworkSerialization.a b;

        public c(List<RegistrySynchronization.a> var0, TagNetworkSerialization.a var1) {
            this.a = var0;
            this.b = var1;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "elements;tags", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "elements;tags", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "elements;tags", "a", "b"}, this, var0);
        }

        public List<RegistrySynchronization.a> a() {
            return this.a;
        }

        public TagNetworkSerialization.a b() {
            return this.b;
        }
    }

    static final class a<T>
    extends Record {
        final d<T> a;
        final IRegistryWritable<T> b;
        private final Map<ResourceKey<?>, Exception> c;

        a(d<T> var0, IRegistryWritable<T> var1, Map<ResourceKey<?>, Exception> var2) {
            this.a = var0;
            this.b = var1;
            this.c = var2;
        }

        public void a(IResourceManager var0, RegistryOps.c var1) {
            RegistryDataLoader.a(var0, var1, this.b, this.a.b, this.c);
        }

        public void a(Map<ResourceKey<? extends IRegistry<?>>, c> var0, ResourceProvider var1, RegistryOps.c var2) {
            RegistryDataLoader.a(var0, var1, var2, this.b, this.a.b, this.c);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "data;registry;loadingErrors", "a", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "data;registry;loadingErrors", "a", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "data;registry;loadingErrors", "a", "b", "c"}, this, var0);
        }

        public d<T> a() {
            return this.a;
        }

        public IRegistryWritable<T> b() {
            return this.b;
        }

        public Map<ResourceKey<?>, Exception> c() {
            return this.c;
        }
    }

    public static final class d<T>
    extends Record {
        private final ResourceKey<? extends IRegistry<T>> a;
        final Codec<T> b;
        final boolean c;

        d(ResourceKey<? extends IRegistry<T>> var0, Codec<T> var1) {
            this(var0, var1, false);
        }

        public d(ResourceKey<? extends IRegistry<T>> var0, Codec<T> var1, boolean var2) {
            this.a = var0;
            this.b = var1;
            this.c = var2;
        }

        a<T> a(Lifecycle var0, Map<ResourceKey<?>, Exception> var1) {
            RegistryMaterials var2 = new RegistryMaterials(this.a, var0);
            return new a(this, var2, var1);
        }

        public void a(BiConsumer<ResourceKey<? extends IRegistry<T>>, Codec<T>> var0) {
            var0.accept(this.a, this.b);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{d.class, "key;elementCodec;requiredNonEmpty", "a", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{d.class, "key;elementCodec;requiredNonEmpty", "a", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{d.class, "key;elementCodec;requiredNonEmpty", "a", "b", "c"}, this, var0);
        }

        public ResourceKey<? extends IRegistry<T>> a() {
            return this.a;
        }

        public Codec<T> b() {
            return this.b;
        }

        public boolean c() {
            return this.c;
        }
    }
}

