/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.dedicated;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.net.HostAndPort;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import io.netty.handler.ssl.SslContext;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Proxy;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.logging.Handler;
import java.util.stream.Stream;
import joptsimple.OptionSet;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.SharedConstants;
import net.minecraft.SystemReport;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.IMinecraftServer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerCommand;
import net.minecraft.server.ServerLinks;
import net.minecraft.server.Services;
import net.minecraft.server.WorldLoader;
import net.minecraft.server.WorldStem;
import net.minecraft.server.dedicated.DedicatedPlayerList;
import net.minecraft.server.dedicated.DedicatedServerProperties;
import net.minecraft.server.dedicated.DedicatedServerSettings;
import net.minecraft.server.gui.ServerGUI;
import net.minecraft.server.jsonrpc.JsonRpcNotificationService;
import net.minecraft.server.jsonrpc.ManagementServer;
import net.minecraft.server.jsonrpc.internalapi.MinecraftApi;
import net.minecraft.server.jsonrpc.security.AuthenticationHandler;
import net.minecraft.server.jsonrpc.security.JsonRpcSslContextProvider;
import net.minecraft.server.jsonrpc.security.SecurityConfig;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.level.progress.LoggingLevelLoadListener;
import net.minecraft.server.network.ITextFilter;
import net.minecraft.server.network.ServerTextFilter;
import net.minecraft.server.packs.repository.ResourcePackRepository;
import net.minecraft.server.permissions.LevelBasedPermissionSet;
import net.minecraft.server.permissions.PermissionSet;
import net.minecraft.server.players.NameAndId;
import net.minecraft.server.players.NameReferencingFileConverter;
import net.minecraft.server.rcon.RemoteControlCommandListener;
import net.minecraft.server.rcon.thread.RemoteControlListener;
import net.minecraft.server.rcon.thread.RemoteStatusListener;
import net.minecraft.util.MathHelper;
import net.minecraft.util.SystemUtils;
import net.minecraft.util.TimeRange;
import net.minecraft.util.UtilColor;
import net.minecraft.util.debug.DebugSubscriptions;
import net.minecraft.util.debugchart.RemoteDebugSampleType;
import net.minecraft.util.debugchart.RemoteSampleLogger;
import net.minecraft.util.debugchart.SampleLogger;
import net.minecraft.util.debugchart.TpsDebugDimensions;
import net.minecraft.util.monitoring.jmx.MinecraftServerBeans;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.WorldData;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.io.IoBuilder;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.Main;
import org.bukkit.craftbukkit.v1_21_R7.SpigotTimings;
import org.bukkit.craftbukkit.v1_21_R7.command.ConsoleCommandCompleter;
import org.bukkit.craftbukkit.v1_21_R7.util.ForwardLogHandler;
import org.bukkit.craftbukkit.v1_21_R7.util.TerminalConsoleWriterThread;
import org.bukkit.event.Event;
import org.bukkit.event.server.RemoteServerCommandEvent;
import org.bukkit.event.server.ServerCommandEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginLoadOrder;
import org.jline.reader.Completer;
import org.jline.reader.EndOfFileException;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.UserInterruptException;
import org.jspecify.annotations.Nullable;
import org.spigotmc.SpigotConfig;

public class DedicatedServer
extends MinecraftServer
implements IMinecraftServer {
    static final org.slf4j.Logger m = LogUtils.getLogger();
    private static final int n = 5000;
    private static final int o = 2;
    private final List<ServerCommand> p = Collections.synchronizedList(Lists.newArrayList());
    private @Nullable RemoteStatusListener q;
    private @Nullable RemoteControlListener s;
    public DedicatedServerSettings t;
    private @Nullable ServerGUI u;
    private final @Nullable ServerTextFilter v;
    private @Nullable RemoteSampleLogger w;
    private boolean x;
    public ServerLinks y;
    private final Map<String, String> z;
    private @Nullable ManagementServer A;
    private long B;

    public DedicatedServer(OptionSet options, WorldLoader.a worldLoader, Thread thread, Convertable.ConversionSession convertable_conversionsession, ResourcePackRepository resourcepackrepository, WorldStem worldstem, DedicatedServerSettings dedicatedserversettings, DataFixer datafixer, Services services) {
        super(options, worldLoader, thread, convertable_conversionsession, resourcepackrepository, worldstem, Proxy.NO_PROXY, datafixer, services, LoggingLevelLoadListener.a());
        this.t = dedicatedserversettings;
        this.v = ServerTextFilter.a(dedicatedserversettings.a());
        this.y = DedicatedServer.a(dedicatedserversettings);
        this.z = dedicatedserversettings.a().i ? DedicatedServer.bQ() : Map.of();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Map<String, String> bQ() {
        Path path = Path.of("codeofconduct", new String[0]);
        if (!Files.isDirectory(path, LinkOption.NOFOLLOW_LINKS)) {
            throw new IllegalArgumentException("Code of Conduct folder does not exist: " + String.valueOf(path));
        }
        try {
            ImmutableMap.Builder immutablemap_builder = ImmutableMap.builder();
            try (Stream<Path> stream = Files.list(path);){
                for (Path path1 : stream.toList()) {
                    String s2 = path1.getFileName().toString();
                    if (!s2.endsWith(".txt")) continue;
                    String s1 = s2.substring(0, s2.length() - 4).toLowerCase(Locale.ROOT);
                    if (!path1.toRealPath(new LinkOption[0]).getParent().equals(path.toAbsolutePath())) {
                        throw new IllegalArgumentException("Failed to read Code of Conduct file \"" + s2 + "\" because it links to a file outside the allowed directory");
                    }
                    try {
                        String s22 = String.join((CharSequence)"\n", Files.readAllLines(path1, StandardCharsets.UTF_8));
                        immutablemap_builder.put((Object)s1, (Object)UtilColor.a(s22));
                    }
                    catch (IOException ioexception) {
                        throw new IllegalArgumentException("Failed to read Code of Conduct file " + s2, ioexception);
                        return new LinkedHashMap<String, String>((Map<String, String>)immutablemap_builder.build());
                    }
                }
            }
        }
        catch (IOException ioexception1) {
            throw new IllegalArgumentException("Failed to read Code of Conduct folder", ioexception1);
        }
    }

    private SslContext bR() {
        try {
            return JsonRpcSslContextProvider.a(this.a().v, this.a().w);
        }
        catch (Exception exception) {
            JsonRpcSslContextProvider.a();
            throw new IllegalStateException("Failed to configure TLS for the server management protocol", exception);
        }
    }

    @Override
    public boolean e() throws IOException {
        int i2 = this.a().s;
        if (this.a().q) {
            String s2 = this.t.a().t;
            if (!SecurityConfig.a(s2)) {
                throw new IllegalStateException("Invalid management server secret, must be 40 alphanumeric characters");
            }
            String s1 = this.a().r;
            HostAndPort hostandport = HostAndPort.fromParts((String)s1, (int)i2);
            Handler[] securityconfig = new SecurityConfig(s2);
            String s22 = this.a().x;
            AuthenticationHandler authenticationhandler = new AuthenticationHandler((SecurityConfig)securityconfig, s22);
            m.info("Starting json RPC server on {}", (Object)hostandport);
            this.A = new ManagementServer(hostandport, authenticationhandler);
            MinecraftApi minecraftapi = MinecraftApi.a(this);
            minecraftapi.h().a(new JsonRpcNotificationService(minecraftapi, this.A));
            if (this.a().u) {
                SslContext sslcontext = this.bR();
                this.A.a(minecraftapi, sslcontext);
            } else {
                this.A.a(minecraftapi);
            }
        }
        final LineReader reader = LineReaderBuilder.builder().terminal(this.terminal).option(LineReader.Option.DISABLE_EVENT_EXPANSION, true).completer((Completer)new ConsoleCommandCompleter()).build();
        Thread thread = new Thread("Server console handler"){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                if (!Main.useConsole) {
                    return;
                }
                try {
                    System.in.available();
                }
                catch (IOException ex) {
                    return;
                }
                try {
                    while (!DedicatedServer.this.ai() && DedicatedServer.this.z()) {
                        try {
                            String s3 = Main.useJline ? reader.readLine(">", null) : reader.readLine();
                            if (s3.trim().length() <= 0) continue;
                            DedicatedServer.this.a(s3, DedicatedServer.this.aG());
                        }
                        catch (EndOfFileException | UserInterruptException eof) {
                            try {
                                Thread.sleep(50L);
                            }
                            catch (InterruptedException ex) {
                                Thread.currentThread().interrupt();
                            }
                        }
                    }
                    return;
                }
                catch (Throwable ioexception) {
                    m.error("Exception handling console input", ioexception);
                }
            }
        };
        java.util.logging.Logger global = java.util.logging.Logger.getLogger("");
        global.setUseParentHandlers(false);
        for (Handler handler : global.getHandlers()) {
            global.removeHandler(handler);
        }
        global.addHandler(new ForwardLogHandler());
        Logger logger = (Logger)LogManager.getRootLogger();
        for (Appender appender : logger.getAppenders().values()) {
            if (!(appender instanceof ConsoleAppender)) continue;
            logger.removeAppender(appender);
        }
        TerminalConsoleWriterThread writerThread = new TerminalConsoleWriterThread(System.out, reader);
        writerThread.start();
        System.setOut(IoBuilder.forLogger((org.apache.logging.log4j.Logger)logger).setLevel(Level.INFO).buildPrintStream());
        System.setErr(IoBuilder.forLogger((org.apache.logging.log4j.Logger)logger).setLevel(Level.WARN).buildPrintStream());
        thread.setDaemon(true);
        thread.setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler(m));
        thread.start();
        m.info("Starting minecraft server version {}", (Object)SharedConstants.b().c());
        if (Runtime.getRuntime().maxMemory() / 1024L / 1024L < 512L) {
            m.warn("To start the server with more ram, launch it as \"java -Xmx1024M -Xms1024M -jar minecraft_server.jar\"");
        }
        m.info("Loading properties");
        DedicatedServerProperties dedicatedserverproperties = this.t.a();
        if (this.X()) {
            this.a_("127.0.0.1");
        } else {
            this.e(dedicatedserverproperties.d);
            this.f(dedicatedserverproperties.e);
            this.a_(dedicatedserverproperties.f);
        }
        this.a(new DedicatedPlayerList(this, this.bd(), this.h));
        SpigotConfig.init((File)this.options.valueOf("spigot-settings"));
        SpigotConfig.registerCommands();
        m.info("Default game type: {}", (Object)dedicatedserverproperties.n.get());
        InetAddress inetaddress = null;
        if (!this.y().isEmpty()) {
            inetaddress = InetAddress.getByName(this.y());
        }
        if (this.V() < 0) {
            this.b(dedicatedserverproperties.p);
        }
        this.Y();
        m.info("Starting Minecraft server on {}:{}", (Object)(this.y().isEmpty() ? "*" : this.y()), (Object)this.V());
        try {
            this.ak().a(inetaddress, this.V());
        }
        catch (IOException ioexception) {
            m.warn("**** FAILED TO BIND TO PORT!");
            m.warn("The exception was: {}", (Object)ioexception.toString());
            m.warn("Perhaps a server is already running on that port?");
            return false;
        }
        this.server.loadPlugins();
        this.server.enablePlugins(PluginLoadOrder.STARTUP);
        if (!this.ae()) {
            m.warn("**** SERVER IS RUNNING IN OFFLINE/INSECURE MODE!");
            m.warn("The server will make no attempt to authenticate usernames. Beware.");
            if (SpigotConfig.bungee) {
                m.warn("Whilst this makes it possible to use BungeeCord, unless access to your server is properly restricted, it also opens up the ability for hackers to connect with any username they choose.");
                m.warn("Please see http://www.spigotmc.org/wiki/firewall-guide/ for further information.");
            } else {
                m.warn("While this makes the game possible to play without internet access, it also opens up the ability for hackers to connect with any username they choose.");
            }
            m.warn("To change this, set \"online-mode\" to \"true\" in the server.properties file.");
        }
        if (this.bE()) {
            this.j.f().a();
        }
        if (!NameReferencingFileConverter.e(this)) {
            return false;
        }
        this.w = new RemoteSampleLogger(TpsDebugDimensions.values().length, this.bw(), RemoteDebugSampleType.a);
        long j2 = SystemUtils.d();
        this.j.f().a(!this.ae());
        m.info("Preparing level \"{}\"", (Object)this.j());
        this.loadLevel(this.g.f());
        long k2 = SystemUtils.d() - j2;
        String s3 = String.format(Locale.ROOT, "%.3fs", (double)k2 / 1.0E9);
        m.info("Done ({})! For help, type \"help\"", (Object)s3);
        if (dedicatedserverproperties.y != null) {
            this.k.n().set(GameRules.S, dedicatedserverproperties.y, this.N());
        }
        if (dedicatedserverproperties.z) {
            m.info("Starting GS4 status listener");
            this.q = RemoteStatusListener.a(this);
        }
        if (dedicatedserverproperties.B) {
            m.info("Starting remote control listener");
            this.s = RemoteControlListener.a(this);
        }
        if (dedicatedserverproperties.V) {
            MinecraftServerBeans.a(this);
            m.info("JMX monitoring enabled");
        }
        this.C().a();
        return true;
    }

    @Override
    public boolean aO() {
        return this.t.a().l.get();
    }

    @Override
    public void g(boolean flag) {
        this.t.a(dedicatedserverproperties -> (DedicatedServerProperties)dedicatedserverproperties.l.a(this.bc(), flag));
    }

    @Override
    public boolean aP() {
        return this.t.a().af.get();
    }

    @Override
    public void h(boolean flag) {
        this.t.a(dedicatedserverproperties -> (DedicatedServerProperties)dedicatedserverproperties.af.a(this.bc(), flag));
    }

    @Override
    public void a(BooleanSupplier booleansupplier) {
        long k2;
        super.a(booleansupplier);
        if (this.A != null) {
            this.A.a();
        }
        long i2 = SystemUtils.c();
        int j2 = this.bD();
        if (j2 > 0 && i2 - this.B >= (k2 = (long)j2 * TimeRange.c)) {
            this.B = i2;
            this.C().f();
        }
    }

    @Override
    public boolean a(boolean flag, boolean flag1, boolean flag2) {
        this.C().c();
        boolean flag3 = super.a(flag, flag1, flag2);
        this.C().d();
        return flag3;
    }

    @Override
    public boolean ag() {
        return this.t.a().g.get();
    }

    public void j(boolean flag) {
        this.t.a(dedicatedserverproperties -> (DedicatedServerProperties)dedicatedserverproperties.g.a(this.bc(), flag));
    }

    @Override
    public DedicatedServerProperties a() {
        return this.t.a();
    }

    public void a(EnumDifficulty enumdifficulty) {
        this.t.a(dedicatedserverproperties -> (DedicatedServerProperties)dedicatedserverproperties.m.a(this.bc(), enumdifficulty));
        this.t();
    }

    @Override
    public void t() {
        this.a(this.a().m.get(), true);
    }

    public int bx() {
        return this.t.a().M.get();
    }

    public void e(int i2) {
        this.t.a(dedicatedserverproperties -> (DedicatedServerProperties)dedicatedserverproperties.M.a(this.bc(), i2));
        this.bA().a(i2);
    }

    public int by() {
        return this.t.a().N.get();
    }

    public void f(int i2) {
        this.t.a(dedicatedserverproperties -> (DedicatedServerProperties)dedicatedserverproperties.N.a(this.bc(), i2));
        this.bA().b(i2);
    }

    @Override
    public SystemReport a(SystemReport systemreport) {
        systemreport.a("Is Modded", () -> this.T().b());
        systemreport.a("Type", () -> "Dedicated Server (map_server.txt)");
        return systemreport;
    }

    @Override
    public void a(Path path) throws IOException {
        DedicatedServerProperties dedicatedserverproperties = this.a();
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            writer.write(String.format(Locale.ROOT, "sync-chunk-writes=%s%n", dedicatedserverproperties.T));
            writer.write(String.format(Locale.ROOT, "gamemode=%s%n", dedicatedserverproperties.n.get()));
            writer.write(String.format(Locale.ROOT, "entity-broadcast-range-percentage=%d%n", dedicatedserverproperties.Y.get()));
            writer.write(String.format(Locale.ROOT, "max-world-size=%d%n", dedicatedserverproperties.S));
            writer.write(String.format(Locale.ROOT, "view-distance=%d%n", dedicatedserverproperties.M.get()));
            writer.write(String.format(Locale.ROOT, "simulation-distance=%d%n", dedicatedserverproperties.N.get()));
            writer.write(String.format(Locale.ROOT, "generate-structures=%s%n", dedicatedserverproperties.aj.d()));
            writer.write(String.format(Locale.ROOT, "use-native=%s%n", dedicatedserverproperties.F));
            writer.write(String.format(Locale.ROOT, "rate-limit=%d%n", dedicatedserverproperties.L));
        }
    }

    @Override
    public void i() {
        if (this.v != null) {
            this.v.close();
        }
        if (this.u != null) {
            this.u.b();
        }
        if (this.s != null) {
            this.s.b();
        }
        if (this.q != null) {
            this.q.b();
        }
        if (this.A != null) {
            try {
                this.A.a(true);
            }
            catch (InterruptedException interruptedexception) {
                m.error("Interrupted while stopping the management server", (Throwable)interruptedexception);
            }
        }
        System.exit(0);
    }

    @Override
    public void K() {
        super.K();
        this.bz();
    }

    public void a(String s2, CommandListenerWrapper commandlistenerwrapper) {
        this.p.add(new ServerCommand(s2, commandlistenerwrapper));
    }

    public void bz() {
        SpigotTimings.serverCommandTimer.startTiming();
        while (!this.p.isEmpty()) {
            ServerCommand servercommand = this.p.remove(0);
            ServerCommandEvent event = new ServerCommandEvent((CommandSender)this.console, servercommand.a);
            this.server.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) continue;
            servercommand = new ServerCommand(event.getCommand(), servercommand.b);
            this.server.dispatchServerCommand((CommandSender)this.console, servercommand);
        }
        SpigotTimings.serverCommandTimer.stopTiming();
    }

    @Override
    public boolean n() {
        return true;
    }

    @Override
    public int o() {
        return this.a().L;
    }

    @Override
    public boolean p() {
        return this.a().F;
    }

    public DedicatedPlayerList bA() {
        return (DedicatedPlayerList)super.aj();
    }

    @Override
    public int r() {
        return this.t.a().O.get();
    }

    public void g(int i2) {
        this.t.a(dedicatedserverproperties -> (DedicatedServerProperties)dedicatedserverproperties.O.a(this.bc(), i2));
    }

    @Override
    public boolean q() {
        return true;
    }

    @Override
    public String b() {
        return this.y();
    }

    @Override
    public int d() {
        return this.V();
    }

    @Override
    public String h() {
        return this.ah();
    }

    public void bB() {
        if (this.u == null) {
            this.u = ServerGUI.a(this);
        }
    }

    public int bC() {
        return this.a().G.get();
    }

    public void h(int i2) {
        this.t.a(dedicatedserverproperties -> (DedicatedServerProperties)dedicatedserverproperties.G.a(this.bc(), i2));
    }

    @Override
    public boolean a(WorldServer worldserver, BlockPosition blockposition, EntityHuman entityhuman) {
        int j2;
        WorldData.a worlddata_a = worldserver.C();
        if (worldserver.aq() != worlddata_a.a()) {
            return false;
        }
        if (this.bA().k().d()) {
            return false;
        }
        if (this.bA().f(entityhuman.gJ())) {
            return false;
        }
        if (this.bC() <= 0) {
            return false;
        }
        BlockPosition blockposition1 = worlddata_a.b();
        int i2 = MathHelper.a(blockposition.u() - blockposition1.u());
        int k2 = Math.max(i2, j2 = MathHelper.a(blockposition.w() - blockposition1.w()));
        return k2 <= this.bC();
    }

    @Override
    public boolean an() {
        return this.a().W.get();
    }

    public void k(boolean flag) {
        this.t.a(dedicatedserverproperties -> (DedicatedServerProperties)dedicatedserverproperties.W.a(this.bc(), flag));
    }

    @Override
    public boolean ao() {
        return this.a().X.get();
    }

    public void l(boolean flag) {
        this.t.a(dedicatedserverproperties -> (DedicatedServerProperties)dedicatedserverproperties.X.a(this.bc(), flag));
    }

    @Override
    public LevelBasedPermissionSet k() {
        return this.a().H.get();
    }

    public void a(LevelBasedPermissionSet levelbasedpermissionset) {
        this.t.a(dedicatedserverproperties -> (DedicatedServerProperties)dedicatedserverproperties.H.a(this.bc(), levelbasedpermissionset));
    }

    @Override
    public PermissionSet l() {
        return this.a().I;
    }

    @Override
    public int aq() {
        return this.t.a().ad.get();
    }

    @Override
    public void d(int i2) {
        this.t.a(dedicatedserverproperties -> (DedicatedServerProperties)dedicatedserverproperties.ad.a(this.bc(), i2));
    }

    public int bD() {
        return this.t.a().ae.get();
    }

    public void i(int i2) {
        this.t.a(dedicatedserverproperties -> (DedicatedServerProperties)dedicatedserverproperties.ae.a(this.bc(), i2));
    }

    @Override
    public String ah() {
        return this.t.a().h.get();
    }

    @Override
    public void d(String s2) {
        this.t.a(dedicatedserverproperties -> (DedicatedServerProperties)dedicatedserverproperties.h.a(this.bc(), s2));
    }

    @Override
    public boolean m() {
        return this.a().Q;
    }

    @Override
    public boolean c() {
        return this.a().R;
    }

    @Override
    public int au() {
        return this.a().S;
    }

    @Override
    public int ax() {
        return this.a().P;
    }

    @Override
    public boolean ay() {
        DedicatedServerProperties dedicatedserverproperties = this.a();
        return dedicatedserverproperties.ag && dedicatedserverproperties.d && this.j.b();
    }

    @Override
    public boolean bn() {
        return this.a().ah;
    }

    protected boolean bE() {
        boolean flag = false;
        for (int i2 = 0; !flag && i2 <= 2; ++i2) {
            if (i2 > 0) {
                m.warn("Encountered a problem while converting the user banlist, retrying in a few seconds");
                this.bS();
            }
            flag = NameReferencingFileConverter.a((MinecraftServer)this);
        }
        boolean flag1 = false;
        for (int j2 = 0; !flag1 && j2 <= 2; ++j2) {
            if (j2 > 0) {
                m.warn("Encountered a problem while converting the ip banlist, retrying in a few seconds");
                this.bS();
            }
            flag1 = NameReferencingFileConverter.b(this);
        }
        boolean flag2 = false;
        for (int k2 = 0; !flag2 && k2 <= 2; ++k2) {
            if (k2 > 0) {
                m.warn("Encountered a problem while converting the op list, retrying in a few seconds");
                this.bS();
            }
            flag2 = NameReferencingFileConverter.c(this);
        }
        boolean flag3 = false;
        for (int l2 = 0; !flag3 && l2 <= 2; ++l2) {
            if (l2 > 0) {
                m.warn("Encountered a problem while converting the whitelist, retrying in a few seconds");
                this.bS();
            }
            flag3 = NameReferencingFileConverter.d(this);
        }
        boolean flag4 = false;
        for (int i1 = 0; !flag4 && i1 <= 2; ++i1) {
            if (i1 > 0) {
                m.warn("Encountered a problem while converting the player save files, retrying in a few seconds");
                this.bS();
            }
            flag4 = NameReferencingFileConverter.a(this);
        }
        return flag || flag1 || flag2 || flag3 || flag4;
    }

    private void bS() {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public long bF() {
        return this.a().J;
    }

    @Override
    public int bl() {
        return this.a().K;
    }

    @Override
    public String s() {
        StringBuilder result = new StringBuilder();
        Plugin[] plugins = this.server.getPluginManager().getPlugins();
        result.append(this.server.getName());
        result.append(" on Bukkit ");
        result.append(this.server.getBukkitVersion());
        if (plugins.length > 0 && this.server.getQueryPlugins()) {
            result.append(": ");
            for (int i2 = 0; i2 < plugins.length; ++i2) {
                if (i2 > 0) {
                    result.append("; ");
                }
                result.append(plugins[i2].getDescription().getName());
                result.append(" ");
                result.append(plugins[i2].getDescription().getVersion().replaceAll(";", ","));
            }
        }
        return result.toString();
    }

    @Override
    public String a(String s2) {
        throw new UnsupportedOperationException("Not supported - remote source required.");
    }

    public String runCommand(RemoteControlCommandListener rconConsoleSource, String s2) {
        rconConsoleSource.e();
        this.h(() -> {
            CommandListenerWrapper wrapper = rconConsoleSource.g();
            RemoteServerCommandEvent event = new RemoteServerCommandEvent(rconConsoleSource.getBukkitSender(wrapper), s2);
            this.server.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            ServerCommand serverCommand = new ServerCommand(event.getCommand(), wrapper);
            this.server.dispatchServerCommand(event.getSender(), serverCommand);
        });
        return rconConsoleSource.f();
    }

    @Override
    public void x() {
        this.C().b();
        super.x();
        SystemUtils.k();
    }

    @Override
    public boolean a(NameAndId nameandid) {
        return false;
    }

    @Override
    public int c(int i2) {
        return this.bG() * i2 / 100;
    }

    public int bG() {
        return this.a().Y.get();
    }

    public void j(int i2) {
        this.t.a(dedicatedserverproperties -> (DedicatedServerProperties)dedicatedserverproperties.Y.a(this.bc(), i2));
    }

    @Override
    public String j() {
        return this.g.f();
    }

    @Override
    public boolean aZ() {
        return this.t.a().T;
    }

    @Override
    public ITextFilter a(EntityPlayer entityplayer) {
        return this.v != null ? this.v.a(entityplayer.gI()) : ITextFilter.e;
    }

    @Override
    public @Nullable EnumGamemode bf() {
        return this.bH() ? this.k.j() : null;
    }

    public boolean bH() {
        return this.t.a().k.get();
    }

    public void m(boolean flag) {
        this.t.a(dedicatedserverproperties -> (DedicatedServerProperties)dedicatedserverproperties.k.a(this.bc(), flag));
        this.b(this.bf());
    }

    public EnumGamemode bI() {
        return this.a().n.get();
    }

    public void c(EnumGamemode enumgamemode) {
        this.t.a(dedicatedserverproperties -> (DedicatedServerProperties)dedicatedserverproperties.n.a(this.bc(), enumgamemode));
        this.k.a(this.bI());
        this.b(this.bf());
    }

    @Override
    public Optional<MinecraftServer.ServerResourcePackInfo> ac() {
        return this.t.a().ab;
    }

    @Override
    public void aU() {
        super.aU();
        this.x = this.bw().a(DebugSubscriptions.a);
    }

    @Override
    public SampleLogger f() {
        return this.w;
    }

    @Override
    public boolean g() {
        return this.x;
    }

    @Override
    public boolean bq() {
        return this.t.a().ak.get();
    }

    public void n(boolean flag) {
        this.t.a(dedicatedserverproperties -> (DedicatedServerProperties)dedicatedserverproperties.ak.a(this.bc(), flag));
    }

    @Override
    public ServerLinks bt() {
        return this.y;
    }

    @Override
    public int bu() {
        return this.t.a().ai.get();
    }

    public void k(int i2) {
        this.t.a(dedicatedserverproperties -> (DedicatedServerProperties)dedicatedserverproperties.ai.a(this.bc(), i2));
    }

    private static ServerLinks a(DedicatedServerSettings dedicatedserversettings) {
        Optional<URI> optional = DedicatedServer.a(dedicatedserversettings.a());
        return optional.map(uri -> new ServerLinks(List.of(ServerLinks.KnownLinkType.a.a((URI)uri)))).orElse(ServerLinks.a);
    }

    private static Optional<URI> a(DedicatedServerProperties dedicatedserverproperties) {
        String s2 = dedicatedserverproperties.j;
        if (s2.isEmpty()) {
            return Optional.empty();
        }
        try {
            return Optional.of(SystemUtils.a(s2));
        }
        catch (Exception exception) {
            m.warn("Failed to parse bug link {}", (Object)s2, (Object)exception);
            return Optional.empty();
        }
    }

    @Override
    public Map<String, String> ab() {
        return this.z;
    }

    @Override
    public boolean isDebugging() {
        return this.a().debug;
    }

    @Override
    public CommandSender getBukkitSender(CommandListenerWrapper wrapper) {
        return this.console;
    }
}

