/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.jsonrpc;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Locale;
import java.util.function.Function;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.jsonrpc.api.MethodInfo;
import net.minecraft.server.jsonrpc.api.ParamInfo;
import net.minecraft.server.jsonrpc.api.ResultInfo;
import net.minecraft.server.jsonrpc.api.Schema;
import net.minecraft.server.jsonrpc.internalapi.MinecraftApi;
import net.minecraft.server.jsonrpc.methods.ClientInfo;
import net.minecraft.server.jsonrpc.methods.EncodeJsonRpcException;
import net.minecraft.server.jsonrpc.methods.InvalidParameterJsonRpcException;
import org.jspecify.annotations.Nullable;

public interface IncomingRpcMethod<Params, Result> {
    public MethodInfo<Params, Result> a();

    public a b();

    public JsonElement a(MinecraftApi var1, @Nullable JsonElement var2, ClientInfo var3);

    public static <Result> b<Void, Result> a(e<Result> var0) {
        return new b(var0);
    }

    public static <Params, Result> b<Params, Result> a(f<Params, Result> var0) {
        return new b<Params, Result>(var0);
    }

    public static <Result> b<Void, Result> a(Function<MinecraftApi, Result> var0) {
        return new b(var0);
    }

    public static class b<Params, Result> {
        private String a = "";
        private @Nullable ParamInfo<Params> b;
        private @Nullable ResultInfo<Result> c;
        private boolean d = true;
        private boolean e = true;
        private @Nullable e<Result> f;
        private @Nullable f<Params, Result> g;

        public b(e<Result> var0) {
            this.f = var0;
        }

        public b(f<Params, Result> var0) {
            this.g = var0;
        }

        public b(Function<MinecraftApi, Result> var0) {
            this.f = (var1, var2) -> var0.apply(var1);
        }

        public b<Params, Result> a(String var0) {
            this.a = var0;
            return this;
        }

        public b<Params, Result> a(String var0, Schema<Result> var1) {
            this.c = new ResultInfo<Result>(var0, var1.b());
            return this;
        }

        public b<Params, Result> b(String var0, Schema<Params> var1) {
            this.b = new ParamInfo<Params>(var0, var1.b());
            return this;
        }

        public b<Params, Result> a() {
            this.d = false;
            return this;
        }

        public b<Params, Result> b() {
            this.e = false;
            return this;
        }

        public IncomingRpcMethod<Params, Result> c() {
            if (this.c == null) {
                throw new IllegalStateException("No response defined");
            }
            a var0 = new a(this.e, this.d);
            MethodInfo<Params, Result> var1 = new MethodInfo<Params, Result>(this.a, this.b, this.c);
            if (this.f != null) {
                return new d<Params, Result>(var1, var0, this.f);
            }
            if (this.g != null) {
                if (this.b == null) {
                    throw new IllegalStateException("No param schema defined");
                }
                return new c<Params, Result>(var1, var0, this.g);
            }
            throw new IllegalStateException("No method defined");
        }

        public IncomingRpcMethod<?, ?> a(IRegistry<IncomingRpcMethod<?, ?>> var0, String var1) {
            return this.a(var0, MinecraftKey.b(var1));
        }

        private IncomingRpcMethod<?, ?> a(IRegistry<IncomingRpcMethod<?, ?>> var0, MinecraftKey var1) {
            return IRegistry.a(var0, var1, this.c());
        }
    }

    @FunctionalInterface
    public static interface e<Result> {
        public Result apply(MinecraftApi var1, ClientInfo var2);
    }

    @FunctionalInterface
    public static interface f<Params, Result> {
        public Result apply(MinecraftApi var1, Params var2, ClientInfo var3);
    }

    public record c<Params, Result>(MethodInfo<Params, Result> a, a b, f<Params, Result> c) implements IncomingRpcMethod<Params, Result>
    {
        @Override
        public JsonElement a(MinecraftApi var0, @Nullable JsonElement var1, ClientInfo var2) {
            JsonElement var3;
            Object var5;
            Object var4;
            if (var1 == null || !var1.isJsonArray() && !var1.isJsonObject()) {
                throw new InvalidParameterJsonRpcException("Expected params as array or named");
            }
            if (this.a.b().isEmpty()) {
                throw new IllegalArgumentException("Method defined as having parameters without describing them");
            }
            if (var1.isJsonObject()) {
                var4 = this.a.b().get().b();
                var5 = var1.getAsJsonObject().get((String)var4);
                if (var5 == null) {
                    throw new InvalidParameterJsonRpcException(String.format(Locale.ROOT, "Params passed by-name, but expected param [%s] does not exist", var4));
                }
                var3 = var5;
            } else {
                var4 = var1.getAsJsonArray();
                if (var4.isEmpty() || var4.size() > 1) {
                    throw new InvalidParameterJsonRpcException("Expected exactly one element in the params array");
                }
                var3 = var4.get(0);
            }
            var4 = this.a.b().get().c().j().parse((DynamicOps)JsonOps.INSTANCE, (Object)var3).getOrThrow(InvalidParameterJsonRpcException::new);
            var5 = this.c.apply(var0, (JsonArray)var4, var2);
            if (this.a.c().isEmpty()) {
                throw new IllegalStateException("No result codec defined");
            }
            return (JsonElement)this.a.c().get().c().j().encodeStart((DynamicOps)JsonOps.INSTANCE, var5).getOrThrow(EncodeJsonRpcException::new);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "info;attributes;function", "a", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "info;attributes;function", "a", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "info;attributes;function", "a", "b", "c"}, this, var0);
        }
    }

    public record d<Params, Result>(MethodInfo<Params, Result> a, a b, e<Result> c) implements IncomingRpcMethod<Params, Result>
    {
        @Override
        public JsonElement a(MinecraftApi var0, @Nullable JsonElement var1, ClientInfo var2) {
            if (!(var1 == null || var1.isJsonArray() && var1.getAsJsonArray().isEmpty())) {
                throw new InvalidParameterJsonRpcException("Expected no params, or an empty array");
            }
            if (this.a.b().isPresent()) {
                throw new IllegalArgumentException("Parameterless method unexpectedly has parameter description");
            }
            Result var3 = this.c.apply(var0, var2);
            if (this.a.c().isEmpty()) {
                throw new IllegalStateException("No result codec defined");
            }
            return (JsonElement)this.a.c().get().c().j().encodeStart((DynamicOps)JsonOps.INSTANCE, var3).getOrThrow(InvalidParameterJsonRpcException::new);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{d.class, "info;attributes;supplier", "a", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{d.class, "info;attributes;supplier", "a", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{d.class, "info;attributes;supplier", "a", "b", "c"}, this, var0);
        }
    }

    public record a(boolean a, boolean b) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "runOnMainThread;discoverable", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "runOnMainThread;discoverable", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "runOnMainThread;discoverable", "a", "b"}, this, var0);
        }
    }
}

