/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.jsonrpc.security;

import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.AttributeKey;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Set;
import net.minecraft.server.jsonrpc.security.SecurityConfig;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

@ChannelHandler.Sharable
public class AuthenticationHandler
extends ChannelDuplexHandler {
    private final Logger b = LogUtils.getLogger();
    private static final AttributeKey<Boolean> c = AttributeKey.valueOf((String)"authenticated");
    private static final AttributeKey<Boolean> d = AttributeKey.valueOf((String)"websocket_auth_allowed");
    private static final String e = "minecraft-v1";
    private static final String f = "minecraft-v1,";
    public static final String a = "Bearer ";
    private final SecurityConfig g;
    private final Set<String> h;

    public AuthenticationHandler(SecurityConfig var0, String var1) {
        this.g = var0;
        this.h = Sets.newHashSet((Object[])var1.split(","));
    }

    public void channelRead(ChannelHandlerContext var0, Object var1) throws Exception {
        Object var3;
        String var2 = this.a(var0);
        if (var1 instanceof HttpRequest) {
            var3 = (HttpRequest)var1;
            a var4 = this.a((HttpRequest)var3);
            if (var4.b()) {
                var0.channel().attr(c).set((Object)true);
                if (var4.d()) {
                    var0.channel().attr(d).set((Object)Boolean.TRUE);
                }
            } else {
                this.b.debug("Authentication rejected for connection with ip {}: {}", (Object)var2, (Object)var4.c());
                var0.channel().attr(c).set((Object)false);
                this.a(var0, var4.c());
                return;
            }
        }
        if (Boolean.TRUE.equals(var3 = (Boolean)var0.channel().attr(c).get())) {
            super.channelRead(var0, var1);
        } else {
            this.b.debug("Dropping unauthenticated connection with ip {}", (Object)var2);
            var0.close();
        }
    }

    public void write(ChannelHandlerContext var0, Object var1, ChannelPromise var2) throws Exception {
        HttpResponse var3;
        if (var1 instanceof HttpResponse && (var3 = (HttpResponse)var1).status().code() == HttpResponseStatus.SWITCHING_PROTOCOLS.code() && var0.channel().attr(d).get() != null && ((Boolean)var0.channel().attr(d).get()).equals(Boolean.TRUE)) {
            var3.headers().set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL, (Object)e);
        }
        super.write(var0, var1, var2);
    }

    private a a(HttpRequest var0) {
        String var1 = this.c(var0);
        if (var1 != null) {
            if (this.a(var1)) {
                return net.minecraft.server.jsonrpc.security.AuthenticationHandler$a.a();
            }
            return net.minecraft.server.jsonrpc.security.AuthenticationHandler$a.a("Invalid API key");
        }
        String var2 = this.d(var0);
        if (var2 != null) {
            if (!this.b(var0)) {
                return net.minecraft.server.jsonrpc.security.AuthenticationHandler$a.a("Origin Not Allowed");
            }
            if (this.a(var2)) {
                return net.minecraft.server.jsonrpc.security.AuthenticationHandler$a.a(true);
            }
            return net.minecraft.server.jsonrpc.security.AuthenticationHandler$a.a("Invalid API key");
        }
        return net.minecraft.server.jsonrpc.security.AuthenticationHandler$a.a("Missing API key");
    }

    private boolean b(HttpRequest var0) {
        String var1 = var0.headers().get((CharSequence)HttpHeaderNames.ORIGIN);
        if (var1 == null || var1.isEmpty()) {
            return false;
        }
        return this.h.contains(var1);
    }

    private @Nullable String c(HttpRequest var0) {
        String var1 = var0.headers().get((CharSequence)HttpHeaderNames.AUTHORIZATION);
        if (var1 != null && var1.startsWith(a)) {
            return var1.substring(a.length()).trim();
        }
        return null;
    }

    private @Nullable String d(HttpRequest var0) {
        String var1 = var0.headers().get((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL);
        if (var1 != null && var1.startsWith(f)) {
            return var1.substring(f.length()).trim();
        }
        return null;
    }

    public boolean a(String var0) {
        if (var0.isEmpty()) {
            return false;
        }
        byte[] var1 = var0.getBytes(StandardCharsets.UTF_8);
        byte[] var2 = this.g.b().getBytes(StandardCharsets.UTF_8);
        return MessageDigest.isEqual(var1, var2);
    }

    private String a(ChannelHandlerContext var0) {
        InetSocketAddress var1 = (InetSocketAddress)var0.channel().remoteAddress();
        return var1.getAddress().getHostAddress();
    }

    private void a(ChannelHandlerContext var0, String var12) {
        String var2 = "{\"error\":\"Unauthorized\",\"message\":\"" + var12 + "\"}";
        byte[] var3 = var2.getBytes(StandardCharsets.UTF_8);
        DefaultFullHttpResponse var4 = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.UNAUTHORIZED, Unpooled.wrappedBuffer((byte[])var3));
        var4.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"application/json");
        var4.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)var3.length);
        var4.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)"close");
        var0.writeAndFlush((Object)var4).addListener(var1 -> var0.close());
    }

    static class a {
        private final boolean a;
        private final String b;
        private final boolean c;

        private a(boolean var0, String var1, boolean var2) {
            this.a = var0;
            this.b = var1;
            this.c = var2;
        }

        public static a a() {
            return new a(true, null, false);
        }

        public static a a(boolean var0) {
            return new a(true, null, var0);
        }

        public static a a(String var0) {
            return new a(false, var0, false);
        }

        public boolean b() {
            return this.a;
        }

        public String c() {
            return this.b;
        }

        public boolean d() {
            return this.c;
        }
    }
}

