/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ByteMaps;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntMaps;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongConsumer;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.SharedConstants;
import net.minecraft.core.SectionPosition;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ChunkResult;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.LoadingChunkTracker;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.SimulationChunkTracker;
import net.minecraft.server.level.ThrottlingChunkTaskDispatcher;
import net.minecraft.server.level.Ticket;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.TriState;
import net.minecraft.util.thread.TaskScheduler;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.SpawnerCreature;
import net.minecraft.world.level.TicketStorage;
import net.minecraft.world.level.chunk.Chunk;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.spigotmc.AsyncCatcher;

public abstract class ChunkMapDistance {
    private static final Logger a = LogUtils.getLogger();
    static final int c = ChunkLevel.a(FullChunkStatus.d);
    final Long2ObjectMap<ObjectSet<EntityPlayer>> d = new Long2ObjectOpenHashMap();
    private final LoadingChunkTracker e;
    private final SimulationChunkTracker f;
    final TicketStorage g;
    private final a h = new a(8);
    private final b i = new b(32);
    protected final Set<PlayerChunk> b = new ReferenceOpenHashSet();
    final ThrottlingChunkTaskDispatcher j;
    final LongSet k = new LongOpenHashSet();
    final Executor l;
    public int m = 10;

    protected ChunkMapDistance(TicketStorage ticketstorage, Executor executor, Executor executor1) {
        this.g = ticketstorage;
        this.e = new LoadingChunkTracker(this, ticketstorage);
        this.f = new SimulationChunkTracker(ticketstorage);
        TaskScheduler<Runnable> taskscheduler = TaskScheduler.a("player ticket throttler", executor1);
        this.j = new ThrottlingChunkTaskDispatcher(taskscheduler, executor, 4);
        this.l = executor1;
    }

    protected abstract boolean a(long var1);

    protected abstract @Nullable PlayerChunk b(long var1);

    protected abstract @Nullable PlayerChunk a(long var1, int var3, @Nullable PlayerChunk var4, int var5);

    public boolean a(PlayerChunkMap playerchunkmap) {
        boolean flag;
        AsyncCatcher.catchOp("chunk updates");
        this.h.a();
        this.f.a();
        this.i.a();
        int i2 = Integer.MAX_VALUE - this.e.a(Integer.MAX_VALUE);
        boolean bl = flag = i2 != 0;
        if (flag && SharedConstants.M) {
            a.debug("DMU {}", (Object)i2);
        }
        if (!this.b.isEmpty()) {
            for (PlayerChunk playerchunk : this.b) {
                playerchunk.callEventIfUnloading(playerchunkmap);
            }
            for (PlayerChunk playerchunk : this.b) {
                playerchunk.a(playerchunkmap);
            }
            for (PlayerChunk playerchunk1 : this.b) {
                playerchunk1.a(playerchunkmap, this.l);
            }
            this.b.clear();
            return true;
        }
        if (!this.k.isEmpty()) {
            LongIterator longiterator = this.k.iterator();
            while (longiterator.hasNext()) {
                long j2 = longiterator.nextLong();
                if (!this.g.a(j2).stream().anyMatch(ticket -> ticket.a() == TicketType.j)) continue;
                PlayerChunk playerchunk2 = playerchunkmap.a(j2);
                if (playerchunk2 == null) {
                    throw new IllegalStateException();
                }
                CompletableFuture<ChunkResult<Chunk>> completablefuture = playerchunk2.b();
                completablefuture.thenAccept(chunkresult -> this.l.execute(() -> this.j.a(j2, () -> {}, false)));
            }
            this.k.clear();
        }
        return flag;
    }

    public void a(SectionPosition sectionposition, EntityPlayer entityplayer) {
        ChunkCoordIntPair chunkcoordintpair = sectionposition.r();
        long i2 = chunkcoordintpair.b();
        ((ObjectSet)this.d.computeIfAbsent(i2, j2 -> new ObjectOpenHashSet())).add((Object)entityplayer);
        this.h.b(i2, 0, true);
        this.i.b(i2, 0, true);
        this.g.a(new Ticket(TicketType.k, this.e()), chunkcoordintpair);
    }

    public void b(SectionPosition sectionposition, EntityPlayer entityplayer) {
        ChunkCoordIntPair chunkcoordintpair = sectionposition.r();
        long i2 = chunkcoordintpair.b();
        ObjectSet objectset = (ObjectSet)this.d.get(i2);
        if (objectset == null) {
            return;
        }
        objectset.remove((Object)entityplayer);
        if (objectset.isEmpty()) {
            this.d.remove(i2);
            this.h.b(i2, Integer.MAX_VALUE, false);
            this.i.b(i2, Integer.MAX_VALUE, false);
            this.g.b(new Ticket(TicketType.k, this.e()), chunkcoordintpair);
        }
    }

    private int e() {
        return Math.max(0, ChunkLevel.a(FullChunkStatus.d) - this.m);
    }

    public boolean c(long i2) {
        return ChunkLevel.d(this.f.c(i2));
    }

    public boolean d(long i2) {
        return ChunkLevel.e(this.f.c(i2));
    }

    public int a(long i2, boolean flag) {
        return flag ? this.f.c(i2) : this.e.c(i2);
    }

    protected void a(int i2) {
        this.i.a(i2);
    }

    public void b(int i2) {
        if (i2 != this.m) {
            this.m = i2;
            this.g.a(this.e(), TicketType.k);
        }
    }

    public int a() {
        this.h.a();
        return this.h.a.size();
    }

    public TriState e(long i2) {
        this.h.a();
        int j2 = this.h.c(i2);
        return j2 <= SpawnerCreature.c ? TriState.a : (j2 > 8 ? TriState.b : TriState.c);
    }

    public void a(LongConsumer longconsumer) {
        for (Long2ByteMap.Entry entry : Long2ByteMaps.fastIterable((Long2ByteMap)this.f.b)) {
            byte b0 = entry.getByteValue();
            long i2 = entry.getLongKey();
            if (!ChunkLevel.d(b0)) continue;
            longconsumer.accept(i2);
        }
    }

    public LongIterator b() {
        this.h.a();
        return this.h.a.keySet().iterator();
    }

    public String c() {
        return this.j.d();
    }

    public boolean d() {
        return this.g.c();
    }

    private class a
    extends ChunkMap {
        protected final Long2ByteMap a;
        protected final int b;

        protected a(int i2) {
            super(i2 + 2, 16, 256);
            this.a = new Long2ByteOpenHashMap();
            this.b = i2;
            this.a.defaultReturnValue((byte)(i2 + 2));
        }

        @Override
        protected int c(long i2) {
            return this.a.get(i2);
        }

        @Override
        protected void a(long i2, int j2) {
            AsyncCatcher.catchOp("chunk level update");
            byte b0 = j2 > this.b ? this.a.remove(i2) : this.a.put(i2, (byte)j2);
            this.a(i2, (int)b0, j2);
        }

        protected void a(long i2, int j2, int k2) {
        }

        @Override
        protected int b(long i2) {
            return this.f(i2) ? 0 : Integer.MAX_VALUE;
        }

        private boolean f(long i2) {
            ObjectSet objectset = (ObjectSet)ChunkMapDistance.this.d.get(i2);
            return objectset != null && !objectset.isEmpty();
        }

        public void a() {
            this.b(Integer.MAX_VALUE);
        }
    }

    private class b
    extends a {
        private int g;
        private final Long2IntMap h;
        private final LongSet i;

        protected b(int i2) {
            super(i2);
            this.g = 0;
            this.h = Long2IntMaps.synchronize((Long2IntMap)new Long2IntOpenHashMap());
            this.i = new LongOpenHashSet();
            this.h.defaultReturnValue(i2 + 2);
        }

        @Override
        protected void a(long i2, int j2, int k2) {
            this.i.add(i2);
        }

        public void a(int i2) {
            for (Long2ByteMap.Entry entry : this.a.long2ByteEntrySet()) {
                byte b0 = entry.getByteValue();
                long j2 = entry.getLongKey();
                this.a(j2, b0, this.c(b0), b0 <= i2);
            }
            this.g = i2;
        }

        private void a(long i2, int j2, boolean flag, boolean flag1) {
            if (flag != flag1) {
                Ticket ticket = new Ticket(TicketType.j, c);
                if (flag1) {
                    ChunkMapDistance.this.j.a(() -> ChunkMapDistance.this.l.execute(() -> {
                        if (this.c(this.c(i2))) {
                            ChunkMapDistance.this.g.a(i2, ticket);
                            ChunkMapDistance.this.k.add(i2);
                        } else {
                            ChunkMapDistance.this.j.a(i2, () -> {}, false);
                        }
                    }), i2, () -> j2);
                } else {
                    ChunkMapDistance.this.j.a(i2, () -> ChunkMapDistance.this.l.execute(() -> ChunkMapDistance.this.g.b(i2, ticket)), true);
                }
            }
        }

        @Override
        public void a() {
            super.a();
            if (!this.i.isEmpty()) {
                LongIterator longiterator = this.i.iterator();
                while (longiterator.hasNext()) {
                    int k2;
                    long i2 = longiterator.nextLong();
                    int j2 = this.h.get(i2);
                    if (j2 == (k2 = this.c(i2))) continue;
                    ChunkMapDistance.this.j.onLevelChange(new ChunkCoordIntPair(i2), () -> this.h.get(i2), k2, l2 -> {
                        if (l2 >= this.h.defaultReturnValue()) {
                            this.h.remove(i2);
                        } else {
                            this.h.put(i2, l2);
                        }
                    });
                    this.a(i2, k2, this.c(j2), this.c(k2));
                }
                this.i.clear();
            }
        }

        private boolean c(int i2) {
            return i2 <= this.g;
        }
    }
}

