/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.hash.HashCode;
import com.google.common.net.InetAddresses;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.EnumChatFormat;
import net.minecraft.ReportedException;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICommandListener;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.OutgoingChatMessage;
import net.minecraft.network.chat.RemoteChatSession;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundShowDialogPacket;
import net.minecraft.network.protocol.game.ClientboundHurtAnimationPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatEndPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatEnterPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatKillPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerRotationPacket;
import net.minecraft.network.protocol.game.ClientboundServerDataPacket;
import net.minecraft.network.protocol.game.ClientboundSetCursorItemPacket;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.network.protocol.game.CommonPlayerSpawnInfo;
import net.minecraft.network.protocol.game.PacketPlayOutAbilities;
import net.minecraft.network.protocol.game.PacketPlayOutAnimation;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutCamera;
import net.minecraft.network.protocol.game.PacketPlayOutCloseWindow;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutExperience;
import net.minecraft.network.protocol.game.PacketPlayOutGameStateChange;
import net.minecraft.network.protocol.game.PacketPlayOutLookAt;
import net.minecraft.network.protocol.game.PacketPlayOutMount;
import net.minecraft.network.protocol.game.PacketPlayOutOpenBook;
import net.minecraft.network.protocol.game.PacketPlayOutOpenSignEditor;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindow;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindowHorse;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindowMerchant;
import net.minecraft.network.protocol.game.PacketPlayOutRemoveEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutRespawn;
import net.minecraft.network.protocol.game.PacketPlayOutServerDifficulty;
import net.minecraft.network.protocol.game.PacketPlayOutSetSlot;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateHealth;
import net.minecraft.network.protocol.game.PacketPlayOutWindowData;
import net.minecraft.network.protocol.game.PacketPlayOutWindowItems;
import net.minecraft.network.protocol.status.ServerPing;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.AdvancementDataPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ScoreboardServer;
import net.minecraft.server.dialog.Dialog;
import net.minecraft.server.level.ChunkTrackingView;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.ParticleStatus;
import net.minecraft.server.level.PlayerInteractManager;
import net.minecraft.server.level.PlayerSpawnFinder;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.ITextFilter;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.server.permissions.PermissionSet;
import net.minecraft.server.players.PlayerList;
import net.minecraft.server.waypoints.ServerWaypointManager;
import net.minecraft.stats.RecipeBookServer;
import net.minecraft.stats.ServerStatisticManager;
import net.minecraft.stats.Statistic;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.HashOps;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.SystemUtils;
import net.minecraft.util.Unit;
import net.minecraft.util.debug.DebugSubscription;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.IInventory;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.attribute.BedRule;
import net.minecraft.world.attribute.EnvironmentAttributes;
import net.minecraft.world.damagesource.CombatTracker;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.PositionMoveRotation;
import net.minecraft.world.entity.Relative;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.animal.equine.EntityHorseAbstract;
import net.minecraft.world.entity.animal.happyghast.HappyGhast;
import net.minecraft.world.entity.animal.nautilus.AbstractNautilus;
import net.minecraft.world.entity.animal.parrot.EntityParrot;
import net.minecraft.world.entity.animal.pig.EntityPig;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.EntityStrider;
import net.minecraft.world.entity.monster.warden.WardenSpawnTracker;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.EnumChatVisibility;
import net.minecraft.world.entity.player.Input;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.entity.projectile.arrow.EntityArrow;
import net.minecraft.world.entity.projectile.throwableitemprojectile.EntityEnderPearl;
import net.minecraft.world.entity.vehicle.boat.AbstractBoat;
import net.minecraft.world.entity.vehicle.minecart.EntityMinecartAbstract;
import net.minecraft.world.food.FoodMetaData;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerHorse;
import net.minecraft.world.inventory.ContainerSynchronizer;
import net.minecraft.world.inventory.ICrafting;
import net.minecraft.world.inventory.NautilusInventoryMenu;
import net.minecraft.world.inventory.RemoteSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.SlotResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldown;
import net.minecraft.world.item.ItemCooldownPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemWorldMap;
import net.minecraft.world.item.component.WrittenBookContent;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.ICollisionAccess;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.BlockChest;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockRespawnAnchor;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityCommand;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.ScoreAccess;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;
import net.minecraft.world.scores.criteria.IScoreboardCriteria;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.WeatherType;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_21_R7.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R7.CraftWorldBorder;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftPortalEvent;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R7.scoreboard.CraftScoreboardManager;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftDimensionUtil;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftLocation;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityExhaustionEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerBedLeaveEvent;
import org.bukkit.event.player.PlayerChangedMainHandEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerLocaleChangeEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerSpawnChangeEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.MainHand;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class EntityPlayer
extends EntityHuman {
    private static final Logger cB = LogUtils.getLogger();
    private static final int cC = 32;
    private static final int cD = 10;
    private static final int cE = 25;
    public static final double a = 1.0;
    public static final double b = 3.0;
    public static final int c = 2;
    public static final String d = "ender_pearls";
    public static final String e = "ender_pearl_dimension";
    public static final String f = "Dimension";
    private static final AttributeModifier cF = new AttributeModifier(MinecraftKey.b("creative_mode_block_range"), 0.5, AttributeModifier.Operation.a);
    private static final AttributeModifier cG = new AttributeModifier(MinecraftKey.b("creative_mode_entity_range"), 2.0, AttributeModifier.Operation.a);
    private static final IChatBaseComponent cH = IChatBaseComponent.c("block.minecraft.set_spawn");
    private static final AttributeModifier cI = new AttributeModifier(MinecraftKey.b("waypoint_transmit_range_crouch"), -1.0, AttributeModifier.Operation.c);
    private static final boolean cJ = false;
    private static final boolean cK = false;
    public PlayerConnection g;
    public final MinecraftServer cL;
    public final PlayerInteractManager h;
    private final AdvancementDataPlayer cM;
    private final ServerStatisticManager cN;
    private float cO = Float.MIN_VALUE;
    private int cP = Integer.MIN_VALUE;
    private int cQ = Integer.MIN_VALUE;
    private int cR = Integer.MIN_VALUE;
    private int cU = Integer.MIN_VALUE;
    private int cV = Integer.MIN_VALUE;
    private float cW = -1.0E8f;
    private int cX = -99999999;
    private boolean cY = true;
    public int cZ = -99999999;
    private EnumChatVisibility da = EnumChatVisibility.a;
    private ParticleStatus db = ParticleStatus.a;
    private boolean dc = true;
    private long dd = SystemUtils.c();
    private @Nullable Entity de;
    public boolean df;
    public boolean i = false;
    private final RecipeBookServer dg;
    private @Nullable Vec3D dh;
    private int di;
    private boolean dj;
    private int dk = 2;
    public String dl = "en_us";
    private @Nullable Vec3D dm;
    private @Nullable Vec3D dn;
    private @Nullable Vec3D do;
    private SectionPosition dp = SectionPosition.a(0, 0, 0);
    private ChunkTrackingView dq = ChunkTrackingView.a;
    private @Nullable RespawnConfig dr;
    private final ITextFilter ds;
    private boolean dt;
    private boolean du;
    private boolean dv = false;
    private WardenSpawnTracker dw = new WardenSpawnTracker();
    private @Nullable BlockPosition dx;
    private Vec3D dy = Vec3D.c;
    private Input dz = Input.b;
    private final Set<EntityEnderPearl> dA = new HashSet<EntityEnderPearl>();
    private long dB;
    private NBTTagCompound dC = new NBTTagCompound();
    private NBTTagCompound dD = new NBTTagCompound();
    private final ContainerSynchronizer dE = new ContainerSynchronizer(){
        private final LoadingCache<TypedDataComponent<?>, Integer> b = CacheBuilder.newBuilder().maximumSize(256L).build(new CacheLoader<TypedDataComponent<?>, Integer>(){
            private final DynamicOps<HashCode> b;
            {
                this.b = EntityPlayer.this.eo().a(HashOps.c);
            }

            public Integer a(TypedDataComponent<?> typeddatacomponent) {
                return ((HashCode)typeddatacomponent.a(this.b).getOrThrow(s2 -> {
                    String s1 = String.valueOf(typeddatacomponent);
                    return new IllegalArgumentException("Failed to hash " + s1 + ": " + s2);
                })).asInt();
            }
        });

        @Override
        public void a(Container container, List<ItemStack> list, ItemStack itemstack, int[] aint) {
            EntityPlayer.this.g.b(new PacketPlayOutWindowItems(container.l, container.k(), list, itemstack));
            for (int i2 = 0; i2 < aint.length; ++i2) {
                this.b(container, i2, aint[i2]);
            }
        }

        @Override
        public void a(Container container, int i2, ItemStack itemstack) {
            EntityPlayer.this.g.b(new PacketPlayOutSetSlot(container.l, container.k(), i2, itemstack));
        }

        @Override
        public void a(Container container, ItemStack itemstack) {
            EntityPlayer.this.g.b(new ClientboundSetCursorItemPacket(itemstack));
        }

        @Override
        public void a(Container container, int i2, int j2) {
            this.b(container, i2, j2);
        }

        private void b(Container container, int i2, int j2) {
            EntityPlayer.this.g.b(new PacketPlayOutWindowData(container.l, i2, j2));
        }

        @Override
        public RemoteSlot a() {
            LoadingCache<TypedDataComponent<?>, Integer> loadingcache = this.b;
            Objects.requireNonNull(this.b);
            return new RemoteSlot.a(arg_0 -> loadingcache.getUnchecked(arg_0));
        }
    };
    private final ICrafting dF = new ICrafting(){

        @Override
        public void a(Container container, int i2, ItemStack itemstack) {
            Slot slot = container.b(i2);
            if (!(slot instanceof SlotResult) && slot.c == EntityPlayer.this.gK()) {
                CriterionTriggers.f.a(EntityPlayer.this, EntityPlayer.this.gK(), itemstack);
            }
        }

        @Override
        public void a(Container container, int i2, int j2) {
        }
    };
    private @Nullable RemoteChatSession dG;
    public final @Nullable Object j;
    private final ICommandListener dH = new ICommandListener(){

        @Override
        public boolean x_() {
            return EntityPlayer.this.A().U().a(GameRules.R);
        }

        @Override
        public boolean y_() {
            return true;
        }

        @Override
        public boolean c() {
            return true;
        }

        @Override
        public void a(IChatBaseComponent ichatbasecomponent) {
            EntityPlayer.this.a(ichatbasecomponent);
        }

        @Override
        public CommandSender getBukkitSender(CommandListenerWrapper wrapper) {
            return EntityPlayer.this.getBukkitEntity();
        }
    };
    private Set<DebugSubscription<?>> dI = Set.of();
    private int dJ;
    public boolean k;
    public CraftPlayer.TransferCookieConnection transferCookieConnection;
    public String displayName;
    public IChatBaseComponent listName;
    public int listOrder = 0;
    public Location compassTarget;
    public int newExp = 0;
    public int newLevel = 0;
    public int newTotalExp = 0;
    public boolean keepLevel = false;
    public double maxHealthCache;
    public boolean joining = true;
    public boolean sentListPacket = false;
    public String kickLeaveMessage = null;
    public long timeOffset = 0L;
    public boolean relativeTime = true;
    public WeatherType weather = null;
    private float pluginRainPosition;
    private float pluginRainPositionPrevious;

    public EntityPlayer(MinecraftServer minecraftserver, WorldServer worldserver, GameProfile gameprofile, ClientInformation clientinformation) {
        super(worldserver, gameprofile);
        this.cL = minecraftserver;
        this.ds = minecraftserver.a(this);
        this.h = minecraftserver.b(this);
        this.h.a(this.b((EnumGamemode)null), null);
        this.dg = new RecipeBookServer((resourcekey, consumer) -> minecraftserver.aJ().a(resourcekey, consumer));
        this.cN = minecraftserver.aj().getPlayerStats(this);
        this.cM = minecraftserver.aj().f(this);
        this.a(clientinformation);
        this.j = null;
        this.displayName = this.da();
        this.bukkitPickUpLoot = true;
        this.maxHealthCache = this.fq();
    }

    public void resendItemInHands() {
        this.cn.b(this.gK(), this.gK().g()).ifPresent(s2 -> this.dE.a(this.cn, s2, this.fx()));
        this.dE.a((Container)this.cm, 45, this.fy());
    }

    @Override
    public BlockPosition a(WorldServer worldserver, BlockPosition blockposition) {
        CompletableFuture<Vec3D> completablefuture = PlayerSpawnFinder.a(worldserver, blockposition);
        MinecraftServer minecraftserver = this.cL;
        Objects.requireNonNull(completablefuture);
        minecraftserver.b(completablefuture::isDone);
        return BlockPosition.a(completablefuture.join());
    }

    @Override
    protected void a(ValueInput valueinput) {
        super.a(valueinput);
        this.dw = valueinput.a("warden_spawn_tracker", WardenSpawnTracker.a).orElseGet(WardenSpawnTracker::new);
        this.dn = valueinput.a("entered_nether_pos", Vec3D.a).orElse(null);
        this.i = valueinput.a("seenCredits", false);
        valueinput.a("recipeBook", RecipeBookServer.b.a).ifPresent(recipebookserver_b -> this.dg.a((RecipeBookServer.b)recipebookserver_b, (ResourceKey<IRecipe<?>> resourcekey) -> this.cL.aJ().b((ResourceKey<IRecipe<?>>)resourcekey).isPresent()));
        this.getBukkitEntity().readExtraData(valueinput);
        if (this.gr()) {
            this.gs();
        }
        this.dr = valueinput.a("respawn", RespawnConfig.a).orElse(null);
        String spawnWorld = valueinput.a("SpawnWorld", "");
        CraftWorld oldWorld = (CraftWorld)Bukkit.getWorld((String)spawnWorld);
        if (oldWorld != null) {
            RespawnConfig respawnConfig = this.dr;
            WorldData.a respawnData = respawnConfig.a();
            this.dr = new RespawnConfig(WorldData.a.a(oldWorld.getHandle().aq(), respawnData.b(), respawnData.d(), respawnData.e()), respawnConfig.b());
        }
        this.dv = valueinput.a("spawn_extra_particles_on_fall", false);
        this.dx = valueinput.a("raid_omen_position", BlockPosition.a).orElse(null);
        this.h.a(this.b(EntityPlayer.a(valueinput, "playerGameType")), EntityPlayer.a(valueinput, "previousPlayerGameType"));
        this.b(valueinput.a("ShoulderEntityLeft", NBTTagCompound.a).orElseGet(NBTTagCompound::new));
        this.c(valueinput.a("ShoulderEntityRight", NBTTagCompound.a).orElseGet(NBTTagCompound::new));
    }

    @Override
    protected void a(ValueOutput valueoutput) {
        super.a(valueoutput);
        valueoutput.a("warden_spawn_tracker", WardenSpawnTracker.a, this.dw);
        this.g(valueoutput);
        valueoutput.a("seenCredits", this.i);
        valueoutput.b("entered_nether_pos", Vec3D.a, this.dn);
        this.e(valueoutput);
        valueoutput.a("recipeBook", RecipeBookServer.b.a, this.dg.b());
        valueoutput.a(f, this.A().aq().a().toString());
        valueoutput.b("respawn", RespawnConfig.a, this.dr);
        this.getBukkitEntity().setExtraData(valueoutput);
        valueoutput.a("spawn_extra_particles_on_fall", this.dv);
        valueoutput.b("raid_omen_position", BlockPosition.a, this.dx);
        this.f(valueoutput);
        if (!this.al().j()) {
            valueoutput.a("ShoulderEntityLeft", NBTTagCompound.a, this.al());
        }
        if (!this.am().j()) {
            valueoutput.a("ShoulderEntityRight", NBTTagCompound.a, this.am());
        }
    }

    private void e(ValueOutput valueoutput) {
        Entity entity = this.du();
        Entity entity1 = this.dz();
        boolean persistVehicle = true;
        if (entity1 != null) {
            for (Entity vehicle = entity1; vehicle != null; vehicle = vehicle.dz()) {
                if (vehicle.persist) continue;
                persistVehicle = false;
                break;
            }
        }
        if (persistVehicle && entity1 != null && entity != this && entity.dt()) {
            ValueOutput valueoutput1 = valueoutput.a("RootVehicle");
            valueoutput1.a("Attach", UUIDUtil.a, entity1.cY());
            entity.c(valueoutput1.a("Entity"));
        }
    }

    public void b(ValueInput valueinput) {
        Optional<ValueInput> optional = valueinput.a("RootVehicle");
        if (!optional.isEmpty()) {
            WorldServer worldserver = this.A();
            Entity entity = EntityTypes.a(optional.get().b("Entity"), (net.minecraft.world.level.World)worldserver, EntitySpawnReason.r, entity1 -> !worldserver.c(entity1) ? null : entity1);
            if (entity != null) {
                UUID uuid = optional.get().a("Attach", UUIDUtil.a).orElse(null);
                if (entity.cY().equals(uuid)) {
                    this.a(entity, true, false);
                } else {
                    for (Entity entity12 : entity.dr()) {
                        if (!entity12.cY().equals(uuid)) continue;
                        this.a(entity12, true, false);
                        break;
                    }
                }
                if (!this.cq()) {
                    cB.warn("Couldn't reattach entity to player");
                    entity.discard(null);
                    for (Entity entity2 : entity.dr()) {
                        entity2.discard(null);
                    }
                }
            }
        }
    }

    private void f(ValueOutput valueoutput) {
        if (!this.dA.isEmpty()) {
            ValueOutput.b valueoutput_b = valueoutput.b(d);
            for (EntityEnderPearl entityenderpearl : this.dA) {
                if (entityenderpearl.eh()) {
                    cB.warn("Trying to save removed ender pearl, skipping");
                    continue;
                }
                ValueOutput valueoutput1 = valueoutput_b.a();
                entityenderpearl.c(valueoutput1);
                valueoutput1.a(e, net.minecraft.world.level.World.g, entityenderpearl.ao().aq());
            }
        }
    }

    public void c(ValueInput valueinput) {
        valueinput.d(d).forEach(this::e);
    }

    private void e(ValueInput valueinput) {
        Optional<ResourceKey<net.minecraft.world.level.World>> optional = valueinput.a(e, net.minecraft.world.level.World.g);
        if (!optional.isEmpty()) {
            WorldServer worldserver = this.A().s().a(optional.get());
            if (worldserver != null) {
                Entity entity = EntityTypes.a(valueinput, (net.minecraft.world.level.World)worldserver, EntitySpawnReason.r, entity1 -> !worldserver.c(entity1) ? null : entity1);
                if (entity != null) {
                    EntityPlayer.a(worldserver, entity.dM());
                } else {
                    cB.warn("Failed to spawn player ender pearl in level ({}), skipping", optional.get());
                }
            } else {
                cB.warn("Trying to load ender pearl without level ({}) being loaded, skipping", optional.get());
            }
        }
    }

    public void spawnIn(net.minecraft.world.level.World world, boolean flag) {
        this.a(world);
        if (world == null) {
            this.ej();
            TeleportTransition teleporttransition = this.findRespawnPositionAndUseSpawnBlock(!flag, TeleportTransition.a, null);
            this.a((net.minecraft.world.level.World)teleporttransition.b());
            this.b(teleporttransition.c());
        }
        this.h.a((WorldServer)world);
    }

    public void a(int i2) {
        float f1;
        float f2 = this.gU();
        float f22 = MathHelper.a((float)i2 / f2, 0.0f, f1 = (f2 - 1.0f) / f2);
        if (f22 != this.cu) {
            this.cu = f22;
            this.cZ = -1;
        }
    }

    public void b(int i2) {
        if (i2 != this.cs) {
            this.cs = i2;
            this.cZ = -1;
        }
    }

    @Override
    public void c(int i2) {
        if (i2 != 0) {
            super.c(i2);
            this.cZ = -1;
        }
    }

    @Override
    public void a(ItemStack itemstack, int i2) {
        super.a(itemstack, i2);
        this.cZ = -1;
    }

    public void a(Container container) {
        container.a(this.dF);
        container.a(this.dE);
        container.startOpen();
    }

    public void c() {
        this.a(this.cm);
    }

    @Override
    public void g_() {
        super.g_();
        this.g.b(ClientboundPlayerCombatEnterPacket.a);
    }

    @Override
    public void P_() {
        super.P_();
        this.g.b(new ClientboundPlayerCombatEndPacket(this.fo()));
    }

    @Override
    public void a(IBlockData iblockdata) {
        CriterionTriggers.e.a(this, iblockdata);
    }

    @Override
    protected ItemCooldown f() {
        return new ItemCooldownPlayer(this);
    }

    @Override
    public void g() {
        Entity entity;
        if (this.joining) {
            this.joining = false;
        }
        this.g.r();
        this.h.a();
        this.dw.a();
        if (this.ax > 0) {
            --this.ax;
        }
        this.cn.d();
        if (!this.cn.b(this)) {
            this.r();
            this.cn = this.cm;
        }
        if ((entity = this.N()) != this) {
            if (entity.cb()) {
                this.a(entity.dP(), entity.dR(), entity.dV(), entity.ec(), entity.ee());
                this.A().p().a(this);
                if (this.gB()) {
                    this.d((Entity)this);
                }
            } else {
                this.d((Entity)this);
            }
        }
        CriterionTriggers.x.a(this);
        if (this.dh != null) {
            CriterionTriggers.v.a(this, this.dh, this.at - this.di);
        }
        this.m();
        this.n();
        this.hu();
        this.cM.a(this, true);
    }

    private void hu() {
        AttributeModifiable attributemodifiable2;
        AttributeModifiable attributemodifiable1;
        AttributeModifiable attributemodifiable = this.h(GenericAttributes.h);
        if (attributemodifiable != null) {
            if (this.ha()) {
                attributemodifiable.a(cF);
            } else {
                attributemodifiable.e(cF);
            }
        }
        if ((attributemodifiable1 = this.h(GenericAttributes.l)) != null) {
            if (this.ha()) {
                attributemodifiable1.a(cG);
            } else {
                attributemodifiable1.e(cG);
            }
        }
        if ((attributemodifiable2 = this.h(GenericAttributes.I)) != null) {
            if (this.cz()) {
                attributemodifiable2.a(cI);
            } else {
                attributemodifiable2.e(cI);
            }
        }
    }

    public void h() {
        try {
            if (!this.au() || !this.dD()) {
                super.g();
                if (!this.cn.b(this)) {
                    this.r();
                    this.cn = this.cm;
                }
                this.co.a(this);
                this.a(StatisticList.k);
                this.a(StatisticList.l);
                if (this.cb()) {
                    this.a(StatisticList.m);
                }
                if (this.cx()) {
                    this.a(StatisticList.o);
                }
                if (!this.gr()) {
                    this.a(StatisticList.n);
                }
            }
            for (int i2 = 0; i2 < this.gK().b(); ++i2) {
                ItemStack itemstack = this.gK().a(i2);
                if (itemstack.f()) continue;
                this.i(itemstack);
            }
            if (this.eZ() != this.cW || this.cX != this.co.a() || this.co.d() == 0.0f != this.cY) {
                this.g.b(new PacketPlayOutUpdateHealth(this.getBukkitEntity().getScaledHealth(), this.co.a(), this.co.d()));
                this.cW = this.eZ();
                this.cX = this.co.a();
                boolean bl = this.cY = this.co.d() == 0.0f;
            }
            if (this.eZ() + this.fX() != this.cO) {
                this.cO = this.eZ() + this.fX();
                this.a(IScoreboardCriteria.h, MathHelper.d(this.cO));
            }
            if (this.co.a() != this.cP) {
                this.cP = this.co.a();
                this.a(IScoreboardCriteria.i, MathHelper.d((float)this.cP));
            }
            if (this.cK() != this.cQ) {
                this.cQ = this.cK();
                this.a(IScoreboardCriteria.j, MathHelper.d((float)this.cQ));
            }
            if (this.fn() != this.cR) {
                this.cR = this.fn();
                this.a(IScoreboardCriteria.k, MathHelper.d((float)this.cR));
            }
            if (this.ct != this.cV) {
                this.cV = this.ct;
                this.a(IScoreboardCriteria.l, MathHelper.d((float)this.cV));
            }
            if (this.maxHealthCache != (double)this.fq()) {
                this.getBukkitEntity().updateScaledHealth();
            }
            if (this.cs != this.cU) {
                this.cU = this.cs;
                this.a(IScoreboardCriteria.m, MathHelper.d((float)this.cU));
            }
            if (this.ct != this.cZ) {
                this.cZ = this.ct;
                this.g.b(new PacketPlayOutExperience(this.cu, this.ct, this.cs));
            }
            if (this.at % 20 == 0) {
                CriterionTriggers.q.a(this);
            }
            if (this.oldLevel == -1) {
                this.oldLevel = this.cs;
            }
            if (this.oldLevel != this.cs) {
                CraftEventFactory.callPlayerLevelChangeEvent(this.getBukkitEntity(), this.oldLevel, this.cs);
                this.oldLevel = this.cs;
            }
            if (this.getBukkitEntity().hasClientWorldBorder()) {
                ((CraftWorldBorder)this.getBukkitEntity().getWorldBorder()).getHandle().t();
            }
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.a(throwable, "Ticking player");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Player being ticked");
            this.a(crashreportsystemdetails);
            throw new ReportedException(crashreport);
        }
    }

    private void i(ItemStack itemstack) {
        Packet<?> packet;
        MapId mapid = itemstack.a(DataComponents.T);
        WorldMap worldmap = ItemWorldMap.a(mapid, (net.minecraft.world.level.World)this.A());
        if (worldmap != null && (packet = worldmap.a(mapid, this)) != null) {
            this.g.b(packet);
        }
    }

    @Override
    protected void i() {
        if (this.A().av() == EnumDifficulty.a && this.A().U().a(GameRules.G).booleanValue()) {
            if (this.at % 20 == 0) {
                float f2;
                if (this.eZ() < this.fq()) {
                    this.heal(1.0f, EntityRegainHealthEvent.RegainReason.REGEN);
                }
                if ((f2 = this.co.d()) < 20.0f) {
                    this.co.b(f2 + 1.0f);
                }
            }
            if (this.at % 10 == 0 && this.co.c()) {
                this.co.a(this.co.a() + 1);
            }
        }
    }

    @Override
    public void j() {
        this.e(this.al());
        this.e(this.am());
        if (this.an > 0.5 || this.by() || this.gL().b || this.gr() || this.aJ) {
            this.k();
        }
    }

    private void e(NBTTagCompound nbttagcompound) {
        EntityTypes entitytypes;
        if (!(nbttagcompound.j() || nbttagcompound.b("Silent", false) || this.as.a(200) != 0 || (entitytypes = (EntityTypes)nbttagcompound.a("id", EntityTypes.a).orElse(null)) != EntityTypes.aW || EntityParrot.a((net.minecraft.world.level.World)this.A(), (Entity)this))) {
            this.A().a((Entity)null, this.dP(), this.dR(), this.dV(), EntityParrot.a((net.minecraft.world.level.World)this.A(), this.as), this.dB(), 1.0f, EntityParrot.a(this.as));
        }
    }

    public boolean a(NBTTagCompound nbttagcompound) {
        if (!this.cq() && this.aV() && !this.by() && !this.aJ) {
            if (this.al().j()) {
                this.b(nbttagcompound);
                this.dB = this.A().au();
                return true;
            }
            if (this.am().j()) {
                this.c(nbttagcompound);
                this.dB = this.A().au();
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    protected void k() {
        if (this.dB + 20L < this.A().au()) {
            if (this.respawnEntityOnShoulder(this.al())) {
                this.b(new NBTTagCompound());
            }
            if (this.respawnEntityOnShoulder(this.am())) {
                this.c(new NBTTagCompound());
            }
        }
    }

    public Entity getEntityOnShoulder(NBTTagCompound nbttagcompound) {
        WorldServer worldserver = this.A();
        if (worldserver instanceof WorldServer) {
            WorldServer worldserver1 = worldserver;
            if (!nbttagcompound.j()) {
                try (ProblemReporter.j problemreporter_j = new ProblemReporter.j(this.es(), cB);){
                    Entity entity2 = EntityTypes.a(TagValueInput.a(problemreporter_j.a(() -> ".shoulder"), (HolderLookup.a)worldserver1.J_(), nbttagcompound), (net.minecraft.world.level.World)worldserver1, EntitySpawnReason.r).map(entity -> {
                        if (entity instanceof EntityTameableAnimal) {
                            EntityTameableAnimal entitytameableanimal = (EntityTameableAnimal)entity;
                            entitytameableanimal.i(this);
                        }
                        entity.a_(this.dP(), this.dR() + (double)0.7f, this.dV());
                        return entity;
                    }).orElse(null);
                    return entity2;
                }
            }
        }
        return null;
    }

    private boolean respawnEntityOnShoulder(NBTTagCompound nbttagcompound) {
        Entity entity = this.getEntityOnShoulder(nbttagcompound);
        if (entity != null) {
            return this.A().addWithUUID(entity, CreatureSpawnEvent.SpawnReason.SHOULDER_ENTITY);
        }
        return true;
    }

    @Override
    public void l() {
        if (this.eZ() > 0.0f && this.dm != null) {
            CriterionTriggers.Z.a(this, this.dm);
        }
        this.dm = null;
        super.l();
    }

    public void m() {
        if (this.an > 0.0 && this.dm == null) {
            this.dm = this.dI();
            if (this.cz != null && this.cz.h <= this.dm.h) {
                CriterionTriggers.ag.a(this, this.cz, this.cA);
            }
        }
    }

    public void n() {
        if (this.dz() != null && this.dz().bN()) {
            if (this.do == null) {
                this.do = this.dI();
            } else {
                CriterionTriggers.aa.a(this, this.do);
            }
        }
        if (!(this.do == null || this.dz() != null && this.dz().bN())) {
            this.do = null;
        }
    }

    private void a(IScoreboardCriteria iscoreboardcriteria, int i2) {
        this.A().getCraftServer().getScoreboardManager().forAllObjectives(iscoreboardcriteria, this, scoreaccess -> scoreaccess.a(i2));
    }

    @Override
    public void a(DamageSource damagesource) {
        String deathMessage;
        boolean keepInventory;
        this.c(GameEvent.p);
        boolean flag = this.A().U().a(GameRules.T);
        if (this.eh()) {
            return;
        }
        ArrayList<org.bukkit.inventory.ItemStack> loot = new ArrayList<org.bukkit.inventory.ItemStack>(this.gK().b());
        boolean bl = keepInventory = this.A().U().a(GameRules.s) != false || this.au();
        if (!keepInventory) {
            for (ItemStack item : this.gK()) {
                if (item.f() || EnchantmentManager.a(item, EnchantmentEffectComponents.E)) continue;
                loot.add(CraftItemStack.asCraftMirror(item).markForInventoryDrop());
            }
        }
        this.b(this.A(), damagesource, this.bI > 0);
        this.a(this.A(), damagesource, flag);
        loot.addAll(this.drops);
        this.drops.clear();
        IChatBaseComponent defaultMessage = this.fo().a();
        String deathmessage = defaultMessage.getString();
        this.keepLevel = keepInventory;
        PlayerDeathEvent event = CraftEventFactory.callPlayerDeathEvent(this, damagesource, loot, deathmessage, keepInventory);
        if (this.cn != this.cm) {
            this.r();
        }
        if ((deathMessage = event.getDeathMessage()) != null && deathMessage.length() > 0 && flag) {
            IChatBaseComponent ichatbasecomponent = deathMessage.equals(deathmessage) ? this.fo().a() : CraftChatMessage.fromStringOrNull(deathMessage);
            this.g.a(new ClientboundPlayerCombatKillPacket(this.aA(), ichatbasecomponent), PacketSendListener.a(() -> {
                int i2 = 256;
                String s2 = ichatbasecomponent.a(256);
                IChatMutableComponent ichatbasecomponent1 = IChatBaseComponent.a("death.attack.message_too_long", IChatBaseComponent.b(s2).a(EnumChatFormat.o));
                IChatMutableComponent ichatbasecomponent2 = IChatBaseComponent.a("death.attack.even_more_magic", this.R_()).a(chatmodifier -> chatmodifier.a(new ChatHoverable.e(ichatbasecomponent1)));
                return new ClientboundPlayerCombatKillPacket(this.aA(), ichatbasecomponent2);
            }));
            ScoreboardTeam scoreboardteambase = this.cI();
            if (scoreboardteambase != null && ((ScoreboardTeamBase)scoreboardteambase).l() != ScoreboardTeamBase.EnumNameTagVisibility.a) {
                if (((ScoreboardTeamBase)scoreboardteambase).l() == ScoreboardTeamBase.EnumNameTagVisibility.c) {
                    this.cL.aj().a((EntityHuman)this, ichatbasecomponent);
                } else if (((ScoreboardTeamBase)scoreboardteambase).l() == ScoreboardTeamBase.EnumNameTagVisibility.d) {
                    this.cL.aj().b(this, ichatbasecomponent);
                }
            } else {
                this.cL.aj().a(ichatbasecomponent, false);
            }
        } else {
            this.g.b(new ClientboundPlayerCombatKillPacket(this.aA(), CommonComponents.a));
        }
        this.k();
        if (this.A().U().a(GameRules.o).booleanValue()) {
            this.hv();
        }
        this.b(this.A(), damagesource.d());
        if (!event.getKeepInventory()) {
            this.gK().a();
        }
        this.d((Entity)this);
        this.A().getCraftServer().getScoreboardManager().forAllObjectives(IScoreboardCriteria.e, this, ScoreAccess::b);
        EntityLiving entityliving = this.fp();
        if (entityliving != null) {
            this.b(StatisticList.h.b(entityliving.ay()));
            entityliving.a((Entity)this, damagesource);
            this.e(entityliving);
        }
        this.A().a((Entity)this, (byte)3);
        this.a(StatisticList.P);
        this.a(StatisticList.i.b(StatisticList.m));
        this.a(StatisticList.i.b(StatisticList.n));
        this.aT();
        this.k(0);
        this.d(false);
        this.fo().c();
        this.d(Optional.of(GlobalPos.a(this.A().aq(), this.dK())));
        this.g.s();
    }

    private void hv() {
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(this.dK()).c(32.0, 10.0, 32.0);
        this.A().a(EntityInsentient.class, axisalignedbb, IEntitySelector.f).stream().filter(entityinsentient -> entityinsentient instanceof IEntityAngerable).forEach(entityinsentient -> ((IEntityAngerable)((Object)entityinsentient)).a_(this.A(), this));
    }

    @Override
    public void a(Entity entity, DamageSource damagesource) {
        if (entity != this) {
            super.a(entity, damagesource);
            CraftScoreboardManager scoreboard = this.A().getCraftServer().getScoreboardManager();
            scoreboard.forAllObjectives(IScoreboardCriteria.g, this, ScoreAccess::b);
            if (entity instanceof EntityHuman) {
                this.a(StatisticList.S);
                scoreboard.forAllObjectives(IScoreboardCriteria.f, this, ScoreAccess::b);
            } else {
                this.a(StatisticList.Q);
            }
            this.a((ScoreHolder)this, (ScoreHolder)entity, IScoreboardCriteria.n);
            this.a((ScoreHolder)entity, (ScoreHolder)this, IScoreboardCriteria.o);
            CriterionTriggers.c.a(this, entity, damagesource);
        }
    }

    private void a(ScoreHolder scoreholder, ScoreHolder scoreholder1, IScoreboardCriteria[] aiscoreboardcriteria) {
        int i2;
        ScoreboardServer scoreboard = this.A().i();
        ScoreboardTeam scoreboardteam = scoreboard.e(scoreholder1.da());
        if (scoreboardteam != null && (i2 = scoreboardteam.o().b()) >= 0 && i2 < aiscoreboardcriteria.length) {
            this.A().getCraftServer().getScoreboardManager().forAllObjectives(aiscoreboardcriteria[i2], scoreholder, ScoreAccess::b);
        }
    }

    @Override
    public boolean a(WorldServer worldserver, DamageSource damagesource, float f2) {
        EntityHuman entityhuman1;
        EntityArrow entityarrow;
        Entity entity1;
        EntityHuman entityhuman;
        if (this.a(worldserver, damagesource)) {
            return false;
        }
        Entity entity = damagesource.d();
        if (entity instanceof EntityHuman && !this.a(entityhuman = (EntityHuman)entity)) {
            return false;
        }
        if (entity instanceof EntityArrow && (entity1 = (entityarrow = (EntityArrow)entity).p()) instanceof EntityHuman && !this.a(entityhuman1 = (EntityHuman)entity1)) {
            return false;
        }
        return super.a(worldserver, damagesource, f2);
    }

    @Override
    public boolean a(EntityHuman entityhuman) {
        return !this.hw() ? false : super.a(entityhuman);
    }

    private boolean hw() {
        return this.A().X();
    }

    public TeleportTransition findRespawnPositionAndUseSpawnBlock(boolean flag, TeleportTransition.a teleporttransition_a, PlayerRespawnEvent.RespawnReason reason) {
        TeleportTransition teleportTransition;
        boolean isBedSpawn = false;
        boolean isAnchorSpawn = false;
        RespawnConfig entityplayer_respawnconfig = this.V();
        WorldServer worldserver = this.cL.a(RespawnConfig.b(entityplayer_respawnconfig));
        if (worldserver != null && entityplayer_respawnconfig != null) {
            Optional<RespawnPosAngle> optional = EntityPlayer.a(worldserver, entityplayer_respawnconfig, flag);
            if (optional.isPresent()) {
                RespawnPosAngle entityplayer_respawnposangle = optional.get();
                isBedSpawn = entityplayer_respawnposangle.isBedSpawn();
                isAnchorSpawn = entityplayer_respawnposangle.isAnchorSpawn();
                teleportTransition = new TeleportTransition(worldserver, entityplayer_respawnposangle.a(), Vec3D.c, entityplayer_respawnposangle.b(), entityplayer_respawnposangle.c(), teleporttransition_a);
            } else {
                teleportTransition = TeleportTransition.b(this, teleporttransition_a);
            }
        } else {
            teleportTransition = TeleportTransition.a(this, teleporttransition_a);
        }
        if (reason == null) {
            return teleportTransition;
        }
        CraftPlayer respawnPlayer = this.getBukkitEntity();
        Location location = CraftLocation.toBukkit(teleportTransition.c(), (World)teleportTransition.b().getWorld(), teleportTransition.e(), teleportTransition.f());
        PlayerRespawnEvent respawnEvent = new PlayerRespawnEvent((Player)respawnPlayer, location, isBedSpawn, isAnchorSpawn, reason);
        this.A().getCraftServer().getPluginManager().callEvent((Event)respawnEvent);
        if (this.g.isDisconnected()) {
            return null;
        }
        location = respawnEvent.getRespawnLocation();
        return new TeleportTransition(((CraftWorld)location.getWorld()).getHandle(), CraftLocation.toVec3D(location), teleportTransition.d(), location.getYaw(), location.getPitch(), teleportTransition.g(), teleportTransition.h(), teleportTransition.i(), teleportTransition.j(), teleportTransition.cause());
    }

    public boolean o() {
        return this.i(GenericAttributes.J) > 0.0;
    }

    @Override
    protected void a(Holder<AttributeBase> holder) {
        if (holder.a(GenericAttributes.J)) {
            ServerWaypointManager serverwaypointmanager = this.A().j();
            if (this.fw().c(holder) > 0.0) {
                serverwaypointmanager.a(this);
            } else {
                serverwaypointmanager.c(this);
            }
        }
        super.a(holder);
    }

    public static Optional<RespawnPosAngle> a(WorldServer worldserver, RespawnConfig entityplayer_respawnconfig, boolean flag) {
        WorldData.a worlddata_a = entityplayer_respawnconfig.b;
        BlockPosition blockposition = worlddata_a.b();
        float f2 = worlddata_a.d();
        float f1 = worlddata_a.e();
        boolean flag1 = entityplayer_respawnconfig.c;
        IBlockData iblockdata = worldserver.a_(blockposition);
        Block block = iblockdata.b();
        if (block instanceof BlockRespawnAnchor && (flag1 || iblockdata.c(BlockRespawnAnchor.d) > 0) && BlockRespawnAnchor.a(worldserver, blockposition)) {
            Optional<Vec3D> optional = BlockRespawnAnchor.a(EntityTypes.cb, worldserver, blockposition);
            if (!flag1 && flag && optional.isPresent()) {
                worldserver.a(blockposition, (IBlockData)iblockdata.b(BlockRespawnAnchor.d, iblockdata.c(BlockRespawnAnchor.d) - 1), 3);
            }
            return optional.map(vec3d -> RespawnPosAngle.of(vec3d, blockposition, 0.0f, false, true));
        }
        if (block instanceof BlockBed && worldserver.c().a(EnvironmentAttributes.C, blockposition).b(worldserver)) {
            return BlockBed.a(EntityTypes.cb, (ICollisionAccess)worldserver, blockposition, (EnumDirection)iblockdata.c(BlockBed.f), f2).map(vec3d -> RespawnPosAngle.of(vec3d, blockposition, 0.0f, true, false));
        }
        if (!flag1) {
            return Optional.empty();
        }
        boolean flag2 = block.a(iblockdata);
        IBlockData iblockdata1 = worldserver.a_(blockposition.d());
        boolean flag3 = iblockdata1.b().a(iblockdata1);
        return flag2 && flag3 ? Optional.of(new RespawnPosAngle(new Vec3D((double)blockposition.u() + 0.5, (double)blockposition.v() + 0.1, (double)blockposition.w() + 0.5), f2, f1, false, false)) : Optional.empty();
    }

    public void p() {
        this.aw();
        this.A().a(this, Entity.RemovalReason.e);
        if (!this.k) {
            this.k = true;
            this.g.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.f, 0.0f));
            this.i = true;
        }
    }

    public @Nullable EntityPlayer a(TeleportTransition teleporttransition) {
        if (this.gr()) {
            return null;
        }
        if (this.eh()) {
            return null;
        }
        if (teleporttransition.g()) {
            this.g.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.b, 0.0f));
        }
        WorldServer worldserver = teleporttransition.b();
        WorldServer worldserver1 = this.A();
        ResourceKey<WorldDimension> resourcekey = worldserver1.getTypeKey();
        Location enter = this.getBukkitEntity().getLocation();
        PositionMoveRotation absolutePosition = PositionMoveRotation.a(PositionMoveRotation.a(this), PositionMoveRotation.a(teleporttransition), teleporttransition.i());
        Location exit = worldserver == null ? null : CraftLocation.toBukkit(absolutePosition.a(), (World)worldserver.getWorld(), absolutePosition.c(), absolutePosition.d());
        PlayerTeleportEvent tpEvent = new PlayerTeleportEvent((Player)this.getBukkitEntity(), enter, exit, teleporttransition.cause());
        Bukkit.getServer().getPluginManager().callEvent((Event)tpEvent);
        Location newExit = tpEvent.getTo();
        if (tpEvent.isCancelled() || newExit == null) {
            return null;
        }
        if (!newExit.equals((Object)exit)) {
            worldserver = ((CraftWorld)newExit.getWorld()).getHandle();
            teleporttransition = new TeleportTransition(worldserver, CraftLocation.toVec3D(newExit), Vec3D.c, newExit.getYaw(), newExit.getPitch(), teleporttransition.g(), teleporttransition.h(), Set.of(), teleporttransition.j(), teleporttransition.cause());
        }
        if (!teleporttransition.h()) {
            this.ad();
        }
        if (worldserver != null && worldserver.aq() == worldserver1.aq()) {
            this.g.internalTeleport(PositionMoveRotation.a(teleporttransition), teleporttransition.i());
            this.g.m();
            teleporttransition.j().onTransition(this);
            return this;
        }
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("moving");
        if (worldserver != null && resourcekey == WorldDimension.b && worldserver.getTypeKey() == WorldDimension.c) {
            this.dn = this.dI();
        }
        gameprofilerfiller.c();
        gameprofilerfiller.a("placing");
        this.df = true;
        WorldData worlddata = worldserver.D_();
        this.g.b(new PacketPlayOutRespawn(this.b(worldserver), 3));
        this.g.b(new PacketPlayOutServerDifficulty(worlddata.p(), worlddata.q()));
        PlayerList playerlist = this.cL.aj();
        playerlist.d(this);
        worldserver1.a(this, Entity.RemovalReason.e);
        this.ej();
        this.a(worldserver);
        this.g.internalTeleport(PositionMoveRotation.a(teleporttransition), teleporttransition.i());
        this.g.m();
        worldserver.d(this);
        gameprofilerfiller.c();
        this.h(worldserver1);
        this.gf();
        this.g.b(new PacketPlayOutAbilities(this.gL()));
        playerlist.a(this, worldserver);
        playerlist.e(this);
        playerlist.c(this);
        teleporttransition.j().onTransition(this);
        this.cZ = -1;
        this.cW = -1.0f;
        this.cX = -1;
        PlayerChangedWorldEvent changeEvent = new PlayerChangedWorldEvent((Player)this.getBukkitEntity(), (World)worldserver1.getWorld());
        this.A().getCraftServer().getPluginManager().callEvent((Event)changeEvent);
        this.a(teleporttransition, worldserver1);
        return this;
    }

    @Override
    public CraftPortalEvent callPortalEvent(Entity entity, Location exit, PlayerTeleportEvent.TeleportCause cause, int searchRadius, int creationRadius) {
        Location enter = this.getBukkitEntity().getLocation();
        PlayerPortalEvent event = new PlayerPortalEvent((Player)this.getBukkitEntity(), enter, exit, cause, searchRadius, true, creationRadius);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled() || event.getTo() == null || event.getTo().getWorld() == null) {
            return null;
        }
        return new CraftPortalEvent(event);
    }

    @Override
    public void a(float f2, boolean flag, float f1, boolean flag1) {
        super.a(f2, flag, f1, flag1);
        this.g.b(new ClientboundPlayerRotationPacket(f2, flag, f1, flag1));
    }

    public void h(WorldServer worldserver) {
        ResourceKey<net.minecraft.world.level.World> resourcekey = worldserver.aq();
        ResourceKey<net.minecraft.world.level.World> resourcekey1 = this.A().aq();
        ResourceKey<net.minecraft.world.level.World> maindimensionkey = CraftDimensionUtil.getMainDimensionKey(worldserver);
        ResourceKey<net.minecraft.world.level.World> maindimensionkey1 = CraftDimensionUtil.getMainDimensionKey(this.A());
        CriterionTriggers.w.a(this, maindimensionkey, maindimensionkey1);
        if (maindimensionkey != resourcekey || maindimensionkey1 != resourcekey1) {
            CriterionTriggers.w.a(this, resourcekey, resourcekey1);
        }
        if (maindimensionkey == net.minecraft.world.level.World.i && maindimensionkey1 == net.minecraft.world.level.World.h && this.dn != null) {
            CriterionTriggers.D.a(this, this.dn);
        }
        if (maindimensionkey1 != net.minecraft.world.level.World.i) {
            this.dn = null;
        }
    }

    @Override
    public boolean a(EntityPlayer entityplayer) {
        return entityplayer.au() ? this.N() == this : (this.au() ? false : super.a(entityplayer));
    }

    @Override
    public void a(Entity entity, int i2) {
        super.a(entity, i2);
        this.cn.d();
    }

    private Either<EntityHuman.EnumBedResult, Unit> getBedResult(BlockPosition blockposition, EnumDirection enumdirection) {
        if (!this.gr() && this.cb()) {
            BedRule bedrule = this.A().c().a(EnvironmentAttributes.C, blockposition);
            boolean flag = bedrule.a(this.A());
            boolean flag1 = bedrule.b(this.A());
            if (!flag1 && !flag) {
                return Either.left((Object)bedrule.a());
            }
            if (!this.a(blockposition, enumdirection)) {
                return Either.left((Object)EntityHuman.EnumBedResult.a);
            }
            if (this.b(blockposition, enumdirection)) {
                return Either.left((Object)EntityHuman.EnumBedResult.b);
            }
            if (flag1) {
                this.setRespawnPosition(new RespawnConfig(WorldData.a.a(this.A().aq(), blockposition, this.ec(), this.ee()), false), true, PlayerSpawnChangeEvent.Cause.BED);
            }
            if (!flag) {
                return Either.left((Object)bedrule.a());
            }
            if (!this.ha()) {
                double d0 = 8.0;
                double d1 = 5.0;
                Vec3D vec3d = Vec3D.c(blockposition);
                List<EntityMonster> list = this.A().a(EntityMonster.class, new AxisAlignedBB(vec3d.a() - 8.0, vec3d.b() - 5.0, vec3d.c() - 8.0, vec3d.a() + 8.0, vec3d.b() + 5.0, vec3d.c() + 8.0), (? super T entitymonster) -> entitymonster.a(this.A(), this));
                if (!list.isEmpty()) {
                    return Either.left((Object)EntityHuman.EnumBedResult.d);
                }
            }
            return Either.right((Object)((Object)Unit.a));
        }
        return Either.left((Object)EntityHuman.EnumBedResult.c);
    }

    @Override
    public Either<EntityHuman.EnumBedResult, Unit> startSleepInBed(BlockPosition blockposition, boolean force) {
        EnumDirection enumdirection = this.A().a_(blockposition).c(BlockFacingHorizontal.f);
        Either<EntityHuman.EnumBedResult, Unit> bedResult = this.getBedResult(blockposition, enumdirection);
        if (bedResult.left().orElse(null) == EntityHuman.EnumBedResult.c) {
            return bedResult;
        }
        if (force) {
            bedResult = Either.right((Object)((Object)Unit.a));
        }
        if ((bedResult = CraftEventFactory.callPlayerBedEnterEvent(this, blockposition, bedResult)).left().isPresent()) {
            return bedResult;
        }
        Either either = super.startSleepInBed(blockposition, force).ifRight(unit -> {
            this.a(StatisticList.ar);
            CriterionTriggers.r.a(this);
        });
        if (!this.A().g()) {
            this.a(IChatBaseComponent.c("sleep.not_possible"), true);
        }
        this.A().h();
        return either;
    }

    @Override
    public void b(BlockPosition blockposition) {
        this.a(StatisticList.i.b(StatisticList.n));
        super.b(blockposition);
    }

    private boolean a(BlockPosition blockposition, EnumDirection enumdirection) {
        return this.i(blockposition) || this.i(blockposition.a(enumdirection.g()));
    }

    private boolean i(BlockPosition blockposition) {
        Vec3D vec3d = Vec3D.c(blockposition);
        return Math.abs(this.dP() - vec3d.a()) <= 3.0 && Math.abs(this.dR() - vec3d.b()) <= 2.0 && Math.abs(this.dV() - vec3d.c()) <= 3.0;
    }

    private boolean b(BlockPosition blockposition, EnumDirection enumdirection) {
        BlockPosition blockposition1 = blockposition.d();
        return !this.h(blockposition1) || !this.h(blockposition1.a(enumdirection.g()));
    }

    @Override
    public void a(boolean flag, boolean flag1) {
        if (!this.gr()) {
            return;
        }
        CraftPlayer player = this.getBukkitEntity();
        BlockPosition bedPosition = this.gp().orElse(null);
        org.bukkit.block.Block bed = bedPosition != null ? this.A().getWorld().getBlockAt(bedPosition.u(), bedPosition.v(), bedPosition.w()) : this.A().getWorld().getBlockAt(player.getLocation());
        PlayerBedLeaveEvent event = new PlayerBedLeaveEvent((Player)player, bed, true);
        this.A().getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        if (this.gr()) {
            this.A().p().a(this, new PacketPlayOutAnimation(this, 2));
        }
        super.a(flag, flag1);
        if (this.g != null) {
            this.g.teleport(this.dP(), this.dR(), this.dV(), this.ec(), this.ee(), PlayerTeleportEvent.TeleportCause.EXIT_BED);
        }
    }

    @Override
    public boolean a(WorldServer worldserver, DamageSource damagesource) {
        return super.a(worldserver, damagesource) || this.S() && !damagesource.a(DamageTypes.m) || !this.g.q();
    }

    @Override
    protected void b(WorldServer worldserver, BlockPosition blockposition) {
        if (!this.au()) {
            super.b(worldserver, blockposition);
        }
    }

    @Override
    protected void a(double d0, boolean flag, IBlockData iblockdata, BlockPosition blockposition) {
        if (this.dv && flag && this.an > 0.0) {
            Vec3D vec3d = blockposition.b().b(0.0, 0.5, 0.0);
            int i2 = (int)MathHelper.a(50.0 * this.an, 0.0, 200.0);
            this.A().a(new ParticleParamBlock(Particles.b, iblockdata), vec3d.g, vec3d.h, vec3d.i, i2, (double)0.3f, (double)0.3f, (double)0.3f, (double)0.15f);
            this.dv = false;
        }
        super.a(d0, flag, iblockdata, blockposition);
    }

    @Override
    public void a(@Nullable Entity entity) {
        super.a(entity);
        this.cz = this.dI();
        this.cA = entity;
        this.w(entity != null && entity.ay() == EntityTypes.bP);
    }

    @Override
    protected void q() {
        if (this.A().y().i()) {
            super.q();
        }
    }

    @Override
    public void a(TileEntitySign tileentitysign, boolean flag) {
        this.g.b(new PacketPlayOutBlockChange(this.A(), tileentitysign.aD_()));
        this.g.b(new PacketPlayOutOpenSignEditor(tileentitysign.aD_(), flag));
    }

    @Override
    public void b(Holder<Dialog> holder) {
        this.g.b(new ClientboundShowDialogPacket(holder));
    }

    public int nextContainerCounter() {
        this.dJ = this.dJ % 100 + 1;
        return this.dJ;
    }

    @Override
    public OptionalInt a(@Nullable ITileInventory itileinventory) {
        if (itileinventory == null) {
            return OptionalInt.empty();
        }
        this.nextContainerCounter();
        Container container = itileinventory.createMenu(this.dJ, this.gK(), this);
        if (container != null) {
            container.setTitle(itileinventory.R_());
            boolean cancelled = false;
            container = CraftEventFactory.callInventoryOpenEvent(this, container, cancelled);
            if (container == null && !cancelled) {
                if (itileinventory instanceof IInventory) {
                    ((IInventory)((Object)itileinventory)).b(this);
                } else if (itileinventory instanceof BlockChest.DoubleInventory) {
                    ((BlockChest.DoubleInventory)itileinventory).inventorylargechest.b(this);
                }
                return OptionalInt.empty();
            }
        }
        if (container == null) {
            if (this.au()) {
                this.a(IChatBaseComponent.c("container.spectatorCantOpen").a(EnumChatFormat.m), true);
            }
            return OptionalInt.empty();
        }
        this.cn = container;
        this.g.b(new PacketPlayOutOpenWindow(container.l, container.a(), container.getTitle()));
        this.a(container);
        return OptionalInt.of(this.dJ);
    }

    @Override
    public void a(int i2, MerchantRecipeList merchantrecipelist, int j2, int k2, boolean flag, boolean flag1) {
        this.g.b(new PacketPlayOutOpenWindowMerchant(i2, merchantrecipelist, j2, k2, flag, flag1));
    }

    @Override
    public void a(EntityHorseAbstract entityhorseabstract, IInventory iinventory) {
        this.nextContainerCounter();
        Container container = new ContainerHorse(this.dJ, this.gK(), iinventory, entityhorseabstract, entityhorseabstract.ad_());
        container.setTitle(entityhorseabstract.R_());
        container = CraftEventFactory.callInventoryOpenEvent(this, container);
        if (container == null) {
            iinventory.b(this);
            return;
        }
        if (this.cn != this.cm) {
            this.r();
        }
        int i2 = entityhorseabstract.ad_();
        this.g.b(new PacketPlayOutOpenWindowHorse(this.dJ, i2, entityhorseabstract.aA()));
        this.cn = container;
        this.a(this.cn);
    }

    @Override
    public void a(AbstractNautilus abstractnautilus, IInventory iinventory) {
        this.nextContainerCounter();
        int i2 = abstractnautilus.hk();
        Container container = new NautilusInventoryMenu(this.dJ, this.gK(), iinventory, abstractnautilus, i2);
        container.setTitle(abstractnautilus.R_());
        container = CraftEventFactory.callInventoryOpenEvent(this, container);
        if (container == null) {
            iinventory.b(this);
            return;
        }
        if (this.cn != this.cm) {
            this.r();
        }
        this.g.b(new PacketPlayOutOpenWindowHorse(this.dJ, i2, abstractnautilus.aA()));
        this.cn = container;
        this.a(this.cn);
    }

    @Override
    public void a(ItemStack itemstack, EnumHand enumhand) {
        if (itemstack.c(DataComponents.ac)) {
            if (WrittenBookContent.a(itemstack, this.C(), this)) {
                this.cn.d();
            }
            this.g.b(new PacketPlayOutOpenBook(enumhand));
        }
    }

    @Override
    public void a(TileEntityCommand tileentitycommand) {
        this.g.b(PacketPlayOutTileEntityData.a(tileentitycommand, TileEntity::d));
    }

    @Override
    public void r() {
        CraftEventFactory.handleInventoryCloseEvent(this);
        this.g.b(new PacketPlayOutCloseWindow(this.cn.l));
        this.s();
    }

    @Override
    public void s() {
        this.cn.a(this);
        this.cm.a(this.cn);
        this.cn = this.cm;
    }

    @Override
    public void t() {
        double d0 = this.dP();
        double d1 = this.dR();
        double d2 = this.dV();
        super.t();
        this.p(this.dP() - d0, this.dR() - d1, this.dV() - d2);
    }

    public void a(double d0, double d1, double d2) {
        if (!this.cq() && !EntityPlayer.q(d0, d1, d2)) {
            if (this.cB()) {
                int i2 = Math.round((float)Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2) * 100.0f);
                if (i2 > 0) {
                    this.a(StatisticList.D, i2);
                    this.causeFoodExhaustion(this.A().spigotConfig.swimMultiplier * (float)i2 * 0.01f, EntityExhaustionEvent.ExhaustionReason.SWIM);
                }
            } else if (((Entity)this).a(TagsFluid.a)) {
                int j2 = Math.round((float)Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2) * 100.0f);
                if (j2 > 0) {
                    this.a(StatisticList.w, j2);
                    this.causeFoodExhaustion(this.A().spigotConfig.swimMultiplier * (float)j2 * 0.01f, EntityExhaustionEvent.ExhaustionReason.WALK_UNDERWATER);
                }
            } else if (this.by()) {
                int k2 = Math.round((float)Math.sqrt(d0 * d0 + d2 * d2) * 100.0f);
                if (k2 > 0) {
                    this.a(StatisticList.s, k2);
                    this.causeFoodExhaustion(this.A().spigotConfig.swimMultiplier * (float)k2 * 0.01f, EntityExhaustionEvent.ExhaustionReason.WALK_ON_WATER);
                }
            } else if (this.fl()) {
                if (d1 > 0.0) {
                    this.a(StatisticList.u, (int)Math.round(d1 * 100.0));
                }
            } else if (this.aV()) {
                int l2 = Math.round((float)Math.sqrt(d0 * d0 + d2 * d2) * 100.0f);
                if (l2 > 0) {
                    if (this.cA()) {
                        this.a(StatisticList.r, l2);
                        this.causeFoodExhaustion(this.A().spigotConfig.sprintMultiplier * (float)l2 * 0.01f, EntityExhaustionEvent.ExhaustionReason.SPRINT);
                    } else if (this.cz()) {
                        this.a(StatisticList.q, l2);
                        this.causeFoodExhaustion(this.A().spigotConfig.otherMultiplier * (float)l2 * 0.01f, EntityExhaustionEvent.ExhaustionReason.CROUCH);
                    } else {
                        this.a(StatisticList.p, l2);
                        this.causeFoodExhaustion(this.A().spigotConfig.otherMultiplier * (float)l2 * 0.01f, EntityExhaustionEvent.ExhaustionReason.WALK);
                    }
                }
            } else if (this.gj()) {
                int i1 = Math.round((float)Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2) * 100.0f);
                this.a(StatisticList.C, i1);
            } else {
                int j1 = Math.round((float)Math.sqrt(d0 * d0 + d2 * d2) * 100.0f);
                if (j1 > 25) {
                    this.a(StatisticList.v, j1);
                }
            }
        }
    }

    private void p(double d0, double d1, double d2) {
        if (this.cq() && !EntityPlayer.q(d0, d1, d2)) {
            int i2 = Math.round((float)Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2) * 100.0f);
            Entity entity = this.dz();
            if (entity instanceof EntityMinecartAbstract) {
                this.a(StatisticList.x, i2);
            } else if (entity instanceof AbstractBoat) {
                this.a(StatisticList.y, i2);
            } else if (entity instanceof EntityPig) {
                this.a(StatisticList.z, i2);
            } else if (entity instanceof EntityHorseAbstract) {
                this.a(StatisticList.B, i2);
            } else if (entity instanceof EntityStrider) {
                this.a(StatisticList.E, i2);
            } else if (entity instanceof HappyGhast) {
                this.a(StatisticList.A, i2);
            } else if (entity instanceof AbstractNautilus) {
                this.a(StatisticList.F, i2);
            }
        }
    }

    private static boolean q(double d0, double d1, double d2) {
        return d0 == 0.0 && d1 == 0.0 && d2 == 0.0;
    }

    @Override
    public void a(Statistic<?> statistic, int i2) {
        this.cN.b(this, statistic, i2);
        this.A().getCraftServer().getScoreboardManager().forAllObjectives(statistic, this, scoreaccess -> scoreaccess.b(i2));
    }

    @Override
    public void a(Statistic<?> statistic) {
        this.cN.a(this, statistic, 0);
        this.A().getCraftServer().getScoreboardManager().forAllObjectives(statistic, this, ScoreAccess::c);
    }

    @Override
    public int a(Collection<RecipeHolder<?>> collection) {
        return this.dg.a(collection, this);
    }

    @Override
    public void a(RecipeHolder<?> recipeholder, List<ItemStack> list) {
        CriterionTriggers.ae.a(this, recipeholder.a(), list);
    }

    @Override
    public void b(List<ResourceKey<IRecipe<?>>> list) {
        List<RecipeHolder<?>> list1 = list.stream().flatMap(resourcekey -> this.cL.aJ().b((ResourceKey<IRecipe<?>>)resourcekey).stream()).collect(Collectors.toList());
        this.a((Collection<RecipeHolder<?>>)list1);
    }

    @Override
    public int b(Collection<RecipeHolder<?>> collection) {
        return this.dg.b(collection, this);
    }

    @Override
    public void u() {
        super.u();
        this.a(StatisticList.G);
        if (this.cA()) {
            this.causeFoodExhaustion(this.A().spigotConfig.jumpSprintExhaustion, EntityExhaustionEvent.ExhaustionReason.JUMP_SPRINT);
        } else {
            this.causeFoodExhaustion(this.A().spigotConfig.jumpWalkExhaustion, EntityExhaustionEvent.ExhaustionReason.JUMP);
        }
    }

    @Override
    public void d(int i2) {
        if (i2 != 0) {
            super.d(i2);
            this.cZ = -1;
        }
    }

    public void v() {
        this.dj = true;
        this.ce();
        if (this.gr()) {
            this.a(true, false);
        }
    }

    public boolean w() {
        return this.dj;
    }

    public void x() {
        this.cW = -1.0E8f;
        this.cZ = -1;
    }

    @Override
    public void a(IChatBaseComponent ichatbasecomponent, boolean flag) {
        this.b(ichatbasecomponent, flag);
    }

    @Override
    protected void Q_() {
        if (!this.bT.f() && this.fZ()) {
            this.g.b(new PacketPlayOutEntityStatus(this, 9));
            super.Q_();
        }
    }

    @Override
    public void a(ArgumentAnchor.Anchor argumentanchor_anchor, Vec3D vec3d) {
        super.a(argumentanchor_anchor, vec3d);
        this.g.b(new PacketPlayOutLookAt(argumentanchor_anchor, vec3d.g, vec3d.h, vec3d.i));
    }

    public void a(ArgumentAnchor.Anchor argumentanchor_anchor, Entity entity, ArgumentAnchor.Anchor argumentanchor_anchor1) {
        Vec3D vec3d = argumentanchor_anchor1.a(entity);
        super.a(argumentanchor_anchor, vec3d);
        this.g.b(new PacketPlayOutLookAt(argumentanchor_anchor, entity, argumentanchor_anchor1));
    }

    public void a(EntityPlayer entityplayer, boolean flag) {
        this.dw = entityplayer.dw;
        this.dG = entityplayer.dG;
        this.h.a(entityplayer.h.b(), entityplayer.h.c());
        this.z();
        this.fw().b(entityplayer.fw());
        if (flag) {
            this.x(entityplayer.eZ());
            this.co = entityplayer.co;
            for (MobEffect mobEffect : entityplayer.eW()) {
            }
            this.g(entityplayer);
            this.aG = entityplayer.aG;
        } else if (this.A().U().a(GameRules.s).booleanValue() || entityplayer.au()) {
            this.g(entityplayer);
        }
        this.cv = entityplayer.cv;
        this.cl = entityplayer.cl;
        this.aD().a(t, (Byte)entityplayer.aD().a(t));
        this.cZ = -1;
        this.cW = -1.0f;
        this.cX = -1;
        this.i = entityplayer.i;
        this.dn = entityplayer.dn;
        this.dq = entityplayer.dq;
        this.dI = entityplayer.dI;
        this.b(entityplayer.al());
        this.c(entityplayer.am());
        this.d(entityplayer.hk());
        this.gy().a(entityplayer.gy());
    }

    private void g(EntityHuman entityhuman) {
        this.gK().a(entityhuman.gK());
        this.cs = entityhuman.cs;
        this.ct = entityhuman.ct;
        this.cu = entityhuman.cu;
        this.q(entityhuman.gF());
    }

    @Override
    protected void a(MobEffect mobeffect, @Nullable Entity entity) {
        super.a(mobeffect, entity);
        this.g.b(new PacketPlayOutEntityEffect(this.aA(), mobeffect, true));
        if (mobeffect.a(MobEffects.y)) {
            this.di = this.at;
            this.dh = this.dI();
        }
        CriterionTriggers.B.a(this, entity);
    }

    @Override
    protected void a(MobEffect mobeffect, boolean flag, @Nullable Entity entity) {
        super.a(mobeffect, flag, entity);
        this.g.b(new PacketPlayOutEntityEffect(this.aA(), mobeffect, false));
        CriterionTriggers.B.a(this, entity);
    }

    @Override
    protected void c(Collection<MobEffect> collection) {
        super.c(collection);
        for (MobEffect mobeffect : collection) {
            this.g.b(new PacketPlayOutRemoveEntityEffect(this.aA(), mobeffect.c()));
            if (!mobeffect.a(MobEffects.y)) continue;
            this.dh = null;
        }
        CriterionTriggers.B.a(this, (Entity)null);
    }

    @Override
    public void b(double d0, double d1, double d2) {
        this.g.a(new PositionMoveRotation(new Vec3D(d0, d1, d2), Vec3D.c, 0.0f, 0.0f), Relative.a(Relative.l, Relative.k));
    }

    @Override
    public void c(double d0, double d1, double d2) {
        this.g.a(new PositionMoveRotation(new Vec3D(d0, d1, d2), Vec3D.c, 0.0f, 0.0f), Relative.j);
    }

    @Override
    public boolean teleportTo(WorldServer worldserver, double d0, double d1, double d2, Set<Relative> set, float f2, float f1, boolean flag, PlayerTeleportEvent.TeleportCause cause) {
        boolean flag1;
        if (this.gr()) {
            this.a(true, true);
        }
        if (flag) {
            this.d((Entity)this);
        }
        if (flag1 = super.teleportTo(worldserver, d0, d1, d2, set, f2, f1, flag, cause)) {
            this.r(set.contains((Object)Relative.d) ? this.cS() + f2 : f2);
            this.g.l();
        }
        return flag1;
    }

    @Override
    public void d(double d0, double d1, double d2) {
        super.d(d0, d1, d2);
        this.g.m();
    }

    @Override
    public void b(Entity entity) {
        this.A().p().a(this, new PacketPlayOutAnimation(entity, 4));
    }

    @Override
    public void c(Entity entity) {
        this.A().p().a(this, new PacketPlayOutAnimation(entity, 5));
    }

    @Override
    public void z() {
        if (this.g != null) {
            this.g.b(new PacketPlayOutAbilities(this.gL()));
            this.M();
        }
    }

    public WorldServer A() {
        return (WorldServer)super.ao();
    }

    public boolean a(EnumGamemode enumgamemode) {
        boolean flag = this.au();
        if (!this.h.a(enumgamemode)) {
            return false;
        }
        this.g.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.e, enumgamemode.a()));
        if (enumgamemode == EnumGamemode.d) {
            this.k();
            this.cf();
            this.gf();
            EnchantmentManager.a(this);
        } else {
            this.d((Entity)this);
            if (flag) {
                EnchantmentManager.a(this.A(), (EntityLiving)this);
            }
        }
        this.z();
        this.fY();
        return true;
    }

    @Override
    public EnumGamemode a() {
        return this.h.b();
    }

    public ICommandListener B() {
        return this.dH;
    }

    public CommandListenerWrapper C() {
        return new CommandListenerWrapper(this.B(), this.dI(), this.cl(), this.A(), this.I(), this.aq(), this.R_(), this.cL, this);
    }

    public void a(IChatBaseComponent ichatbasecomponent) {
        this.b(ichatbasecomponent, false);
    }

    public void b(IChatBaseComponent ichatbasecomponent, boolean flag) {
        if (this.x(flag)) {
            this.g.a(new ClientboundSystemChatPacket(ichatbasecomponent, flag), PacketSendListener.a(() -> {
                if (this.x(false)) {
                    int i2 = 256;
                    String s2 = ichatbasecomponent.a(256);
                    IChatMutableComponent ichatbasecomponent1 = IChatBaseComponent.b(s2).a(EnumChatFormat.o);
                    return new ClientboundSystemChatPacket(IChatBaseComponent.a("multiplayer.message_not_delivered", ichatbasecomponent1).a(EnumChatFormat.m), false);
                }
                return null;
            }));
        }
    }

    public void a(OutgoingChatMessage outgoingchatmessage, boolean flag, ChatMessageType.a chatmessagetype_a) {
        if (this.hy()) {
            outgoingchatmessage.a(this, flag, chatmessagetype_a);
        }
    }

    public String D() {
        SocketAddress socketaddress = this.g.n();
        if (socketaddress instanceof InetSocketAddress) {
            InetSocketAddress inetsocketaddress = (InetSocketAddress)socketaddress;
            return InetAddresses.toAddrString((InetAddress)inetsocketaddress.getAddress());
        }
        return "<unknown>";
    }

    public void a(ClientInformation clientinformation) {
        PlayerChangedMainHandEvent event;
        if (this.at() != clientinformation.g()) {
            event = new PlayerChangedMainHandEvent((Player)this.getBukkitEntity(), this.at() == EnumMainHand.a ? MainHand.LEFT : MainHand.RIGHT);
            this.cL.server.getPluginManager().callEvent((Event)event);
        }
        if (!this.dl.equals(clientinformation.b())) {
            event = new PlayerLocaleChangeEvent((Player)this.getBukkitEntity(), clientinformation.b());
            this.cL.server.getPluginManager().callEvent((Event)event);
        }
        this.dl = clientinformation.b();
        this.dk = clientinformation.c();
        this.da = clientinformation.d();
        this.dc = clientinformation.e();
        this.dt = clientinformation.h();
        this.du = clientinformation.i();
        this.db = clientinformation.j();
        this.aD().a(t, (byte)clientinformation.f());
        this.aD().a(s, clientinformation.g());
    }

    public ClientInformation E() {
        byte i2 = (Byte)this.aD().a(t);
        return new ClientInformation(this.dl, this.dk, this.da, this.dc, i2, this.at(), this.dt, this.du, this.db);
    }

    public boolean F() {
        return this.dc;
    }

    public EnumChatVisibility G() {
        return this.da;
    }

    private boolean x(boolean flag) {
        return this.da == EnumChatVisibility.c ? flag : true;
    }

    private boolean hy() {
        return this.da == EnumChatVisibility.a;
    }

    public int H() {
        return this.dk;
    }

    public void a(ServerPing serverping) {
        this.g.b(new ClientboundServerDataPacket(serverping.a(), serverping.d().map(ServerPing.a::a)));
    }

    @Override
    public PermissionSet I() {
        return this.cL.b(this.gJ());
    }

    public void J() {
        this.dd = SystemUtils.c();
    }

    public ServerStatisticManager K() {
        return this.cN;
    }

    public RecipeBookServer L() {
        return this.dg;
    }

    @Override
    protected void M() {
        if (this.au()) {
            this.eU();
            this.l(true);
        } else {
            super.M();
        }
    }

    public Entity N() {
        return this.de == null ? this : this.de;
    }

    public void d(@Nullable Entity entity) {
        Entity entity1 = this.N();
        Entity entity2 = this.de = entity == null ? this : entity;
        if (entity1 != this.de) {
            WorldServer worldserver;
            boolean result;
            net.minecraft.world.level.World world = this.de.ao();
            if (world instanceof WorldServer && !(result = this.teleportTo(worldserver = (WorldServer)world, this.de.dP(), this.de.dR(), this.de.dV(), Set.of(), this.ec(), this.ee(), false, PlayerTeleportEvent.TeleportCause.SPECTATE))) {
                this.de = entity1;
                return;
            }
            if (entity != null) {
                this.A().p().a(this);
            }
            this.g.b(new PacketPlayOutCamera(this.de));
            this.g.m();
        }
    }

    @Override
    protected void O() {
        if (!this.df) {
            super.O();
        }
    }

    @Override
    public void e(Entity entity) {
        if (this.au()) {
            this.d(entity);
        } else {
            super.e(entity);
        }
    }

    public long P() {
        return this.dd;
    }

    public @Nullable IChatBaseComponent Q() {
        return this.listName;
    }

    public int R() {
        return this.listOrder;
    }

    @Override
    public void a(EnumHand enumhand) {
        super.a(enumhand);
        this.hf();
    }

    public boolean S() {
        return this.df;
    }

    public void T() {
        this.df = false;
    }

    public AdvancementDataPlayer U() {
        return this.cM;
    }

    public @Nullable RespawnConfig V() {
        return this.dr;
    }

    public void b(EntityPlayer entityplayer) {
        this.a(entityplayer.dr, false);
    }

    public void a(@Nullable RespawnConfig entityplayer_respawnconfig, boolean flag) {
        this.setRespawnPosition(entityplayer_respawnconfig, flag, PlayerSpawnChangeEvent.Cause.UNKNOWN);
    }

    public void setRespawnPosition(@Nullable RespawnConfig entityplayer_respawnconfig, boolean flag, PlayerSpawnChangeEvent.Cause cause) {
        Location newSpawn = null;
        boolean forced = false;
        if (entityplayer_respawnconfig != null) {
            WorldData.a respawnData = entityplayer_respawnconfig.a();
            WorldServer newWorld = this.cL.a(respawnData.a());
            newSpawn = CraftLocation.toBukkit(respawnData.b(), (World)newWorld.getWorld(), respawnData.d(), respawnData.e());
            forced = entityplayer_respawnconfig.b();
        }
        PlayerSpawnChangeEvent event = new PlayerSpawnChangeEvent((Player)this.getBukkitEntity(), newSpawn, forced, cause);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        newSpawn = event.getNewSpawn();
        entityplayer_respawnconfig = newSpawn != null ? new RespawnConfig(WorldData.a.a(((CraftWorld)newSpawn.getWorld()).getHandle().aq(), BlockPosition.a(newSpawn.getX(), newSpawn.getY(), newSpawn.getZ()), newSpawn.getYaw(), newSpawn.getPitch()), event.isForced()) : null;
        if (flag && entityplayer_respawnconfig != null && !entityplayer_respawnconfig.a(this.dr)) {
            this.a(cH);
        }
        this.dr = entityplayer_respawnconfig;
    }

    public SectionPosition W() {
        return this.dp;
    }

    public void a(SectionPosition sectionposition) {
        this.dp = sectionposition;
    }

    public ChunkTrackingView X() {
        return this.dq;
    }

    public void a(ChunkTrackingView chunktrackingview) {
        this.dq = chunktrackingview;
    }

    @Override
    public EntityItem drop(ItemStack itemstack, boolean flag, boolean flag1, boolean callEvent) {
        EntityItem entityitem = super.drop(itemstack, flag, flag1, callEvent);
        if (flag1) {
            ItemStack itemstack1;
            ItemStack itemStack = itemstack1 = entityitem != null ? entityitem.e() : ItemStack.l;
            if (!itemstack1.f()) {
                this.a(StatisticList.f.b(itemstack1.h()), itemstack.N());
                this.a(StatisticList.H);
            }
        }
        return entityitem;
    }

    public ITextFilter Y() {
        return this.ds;
    }

    public void a(WorldServer worldserver) {
        this.a((net.minecraft.world.level.World)worldserver);
        this.h.a(worldserver);
    }

    private static @Nullable EnumGamemode a(ValueInput valueinput, String s2) {
        return valueinput.a(s2, EnumGamemode.h).orElse(null);
    }

    private EnumGamemode b(@Nullable EnumGamemode enumgamemode) {
        EnumGamemode enumgamemode1 = this.cL.bf();
        return enumgamemode1 != null ? enumgamemode1 : (enumgamemode != null ? enumgamemode : this.cL.w());
    }

    private void g(ValueOutput valueoutput) {
        valueoutput.a("playerGameType", EnumGamemode.h, this.h.b());
        EnumGamemode enumgamemode = this.h.c();
        valueoutput.b("previousPlayerGameType", EnumGamemode.h, enumgamemode);
    }

    @Override
    public boolean Z() {
        return this.dt;
    }

    public boolean c(EntityPlayer entityplayer) {
        return entityplayer == this ? false : this.dt || entityplayer.dt;
    }

    @Override
    public boolean c(WorldServer worldserver, BlockPosition blockposition) {
        return super.c(worldserver, blockposition) && worldserver.a((Entity)this, blockposition);
    }

    @Override
    protected void a_(ItemStack itemstack) {
        CriterionTriggers.Y.a(this, itemstack);
        super.a_(itemstack);
    }

    public void a(boolean flag) {
        this.dropItem(flag);
    }

    public EntityItem dropItem(boolean flag) {
        PlayerInventory playerinventory = this.gK();
        ItemStack itemstack = playerinventory.a(flag);
        this.cn.b(playerinventory, playerinventory.g()).ifPresent(i2 -> this.cn.a(i2, playerinventory.h()));
        if (this.bT.f()) {
            this.gf();
        }
        return this.a(itemstack, false, true);
    }

    @Override
    public void b(ItemStack itemstack) {
        if (!this.gK().g(itemstack)) {
            this.a(itemstack, false);
        }
    }

    public boolean aa() {
        return this.du;
    }

    @Override
    public Optional<WardenSpawnTracker> ab() {
        return Optional.of(this.dw);
    }

    public void b(boolean flag) {
        this.dv = flag;
    }

    @Override
    public void a(EntityItem entityitem) {
        super.a(entityitem);
        Entity entity = entityitem.p();
        if (entity != null) {
            CriterionTriggers.T.a(this, entityitem.e(), entity);
        }
    }

    public void a(RemoteChatSession remotechatsession) {
        this.dG = remotechatsession;
    }

    public @Nullable RemoteChatSession ac() {
        return this.dG != null && this.dG.b() ? null : this.dG;
    }

    @Override
    public void a(double d0, double d1) {
        this.cy = (float)(MathHelper.d(d1, d0) * 57.2957763671875 - (double)this.ec());
        this.g.b(new ClientboundHurtAnimationPacket(this));
    }

    @Override
    public boolean a(Entity entity, boolean flag, boolean flag1) {
        if (super.a(entity, flag, flag1)) {
            entity.k(this);
            this.g.a(new PositionMoveRotation(this.dI(), Vec3D.c, 0.0f, 0.0f), Relative.k);
            if (entity instanceof EntityLiving) {
                EntityLiving entityliving = (EntityLiving)entity;
                this.cL.aj().a(entityliving, this.g);
            }
            this.g.b(new PacketPlayOutMount(entity));
            return true;
        }
        return false;
    }

    @Override
    public void ad() {
        Entity entity = this.dz();
        super.ad();
        if (entity instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)entity;
            for (MobEffect mobeffect : entityliving.eW()) {
                this.g.b(new PacketPlayOutRemoveEntityEffect(entity.aA(), mobeffect.c()));
            }
        }
        if (entity != null) {
            this.g.b(new PacketPlayOutMount(entity));
        }
    }

    public CommonPlayerSpawnInfo b(WorldServer worldserver) {
        return new CommonPlayerSpawnInfo(worldserver.ap(), worldserver.aq(), BiomeManager.a(worldserver.J()), this.h.b(), this.h.c(), worldserver.ar(), worldserver.I(), this.hk(), this.aN(), worldserver.V());
    }

    public void c(BlockPosition blockposition) {
        this.dx = blockposition;
    }

    public void ae() {
        this.dx = null;
    }

    public @Nullable BlockPosition af() {
        return this.dx;
    }

    @Override
    public Vec3D ag() {
        Entity entity = this.dz();
        return entity != null && entity.dl() != this ? entity.ag() : this.dy;
    }

    @Override
    public Vec3D ah() {
        Entity entity = this.dz();
        return entity != null && entity.dl() != this ? entity.ah() : this.dy;
    }

    public void a(Vec3D vec3d) {
        this.dy = vec3d;
    }

    @Override
    protected float a(Entity entity, float f2, DamageSource damagesource) {
        return EnchantmentManager.a(this.A(), this.eq(), entity, damagesource, f2);
    }

    @Override
    public void a(Item item, EnumItemSlot enumitemslot) {
        super.a(item, enumitemslot);
        this.b(StatisticList.d.b(item));
    }

    public Input ai() {
        return this.dz;
    }

    public void a(Input input) {
        this.dz = input;
    }

    public Vec3D aj() {
        float f2;
        float f3 = this.dz.c() == this.dz.d() ? 0.0f : (f2 = this.dz.c() ? 1.0f : -1.0f);
        float f1 = this.dz.a() == this.dz.b() ? 0.0f : (this.dz.a() ? 1.0f : -1.0f);
        return EntityPlayer.a(new Vec3D(f2, 0.0, f1), 1.0f, this.ec());
    }

    public void a(EntityEnderPearl entityenderpearl) {
        this.dA.add(entityenderpearl);
    }

    public void b(EntityEnderPearl entityenderpearl) {
        this.dA.remove(entityenderpearl);
    }

    public Set<EntityEnderPearl> ak() {
        return this.dA;
    }

    public NBTTagCompound al() {
        return this.dC;
    }

    public void b(NBTTagCompound nbttagcompound) {
        this.dC = nbttagcompound;
        this.b(EntityPlayer.d(nbttagcompound));
    }

    public NBTTagCompound am() {
        return this.dD;
    }

    public void c(NBTTagCompound nbttagcompound) {
        this.dD = nbttagcompound;
        this.c(EntityPlayer.d(nbttagcompound));
    }

    public long c(EntityEnderPearl entityenderpearl) {
        net.minecraft.world.level.World world = entityenderpearl.ao();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            ChunkCoordIntPair chunkcoordintpair = entityenderpearl.dM();
            this.a(entityenderpearl);
            worldserver.l();
            return EntityPlayer.a(worldserver, chunkcoordintpair) - 1L;
        }
        return 0L;
    }

    public static long a(WorldServer worldserver, ChunkCoordIntPair chunkcoordintpair) {
        worldserver.p().b(TicketType.n, chunkcoordintpair, 2);
        return TicketType.n.g();
    }

    public void a(Set<DebugSubscription<?>> set) {
        this.dI = Set.copyOf(set);
    }

    public Set<DebugSubscription<?>> an() {
        return !this.cL.bw().a(this) ? Set.of() : this.dI;
    }

    public long getPlayerTime() {
        if (this.relativeTime) {
            return this.A().al() + this.timeOffset;
        }
        return this.A().al() - this.A().al() % 24000L + this.timeOffset;
    }

    public WeatherType getPlayerWeather() {
        return this.weather;
    }

    public void setPlayerWeather(WeatherType type, boolean plugin) {
        if (!plugin && this.weather != null) {
            return;
        }
        if (plugin) {
            this.weather = type;
        }
        if (type == WeatherType.DOWNFALL) {
            this.g.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.d, 0.0f));
        } else {
            this.g.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.c, 0.0f));
        }
    }

    public void updateWeather(float oldRain, float newRain, float oldThunder, float newThunder) {
        if (this.weather == null) {
            if (oldRain != newRain) {
                this.g.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.i, newRain));
            }
        } else if (this.pluginRainPositionPrevious != this.pluginRainPosition) {
            this.g.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.i, this.pluginRainPosition));
        }
        if (oldThunder != newThunder) {
            if (this.weather == WeatherType.DOWNFALL || this.weather == null) {
                this.g.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.j, newThunder));
            } else {
                this.g.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.j, 0.0f));
            }
        }
    }

    public void tickWeather() {
        if (this.weather == null) {
            return;
        }
        this.pluginRainPositionPrevious = this.pluginRainPosition;
        this.pluginRainPosition = this.weather == WeatherType.DOWNFALL ? (float)((double)this.pluginRainPosition + 0.01) : (float)((double)this.pluginRainPosition - 0.01);
        this.pluginRainPosition = MathHelper.a(this.pluginRainPosition, 0.0f, 1.0f);
    }

    public void resetPlayerWeather() {
        this.weather = null;
        this.setPlayerWeather(this.A().D_().h() ? WeatherType.DOWNFALL : WeatherType.CLEAR, false);
    }

    @Override
    public String toString() {
        return super.toString() + "(" + this.da() + " at " + this.dP() + "," + this.dR() + "," + this.dV() + ")";
    }

    public void forceSetPositionRotation(double x2, double y2, double z2, float yaw, float pitch) {
        this.b(x2, y2, z2, yaw, pitch);
        this.g.m();
    }

    @Override
    public boolean fE() {
        return super.fE() || !this.getBukkitEntity().isOnline();
    }

    public void reset() {
        float exp = 0.0f;
        if (this.keepLevel) {
            exp = this.cu;
            this.newTotalExp = this.ct;
            this.newLevel = this.cs;
        }
        this.x(this.fq());
        this.gf();
        this.h(0);
        this.an = 0.0;
        this.co = new FoodMetaData();
        this.cs = this.newLevel;
        this.ct = this.newTotalExp;
        this.cu = 0.0f;
        this.bw = 0;
        this.setArrowCount(0, true);
        this.removeAllEffects(EntityPotionEffectEvent.Cause.DEATH);
        this.cr = true;
        this.cn = this.cm;
        this.bH = null;
        this.cs = null;
        this.cn = new CombatTracker(this);
        this.cZ = -1;
        if (this.keepLevel) {
            this.cu = exp;
        } else {
            this.d(this.newExp);
        }
        this.keepLevel = false;
        this.m(0.0, 0.0, 0.0);
        this.cG = (AttributeModifier)false;
    }

    @Override
    public CraftPlayer getBukkitEntity() {
        return (CraftPlayer)super.getBukkitEntity();
    }

    public static final class RespawnConfig
    extends Record {
        private final WorldData.a b;
        private final boolean c;
        public static final Codec<RespawnConfig> a = RecordCodecBuilder.create(instance -> instance.group((App)WorldData.a.b.forGetter(RespawnConfig::a), (App)Codec.BOOL.optionalFieldOf("forced", (Object)false).forGetter(RespawnConfig::b)).apply((Applicative)instance, RespawnConfig::new));

        public RespawnConfig(WorldData.a respawnData, boolean forced) {
            this.b = respawnData;
            this.c = forced;
        }

        static ResourceKey<net.minecraft.world.level.World> b(@Nullable RespawnConfig entityplayer_respawnconfig) {
            return entityplayer_respawnconfig != null ? entityplayer_respawnconfig.a().a() : net.minecraft.world.level.World.h;
        }

        public boolean a(@Nullable RespawnConfig entityplayer_respawnconfig) {
            return entityplayer_respawnconfig != null && this.b.c().equals(entityplayer_respawnconfig.b.c());
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{RespawnConfig.class, "respawnData;forced", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{RespawnConfig.class, "respawnData;forced", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{RespawnConfig.class, "respawnData;forced", "b", "c"}, this, o2);
        }

        public WorldData.a a() {
            return this.b;
        }

        public boolean b() {
            return this.c;
        }
    }

    public record RespawnPosAngle(Vec3D a, float b, float c, boolean isBedSpawn, boolean isAnchorSpawn) {
        public static RespawnPosAngle of(Vec3D vec3d, BlockPosition blockposition, float f2, boolean isBedSpawn, boolean isAnchorSpawn) {
            return new RespawnPosAngle(vec3d, RespawnPosAngle.a(vec3d, blockposition), f2, isBedSpawn, isAnchorSpawn);
        }

        private static float a(Vec3D vec3d, BlockPosition blockposition) {
            Vec3D vec3d1 = Vec3D.c(blockposition).d(vec3d).d();
            return (float)MathHelper.g(MathHelper.d(vec3d1.i, vec3d1.g) * 57.2957763671875 - 90.0);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{RespawnPosAngle.class, "position;yaw;pitch;isBedSpawn;isAnchorSpawn", "a", "b", "c", "isBedSpawn", "isAnchorSpawn"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{RespawnPosAngle.class, "position;yaw;pitch;isBedSpawn;isAnchorSpawn", "a", "b", "c", "isBedSpawn", "isAnchorSpawn"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{RespawnPosAngle.class, "position;yaw;pitch;isBedSpawn;isAnchorSpawn", "a", "b", "c", "isBedSpawn", "isAnchorSpawn"}, this, o2);
        }
    }

    public static final class c
    extends Record {
        private final Optional<ResourceKey<net.minecraft.world.level.World>> c;
        private final Optional<Vec3D> d;
        private final Optional<Vec2F> e;
        public static final MapCodec<c> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)net.minecraft.world.level.World.g.optionalFieldOf(EntityPlayer.f).forGetter(c::a), (App)Vec3D.a.optionalFieldOf("Pos").forGetter(c::b), (App)Vec2F.i.optionalFieldOf("Rotation").forGetter(c::c)).apply((Applicative)instance, c::new));
        public static final c b = new c(Optional.empty(), Optional.empty(), Optional.empty());

        public c(Optional<ResourceKey<net.minecraft.world.level.World>> dimension, Optional<Vec3D> position, Optional<Vec2F> rotation) {
            this.c = dimension;
            this.d = position;
            this.e = rotation;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "dimension;position;rotation", "c", "d", "e"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "dimension;position;rotation", "c", "d", "e"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "dimension;position;rotation", "c", "d", "e"}, this, o2);
        }

        public Optional<ResourceKey<net.minecraft.world.level.World>> a() {
            return this.c;
        }

        public Optional<Vec3D> b() {
            return this.d;
        }

        public Optional<Vec2F> c() {
            return this.e;
        }
    }
}

