/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBundlePacket;
import net.minecraft.network.protocol.game.ClientboundEntityPositionSyncPacket;
import net.minecraft.network.protocol.game.ClientboundMoveMinecartPacket;
import net.minecraft.network.protocol.game.ClientboundProjectilePowerPacket;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutAttachEntity;
import net.minecraft.network.protocol.game.PacketPlayOutEntity;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.network.protocol.game.PacketPlayOutEntityHeadRotation;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityVelocity;
import net.minecraft.network.protocol.game.PacketPlayOutMount;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateAttributes;
import net.minecraft.network.protocol.game.VecDeltaCodec;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.decoration.EntityItemFrame;
import net.minecraft.world.entity.projectile.arrow.EntityArrow;
import net.minecraft.world.entity.projectile.hurtingprojectile.EntityFireball;
import net.minecraft.world.entity.vehicle.minecart.EntityMinecartAbstract;
import net.minecraft.world.entity.vehicle.minecart.MinecartBehavior;
import net.minecraft.world.entity.vehicle.minecart.NewMinecartBehavior;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemWorldMap;
import net.minecraft.world.level.World;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerVelocityEvent;
import org.bukkit.util.Vector;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class EntityTrackerEntry {
    private static final Logger b = LogUtils.getLogger();
    private static final int c = 1;
    private static final double d = 7.62939453125E-6;
    public static final int a = 60;
    private static final int e = 400;
    private final WorldServer f;
    private final Entity g;
    private final int h;
    private final boolean i;
    private final a j;
    private final VecDeltaCodec k = new VecDeltaCodec();
    private byte l;
    private byte m;
    private byte n;
    private Vec3D o;
    private int p;
    private int q;
    private List<Entity> r = Collections.emptyList();
    private boolean s;
    private boolean t;
    private @Nullable List<DataWatcher.c<?>> u;
    private final Set<ServerPlayerConnection> trackedPlayers;

    public EntityTrackerEntry(WorldServer worldserver, Entity entity, int i2, boolean flag, a entitytrackerentry_a, Set<ServerPlayerConnection> trackedPlayers) {
        this.trackedPlayers = trackedPlayers;
        this.f = worldserver;
        this.j = entitytrackerentry_a;
        this.g = entity;
        this.h = i2;
        this.i = flag;
        this.k.e(entity.dJ());
        this.o = entity.dN();
        this.l = MathHelper.e(entity.ec());
        this.m = MathHelper.e(entity.ee());
        this.n = MathHelper.e(entity.cS());
        this.t = entity.aV();
        this.u = entity.aD().c();
    }

    public void a() {
        Entity entity;
        this.g.aI();
        List<Entity> list = this.g.dn();
        if (!list.equals(this.r)) {
            this.j.sendToTrackingPlayersFilteredAndSelf(new PacketPlayOutMount(this.g), entityplayer -> list.contains(entityplayer) == this.r.contains(entityplayer));
            this.r = list;
        }
        if ((entity = this.g) instanceof EntityItemFrame) {
            MapId mapid;
            WorldMap worldmap;
            EntityItemFrame entityitemframe = (EntityItemFrame)entity;
            ItemStack itemstack = entityitemframe.w();
            if (this.p % 10 == 0 && itemstack.h() instanceof ItemWorldMap && (worldmap = ItemWorldMap.a(mapid = itemstack.a(DataComponents.T), (World)this.f)) != null) {
                for (ServerPlayerConnection connection : this.trackedPlayers) {
                    EntityPlayer entityplayer2 = connection.p();
                    worldmap.a(entityplayer2, itemstack);
                    Packet<?> packet = worldmap.a(mapid, entityplayer2);
                    if (packet == null) continue;
                    entityplayer2.g.b(packet);
                }
            }
            this.g();
        }
        if (this.p % this.h == 0 || this.g.aF || this.g.aD().a()) {
            boolean flag;
            byte b0 = MathHelper.e(this.g.ec());
            byte b1 = MathHelper.e(this.g.ee());
            boolean bl = flag = Math.abs(b0 - this.l) >= 1 || Math.abs(b1 - this.m) >= 1;
            if (this.g.cq()) {
                if (flag) {
                    this.j.a(new PacketPlayOutEntity.PacketPlayOutEntityLook(this.g.aA(), b0, b1, this.g.aV()));
                    this.l = b0;
                    this.m = b1;
                }
                this.k.e(this.g.dJ());
                this.g();
                this.s = true;
            } else {
                EntityMinecartAbstract entityminecartabstract;
                MinecartBehavior minecartbehavior;
                Entity entity1 = this.g;
                if (entity1 instanceof EntityMinecartAbstract && (minecartbehavior = (entityminecartabstract = (EntityMinecartAbstract)entity1).q()) instanceof NewMinecartBehavior) {
                    NewMinecartBehavior newminecartbehavior = (NewMinecartBehavior)minecartbehavior;
                    this.a(newminecartbehavior, b0, b1, flag);
                } else {
                    Vec3D vec3d1;
                    double d0;
                    boolean flag5;
                    ++this.q;
                    Vec3D vec3d = this.g.dJ();
                    boolean flag1 = this.k.d(vec3d).h() >= 7.62939453125E-6;
                    Packet<PacketListenerPlayOut> packet1 = null;
                    boolean flag2 = flag1 || this.p % 60 == 0;
                    boolean flag3 = false;
                    boolean flag4 = false;
                    long i2 = this.k.a(vec3d);
                    long j2 = this.k.b(vec3d);
                    long k2 = this.k.c(vec3d);
                    boolean bl2 = flag5 = i2 < -32768L || i2 > 32767L || j2 < -32768L || j2 > 32767L || k2 < -32768L || k2 > 32767L;
                    if (!(this.g.az() || flag5 || this.q > 400 || this.s || this.t != this.g.aV())) {
                        if (!(flag2 && flag || this.g instanceof EntityArrow)) {
                            if (flag2) {
                                packet1 = new PacketPlayOutEntity.PacketPlayOutRelEntityMove(this.g.aA(), (short)i2, (short)j2, (short)k2, this.g.aV());
                                flag3 = true;
                            } else if (flag) {
                                packet1 = new PacketPlayOutEntity.PacketPlayOutEntityLook(this.g.aA(), b0, b1, this.g.aV());
                                flag4 = true;
                            }
                        } else {
                            packet1 = new PacketPlayOutEntity.PacketPlayOutRelEntityMoveLook(this.g.aA(), (short)i2, (short)j2, (short)k2, b0, b1, this.g.aV());
                            flag3 = true;
                            flag4 = true;
                        }
                    } else {
                        this.t = this.g.aV();
                        this.q = 0;
                        packet1 = ClientboundEntityPositionSyncPacket.a(this.g);
                        flag3 = true;
                        flag4 = true;
                    }
                    if ((this.g.aF || this.i || this.g instanceof EntityLiving && ((EntityLiving)this.g).gj()) && ((d0 = (vec3d1 = this.g.dN()).g(this.o)) > 1.0E-7 || d0 > 0.0 && vec3d1.h() == 0.0)) {
                        this.o = vec3d1;
                        Entity entity2 = this.g;
                        if (entity2 instanceof EntityFireball) {
                            EntityFireball entityfireball = (EntityFireball)entity2;
                            this.j.a(new ClientboundBundlePacket((Iterable<Packet<? super PacketListenerPlayOut>>)List.of(new PacketPlayOutEntityVelocity(this.g.aA(), this.o), new ClientboundProjectilePowerPacket(entityfireball.aA(), entityfireball.d))));
                        } else {
                            this.j.a(new PacketPlayOutEntityVelocity(this.g.aA(), this.o));
                        }
                    }
                    if (packet1 != null) {
                        this.j.a(packet1);
                    }
                    this.g();
                    if (flag3) {
                        this.k.e(vec3d);
                    }
                    if (flag4) {
                        this.l = b0;
                        this.m = b1;
                    }
                    this.s = false;
                }
            }
            byte b2 = MathHelper.e(this.g.cS());
            if (Math.abs(b2 - this.n) >= 1) {
                this.j.a(new PacketPlayOutEntityHeadRotation(this.g, b2));
                this.n = b2;
            }
            this.g.aF = false;
        }
        ++this.p;
        if (this.g.ah) {
            boolean cancelled = false;
            if (this.g instanceof EntityPlayer) {
                Player player = (Player)this.g.getBukkitEntity();
                Vector velocity = player.getVelocity();
                PlayerVelocityEvent event = new PlayerVelocityEvent(player, velocity.clone());
                this.g.ao().getCraftServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    cancelled = true;
                } else if (!velocity.equals((Object)event.getVelocity())) {
                    player.setVelocity(event.getVelocity());
                }
            }
            if (cancelled) {
                return;
            }
            this.g.ah = false;
            this.j.b(new PacketPlayOutEntityVelocity(this.g));
        }
    }

    private void a(NewMinecartBehavior newminecartbehavior, byte b0, byte b1, boolean flag) {
        this.g();
        if (newminecartbehavior.e.isEmpty()) {
            boolean flag2;
            Vec3D vec3d = this.g.dN();
            double d0 = vec3d.g(this.o);
            Vec3D vec3d1 = this.g.dJ();
            boolean flag1 = this.k.d(vec3d1).h() >= 7.62939453125E-6;
            boolean bl = flag2 = flag1 || this.p % 60 == 0;
            if (flag2 || flag || d0 > 1.0E-7) {
                this.j.a(new ClientboundMoveMinecartPacket(this.g.aA(), List.of(new NewMinecartBehavior.a(this.g.dI(), this.g.dN(), this.g.ec(), this.g.ee(), 1.0f))));
            }
        } else {
            this.j.a(new ClientboundMoveMinecartPacket(this.g.aA(), List.copyOf(newminecartbehavior.e)));
            newminecartbehavior.e.clear();
        }
        this.l = b0;
        this.m = b1;
        this.k.e(this.g.dI());
    }

    public void a(EntityPlayer entityplayer) {
        this.g.e(entityplayer);
        entityplayer.g.b(new PacketPlayOutEntityDestroy(this.g.aA()));
    }

    public void b(EntityPlayer entityplayer) {
        ArrayList<Packet<? super PacketListenerPlayOut>> list = new ArrayList<Packet<? super PacketListenerPlayOut>>();
        Objects.requireNonNull(list);
        this.a(entityplayer, list::add);
        entityplayer.g.b(new ClientboundBundlePacket((Iterable<Packet<? super PacketListenerPlayOut>>)list));
        this.g.d(entityplayer);
    }

    public void a(EntityPlayer entityplayer, Consumer<Packet<PacketListenerPlayOut>> consumer) {
        Leashable leashable;
        Entity entity;
        this.g.aI();
        if (this.g.eh()) {
            return;
        }
        Packet<PacketListenerPlayOut> packet = this.g.a(this);
        consumer.accept(packet);
        if (this.u != null) {
            consumer.accept(new PacketPlayOutEntityMetadata(this.g.aA(), this.u));
        }
        if ((entity = this.g) instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)entity;
            Collection<AttributeModifiable> collection = entityliving.fw().c();
            if (this.g.aA() == entityplayer.aA()) {
                ((EntityPlayer)this.g).getBukkitEntity().injectScaledMaxHealth(collection, false);
            }
            if (!collection.isEmpty()) {
                consumer.accept(new PacketPlayOutUpdateAttributes(this.g.aA(), collection));
            }
        }
        if ((entity = this.g) instanceof EntityLiving) {
            EntityLiving entityliving1 = (EntityLiving)entity;
            ArrayList list = Lists.newArrayList();
            for (EnumItemSlot enumitemslot : EnumItemSlot.j) {
                ItemStack itemstack = entityliving1.a(enumitemslot);
                if (itemstack.f()) continue;
                list.add(Pair.of((Object)enumitemslot, (Object)itemstack.v()));
            }
            if (!list.isEmpty()) {
                consumer.accept(new PacketPlayOutEntityEquipment(this.g.aA(), list));
            }
            ((EntityLiving)this.g).detectEquipmentUpdatesPublic();
        }
        if (!this.g.dn().isEmpty()) {
            consumer.accept(new PacketPlayOutMount(this.g));
        }
        if (this.g.cq()) {
            consumer.accept(new PacketPlayOutMount(this.g.dz()));
        }
        if ((entity = this.g) instanceof Leashable && (leashable = (Leashable)((Object)entity)).S_()) {
            consumer.accept(new PacketPlayOutAttachEntity(this.g, leashable.C()));
        }
    }

    public Vec3D b() {
        return this.k.a();
    }

    public Vec3D c() {
        return this.o;
    }

    public float d() {
        return MathHelper.a(this.m);
    }

    public float e() {
        return MathHelper.a(this.l);
    }

    public float f() {
        return MathHelper.a(this.n);
    }

    private void g() {
        DataWatcher datawatcher = this.g.aD();
        List<DataWatcher.c<?>> list = datawatcher.b();
        if (list != null) {
            this.u = datawatcher.c();
            this.j.b(new PacketPlayOutEntityMetadata(this.g.aA(), list));
        }
        if (this.g instanceof EntityLiving) {
            Set<AttributeModifiable> set = ((EntityLiving)this.g).fw().a();
            if (!set.isEmpty()) {
                if (this.g instanceof EntityPlayer) {
                    ((EntityPlayer)this.g).getBukkitEntity().injectScaledMaxHealth(set, false);
                }
                this.j.b(new PacketPlayOutUpdateAttributes(this.g.aA(), set));
            }
            set.clear();
        }
    }

    public static interface a {
        public void a(Packet<? super PacketListenerPlayOut> var1);

        public void b(Packet<? super PacketListenerPlayOut> var1);

        public void a(Packet<? super PacketListenerPlayOut> var1, Predicate<EntityPlayer> var2);

        public void sendToTrackingPlayersFilteredAndSelf(Packet<? super PacketListenerPlayOut> var1, Predicate<EntityPlayer> var2);
    }
}

