/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.primitives.Ints;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.exceptions.AuthenticationUnavailableException;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.authlib.yggdrasil.ProfileResult;
import com.mojang.logging.LogUtils;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.PrivateKey;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.DisconnectionDetails;
import net.minecraft.network.EnumProtocol;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.TickablePacketListener;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PlayerConnectionUtils;
import net.minecraft.network.protocol.configuration.ConfigurationProtocols;
import net.minecraft.network.protocol.cookie.ServerboundCookieResponsePacket;
import net.minecraft.network.protocol.login.PacketLoginInEncryptionBegin;
import net.minecraft.network.protocol.login.PacketLoginInListener;
import net.minecraft.network.protocol.login.PacketLoginInStart;
import net.minecraft.network.protocol.login.PacketLoginOutDisconnect;
import net.minecraft.network.protocol.login.PacketLoginOutEncryptionBegin;
import net.minecraft.network.protocol.login.PacketLoginOutSetCompression;
import net.minecraft.network.protocol.login.PacketLoginOutSuccess;
import net.minecraft.network.protocol.login.ServerboundCustomQueryAnswerPacket;
import net.minecraft.network.protocol.login.ServerboundLoginAcknowledgedPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.network.HandshakeListener;
import net.minecraft.server.network.ServerCommonPacketListenerImpl;
import net.minecraft.server.network.ServerConfigurationPacketListenerImpl;
import net.minecraft.server.notifications.ServerActivityMonitor;
import net.minecraft.server.players.PlayerList;
import net.minecraft.util.CryptographyException;
import net.minecraft.util.MinecraftEncryption;
import net.minecraft.util.RandomSource;
import net.minecraft.util.UtilColor;
import org.apache.commons.lang3.Validate;
import org.bukkit.craftbukkit.v1_21_R7.CraftServer;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R7.util.Waitable;
import org.bukkit.event.Event;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.event.player.PlayerPreLoginEvent;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class LoginListener
implements PacketLoginInListener,
TickablePacketListener,
CraftPlayer.TransferCookieConnection {
    private static final AtomicInteger b = new AtomicInteger(0);
    static final Logger c = LogUtils.getLogger();
    private static final int d = 600;
    private final byte[] e;
    final MinecraftServer f;
    public final NetworkManager g;
    final ServerActivityMonitor h;
    private volatile EnumProtocolState i = EnumProtocolState.a;
    private int j;
    @Nullable String k;
    private @Nullable GameProfile l;
    private final String m;
    private final boolean n;
    private EntityPlayer player;

    @Override
    public boolean isTransferred() {
        return this.n;
    }

    @Override
    public EnumProtocol getProtocol() {
        return EnumProtocol.d;
    }

    @Override
    public void sendPacket(Packet<?> packet) {
        this.g.a(packet);
    }

    @Override
    public void kickPlayer(IChatBaseComponent reason) {
        this.a(reason);
    }

    public LoginListener(MinecraftServer minecraftserver, NetworkManager networkmanager, boolean flag) {
        this.m = "";
        this.f = minecraftserver;
        this.g = networkmanager;
        this.h = this.f.H();
        this.e = Ints.toByteArray((int)RandomSource.a().f());
        this.n = flag;
    }

    @Override
    public void d() {
        if (this.i == EnumProtocolState.e) {
            this.c(Objects.requireNonNull(this.l));
        }
        if (this.i == EnumProtocolState.WAITING_FOR_COOKIES && !this.player.getBukkitEntity().isAwaitingCookies()) {
            this.postCookies(this.l);
        }
        if (this.i == EnumProtocolState.f && !this.a(Objects.requireNonNull(this.l))) {
            this.d(this.l);
        }
        if (this.j++ == 600) {
            this.a(IChatBaseComponent.c("multiplayer.disconnect.slow_login"));
        }
    }

    @Deprecated
    public void disconnect(String s2) {
        this.a(IChatBaseComponent.b(s2));
    }

    @Override
    public boolean c() {
        return this.g.i();
    }

    public void a(IChatBaseComponent ichatbasecomponent) {
        try {
            this.i = EnumProtocolState.DISCONNECTED;
            c.info("Disconnecting {}: {}", (Object)this.e(), (Object)ichatbasecomponent.getString());
            this.g.a(new PacketLoginOutDisconnect(ichatbasecomponent));
            this.g.a(ichatbasecomponent);
        }
        catch (Exception exception) {
            c.error("Error whilst disconnecting player", (Throwable)exception);
        }
    }

    private boolean a(GameProfile gameprofile) {
        return this.f.aj().b(gameprofile.id()) != null;
    }

    @Override
    public void a(DisconnectionDetails disconnectiondetails) {
        c.info("{} lost connection: {}", (Object)this.e(), (Object)disconnectiondetails.a().getString());
    }

    public String e() {
        String s2 = this.g.a(this.f.bn());
        return this.k != null ? this.k + " (" + s2 + ")" : s2;
    }

    @Override
    public void a(PacketLoginInStart packetlogininstart) {
        Validate.validState((this.i == EnumProtocolState.a ? 1 : 0) != 0, (String)"Unexpected hello packet", (Object[])new Object[0]);
        Validate.validState((boolean)UtilColor.f(packetlogininstart.b()), (String)"Invalid characters in username", (Object[])new Object[0]);
        this.k = packetlogininstart.b();
        GameProfile gameprofile = this.f.W();
        if (gameprofile != null && this.k.equalsIgnoreCase(gameprofile.name())) {
            this.b(gameprofile);
        } else if (this.f.ae() && !this.g.e()) {
            this.i = EnumProtocolState.b;
            this.g.a(new PacketLoginOutEncryptionBegin("", this.f.U().getPublic().getEncoded(), this.e, true));
        } else {
            Thread thread = new Thread("User Authenticator #" + b.incrementAndGet()){

                @Override
                public void run() {
                    try {
                        GameProfile gameprofile = LoginListener.this.createOfflineProfile(LoginListener.this.k);
                        LoginListener.this.callPlayerPreLoginEvents(gameprofile);
                        c.info("UUID of player {} is {}", (Object)gameprofile.name(), (Object)gameprofile.id());
                        LoginListener.this.b(gameprofile);
                    }
                    catch (Exception ex) {
                        LoginListener.this.disconnect("Failed to verify username!");
                        LoginListener.this.f.server.getLogger().log(Level.WARNING, "Exception verifying " + LoginListener.this.k, ex);
                    }
                }
            };
            thread.setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler(c));
            thread.start();
        }
    }

    void b(GameProfile gameprofile) {
        this.l = gameprofile;
        this.i = EnumProtocolState.e;
    }

    private void c(GameProfile gameprofile) {
        PlayerList playerlist = this.f.aj();
        this.player = playerlist.canPlayerLogin(this, gameprofile);
        if (this.player != null) {
            if (this.player.getBukkitEntity().isAwaitingCookies()) {
                this.i = EnumProtocolState.WAITING_FOR_COOKIES;
            } else {
                this.postCookies(gameprofile);
            }
        }
    }

    private void postCookies(GameProfile gameprofile) {
        PlayerList playerlist = this.f.aj();
        if (this.player != null) {
            boolean flag;
            if (this.f.ax() >= 0 && !this.g.e()) {
                this.g.a(new PacketLoginOutSetCompression(this.f.ax()), PacketSendListener.a(() -> this.g.a(this.f.ax(), true)));
            }
            if (flag = playerlist.disconnectAllPlayersWithProfile(gameprofile.id(), this.player)) {
                this.i = EnumProtocolState.f;
            } else {
                this.d(gameprofile);
            }
        }
    }

    private void d(GameProfile gameprofile) {
        this.i = EnumProtocolState.g;
        this.g.a(new PacketLoginOutSuccess(gameprofile));
    }

    @Override
    public void a(PacketLoginInEncryptionBegin packetlogininencryptionbegin) {
        String s2;
        Validate.validState((this.i == EnumProtocolState.b ? 1 : 0) != 0, (String)"Unexpected key packet", (Object[])new Object[0]);
        try {
            PrivateKey privatekey = this.f.U().getPrivate();
            if (!packetlogininencryptionbegin.a(this.e, privatekey)) {
                throw new IllegalStateException("Protocol error");
            }
            SecretKey secretkey = packetlogininencryptionbegin.a(privatekey);
            Cipher cipher = MinecraftEncryption.a(2, secretkey);
            Cipher cipher1 = MinecraftEncryption.a(1, secretkey);
            s2 = new BigInteger(MinecraftEncryption.a("", this.f.U().getPublic(), secretkey)).toString(16);
            this.i = EnumProtocolState.c;
            this.g.a(cipher, cipher1);
        }
        catch (CryptographyException cryptographyexception) {
            throw new IllegalStateException("Protocol error", cryptographyexception);
        }
        Thread thread = new Thread("User Authenticator #" + b.incrementAndGet()){

            @Override
            public void run() {
                String s1 = Objects.requireNonNull(LoginListener.this.k, "Player name not initialized");
                try {
                    ProfileResult profileresult = LoginListener.this.f.ar().c().hasJoinedServer(s1, s2, this.getAddress());
                    if (profileresult != null) {
                        GameProfile gameprofile = profileresult.profile();
                        if (!LoginListener.this.g.i()) {
                            return;
                        }
                        LoginListener.this.callPlayerPreLoginEvents(gameprofile);
                        c.info("UUID of player {} is {}", (Object)gameprofile.name(), (Object)gameprofile.id());
                        LoginListener.this.h.b();
                        LoginListener.this.b(gameprofile);
                    } else if (LoginListener.this.f.X()) {
                        c.warn("Failed to verify username but will let them in anyway!");
                        LoginListener.this.b(LoginListener.this.createOfflineProfile(s1));
                    } else {
                        LoginListener.this.a(IChatBaseComponent.c("multiplayer.disconnect.unverified_username"));
                        c.error("Username '{}' tried to join with an invalid session", (Object)s1);
                    }
                }
                catch (AuthenticationUnavailableException authenticationunavailableexception) {
                    if (LoginListener.this.f.X()) {
                        c.warn("Authentication servers are down but will let them in anyway!");
                        LoginListener.this.b(LoginListener.this.createOfflineProfile(s1));
                    } else {
                        LoginListener.this.a(IChatBaseComponent.c("multiplayer.disconnect.authservers_down"));
                        c.error("Couldn't verify username because servers are unavailable");
                    }
                }
                catch (Exception exception) {
                    LoginListener.this.disconnect("Failed to verify username!");
                    LoginListener.this.f.server.getLogger().log(Level.WARNING, "Exception verifying " + s1, exception);
                }
            }

            private @Nullable InetAddress getAddress() {
                SocketAddress socketaddress = LoginListener.this.g.d();
                return LoginListener.this.f.af() && socketaddress instanceof InetSocketAddress ? ((InetSocketAddress)socketaddress).getAddress() : null;
            }
        };
        thread.setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler(c));
        thread.start();
    }

    private void callPlayerPreLoginEvents(GameProfile gameprofile) throws Exception {
        String playerName = gameprofile.name();
        InetAddress address = ((InetSocketAddress)this.g.d()).getAddress();
        UUID uniqueId = gameprofile.id();
        final CraftServer server = this.f.server;
        AsyncPlayerPreLoginEvent asyncEvent = new AsyncPlayerPreLoginEvent(playerName, address, uniqueId, this.n);
        server.getPluginManager().callEvent((Event)asyncEvent);
        if (PlayerPreLoginEvent.getHandlerList().getRegisteredListeners().length != 0) {
            final PlayerPreLoginEvent event = new PlayerPreLoginEvent(playerName, address, uniqueId);
            if (asyncEvent.getResult() != PlayerPreLoginEvent.Result.ALLOWED) {
                event.disallow(asyncEvent.getResult(), asyncEvent.getKickMessage());
            }
            Waitable<PlayerPreLoginEvent.Result> waitable = new Waitable<PlayerPreLoginEvent.Result>(this){

                @Override
                protected PlayerPreLoginEvent.Result evaluate() {
                    server.getPluginManager().callEvent((Event)event);
                    return event.getResult();
                }
            };
            this.f.processQueue.add(waitable);
            if (waitable.get() != PlayerPreLoginEvent.Result.ALLOWED) {
                this.disconnect(event.getKickMessage());
                return;
            }
        } else if (asyncEvent.getLoginResult() != AsyncPlayerPreLoginEvent.Result.ALLOWED) {
            this.disconnect(asyncEvent.getKickMessage());
            return;
        }
    }

    @Override
    public void a(ServerboundCustomQueryAnswerPacket serverboundcustomqueryanswerpacket) {
        this.a(ServerCommonPacketListenerImpl.c);
    }

    @Override
    public void a(ServerboundLoginAcknowledgedPacket serverboundloginacknowledgedpacket) {
        PlayerConnectionUtils.a(serverboundloginacknowledgedpacket, this, this.f.bv());
        Validate.validState((this.i == EnumProtocolState.g ? 1 : 0) != 0, (String)"Unexpected login acknowledgement packet", (Object[])new Object[0]);
        this.g.a(ConfigurationProtocols.d);
        CommonListenerCookie commonlistenercookie = CommonListenerCookie.a(Objects.requireNonNull(this.l), this.n);
        ServerConfigurationPacketListenerImpl serverconfigurationpacketlistenerimpl = new ServerConfigurationPacketListenerImpl(this.f, this.g, commonlistenercookie, this.player);
        this.g.a(ConfigurationProtocols.b, serverconfigurationpacketlistenerimpl);
        serverconfigurationpacketlistenerimpl.l();
        this.i = EnumProtocolState.h;
    }

    @Override
    public void a(CrashReport crashreport, CrashReportSystemDetails crashreportsystemdetails) {
        crashreportsystemdetails.a("Login phase", () -> this.i.toString());
    }

    @Override
    public void a(ServerboundCookieResponsePacket serverboundcookieresponsepacket) {
        PlayerConnectionUtils.a(serverboundcookieresponsepacket, this, this.f.bv());
        if (this.player != null && this.player.getBukkitEntity().handleCookieResponse(serverboundcookieresponsepacket)) {
            return;
        }
        this.a(ServerCommonPacketListenerImpl.c);
    }

    protected GameProfile createOfflineProfile(String s2) {
        UUID uuid = this.g.spoofedUUID != null ? this.g.spoofedUUID : UUIDUtil.a(s2);
        LinkedListMultimap properties = LinkedListMultimap.create();
        if (this.g.spoofedProfile != null) {
            for (Property property : this.g.spoofedProfile) {
                if (!HandshakeListener.PROP_PATTERN.matcher(property.name()).matches()) continue;
                properties.put((Object)property.name(), (Object)property);
            }
        }
        return new GameProfile(uuid, s2, new PropertyMap((Multimap)properties));
    }

    private static enum EnumProtocolState {
        a,
        b,
        c,
        d,
        e,
        f,
        g,
        h,
        WAITING_FOR_COOKIES,
        DISCONNECTED;

    }
}

