/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.metadata.pack;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.InclusiveRange;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public final class PackFormat
extends Record
implements Comparable<PackFormat> {
    private final int c;
    private final int d;
    private static final Logger e = LogUtils.getLogger();
    public static final Codec<PackFormat> a = PackFormat.b(0);
    public static final Codec<PackFormat> b = PackFormat.b(Integer.MAX_VALUE);

    public PackFormat(int var0, int var1) {
        this.c = var0;
        this.d = var1;
    }

    private static Codec<PackFormat> b(int var0) {
        return ExtraCodecs.c(ExtraCodecs.q, ExtraCodecs.q.listOf(1, 256)).xmap(var1 -> var1.size() > 1 ? PackFormat.a((int)((Integer)var1.getFirst()), (Integer)var1.get(1)) : PackFormat.a((int)((Integer)var1.getFirst()), var0), var1 -> var1.d != var0 ? List.of(Integer.valueOf(var1.b()), Integer.valueOf(var1.c())) : List.of(Integer.valueOf(var1.b())));
    }

    public static <ResultType, HolderType extends b> DataResult<List<ResultType>> a(List<HolderType> var0, int var1, BiFunction<HolderType, InclusiveRange<PackFormat>, ResultType> var2) {
        int var3 = var0.stream().map(b::a).mapToInt(a::a).min().orElse(Integer.MAX_VALUE);
        ArrayList<ResultType> var4 = new ArrayList<ResultType>(var0.size());
        for (b var6 : var0) {
            a var7 = var6.a();
            if (var7.b().isEmpty() && var7.c().isEmpty() && var7.e().isEmpty()) {
                e.warn("Unknown or broken overlay entry {}", (Object)var6);
                continue;
            }
            DataResult<InclusiveRange<PackFormat>> var8 = var7.a(var1, false, var3 <= var1, "Overlay \"" + String.valueOf(var6) + "\"", "formats");
            if (var8.isSuccess()) {
                var4.add(var2.apply(var6, (InclusiveRange)var8.getOrThrow()));
                continue;
            }
            return DataResult.error(() -> ((DataResult.Error)((DataResult.Error)var8.error().get())).message());
        }
        return DataResult.success(List.copyOf(var4));
    }

    @VisibleForTesting
    public static int a(EnumResourcePackType var0) {
        return switch (var0) {
            default -> throw new MatchException(null, null);
            case EnumResourcePackType.a -> 64;
            case EnumResourcePackType.b -> 81;
        };
    }

    public static MapCodec<InclusiveRange<PackFormat>> b(EnumResourcePackType var0) {
        int var12 = PackFormat.a(var0);
        return net.minecraft.server.packs.metadata.pack.PackFormat$a.f.flatXmap(var1 -> var1.a(var12, true, false, "Pack", "supported_formats"), var1 -> DataResult.success((Object)net.minecraft.server.packs.metadata.pack.PackFormat$a.a(var1, var12)));
    }

    public static PackFormat a(int var0, int var1) {
        return new PackFormat(var0, var1);
    }

    public static PackFormat a(int var0) {
        return new PackFormat(var0, 0);
    }

    public InclusiveRange<PackFormat> a() {
        return new InclusiveRange<PackFormat>(this, PackFormat.a(this.c, Integer.MAX_VALUE));
    }

    public int a(PackFormat var0) {
        int var1 = Integer.compare(this.b(), var0.b());
        if (var1 != 0) {
            return var1;
        }
        return Integer.compare(this.c(), var0.c());
    }

    @Override
    public String toString() {
        if (this.d == Integer.MAX_VALUE) {
            return String.format(Locale.ROOT, "%d.*", this.b());
        }
        return String.format(Locale.ROOT, "%d.%d", this.b(), this.c());
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{PackFormat.class, "major;minor", "c", "d"}, this);
    }

    @Override
    public final boolean equals(Object var0) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{PackFormat.class, "major;minor", "c", "d"}, this, var0);
    }

    public int b() {
        return this.c;
    }

    public int c() {
        return this.d;
    }

    @Override
    public /* synthetic */ int compareTo(Object object) {
        return this.a((PackFormat)object);
    }

    public static interface b {
        public a a();
    }

    public record a(Optional<PackFormat> b, Optional<PackFormat> c, Optional<Integer> d, Optional<InclusiveRange<Integer>> e) {
        static final MapCodec<a> f = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)a.optionalFieldOf("min_format").forGetter(a::b), (App)b.optionalFieldOf("max_format").forGetter(a::c), (App)Codec.INT.optionalFieldOf("pack_format").forGetter(a::d), (App)InclusiveRange.a(Codec.INT).optionalFieldOf("supported_formats").forGetter(a::e)).apply((Applicative)var0, a::new));
        public static final MapCodec<a> a = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)a.optionalFieldOf("min_format").forGetter(a::b), (App)b.optionalFieldOf("max_format").forGetter(a::c), (App)InclusiveRange.a(Codec.INT).optionalFieldOf("formats").forGetter(a::e)).apply((Applicative)var02, (var0, var1, var2) -> new a((Optional<PackFormat>)var0, (Optional<PackFormat>)var1, var0.map(PackFormat::b), (Optional<InclusiveRange<Integer>>)var2)));

        public static a a(InclusiveRange<PackFormat> var0, int var1) {
            InclusiveRange<Integer> var2 = var0.a(PackFormat::b);
            return new a(Optional.of(var0.a()), Optional.of(var0.b()), var2.a(var1) ? Optional.of(var2.a()) : Optional.empty(), var2.a(var1) ? Optional.of(new InclusiveRange<Integer>(var2.a(), var2.b())) : Optional.empty());
        }

        public int a() {
            if (this.b.isPresent()) {
                if (this.e.isPresent()) {
                    return Math.min(this.b.get().b(), this.e.get().a());
                }
                return this.b.get().b();
            }
            if (this.e.isPresent()) {
                return this.e.get().a();
            }
            return Integer.MAX_VALUE;
        }

        public DataResult<InclusiveRange<PackFormat>> a(int var0, boolean var1, boolean var2, String var3, String var4) {
            if (this.b.isPresent() != this.c.isPresent()) {
                return DataResult.error(() -> var3 + " missing field, must declare both min_format and max_format");
            }
            if (var2 && this.e.isEmpty()) {
                return DataResult.error(() -> var3 + " missing required field " + var4 + ", must be present in all overlays for any overlays to work across game versions");
            }
            if (this.b.isPresent()) {
                return this.b(var0, var1, var2, var3, var4);
            }
            if (this.e.isPresent()) {
                return this.a(var0, var1, var3, var4);
            }
            if (var1 && this.d.isPresent()) {
                int var5 = this.d.get();
                if (var5 > var0) {
                    return DataResult.error(() -> var3 + " declares support for version newer than " + var0 + ", but is missing mandatory fields min_format and max_format");
                }
                return DataResult.success(new InclusiveRange<PackFormat>(PackFormat.a(var5)));
            }
            return DataResult.error(() -> var3 + " could not be parsed, missing format version information");
        }

        private DataResult<InclusiveRange<PackFormat>> b(int var0, boolean var1, boolean var2, String var3, String var4) {
            int var5 = this.b.get().b();
            int var6 = this.c.get().b();
            if (this.b.get().a(this.c.get()) > 0) {
                return DataResult.error(() -> var3 + " min_format (" + String.valueOf(this.b.get()) + ") is greater than max_format (" + String.valueOf(this.c.get()) + ")");
            }
            if (var5 > var0 && !var2) {
                String var7;
                if (this.e.isPresent()) {
                    return DataResult.error(() -> var3 + " key " + var4 + " is deprecated starting from pack format " + (var0 + 1) + ". Remove " + var4 + " from your pack.mcmeta.");
                }
                if (var1 && this.d.isPresent() && (var7 = this.a(var5, var6)) != null) {
                    return DataResult.error(() -> var7);
                }
            } else {
                Object var7;
                if (this.e.isPresent()) {
                    var7 = this.e.get();
                    if (((InclusiveRange)var7).a() != var5) {
                        return DataResult.error(() -> var3 + " version declaration mismatch between " + var4 + " (from " + String.valueOf(var7.a()) + ") and min_format (" + String.valueOf(this.b.get()) + ")");
                    }
                    if (((InclusiveRange)var7).b() != var6 && ((InclusiveRange)var7).b() != var0) {
                        return DataResult.error(() -> var3 + " version declaration mismatch between " + var4 + " (up to " + String.valueOf(var7.b()) + ") and max_format (" + String.valueOf(this.c.get()) + ")");
                    }
                } else {
                    return DataResult.error(() -> var3 + " declares support for format " + var5 + ", but game versions supporting formats 17 to " + var0 + " require a " + var4 + " field. Add \"" + var4 + "\": [" + var5 + ", " + var0 + "] or require a version greater or equal to " + (var0 + 1) + ".0.");
                }
                if (var1) {
                    if (this.d.isPresent()) {
                        var7 = this.a(var5, var6);
                        if (var7 != null) {
                            return DataResult.error(() -> a.b((String)var7));
                        }
                    } else {
                        return DataResult.error(() -> var3 + " declares support for formats up to " + var0 + ", but game versions supporting formats 17 to " + var0 + " require a pack_format field. Add \"pack_format\": " + var5 + " or require a version greater or equal to " + (var0 + 1) + ".0.");
                    }
                }
            }
            return DataResult.success(new InclusiveRange<PackFormat>(this.b.get(), this.c.get()));
        }

        private DataResult<InclusiveRange<PackFormat>> a(int var0, boolean var1, String var2, String var3) {
            InclusiveRange<Integer> var4 = this.e.get();
            int var5 = var4.a();
            int var6 = var4.b();
            if (var6 > var0) {
                return DataResult.error(() -> var2 + " declares support for version newer than " + var0 + ", but is missing mandatory fields min_format and max_format");
            }
            if (var1) {
                if (this.d.isPresent()) {
                    String var7 = this.a(var5, var6);
                    if (var7 != null) {
                        return DataResult.error(() -> var7);
                    }
                } else {
                    return DataResult.error(() -> var2 + " declares support for formats up to " + var0 + ", but game versions supporting formats 17 to " + var0 + " require a pack_format field. Add \"pack_format\": " + var5 + " or require a version greater or equal to " + (var0 + 1) + ".0.");
                }
            }
            return DataResult.success(new InclusiveRange<Integer>(var5, var6).a(PackFormat::a));
        }

        private @Nullable String a(int var0, int var1) {
            int var2 = this.d.get();
            if (var2 < var0 || var2 > var1) {
                return "Pack declared support for versions " + var0 + " to " + var1 + " but declared main format is " + var2;
            }
            if (var2 < 15) {
                return "Multi-version packs cannot support minimum version of less than 15, since this will leave versions in range unable to load pack.";
            }
            return null;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "min;max;format;supported", "b", "c", "d", "e"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "min;max;format;supported", "b", "c", "d", "e"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "min;max;format;supported", "b", "c", "d", "e"}, this, var0);
        }

        private static /* synthetic */ String b(String var0) {
            return var0;
        }
    }
}

