/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.collect.Comparators;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.util.EasingType;
import net.minecraft.util.Keyframe;
import net.minecraft.util.KeyframeTrackSampler;
import net.minecraft.world.attribute.LerpFunction;

public record KeyframeTrack<T>(List<Keyframe<T>> a, EasingType b) {
    public KeyframeTrack {
        if (var0.isEmpty()) {
            throw new IllegalArgumentException("Track has no keyframes");
        }
    }

    public static <T> MapCodec<KeyframeTrack<T>> a(Codec<T> var0) {
        Codec var12 = Keyframe.a(var0).listOf().validate(KeyframeTrack::a);
        return RecordCodecBuilder.mapCodec(var1 -> var1.group((App)var12.fieldOf("keyframes").forGetter(KeyframeTrack::a), (App)EasingType.b.optionalFieldOf("ease", (Object)EasingType.d).forGetter(KeyframeTrack::b)).apply((Applicative)var1, KeyframeTrack::new));
    }

    static <T> DataResult<List<Keyframe<T>>> a(List<Keyframe<T>> var0) {
        if (var0.isEmpty()) {
            return DataResult.error(() -> "Keyframes must not be empty");
        }
        if (!Comparators.isInOrder(var0, Comparator.comparingInt(Keyframe::a))) {
            return DataResult.error(() -> "Keyframes must be ordered by ticks field");
        }
        if (var0.size() > 1) {
            int var1 = 0;
            int var2 = var0.getLast().a();
            for (Keyframe var4 : var0) {
                if (var4.a() == var2) {
                    if (++var1 > 2) {
                        return DataResult.error(() -> "More than 2 keyframes on same tick: " + var4.a());
                    }
                } else {
                    var1 = 0;
                }
                var2 = var4.a();
            }
        }
        return DataResult.success(var0);
    }

    public static DataResult<KeyframeTrack<?>> a(KeyframeTrack<?> var0, int var1) {
        for (Keyframe<?> var3 : var0.a()) {
            int var4 = var3.a();
            if (var4 >= 0 && var4 <= var1) continue;
            return DataResult.error(() -> "Keyframe at tick " + var3.a() + " must be in range [0; " + var1 + "]");
        }
        return DataResult.success(var0);
    }

    public KeyframeTrackSampler<T> a(Optional<Integer> var0, LerpFunction<T> var1) {
        return new KeyframeTrackSampler<T>(this, var0, var1);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{KeyframeTrack.class, "keyframes;easingType", "a", "b"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{KeyframeTrack.class, "keyframes;easingType", "a", "b"}, this);
    }

    @Override
    public final boolean equals(Object var0) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{KeyframeTrack.class, "keyframes;easingType", "a", "b"}, this, var0);
    }

    public static class a<T> {
        private final ImmutableList.Builder<Keyframe<T>> a = ImmutableList.builder();
        private EasingType b = EasingType.d;

        public a<T> a(int var0, T var1) {
            this.a.add(new Keyframe<T>(var0, var1));
            return this;
        }

        public a<T> a(EasingType var0) {
            this.b = var0;
            return this;
        }

        public KeyframeTrack<T> a() {
            List var0 = (List)KeyframeTrack.a(this.a.build()).getOrThrow();
            return new KeyframeTrack(var0, this.b);
        }
    }
}

