/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.collect.ImmutableList;
import com.mojang.logging.LogUtils;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.Tlhelp32;
import com.sun.jna.platform.win32.Version;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import net.minecraft.CrashReportSystemDetails;
import org.slf4j.Logger;

public class NativeModuleLister {
    private static final Logger a = LogUtils.getLogger();
    private static final int b = 65535;
    private static final int c = 1033;
    private static final int d = -65536;
    private static final int e = 0x4B00000;

    public static List<a> a() {
        if (!Platform.isWindows()) {
            return ImmutableList.of();
        }
        int var0 = Kernel32.INSTANCE.GetCurrentProcessId();
        ImmutableList.Builder var1 = ImmutableList.builder();
        List var2 = Kernel32Util.getModules((int)var0);
        for (Tlhelp32.MODULEENTRY32W var4 : var2) {
            String var5 = var4.szModule();
            Optional<b> var6 = NativeModuleLister.a(var4.szExePath());
            var1.add((Object)new a(var5, var6));
        }
        return var1.build();
    }

    private static Optional<b> a(String var0) {
        try {
            IntByReference var1 = new IntByReference();
            int var2 = Version.INSTANCE.GetFileVersionInfoSize(var0, var1);
            if (var2 == 0) {
                int var3 = Native.getLastError();
                if (var3 == 1813 || var3 == 1812) {
                    return Optional.empty();
                }
                throw new Win32Exception(var3);
            }
            Memory var3 = new Memory((long)var2);
            if (!Version.INSTANCE.GetFileVersionInfo(var0, 0, var2, (Pointer)var3)) {
                throw new Win32Exception(Native.getLastError());
            }
            IntByReference var4 = new IntByReference();
            Pointer var5 = NativeModuleLister.a((Pointer)var3, "\\VarFileInfo\\Translation", var4);
            int[] var6 = var5.getIntArray(0L, var4.getValue() / 4);
            OptionalInt var7 = NativeModuleLister.a(var6);
            if (var7.isEmpty()) {
                return Optional.empty();
            }
            int var8 = var7.getAsInt();
            int var9 = var8 & 0xFFFF;
            int var10 = (var8 & 0xFFFF0000) >> 16;
            String var11 = NativeModuleLister.b((Pointer)var3, NativeModuleLister.a("FileDescription", var9, var10), var4);
            String var12 = NativeModuleLister.b((Pointer)var3, NativeModuleLister.a("CompanyName", var9, var10), var4);
            String var13 = NativeModuleLister.b((Pointer)var3, NativeModuleLister.a("FileVersion", var9, var10), var4);
            return Optional.of(new b(var11, var13, var12));
        }
        catch (Exception var1) {
            a.info("Failed to find module info for {}", (Object)var0, (Object)var1);
            return Optional.empty();
        }
    }

    private static String a(String var0, int var1, int var2) {
        return String.format(Locale.ROOT, "\\StringFileInfo\\%04x%04x\\%s", var1, var2, var0);
    }

    private static OptionalInt a(int[] var0) {
        OptionalInt var1 = OptionalInt.empty();
        for (int var5 : var0) {
            if ((var5 & 0xFFFF0000) == 0x4B00000 && (var5 & 0xFFFF) == 1033) {
                return OptionalInt.of(var5);
            }
            var1 = OptionalInt.of(var5);
        }
        return var1;
    }

    private static Pointer a(Pointer var0, String var1, IntByReference var2) {
        PointerByReference var3 = new PointerByReference();
        if (!Version.INSTANCE.VerQueryValue(var0, var1, var3, var2)) {
            throw new UnsupportedOperationException("Can't get version value " + var1);
        }
        return var3.getValue();
    }

    private static String b(Pointer var0, String var1, IntByReference var2) {
        try {
            Pointer var3 = NativeModuleLister.a(var0, var1, var2);
            byte[] var4 = var3.getByteArray(0L, (var2.getValue() - 1) * 2);
            return new String(var4, StandardCharsets.UTF_16LE);
        }
        catch (Exception var3) {
            return "";
        }
    }

    public static void a(CrashReportSystemDetails var0) {
        var0.a("Modules", () -> NativeModuleLister.a().stream().sorted(Comparator.comparing(var0 -> var0.a)).map(var0 -> "\n\t\t" + String.valueOf(var0)).collect(Collectors.joining()));
    }

    public static class a {
        public final String a;
        public final Optional<b> b;

        public a(String var0, Optional<b> var1) {
            this.a = var0;
            this.b = var1;
        }

        public String toString() {
            return this.b.map(var0 -> this.a + ":" + String.valueOf(var0)).orElse(this.a);
        }
    }

    public static class b {
        public final String a;
        public final String b;
        public final String c;

        public b(String var0, String var1, String var2) {
            this.a = var0;
            this.b = var1;
            this.c = var2;
        }

        public String toString() {
            return this.a + ":" + this.b + ":" + this.c;
        }
    }
}

