/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.profiling.jfr;

import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.SocketAddress;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.ParseException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jdk.jfr.Configuration;
import jdk.jfr.Event;
import jdk.jfr.FlightRecorder;
import jdk.jfr.FlightRecorderListener;
import jdk.jfr.Recording;
import net.minecraft.SharedConstants;
import net.minecraft.core.Holder;
import net.minecraft.network.EnumProtocol;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.FileUtils;
import net.minecraft.util.SystemUtils;
import net.minecraft.util.profiling.jfr.Environment;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import net.minecraft.util.profiling.jfr.SummaryReporter;
import net.minecraft.util.profiling.jfr.callback.ProfiledDuration;
import net.minecraft.util.profiling.jfr.event.ChunkGenerationEvent;
import net.minecraft.util.profiling.jfr.event.ChunkRegionReadEvent;
import net.minecraft.util.profiling.jfr.event.ChunkRegionWriteEvent;
import net.minecraft.util.profiling.jfr.event.ClientFpsEvent;
import net.minecraft.util.profiling.jfr.event.NetworkSummaryEvent;
import net.minecraft.util.profiling.jfr.event.PacketReceivedEvent;
import net.minecraft.util.profiling.jfr.event.PacketSentEvent;
import net.minecraft.util.profiling.jfr.event.ServerTickTimeEvent;
import net.minecraft.util.profiling.jfr.event.StructureGenerationEvent;
import net.minecraft.util.profiling.jfr.event.WorldLoadFinishedEvent;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.World;
import net.minecraft.world.level.chunk.storage.RegionFileCompression;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class JfrProfiler
implements JvmProfiler {
    private static final Logger g = LogUtils.getLogger();
    public static final String a = "Minecraft";
    public static final String b = "World Generation";
    public static final String c = "Ticking";
    public static final String d = "Network";
    public static final String e = "Storage";
    private static final List<Class<? extends Event>> h = List.of(ChunkGenerationEvent.class, ChunkRegionReadEvent.class, ChunkRegionWriteEvent.class, PacketReceivedEvent.class, PacketSentEvent.class, NetworkSummaryEvent.class, ServerTickTimeEvent.class, ClientFpsEvent.class, StructureGenerationEvent.class, WorldLoadFinishedEvent.class);
    private static final String i = "/flightrecorder-config.jfc";
    private static final DateTimeFormatter j = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd-HHmmss").toFormatter(Locale.ROOT).withZone(ZoneId.systemDefault());
    private static final JfrProfiler k = new JfrProfiler();
    @Nullable Recording l;
    private int m;
    private float n;
    private final Map<String, NetworkSummaryEvent.b> o = new ConcurrentHashMap<String, NetworkSummaryEvent.b>();
    private final Runnable p = () -> new ClientFpsEvent(this.m).commit();
    private final Runnable q = () -> new ServerTickTimeEvent(this.n).commit();
    private final Runnable r = () -> {
        Iterator<NetworkSummaryEvent.b> var0 = this.o.values().iterator();
        while (var0.hasNext()) {
            var0.next().a();
            var0.remove();
        }
    };

    private JfrProfiler() {
        h.forEach(FlightRecorder::register);
        this.f();
        FlightRecorder.addListener(new FlightRecorderListener(){

            @Override
            public void recordingStateChanged(Recording var0) {
                switch (var0.getState()) {
                    case STOPPED: {
                        JfrProfiler.this.f();
                        break;
                    }
                }
            }
        });
    }

    void f() {
        JfrProfiler.a(ClientFpsEvent.class, this.p);
        JfrProfiler.a(ServerTickTimeEvent.class, this.q);
        JfrProfiler.a(NetworkSummaryEvent.class, this.r);
    }

    private static void a(Class<? extends Event> var0, Runnable var1) {
        FlightRecorder.removePeriodicEvent(var1);
        FlightRecorder.addPeriodicEvent(var0, var1);
    }

    public static JfrProfiler a() {
        return k;
    }

    @Override
    public boolean a(Environment var0) {
        boolean bl;
        URL var1 = JfrProfiler.class.getResource(i);
        if (var1 == null) {
            g.warn("Could not find default flight recorder config at {}", (Object)i);
            return false;
        }
        BufferedReader var2 = new BufferedReader(new InputStreamReader(var1.openStream(), StandardCharsets.UTF_8));
        try {
            bl = this.a(var2, var0);
        }
        catch (Throwable throwable) {
            try {
                try {
                    var2.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException var22) {
                g.warn("Failed to start flight recorder using configuration at {}", (Object)var1, (Object)var22);
                return false;
            }
        }
        var2.close();
        return bl;
    }

    @Override
    public Path b() {
        if (this.l == null) {
            throw new IllegalStateException("Not currently profiling");
        }
        this.o.clear();
        Path var0 = this.l.getDestination();
        this.l.stop();
        return var0;
    }

    @Override
    public boolean c() {
        return this.l != null;
    }

    @Override
    public boolean d() {
        return FlightRecorder.isAvailable();
    }

    private boolean a(Reader var0, Environment var1) {
        if (this.c()) {
            g.warn("Profiling already in progress");
            return false;
        }
        try {
            Configuration var22 = Configuration.create(var0);
            String var3 = j.format(Instant.now());
            this.l = SystemUtils.a(new Recording(var22), (? super T var2) -> {
                h.forEach(var2::enable);
                var2.setDumpOnExit(true);
                var2.setToDisk(true);
                var2.setName(String.format(Locale.ROOT, "%s-%s-%s", var1.a(), SharedConstants.b().c(), var3));
            });
            Path var4 = Paths.get(String.format(Locale.ROOT, "debug/%s-%s.jfr", var1.a(), var3), new String[0]);
            FileUtils.c(var4.getParent());
            this.l.setDestination(var4);
            this.l.start();
            this.g();
        }
        catch (IOException | ParseException var23) {
            g.warn("Failed to start jfr profiling", (Throwable)var23);
            return false;
        }
        g.info("Started flight recorder profiling id({}):name({}) - will dump to {} on exit or stop command", new Object[]{this.l.getId(), this.l.getName(), this.l.getDestination()});
        return true;
    }

    private void g() {
        FlightRecorder.addListener(new FlightRecorderListener(){
            final SummaryReporter a = new SummaryReporter(() -> {
                JfrProfiler.this.l = null;
            });

            @Override
            public void recordingStateChanged(Recording var0) {
                if (var0 != JfrProfiler.this.l) {
                    return;
                }
                switch (var0.getState()) {
                    case STOPPED: {
                        this.a.a(var0.getDestination());
                        FlightRecorder.removeListener(this);
                        break;
                    }
                }
            }
        });
    }

    @Override
    public void a(int var0) {
        if (ClientFpsEvent.TYPE.isEnabled()) {
            this.m = var0;
        }
    }

    @Override
    public void a(float var0) {
        if (ServerTickTimeEvent.TYPE.isEnabled()) {
            this.n = var0;
        }
    }

    @Override
    public void a(EnumProtocol var0, PacketType<?> var1, SocketAddress var2, int var3) {
        if (PacketReceivedEvent.TYPE.isEnabled()) {
            new PacketReceivedEvent(var0.a(), var1.a().b(), var1.b().toString(), var2, var3).commit();
        }
        if (NetworkSummaryEvent.TYPE.isEnabled()) {
            this.a(var2).b(var3);
        }
    }

    @Override
    public void b(EnumProtocol var0, PacketType<?> var1, SocketAddress var2, int var3) {
        if (PacketSentEvent.TYPE.isEnabled()) {
            new PacketSentEvent(var0.a(), var1.a().b(), var1.b().toString(), var2, var3).commit();
        }
        if (NetworkSummaryEvent.TYPE.isEnabled()) {
            this.a(var2).a(var3);
        }
    }

    private NetworkSummaryEvent.b a(SocketAddress var0) {
        return this.o.computeIfAbsent(var0.toString(), NetworkSummaryEvent.b::new);
    }

    @Override
    public void a(RegionStorageInfo var0, ChunkCoordIntPair var1, RegionFileCompression var2, int var3) {
        if (ChunkRegionReadEvent.TYPE.isEnabled()) {
            new ChunkRegionReadEvent(var0, var1, var2, var3).commit();
        }
    }

    @Override
    public void b(RegionStorageInfo var0, ChunkCoordIntPair var1, RegionFileCompression var2, int var3) {
        if (ChunkRegionWriteEvent.TYPE.isEnabled()) {
            new ChunkRegionWriteEvent(var0, var1, var2, var3).commit();
        }
    }

    @Override
    public @Nullable ProfiledDuration e() {
        if (!WorldLoadFinishedEvent.TYPE.isEnabled()) {
            return null;
        }
        WorldLoadFinishedEvent var0 = new WorldLoadFinishedEvent();
        var0.begin();
        return var1 -> var0.commit();
    }

    @Override
    public @Nullable ProfiledDuration a(ChunkCoordIntPair var0, ResourceKey<World> var12, String var2) {
        if (!ChunkGenerationEvent.TYPE.isEnabled()) {
            return null;
        }
        ChunkGenerationEvent var3 = new ChunkGenerationEvent(var0, var12, var2);
        var3.begin();
        return var1 -> var3.commit();
    }

    @Override
    public @Nullable ProfiledDuration a(ChunkCoordIntPair var0, ResourceKey<World> var12, Holder<Structure> var2) {
        if (!StructureGenerationEvent.TYPE.isEnabled()) {
            return null;
        }
        StructureGenerationEvent var3 = new StructureGenerationEvent(var0, var2, var12);
        var3.begin();
        return var1 -> {
            var0.success = var1;
            var3.commit();
        };
    }
}

