/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.profiling.jfr.serialize;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.LongSerializationPolicy;
import com.mojang.datafixers.util.Pair;
import java.time.Duration;
import java.util.DoubleSummaryStatistics;
import java.util.IntSummaryStatistics;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import net.minecraft.util.SystemUtils;
import net.minecraft.util.profiling.jfr.Percentiles;
import net.minecraft.util.profiling.jfr.parse.JfrStatsResult;
import net.minecraft.util.profiling.jfr.stats.ChunkGenStat;
import net.minecraft.util.profiling.jfr.stats.ChunkIdentification;
import net.minecraft.util.profiling.jfr.stats.CpuLoadStat;
import net.minecraft.util.profiling.jfr.stats.FileIOStat;
import net.minecraft.util.profiling.jfr.stats.FpsStat;
import net.minecraft.util.profiling.jfr.stats.GcHeapStat;
import net.minecraft.util.profiling.jfr.stats.IoSummary;
import net.minecraft.util.profiling.jfr.stats.PacketIdentification;
import net.minecraft.util.profiling.jfr.stats.StructureGenStat;
import net.minecraft.util.profiling.jfr.stats.ThreadAllocationStat;
import net.minecraft.util.profiling.jfr.stats.TickTimeStat;
import net.minecraft.util.profiling.jfr.stats.TimedStatSummary;
import net.minecraft.world.level.chunk.status.ChunkStatus;

public class JfrResultJsonSerializer {
    private static final String b = "bytesPerSecond";
    private static final String c = "count";
    private static final String d = "durationNanosTotal";
    private static final String e = "totalBytes";
    private static final String f = "countPerSecond";
    final Gson a = new GsonBuilder().setPrettyPrinting().setLongSerializationPolicy(LongSerializationPolicy.DEFAULT).create();

    private static void a(PacketIdentification var0, JsonObject var1) {
        var1.addProperty("protocolId", var0.b());
        var1.addProperty("packetId", var0.c());
    }

    private static void a(ChunkIdentification var0, JsonObject var1) {
        var1.addProperty("level", var0.a());
        var1.addProperty("dimension", var0.b());
        var1.addProperty("x", (Number)var0.c());
        var1.addProperty("z", (Number)var0.d());
    }

    public String a(JfrStatsResult var0) {
        JsonObject var1 = new JsonObject();
        var1.addProperty("startedEpoch", (Number)var0.c().toEpochMilli());
        var1.addProperty("endedEpoch", (Number)var0.d().toEpochMilli());
        var1.addProperty("durationMs", (Number)var0.e().toMillis());
        Duration var2 = var0.f();
        if (var2 != null) {
            var1.addProperty("worldGenDurationMs", (Number)var2.toMillis());
        }
        var1.add("heap", this.a(var0.j()));
        var1.add("cpuPercent", this.e(var0.i()));
        var1.add("network", this.c(var0));
        var1.add("fileIO", this.b(var0));
        var1.add("fps", this.d(var0.g()));
        var1.add("serverTick", this.c(var0.h()));
        var1.add("threadAllocation", this.a(var0.k()));
        var1.add("chunkGen", this.b(var0.a()));
        var1.add("structureGen", this.a(var0.s()));
        return this.a.toJson((JsonElement)var1);
    }

    private JsonElement a(GcHeapStat.a var0) {
        JsonObject var1 = new JsonObject();
        var1.addProperty("allocationRateBytesPerSecond", (Number)var0.e());
        var1.addProperty("gcCount", (Number)var0.d());
        var1.addProperty("gcOverHeadPercent", (Number)Float.valueOf(var0.a()));
        var1.addProperty("gcTotalDurationMs", (Number)var0.c().toMillis());
        return var1;
    }

    private JsonElement a(List<StructureGenStat> var0) {
        JsonObject var1 = new JsonObject();
        Optional<TimedStatSummary<StructureGenStat>> var2 = TimedStatSummary.a(var0);
        if (var2.isEmpty()) {
            return var1;
        }
        TimedStatSummary<StructureGenStat> var32 = var2.get();
        JsonArray var42 = new JsonArray();
        var1.add("structure", (JsonElement)var42);
        var0.stream().collect(Collectors.groupingBy(StructureGenStat::c)).forEach((var3, var4) -> {
            Optional var5 = TimedStatSummary.a(var4);
            if (var5.isEmpty()) {
                return;
            }
            TimedStatSummary var6 = var5.get();
            JsonObject var7 = new JsonObject();
            var42.add((JsonElement)var7);
            var7.addProperty("name", var3);
            var7.addProperty(c, (Number)var6.d());
            var7.addProperty(d, (Number)var6.f().toNanos());
            var7.addProperty("durationNanosAvg", (Number)(var6.f().toNanos() / (long)var6.d()));
            JsonObject var8 = SystemUtils.a(new JsonObject(), (? super T var1) -> var7.add("durationNanosPercentiles", (JsonElement)var1));
            var6.e().forEach((var1, var2) -> var8.addProperty("p" + var1, (Number)var2));
            Function<StructureGenStat, JsonElement> var9 = var0 -> {
                JsonObject var1 = new JsonObject();
                var1.addProperty("durationNanos", (Number)var0.a().toNanos());
                var1.addProperty("chunkPosX", (Number)var0.b().h);
                var1.addProperty("chunkPosZ", (Number)var0.b().i);
                var1.addProperty("structureName", var0.c());
                var1.addProperty("level", var0.d());
                var1.addProperty("success", Boolean.valueOf(var0.e()));
                return var1;
            };
            var1.add("fastest", var9.apply((StructureGenStat)var32.a()));
            var1.add("slowest", var9.apply((StructureGenStat)var32.b()));
            var1.add("secondSlowest", (JsonElement)(var32.c() != null ? var9.apply((StructureGenStat)var32.c()) : JsonNull.INSTANCE));
        });
        return var1;
    }

    private JsonElement b(List<Pair<ChunkStatus, TimedStatSummary<ChunkGenStat>>> var02) {
        JsonObject var12 = new JsonObject();
        if (var02.isEmpty()) {
            return var12;
        }
        var12.addProperty(d, (Number)var02.stream().mapToDouble(var0 -> ((TimedStatSummary)var0.getSecond()).f().toNanos()).sum());
        JsonArray var22 = SystemUtils.a(new JsonArray(), (? super T var1) -> var12.add("status", (JsonElement)var1));
        for (Pair<ChunkStatus, TimedStatSummary<ChunkGenStat>> var4 : var02) {
            TimedStatSummary var5 = (TimedStatSummary)var4.getSecond();
            JsonObject var6 = SystemUtils.a(new JsonObject(), arg_0 -> ((JsonArray)var22).add(arg_0));
            var6.addProperty("state", ((ChunkStatus)var4.getFirst()).toString());
            var6.addProperty(c, (Number)var5.d());
            var6.addProperty(d, (Number)var5.f().toNanos());
            var6.addProperty("durationNanosAvg", (Number)(var5.f().toNanos() / (long)var5.d()));
            JsonObject var7 = SystemUtils.a(new JsonObject(), (? super T var1) -> var6.add("durationNanosPercentiles", (JsonElement)var1));
            var5.e().forEach((var1, var2) -> var7.addProperty("p" + var1, (Number)var2));
            Function<ChunkGenStat, JsonElement> var8 = var0 -> {
                JsonObject var1 = new JsonObject();
                var1.addProperty("durationNanos", (Number)var0.a().toNanos());
                var1.addProperty("level", var0.e());
                var1.addProperty("chunkPosX", (Number)var0.b().h);
                var1.addProperty("chunkPosZ", (Number)var0.b().i);
                var1.addProperty("worldPosX", (Number)var0.c().c());
                var1.addProperty("worldPosZ", (Number)var0.c().d());
                return var1;
            };
            var6.add("fastest", var8.apply((ChunkGenStat)var5.a()));
            var6.add("slowest", var8.apply((ChunkGenStat)var5.b()));
            var6.add("secondSlowest", (JsonElement)(var5.c() != null ? var8.apply((ChunkGenStat)var5.c()) : JsonNull.INSTANCE));
        }
        return var12;
    }

    private JsonElement a(ThreadAllocationStat.a var0) {
        JsonArray var12 = new JsonArray();
        var0.a().forEach((var1, var22) -> var12.add((JsonElement)SystemUtils.a(new JsonObject(), (? super T var2) -> {
            var2.addProperty("thread", var1);
            var2.addProperty(b, (Number)var22);
        })));
        return var12;
    }

    private JsonElement c(List<TickTimeStat> var02) {
        if (var02.isEmpty()) {
            return JsonNull.INSTANCE;
        }
        JsonObject var12 = new JsonObject();
        double[] var22 = var02.stream().mapToDouble(var0 -> (double)var0.b().toNanos() / 1000000.0).toArray();
        DoubleSummaryStatistics var3 = DoubleStream.of(var22).summaryStatistics();
        var12.addProperty("minMs", (Number)var3.getMin());
        var12.addProperty("averageMs", (Number)var3.getAverage());
        var12.addProperty("maxMs", (Number)var3.getMax());
        Map<Integer, Double> var4 = Percentiles.a(var22);
        var4.forEach((var1, var2) -> var12.addProperty("p" + var1, (Number)var2));
        return var12;
    }

    private JsonElement d(List<FpsStat> var0) {
        if (var0.isEmpty()) {
            return JsonNull.INSTANCE;
        }
        JsonObject var12 = new JsonObject();
        int[] var22 = var0.stream().mapToInt(FpsStat::a).toArray();
        IntSummaryStatistics var3 = IntStream.of(var22).summaryStatistics();
        var12.addProperty("minFPS", (Number)var3.getMin());
        var12.addProperty("averageFPS", (Number)var3.getAverage());
        var12.addProperty("maxFPS", (Number)var3.getMax());
        Map<Integer, Double> var4 = Percentiles.a(var22);
        var4.forEach((var1, var2) -> var12.addProperty("p" + var1, (Number)var2));
        return var12;
    }

    private JsonElement b(JfrStatsResult var0) {
        JsonObject var1 = new JsonObject();
        var1.add("write", this.a(var0.p()));
        var1.add("read", this.a(var0.q()));
        var1.add("chunksRead", this.a(var0.o(), JfrResultJsonSerializer::a));
        var1.add("chunksWritten", this.a(var0.n(), JfrResultJsonSerializer::a));
        return var1;
    }

    private JsonElement a(FileIOStat.a var0) {
        JsonObject var12 = new JsonObject();
        var12.addProperty(e, (Number)var0.a());
        var12.addProperty(c, (Number)var0.c());
        var12.addProperty(b, (Number)var0.b());
        var12.addProperty(f, (Number)var0.d());
        JsonArray var2 = new JsonArray();
        var12.add("topContributors", (JsonElement)var2);
        var0.f().forEach(var1 -> {
            JsonObject var2 = new JsonObject();
            var2.add((JsonElement)var2);
            var2.addProperty("path", (String)var1.getFirst());
            var2.addProperty(e, (Number)var1.getSecond());
        });
        return var12;
    }

    private JsonElement c(JfrStatsResult var0) {
        JsonObject var1 = new JsonObject();
        var1.add("sent", this.a(var0.m(), JfrResultJsonSerializer::a));
        var1.add("received", this.a(var0.l(), JfrResultJsonSerializer::a));
        return var1;
    }

    private <T> JsonElement a(IoSummary<T> var0, BiConsumer<T, JsonObject> var1) {
        JsonObject var22 = new JsonObject();
        var22.addProperty(e, (Number)var0.d());
        var22.addProperty(c, (Number)var0.c());
        var22.addProperty(b, (Number)var0.b());
        var22.addProperty(f, (Number)var0.a());
        JsonArray var3 = new JsonArray();
        var22.add("topContributors", (JsonElement)var3);
        var0.e().forEach(var2 -> {
            JsonObject var3 = new JsonObject();
            var3.add((JsonElement)var3);
            Object var4 = var2.getFirst();
            IoSummary.a var5 = (IoSummary.a)var2.getSecond();
            var1.accept(var4, var3);
            var3.addProperty(e, (Number)var5.c());
            var3.addProperty(c, (Number)var5.b());
            var3.addProperty("averageSize", (Number)Float.valueOf(var5.a()));
        });
        return var22;
    }

    private JsonElement e(List<CpuLoadStat> var02) {
        JsonObject var12 = new JsonObject();
        BiFunction<List, ToDoubleFunction, JsonObject> var2 = (var0, var1) -> {
            JsonObject var2 = new JsonObject();
            DoubleSummaryStatistics var3 = var0.stream().mapToDouble(var1).summaryStatistics();
            var2.addProperty("min", (Number)var3.getMin());
            var2.addProperty("average", (Number)var3.getAverage());
            var2.addProperty("max", (Number)var3.getMax());
            return var2;
        };
        var12.add("jvm", (JsonElement)var2.apply(var02, CpuLoadStat::a));
        var12.add("userJvm", (JsonElement)var2.apply(var02, CpuLoadStat::b));
        var12.add("system", (JsonElement)var2.apply(var02, CpuLoadStat::c));
        return var12;
    }
}

