/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.damagesource;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageScaling;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlock;
import org.jspecify.annotations.Nullable;

public class DamageSource {
    private final Holder<DamageType> a;
    private final @Nullable Entity b;
    private final @Nullable Entity c;
    private final @Nullable Vec3D d;
    private @Nullable Block directBlock;
    private @Nullable BlockState directBlockState;
    private boolean sweep = false;
    private boolean melting = false;
    private boolean poison = false;
    private Entity customEntityDamager = null;
    private Entity customCausingEntityDamager = null;

    public DamageSource sweep() {
        this.sweep = true;
        return this;
    }

    public boolean isSweep() {
        return this.sweep;
    }

    public DamageSource melting() {
        this.melting = true;
        return this;
    }

    public boolean isMelting() {
        return this.melting;
    }

    public DamageSource poison() {
        this.poison = true;
        return this;
    }

    public boolean isPoison() {
        return this.poison;
    }

    public Entity getDamager() {
        return this.customEntityDamager != null ? this.customEntityDamager : this.c;
    }

    public Entity getCausingDamager() {
        return this.customCausingEntityDamager != null ? this.customCausingEntityDamager : this.b;
    }

    public DamageSource customEntityDamager(Entity entity) {
        if (this.customEntityDamager != null || this.c == entity || this.b == entity) {
            return this;
        }
        DamageSource damageSource = this.cloneInstance();
        damageSource.customEntityDamager = entity;
        return damageSource;
    }

    public DamageSource customCausingEntityDamager(Entity entity) {
        if (this.customCausingEntityDamager != null || this.c == entity || this.b == entity) {
            return this;
        }
        DamageSource damageSource = this.cloneInstance();
        damageSource.customCausingEntityDamager = entity;
        return damageSource;
    }

    public Block getDirectBlock() {
        return this.directBlock;
    }

    public DamageSource directBlock(World world, BlockPosition blockPosition) {
        if (blockPosition == null || world == null) {
            return this;
        }
        return this.directBlock(CraftBlock.at(world, blockPosition));
    }

    public DamageSource directBlock(Block block) {
        if (block == null) {
            return this;
        }
        DamageSource damageSource = this.cloneInstance();
        damageSource.directBlock = block;
        return damageSource;
    }

    public BlockState getDirectBlockState() {
        return this.directBlockState;
    }

    public DamageSource directBlockState(BlockState blockState) {
        if (blockState == null) {
            return this;
        }
        DamageSource damageSource = this.cloneInstance();
        damageSource.directBlockState = blockState;
        return damageSource;
    }

    private DamageSource cloneInstance() {
        DamageSource damageSource = new DamageSource(this.a, this.c, this.b, this.d);
        damageSource.directBlock = this.getDirectBlock();
        damageSource.directBlockState = this.getDirectBlockState();
        damageSource.sweep = this.isSweep();
        damageSource.poison = this.isPoison();
        damageSource.melting = this.isMelting();
        return damageSource;
    }

    public String toString() {
        return "DamageSource (" + this.k().a() + ")";
    }

    public float a() {
        return this.k().c();
    }

    public boolean b() {
        return this.b == this.c;
    }

    public DamageSource(Holder<DamageType> holder, @Nullable Entity entity, @Nullable Entity entity1, @Nullable Vec3D vec3d) {
        this.a = holder;
        this.b = entity1;
        this.c = entity;
        this.d = vec3d;
    }

    public DamageSource(Holder<DamageType> holder, @Nullable Entity entity, @Nullable Entity entity1) {
        this(holder, entity, entity1, null);
    }

    public DamageSource(Holder<DamageType> holder, Vec3D vec3d) {
        this(holder, null, null, vec3d);
    }

    public DamageSource(Holder<DamageType> holder, @Nullable Entity entity) {
        this(holder, entity, entity);
    }

    public DamageSource(Holder<DamageType> holder) {
        this(holder, null, null, null);
    }

    public @Nullable Entity c() {
        return this.c;
    }

    public @Nullable Entity d() {
        return this.b;
    }

    public @Nullable ItemStack e() {
        return this.c != null ? this.c.eq() : null;
    }

    public IChatBaseComponent a(EntityLiving entityliving) {
        ItemStack itemstack;
        String s2 = "death.attack." + this.k().a();
        if (this.b == null && this.c == null) {
            EntityLiving entityliving1 = entityliving.fp();
            String s1 = s2 + ".player";
            return entityliving1 != null ? IChatBaseComponent.a(s1, entityliving.R_(), entityliving1.R_()) : IChatBaseComponent.a(s2, entityliving.R_());
        }
        IChatBaseComponent ichatbasecomponent = this.b == null ? this.c.R_() : this.b.R_();
        Entity entity = this.b;
        if (entity instanceof EntityLiving) {
            EntityLiving entityliving2 = (EntityLiving)entity;
            itemstack = entityliving2.fx();
        } else {
            itemstack = ItemStack.l;
        }
        ItemStack itemstack1 = itemstack;
        return !itemstack1.f() && itemstack1.c(DataComponents.h) ? IChatBaseComponent.a(s2 + ".item", entityliving.R_(), ichatbasecomponent, itemstack1.K()) : IChatBaseComponent.a(s2, entityliving.R_(), ichatbasecomponent);
    }

    public String f() {
        return this.k().a();
    }

    public boolean g() {
        return switch (this.k().b()) {
            case DamageScaling.a -> false;
            case DamageScaling.b -> this.b instanceof EntityLiving && !(this.b instanceof EntityHuman);
            case DamageScaling.c -> true;
            default -> throw new MatchException(null, null);
        };
    }

    public boolean h() {
        Entity entity = this.d();
        if (entity instanceof EntityHuman) {
            EntityHuman entityhuman = (EntityHuman)entity;
            if (entityhuman.gL().d) {
                boolean flag = true;
                return flag;
            }
        }
        boolean flag = false;
        return flag;
    }

    public @Nullable Vec3D i() {
        return this.d != null ? this.d : (this.c != null ? this.c.dI() : null);
    }

    public @Nullable Vec3D j() {
        return this.d;
    }

    public boolean a(TagKey<DamageType> tagkey) {
        return this.a.a(tagkey);
    }

    public boolean a(ResourceKey<DamageType> resourcekey) {
        return this.a.a(resourcekey);
    }

    public DamageType k() {
        return this.a.a();
    }

    public Holder<DamageType> l() {
        return this.a;
    }
}

