/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.sensing;

import com.google.common.collect.ImmutableSet;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;

public class TemptingSensor
extends Sensor<EntityCreature> {
    private static final PathfinderTargetCondition a = PathfinderTargetCondition.b().d();
    private final BiPredicate<EntityCreature, ItemStack> b;

    public TemptingSensor(Predicate<ItemStack> predicate) {
        this((EntityCreature entitycreature, ItemStack itemstack) -> predicate.test((ItemStack)itemstack));
    }

    public static TemptingSensor b() {
        return new TemptingSensor((entitycreature, itemstack) -> {
            if (entitycreature instanceof EntityAnimal) {
                EntityAnimal entityanimal = (EntityAnimal)entitycreature;
                return entityanimal.j((ItemStack)itemstack);
            }
            return false;
        });
    }

    private TemptingSensor(BiPredicate<EntityCreature, ItemStack> bipredicate) {
        this.b = bipredicate;
    }

    @Override
    protected void a(WorldServer worldserver, EntityCreature entitycreature) {
        BehaviorController<?> behaviorcontroller = entitycreature.ev();
        PathfinderTargetCondition pathfindertargetcondition = a.c().a((float)entitycreature.i(GenericAttributes.G));
        Stream<EntityPlayer> stream = worldserver.E().stream().filter(IEntitySelector.f).filter(entityplayer -> pathfindertargetcondition.a(worldserver, entitycreature, (EntityLiving)entityplayer)).filter(entityplayer -> this.a(entitycreature, (EntityHuman)entityplayer)).filter(entityplayer -> !entitycreature.z((Entity)entityplayer));
        Objects.requireNonNull(entitycreature);
        List list = stream.sorted(Comparator.comparingDouble(entitycreature::g)).collect(Collectors.toList());
        if (!list.isEmpty()) {
            EntityHuman entityhuman = (EntityHuman)list.get(0);
            EntityTargetLivingEntityEvent event = CraftEventFactory.callEntityTargetLivingEvent(entitycreature, entityhuman, EntityTargetEvent.TargetReason.TEMPT);
            if (event.isCancelled()) {
                return;
            }
            if (event.getTarget() instanceof HumanEntity) {
                behaviorcontroller.a(MemoryModuleType.P, ((CraftHumanEntity)event.getTarget()).getHandle());
            } else {
                behaviorcontroller.b(MemoryModuleType.P);
            }
        } else {
            behaviorcontroller.b(MemoryModuleType.P);
        }
    }

    private boolean a(EntityCreature entitycreature, EntityHuman entityhuman) {
        return this.a(entitycreature, entityhuman.fx()) || this.a(entitycreature, entityhuman.fy());
    }

    private boolean a(EntityCreature entitycreature, ItemStack itemstack) {
        return this.b.test(entitycreature, itemstack);
    }

    @Override
    public Set<MemoryModuleType<?>> a() {
        return ImmutableSet.of(MemoryModuleType.P);
    }
}

