/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.chicken;

import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.chicken.ChickenVariant;
import net.minecraft.world.entity.animal.chicken.ChickenVariants;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.variant.SpawnContext;
import net.minecraft.world.entity.variant.VariantUtils;
import net.minecraft.world.item.EitherHolder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.phys.Vec3D;
import org.jspecify.annotations.Nullable;

public class EntityChicken
extends EntityAnimal {
    private static final EntitySize cD = EntityTypes.C.n().a(0.5f).b(0.2975f);
    private static final DataWatcherObject<Holder<ChickenVariant>> cE = DataWatcher.a(EntityChicken.class, DataWatcherRegistry.x);
    private static final boolean cF = false;
    public float cv;
    public float cw;
    public float cx;
    public float cz;
    public float cA = 1.0f;
    private float cG = 1.0f;
    public int cB = this.as.a(6000) + 6000;
    public boolean cC = false;

    public EntityChicken(EntityTypes<? extends EntityChicken> entitytypes, World world) {
        super((EntityTypes<? extends EntityAnimal>)entitytypes, world);
        this.a(PathType.j, 0.0f);
    }

    @Override
    protected void D() {
        this.cs.a(0, new PathfinderGoalFloat(this));
        this.cs.a(1, new PathfinderGoalPanic(this, 1.4));
        this.cs.a(2, new PathfinderGoalBreed(this, 1.0));
        this.cs.a(3, new PathfinderGoalTempt(this, 1.0, itemstack -> itemstack.a(TagsItem.aS), false));
        this.cs.a(4, new PathfinderGoalFollowParent(this, 1.1));
        this.cs.a(5, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.cs.a(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.cs.a(7, new PathfinderGoalRandomLookaround(this));
    }

    @Override
    public EntitySize b(EntityPose entitypose) {
        return this.e_() ? cD : super.b(entitypose);
    }

    public static AttributeProvider.Builder p() {
        return EntityAnimal.gW().a(GenericAttributes.u, 4.0).a(GenericAttributes.x, 0.25);
    }

    @Override
    public void d_() {
        super.d_();
        this.cz = this.cv;
        this.cx = this.cw;
        this.cw += (this.aV() ? -1.0f : 4.0f) * 0.3f;
        this.cw = MathHelper.a(this.cw, 0.0f, 1.0f);
        if (!this.aV() && this.cA < 1.0f) {
            this.cA = 1.0f;
        }
        this.cA *= 0.9f;
        Vec3D vec3d = this.dN();
        if (!this.aV() && vec3d.h < 0.0) {
            this.k(vec3d.d(1.0, 0.6, 1.0));
        }
        this.cv += this.cA * 2.0f;
        World world = this.ao();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            if (this.cb() && !this.e_() && !this.gQ() && --this.cB <= 0) {
                this.forceDrops = true;
                if (this.a(worldserver, LootTables.aI, this::a)) {
                    this.a(SoundEffects.fu, 1.0f, (this.as.i() - this.as.i()) * 0.2f + 1.0f);
                    this.c(GameEvent.t);
                }
                this.forceDrops = false;
                this.cB = this.as.a(6000) + 6000;
            }
        }
    }

    @Override
    protected boolean bp() {
        return this.am > this.cG;
    }

    @Override
    protected void bo() {
        this.cG = this.am + this.cw / 2.0f;
    }

    @Override
    protected SoundEffect W() {
        return SoundEffects.fs;
    }

    @Override
    protected SoundEffect h(DamageSource damagesource) {
        return SoundEffects.fv;
    }

    @Override
    protected SoundEffect fd() {
        return SoundEffects.ft;
    }

    @Override
    protected void b(BlockPosition blockposition, IBlockData iblockdata) {
        this.a(SoundEffects.fw, 0.15f, 1.0f);
    }

    public @Nullable EntityChicken b(WorldServer worldserver, EntityAgeable entityageable) {
        EntityChicken entitychicken = EntityTypes.C.a(worldserver, EntitySpawnReason.e);
        if (entitychicken != null && entityageable instanceof EntityChicken) {
            EntityChicken entitychicken1 = (EntityChicken)entityageable;
            entitychicken.b(this.as.h() ? this.gP() : entitychicken1.gP());
        }
        return entitychicken;
    }

    @Override
    public GroupDataEntity a(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EntitySpawnReason entityspawnreason, @Nullable GroupDataEntity groupdataentity) {
        VariantUtils.a(SpawnContext.a(worldaccess, this.dK()), Registries.aV).ifPresent(this::b);
        return super.a(worldaccess, difficultydamagescaler, entityspawnreason, groupdataentity);
    }

    @Override
    public boolean j(ItemStack itemstack) {
        return itemstack.a(TagsItem.aS);
    }

    @Override
    protected int f(WorldServer worldserver) {
        return this.gQ() ? 10 : super.f(worldserver);
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(cE, VariantUtils.a(this.eo(), ChickenVariants.a));
    }

    @Override
    protected void a(ValueInput valueinput) {
        super.a(valueinput);
        this.cC = valueinput.a("IsChickenJockey", false);
        valueinput.e("EggLayTime").ifPresent(integer -> {
            this.cB = integer;
        });
        VariantUtils.a(valueinput, Registries.aV).ifPresent(this::b);
    }

    @Override
    protected void a(ValueOutput valueoutput) {
        super.a(valueoutput);
        valueoutput.a("IsChickenJockey", this.cC);
        valueoutput.a("EggLayTime", this.cB);
        VariantUtils.a(valueoutput, this.gP());
    }

    public void b(Holder<ChickenVariant> holder) {
        this.az.a(cE, holder);
    }

    public Holder<ChickenVariant> gP() {
        return this.az.a(cE);
    }

    @Override
    public <T> @Nullable T a(DataComponentType<? extends T> datacomponenttype) {
        return datacomponenttype == DataComponents.aQ ? EntityChicken.c(datacomponenttype, new EitherHolder<ChickenVariant>(this.gP())) : super.a(datacomponenttype);
    }

    @Override
    protected void a(DataComponentGetter datacomponentgetter) {
        this.a(datacomponentgetter, DataComponents.aQ);
        super.a(datacomponentgetter);
    }

    @Override
    protected <T> boolean b(DataComponentType<T> datacomponenttype, T t0) {
        if (datacomponenttype == DataComponents.aQ) {
            Optional<Holder<ChickenVariant>> optional = EntityChicken.c(DataComponents.aQ, t0).a(this.eo());
            if (optional.isPresent()) {
                this.b(optional.get());
                return true;
            }
            return false;
        }
        return super.b(datacomponenttype, t0);
    }

    @Override
    public boolean i(double d0) {
        return this.gQ();
    }

    @Override
    protected void a(Entity entity, Entity.MoveFunction entity_movefunction) {
        super.a(entity, entity_movefunction);
        if (entity instanceof EntityLiving) {
            ((EntityLiving)entity).bC = this.bC;
        }
    }

    public boolean gQ() {
        return this.cC;
    }

    public void x(boolean flag) {
        this.cC = flag;
    }
}

