/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.cow;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import java.util.UUID;
import java.util.function.IntFunction;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.particles.SpellParticleOption;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.INamable;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.IShearable;
import net.minecraft.world.entity.animal.cow.AbstractCow;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemLiquidUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.SuspiciousStewEffects;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SuspiciousEffectHolder;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootTables;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.entity.Item;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDropItemEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.jspecify.annotations.Nullable;

public class EntityMushroomCow
extends AbstractCow
implements IShearable {
    private static final DataWatcherObject<Integer> cv = DataWatcher.a(EntityMushroomCow.class, DataWatcherRegistry.b);
    private static final int cw = 1024;
    private static final String cx = "stew_effects";
    public @Nullable SuspiciousStewEffects cz;
    private @Nullable UUID cA;

    public EntityMushroomCow(EntityTypes<? extends EntityMushroomCow> entitytypes, World world) {
        super((EntityTypes<? extends AbstractCow>)entitytypes, world);
    }

    @Override
    public float a(BlockPosition blockposition, IWorldReader iworldreader) {
        return iworldreader.a_(blockposition.e()).a(Blocks.fU) ? 10.0f : iworldreader.C(blockposition);
    }

    public static boolean c(EntityTypes<EntityMushroomCow> entitytypes, GeneratorAccess generatoraccess, EntitySpawnReason entityspawnreason, BlockPosition blockposition, RandomSource randomsource) {
        return generatoraccess.a_(blockposition.e()).a(TagsBlock.cp) && EntityMushroomCow.a(generatoraccess, blockposition);
    }

    @Override
    public void a(WorldServer worldserver, EntityLightning entitylightning) {
        UUID uuid = entitylightning.cY();
        if (!uuid.equals(this.cA)) {
            this.a(this.gP() == Type.a ? Type.b : Type.a);
            this.cA = uuid;
            this.a(SoundEffects.rc, 2.0f, 1.0f);
        }
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(cv, Type.c.h);
    }

    @Override
    public EnumInteractionResult b(EntityHuman entityhuman, EnumHand enumhand) {
        ItemStack itemstack = entityhuman.b(enumhand);
        if (itemstack.a(Items.pU) && !this.e_()) {
            ItemStack itemstack1;
            boolean flag = false;
            if (this.cz != null) {
                flag = true;
                itemstack1 = new ItemStack(Items.yA);
                itemstack1.b(DataComponents.aa, this.cz);
                this.cz = null;
            } else {
                itemstack1 = new ItemStack(Items.qX);
            }
            ItemStack itemstack2 = ItemLiquidUtil.a(itemstack, entityhuman, itemstack1, false);
            entityhuman.a(enumhand, itemstack2);
            SoundEffect soundeffect = flag ? SoundEffects.rf : SoundEffects.re;
            this.a(soundeffect, 1.0f, 1.0f);
            return EnumInteractionResult.a;
        }
        if (itemstack.a(Items.tZ) && this.a()) {
            World world = this.ao();
            if (world instanceof WorldServer) {
                WorldServer worldserver = (WorldServer)world;
                if (!CraftEventFactory.handlePlayerShearEntityEvent(entityhuman, this, itemstack, enumhand)) {
                    return EnumInteractionResult.e;
                }
                this.a(worldserver, SoundCategory.h, itemstack);
                this.a(GameEvent.M, (Entity)entityhuman);
                itemstack.a(1, (EntityLiving)entityhuman, enumhand.a());
            }
            return EnumInteractionResult.a;
        }
        if (this.gP() == Type.b) {
            Optional<SuspiciousStewEffects> optional = this.k(itemstack);
            if (optional.isEmpty()) {
                return super.b(entityhuman, enumhand);
            }
            if (this.cz != null) {
                for (int i2 = 0; i2 < 2; ++i2) {
                    this.ao().a(Particles.ai, this.dP() + this.as.j() / 2.0, this.f(0.5), this.dV() + this.as.j() / 2.0, 0.0, this.as.j() / 5.0, 0.0);
                }
            } else {
                itemstack.a(1, (EntityLiving)entityhuman);
                SpellParticleOption spellparticleoption = SpellParticleOption.a(Particles.q, -1, 1.0f);
                for (int j2 = 0; j2 < 4; ++j2) {
                    this.ao().a(spellparticleoption, this.dP() + this.as.j() / 2.0, this.f(0.5), this.dV() + this.as.j() / 2.0, 0.0, this.as.j() / 5.0, 0.0);
                }
                this.cz = optional.get();
                this.a(SoundEffects.rd, 2.0f, 1.0f);
            }
            return EnumInteractionResult.a;
        }
        return super.b(entityhuman, enumhand);
    }

    @Override
    public void a(WorldServer worldserver, SoundCategory soundcategory, ItemStack itemstack) {
        worldserver.a((Entity)null, this, SoundEffects.rg, soundcategory, 1.0f, 1.0f);
        this.convertTo(EntityTypes.G, ConversionParams.a(this, false, false), entitycow -> {
            worldserver.a(Particles.x, this.dP(), this.f(0.5), this.dV(), 1, 0.0, 0.0, 0.0, 0.0);
            this.a(worldserver, LootTables.aX, itemstack, (WorldServer worldserver1, ItemStack itemstack1) -> {
                for (int i2 = 0; i2 < itemstack1.N(); ++i2) {
                    EntityItem entityitem = new EntityItem(this.ao(), this.dP(), this.f(1.0), this.dV(), itemstack1.c(1));
                    EntityDropItemEvent event = new EntityDropItemEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (Item)entityitem.getBukkitEntity());
                    Bukkit.getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) continue;
                    worldserver1.b(entityitem);
                }
            });
        }, EntityTransformEvent.TransformReason.SHEARED, CreatureSpawnEvent.SpawnReason.SHEARED);
    }

    @Override
    public boolean a() {
        return this.cb() && !this.e_();
    }

    @Override
    protected void a(ValueOutput valueoutput) {
        super.a(valueoutput);
        valueoutput.a("Type", Type.d, this.gP());
        valueoutput.b(cx, SuspiciousStewEffects.c, this.cz);
    }

    @Override
    protected void a(ValueInput valueinput) {
        super.a(valueinput);
        this.a(valueinput.a("Type", Type.d).orElse(Type.c));
        this.cz = valueinput.a(cx, SuspiciousStewEffects.c).orElse(null);
    }

    private Optional<SuspiciousStewEffects> k(ItemStack itemstack) {
        SuspiciousEffectHolder suspiciouseffectholder = SuspiciousEffectHolder.a(itemstack.h());
        return suspiciouseffectholder != null ? Optional.of(suspiciouseffectholder.c()) : Optional.empty();
    }

    public void a(Type entitymushroomcow_type) {
        this.az.a(cv, entitymushroomcow_type.h);
    }

    public Type gP() {
        return Type.a(this.az.a(cv));
    }

    @Override
    public <T> @Nullable T a(DataComponentType<? extends T> datacomponenttype) {
        return datacomponenttype == DataComponents.aM ? EntityMushroomCow.c(datacomponenttype, this.gP()) : super.a(datacomponenttype);
    }

    @Override
    protected void a(DataComponentGetter datacomponentgetter) {
        this.a(datacomponentgetter, DataComponents.aM);
        super.a(datacomponentgetter);
    }

    @Override
    protected <T> boolean b(DataComponentType<T> datacomponenttype, T t0) {
        if (datacomponenttype == DataComponents.aM) {
            this.a(EntityMushroomCow.c(DataComponents.aM, t0));
            return true;
        }
        return super.b(datacomponenttype, t0);
    }

    public @Nullable EntityMushroomCow b(WorldServer worldserver, EntityAgeable entityageable) {
        EntityMushroomCow entitymushroomcow = EntityTypes.aK.a(worldserver, EntitySpawnReason.e);
        if (entitymushroomcow != null) {
            entitymushroomcow.a(this.a((EntityMushroomCow)entityageable));
        }
        return entitymushroomcow;
    }

    private Type a(EntityMushroomCow entitymushroomcow) {
        Type entitymushroomcow_type1;
        Type entitymushroomcow_type = this.gP();
        Type entitymushroomcow_type2 = entitymushroomcow_type == (entitymushroomcow_type1 = entitymushroomcow.gP()) && this.as.a(1024) == 0 ? (entitymushroomcow_type == Type.b ? Type.a : Type.b) : (this.as.h() ? entitymushroomcow_type : entitymushroomcow_type1);
        return entitymushroomcow_type2;
    }

    public static enum Type implements INamable
    {
        a("red", 0, Blocks.cq.m()),
        b("brown", 1, Blocks.cp.m());

        public static final Type c;
        public static final Codec<Type> d;
        private static final IntFunction<Type> f;
        public static final StreamCodec<ByteBuf, Type> e;
        private final String g;
        final int h;
        private final IBlockData i;

        private Type(String s2, int i2, IBlockData iblockdata) {
            this.g = s2;
            this.h = i2;
            this.i = iblockdata;
        }

        public IBlockData a() {
            return this.i;
        }

        @Override
        public String c() {
            return this.g;
        }

        private int b() {
            return this.h;
        }

        static Type a(int i2) {
            return f.apply(i2);
        }

        static {
            c = a;
            d = INamable.a(Type::values);
            f = ByIdMap.a(Type::b, Type.values(), ByIdMap.a.c);
            e = ByteBufCodecs.a(f, Type::b);
        }
    }
}

