/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.parrot;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.PrimitiveCodec;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SystemUtils;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerMoveFlying;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowEntity;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowOwner;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPerch;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomFly;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSit;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.navigation.NavigationFlying;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityBird;
import net.minecraft.world.entity.animal.parrot.EntityPerchable;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.BlockLeaves;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.jspecify.annotations.Nullable;

public class EntityParrot
extends EntityPerchable
implements EntityBird {
    private static final DataWatcherObject<Integer> cD = DataWatcher.a(EntityParrot.class, DataWatcherRegistry.b);
    private static final Predicate<EntityInsentient> cE = new Predicate<EntityInsentient>(){

        public boolean a(@Nullable EntityInsentient entityinsentient) {
            return entityinsentient != null && cF.containsKey(entityinsentient.ay());
        }
    };
    static final Map<EntityTypes<?>, SoundEffect> cF = SystemUtils.a(Maps.newHashMap(), (? super T hashmap) -> {
        hashmap.put(EntityTypes.q, SoundEffects.vr);
        hashmap.put(EntityTypes.s, SoundEffects.vs);
        hashmap.put(EntityTypes.t, SoundEffects.vt);
        hashmap.put(EntityTypes.w, SoundEffects.vu);
        hashmap.put(EntityTypes.y, SoundEffects.vS);
        hashmap.put(EntityTypes.H, SoundEffects.vv);
        hashmap.put(EntityTypes.I, SoundEffects.vw);
        hashmap.put(EntityTypes.O, SoundEffects.vx);
        hashmap.put(EntityTypes.Q, SoundEffects.vy);
        hashmap.put(EntityTypes.T, SoundEffects.vz);
        hashmap.put(EntityTypes.S, SoundEffects.vA);
        hashmap.put(EntityTypes.W, SoundEffects.vB);
        hashmap.put(EntityTypes.ah, SoundEffects.vC);
        hashmap.put(EntityTypes.ai, SoundEffects.tA);
        hashmap.put(EntityTypes.an, SoundEffects.vD);
        hashmap.put(EntityTypes.ao, SoundEffects.vE);
        hashmap.put(EntityTypes.ar, SoundEffects.vF);
        hashmap.put(EntityTypes.as, SoundEffects.vG);
        hashmap.put(EntityTypes.aE, SoundEffects.vH);
        hashmap.put(EntityTypes.aV, SoundEffects.vJ);
        hashmap.put(EntityTypes.aX, SoundEffects.vI);
        hashmap.put(EntityTypes.aZ, SoundEffects.vK);
        hashmap.put(EntityTypes.ba, SoundEffects.vL);
        hashmap.put(EntityTypes.bb, SoundEffects.vM);
        hashmap.put(EntityTypes.bh, SoundEffects.vN);
        hashmap.put(EntityTypes.bk, SoundEffects.vO);
        hashmap.put(EntityTypes.bm, SoundEffects.vP);
        hashmap.put(EntityTypes.bn, SoundEffects.vQ);
        hashmap.put(EntityTypes.bp, SoundEffects.vR);
        hashmap.put(EntityTypes.bw, SoundEffects.vS);
        hashmap.put(EntityTypes.bA, SoundEffects.vT);
        hashmap.put(EntityTypes.bK, SoundEffects.vU);
        hashmap.put(EntityTypes.bM, SoundEffects.vV);
        hashmap.put(EntityTypes.bO, SoundEffects.vW);
        hashmap.put(EntityTypes.bQ, SoundEffects.vX);
        hashmap.put(EntityTypes.bR, SoundEffects.vY);
        hashmap.put(EntityTypes.bS, SoundEffects.vZ);
        hashmap.put(EntityTypes.bV, SoundEffects.wa);
        hashmap.put(EntityTypes.bW, SoundEffects.wb);
        hashmap.put(EntityTypes.bX, SoundEffects.wc);
        hashmap.put(EntityTypes.bY, SoundEffects.wd);
        hashmap.put(EntityTypes.bZ, SoundEffects.we);
    });
    public float cz;
    public float cA;
    public float cB;
    public float cC;
    private float cG = 1.0f;
    private float cH = 1.0f;
    private boolean cI;
    private @Nullable BlockPosition cJ;

    public EntityParrot(EntityTypes<? extends EntityParrot> entitytypes, World world) {
        super((EntityTypes<? extends EntityPerchable>)entitytypes, world);
        this.cp = new ControllerMoveFlying(this, 10, false);
        this.a(PathType.n, -1.0f);
        this.a(PathType.o, -1.0f);
        this.a(PathType.x, -1.0f);
    }

    @Override
    public @Nullable GroupDataEntity a(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EntitySpawnReason entityspawnreason, @Nullable GroupDataEntity groupdataentity) {
        this.a(SystemUtils.a(Variant.values(), worldaccess.G_()));
        if (groupdataentity == null) {
            groupdataentity = new EntityAgeable.a(false);
        }
        return super.a(worldaccess, difficultydamagescaler, entityspawnreason, groupdataentity);
    }

    @Override
    public boolean e_() {
        return false;
    }

    @Override
    protected void D() {
        this.cs.a(0, new EntityTameableAnimal.a(1.25));
        this.cs.a(0, new PathfinderGoalFloat(this));
        this.cs.a(1, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.cs.a(2, new PathfinderGoalSit(this));
        this.cs.a(2, new PathfinderGoalFollowOwner(this, 1.0, 5.0f, 1.0f));
        this.cs.a(2, new a(this, 1.0));
        this.cs.a(3, new PathfinderGoalPerch(this));
        this.cs.a(3, new PathfinderGoalFollowEntity(this, 1.0, 3.0f, 7.0f));
    }

    public static AttributeProvider.Builder hd() {
        return EntityAnimal.gW().a(GenericAttributes.u, 6.0).a(GenericAttributes.n, 0.4f).a(GenericAttributes.x, 0.2f).a(GenericAttributes.d, 3.0);
    }

    @Override
    protected NavigationAbstract b(World world) {
        NavigationFlying navigationflying = new NavigationFlying(this, world);
        navigationflying.e(false);
        navigationflying.a(true);
        return navigationflying;
    }

    @Override
    public void d_() {
        if (this.cJ == null || !this.cJ.a(this.dI(), 3.46) || !this.ao().a_(this.cJ).a(Blocks.ew)) {
            this.cI = false;
            this.cJ = null;
        }
        if (this.ao().y.a(400) == 0) {
            EntityParrot.a(this.ao(), this);
        }
        super.d_();
        this.hh();
    }

    @Override
    public void a(BlockPosition blockposition, boolean flag) {
        this.cJ = blockposition;
        this.cI = flag;
    }

    public boolean he() {
        return this.cI;
    }

    private void hh() {
        this.cC = this.cz;
        this.cB = this.cA;
        this.cA += (float)(!this.aV() && !this.cq() ? 4 : -1) * 0.3f;
        this.cA = MathHelper.a(this.cA, 0.0f, 1.0f);
        if (!this.aV() && this.cG < 1.0f) {
            this.cG = 1.0f;
        }
        this.cG *= 0.9f;
        Vec3D vec3d = this.dN();
        if (!this.aV() && vec3d.h < 0.0) {
            this.k(vec3d.d(1.0, 0.6, 1.0));
        }
        this.cz += this.cG * 2.0f;
    }

    public static boolean a(World world, Entity entity) {
        if (entity.cb() && !entity.bq() && world.y.a(2) == 0) {
            EntityInsentient entityinsentient;
            List<EntityInsentient> list = world.a(EntityInsentient.class, entity.dj().g(20.0), cE);
            if (!list.isEmpty() && !(entityinsentient = list.get(world.y.a(list.size()))).bq()) {
                SoundEffect soundeffect = EntityParrot.b(entityinsentient.ay());
                world.a((Entity)null, entity.dP(), entity.dR(), entity.dV(), soundeffect, entity.dB(), 0.7f, EntityParrot.a(world.y));
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public EnumInteractionResult b(EntityHuman entityhuman, EnumHand enumhand) {
        ItemStack itemstack = entityhuman.b(enumhand);
        if (!this.p() && itemstack.a(TagsItem.bf)) {
            this.a(entityhuman, enumhand, itemstack);
            if (!this.bq()) {
                this.ao().a((Entity)null, this.dP(), this.dR(), this.dV(), SoundEffects.vo, this.dB(), 1.0f, 1.0f + (this.as.i() - this.as.i()) * 0.2f);
            }
            if (!this.ao().B_()) {
                if (this.as.a(10) == 0 && !CraftEventFactory.callEntityTameEvent(this, entityhuman).isCancelled()) {
                    this.g(entityhuman);
                    this.ao().a((Entity)this, (byte)7);
                } else {
                    this.ao().a((Entity)this, (byte)6);
                }
            }
            return EnumInteractionResult.a;
        }
        if (!itemstack.a(TagsItem.bg)) {
            if (!this.d() && this.p() && this.j(entityhuman)) {
                if (!this.ao().B_()) {
                    this.z(!this.gR());
                }
                return EnumInteractionResult.a;
            }
            return super.b(entityhuman, enumhand);
        }
        this.a(entityhuman, enumhand, itemstack);
        this.addEffect(new MobEffect(MobEffects.s, 900), EntityPotionEffectEvent.Cause.FOOD);
        if (entityhuman.ha() || !this.cU()) {
            this.a(this.en().a(entityhuman), Float.MAX_VALUE);
        }
        return EnumInteractionResult.a;
    }

    @Override
    public boolean j(ItemStack itemstack) {
        return false;
    }

    public static boolean c(EntityTypes<EntityParrot> entitytypes, GeneratorAccess generatoraccess, EntitySpawnReason entityspawnreason, BlockPosition blockposition, RandomSource randomsource) {
        return generatoraccess.a_(blockposition.e()).a(TagsBlock.cq) && EntityParrot.a(generatoraccess, blockposition);
    }

    @Override
    protected void a(double d0, boolean flag, IBlockData iblockdata, BlockPosition blockposition) {
    }

    @Override
    public boolean a(EntityAnimal entityanimal) {
        return false;
    }

    @Override
    public @Nullable EntityAgeable a(WorldServer worldserver, EntityAgeable entityageable) {
        return null;
    }

    @Override
    public @Nullable SoundEffect W() {
        return EntityParrot.a(this.ao(), this.ao().y);
    }

    public static SoundEffect a(World world, RandomSource randomsource) {
        if (world.av() != EnumDifficulty.a && randomsource.a(1000) == 0) {
            ArrayList list = Lists.newArrayList(cF.keySet());
            return EntityParrot.b((EntityTypes)list.get(randomsource.a(list.size())));
        }
        return SoundEffects.vm;
    }

    private static SoundEffect b(EntityTypes<?> entitytypes) {
        return cF.getOrDefault(entitytypes, SoundEffects.vm);
    }

    @Override
    protected SoundEffect h(DamageSource damagesource) {
        return SoundEffects.vq;
    }

    @Override
    protected SoundEffect fd() {
        return SoundEffects.vn;
    }

    @Override
    protected void b(BlockPosition blockposition, IBlockData iblockdata) {
        this.a(SoundEffects.wf, 0.15f, 1.0f);
    }

    @Override
    protected boolean bp() {
        return this.am > this.cH;
    }

    @Override
    protected void bo() {
        this.a(SoundEffects.vp, 0.15f, 1.0f);
        this.cH = this.am + this.cA / 2.0f;
    }

    @Override
    public float fD() {
        return EntityParrot.a(this.as);
    }

    public static float a(RandomSource randomsource) {
        return (randomsource.i() - randomsource.i()) * 0.2f + 1.0f;
    }

    @Override
    public SoundCategory dB() {
        return SoundCategory.g;
    }

    @Override
    public boolean bY() {
        return super.bY();
    }

    @Override
    protected void F(Entity entity) {
        if (!(entity instanceof EntityHuman)) {
            super.F(entity);
        }
    }

    @Override
    public boolean a(WorldServer worldserver, DamageSource damagesource, float f2) {
        if (this.a(worldserver, damagesource)) {
            return false;
        }
        boolean result = super.a(worldserver, damagesource, f2);
        if (!result) {
            return result;
        }
        this.z(false);
        return result;
    }

    public Variant hf() {
        return Variant.a(this.az.a(cD));
    }

    public void a(Variant entityparrot_variant) {
        this.az.a(cD, entityparrot_variant.k);
    }

    @Override
    public <T> @Nullable T a(DataComponentType<? extends T> datacomponenttype) {
        return datacomponenttype == DataComponents.aI ? EntityParrot.c(datacomponenttype, this.hf()) : super.a(datacomponenttype);
    }

    @Override
    protected void a(DataComponentGetter datacomponentgetter) {
        this.a(datacomponentgetter, DataComponents.aI);
        super.a(datacomponentgetter);
    }

    @Override
    protected <T> boolean b(DataComponentType<T> datacomponenttype, T t0) {
        if (datacomponenttype == DataComponents.aI) {
            this.a(EntityParrot.c(DataComponents.aI, t0));
            return true;
        }
        return super.b(datacomponenttype, t0);
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(cD, Variant.f.k);
    }

    @Override
    protected void a(ValueOutput valueoutput) {
        super.a(valueoutput);
        valueoutput.a("Variant", Variant.h, this.hf());
    }

    @Override
    protected void a(ValueInput valueinput) {
        super.a(valueinput);
        this.a(valueinput.a("Variant", Variant.h).orElse(Variant.f));
    }

    @Override
    public boolean d() {
        return !this.aV();
    }

    @Override
    protected boolean gV() {
        return true;
    }

    @Override
    public Vec3D B() {
        return new Vec3D(0.0, 0.5f * this.dk(), this.dF() * 0.4f);
    }

    public static enum Variant implements INamable
    {
        a(0, "red_blue"),
        b(1, "blue"),
        c(2, "green"),
        d(3, "yellow_blue"),
        e(4, "gray");

        public static final Variant f;
        private static final IntFunction<Variant> j;
        public static final Codec<Variant> g;
        @Deprecated
        public static final Codec<Variant> h;
        public static final StreamCodec<ByteBuf, Variant> i;
        final int k;
        private final String l;

        private Variant(int i2, String s2) {
            this.k = i2;
            this.l = s2;
        }

        public int a() {
            return this.k;
        }

        public static Variant a(int i2) {
            return j.apply(i2);
        }

        @Override
        public String c() {
            return this.l;
        }

        static {
            f = a;
            j = ByIdMap.a(Variant::a, Variant.values(), ByIdMap.a.c);
            g = INamable.a(Variant::values);
            PrimitiveCodec primitivecodec = Codec.INT;
            IntFunction<Variant> intfunction = j;
            Objects.requireNonNull(intfunction);
            h = primitivecodec.xmap(intfunction::apply, Variant::a);
            i = ByteBufCodecs.a(j, Variant::a);
        }
    }

    private static class a
    extends PathfinderGoalRandomFly {
        public a(EntityCreature entitycreature, double d0) {
            super(entitycreature, d0);
        }

        @Override
        protected @Nullable Vec3D h() {
            Vec3D vec3d = null;
            if (this.b.by()) {
                vec3d = LandRandomPos.a(this.b, 15, 15);
            }
            if (this.b.ep().i() >= this.j) {
                vec3d = this.k();
            }
            return vec3d == null ? super.h() : vec3d;
        }

        private @Nullable Vec3D k() {
            BlockPosition blockposition = this.b.dK();
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition1 = new BlockPosition.MutableBlockPosition();
            for (BlockPosition blockposition1 : BlockPosition.b(MathHelper.c(this.b.dP() - 3.0), MathHelper.c(this.b.dR() - 6.0), MathHelper.c(this.b.dV() - 3.0), MathHelper.c(this.b.dP() + 3.0), MathHelper.c(this.b.dR() + 6.0), MathHelper.c(this.b.dV() + 3.0))) {
                IBlockData iblockdata;
                boolean flag;
                if (blockposition.equals(blockposition1) || !(flag = (iblockdata = this.b.ao().a_(blockposition_mutableblockposition1.a((BaseBlockPosition)blockposition1, EnumDirection.a))).b() instanceof BlockLeaves || iblockdata.a(TagsBlock.E)) || !this.b.ao().A(blockposition1) || !this.b.ao().A(blockposition_mutableblockposition.a((BaseBlockPosition)blockposition1, EnumDirection.b))) continue;
                return Vec3D.c(blockposition1);
            }
            return null;
        }
    }
}

