/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.sniffer;

import com.mojang.serialization.Dynamic;
import io.netty.buffer.ByteBuf;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.MathHelper;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.sniffer.SnifferAi;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.entity.Item;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDropItemEvent;

public class Sniffer
extends EntityAnimal {
    private static final int cB = 1700;
    private static final int cC = 6000;
    private static final int cD = 30;
    private static final int cE = 120;
    private static final int cF = 48000;
    private static final float cG = 0.4f;
    private static final EntitySize cH = EntitySize.b(EntityTypes.br.l(), EntityTypes.br.m() - 0.4f).b(0.81f);
    private static final DataWatcherObject<State> cI = DataWatcher.a(Sniffer.class, DataWatcherRegistry.G);
    private static final DataWatcherObject<Integer> cJ = DataWatcher.a(Sniffer.class, DataWatcherRegistry.b);
    public final AnimationState cv = new AnimationState();
    public final AnimationState cw = new AnimationState();
    public final AnimationState cx = new AnimationState();
    public final AnimationState cz = new AnimationState();
    public final AnimationState cA = new AnimationState();

    public static AttributeProvider.Builder p() {
        return EntityAnimal.gW().a(GenericAttributes.x, 0.1f).a(GenericAttributes.u, 14.0);
    }

    public Sniffer(EntityTypes<? extends EntityAnimal> entitytypes, World world) {
        super(entitytypes, world);
        this.N().a(true);
        this.a(PathType.j, -1.0f);
        this.a(PathType.g, -1.0f);
        this.a(PathType.y, -1.0f);
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(cI, State.a);
        datawatcher_a.a(cJ, 0);
    }

    @Override
    public void G() {
        super.G();
        if (this.cp() || this.by()) {
            this.a(PathType.j, 0.0f);
        }
    }

    @Override
    public void H() {
        this.a(PathType.j, -1.0f);
    }

    @Override
    public EntitySize b(EntityPose entitypose) {
        return this.he() == State.f ? cH.a(this.eE()) : super.b(entitypose);
    }

    public boolean gP() {
        return this.he() == State.e;
    }

    public boolean gQ() {
        return this.ca.c(MemoryModuleType.S).orElse(false);
    }

    public boolean gR() {
        return !this.gQ() && !this.gM() && !this.by() && !this.hb() && this.aV() && !this.cq() && !this.S_();
    }

    public boolean gS() {
        return this.he() == State.f || this.he() == State.e;
    }

    private BlockPosition gV() {
        Vec3D vec3d = this.hd();
        return BlockPosition.a(vec3d.a(), this.dR() + (double)0.2f, vec3d.c());
    }

    private Vec3D hd() {
        return this.dI().e(this.cm().c(2.25));
    }

    @Override
    public boolean z() {
        return true;
    }

    @Override
    public Vec3D[] A() {
        return Leashable.a(this, -0.01, 0.63, 0.38, 1.15);
    }

    public State he() {
        return this.az.a(cI);
    }

    private Sniffer b(State sniffer_state) {
        this.az.a(cI, sniffer_state);
        return this;
    }

    @Override
    public void a(DataWatcherObject<?> datawatcherobject) {
        if (cI.equals(datawatcherobject)) {
            State sniffer_state = this.he();
            this.hf();
            switch (sniffer_state.ordinal()) {
                case 1: {
                    this.cv.b(this.at);
                    break;
                }
                case 2: {
                    this.cw.b(this.at);
                    break;
                }
                case 3: {
                    this.cx.b(this.at);
                }
                default: {
                    break;
                }
                case 5: {
                    this.cz.b(this.at);
                    break;
                }
                case 6: {
                    this.cA.b(this.at);
                }
            }
            this.j_();
        }
        super.a(datawatcherobject);
    }

    private void hf() {
        this.cz.a();
        this.cx.a();
        this.cA.a();
        this.cv.a();
        this.cw.a();
    }

    public Sniffer a(State sniffer_state) {
        switch (sniffer_state.ordinal()) {
            case 0: {
                this.b(State.a);
                break;
            }
            case 1: {
                this.a(SoundEffects.BO, 1.0f, 1.0f);
                this.b(State.b);
                break;
            }
            case 2: {
                this.b(State.c).hg();
                break;
            }
            case 3: {
                this.a(SoundEffects.BK, 1.0f, 1.0f);
                this.b(State.d);
                break;
            }
            case 4: {
                this.b(State.e);
                break;
            }
            case 5: {
                this.b(State.f).hh();
                break;
            }
            case 6: {
                this.a(SoundEffects.BN, 1.0f, 1.0f);
                this.b(State.g);
            }
        }
        return this;
    }

    private Sniffer hg() {
        this.a(SoundEffects.BJ, 1.0f, this.e_() ? 1.3f : 1.0f);
        return this;
    }

    private Sniffer hh() {
        this.az.a(cJ, this.at + 120);
        this.ao().a((Entity)this, (byte)63);
        return this;
    }

    public Sniffer x(boolean flag) {
        if (flag) {
            this.i(this.bg());
        }
        return this;
    }

    public Optional<BlockPosition> gT() {
        return IntStream.range(0, 5).mapToObj(i2 -> LandRandomPos.a(this, 10 + 2 * i2, 3)).filter(Objects::nonNull).map(BlockPosition::a).filter(blockposition -> this.ao().w().a((BlockPosition)blockposition)).map(BlockPosition::e).filter(this::h).findFirst();
    }

    public boolean gU() {
        return !this.gM() && !this.gQ() && !this.e_() && !this.by() && this.aV() && !this.cq() && this.h(this.gV().e());
    }

    private boolean h(BlockPosition blockposition) {
        return this.ao().a_(blockposition).a(TagsBlock.cJ) && this.hj().noneMatch(globalpos -> GlobalPos.a(this.ao().aq(), blockposition).equals(globalpos)) && Optional.ofNullable(this.N().a(blockposition, 1)).map(PathEntity::j).orElse(false) != false;
    }

    private void hi() {
        World world = this.ao();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            if (this.az.a(cJ) == this.at) {
                BlockPosition blockposition = this.gV();
                this.a(worldserver, LootTables.aG, (WorldServer worldserver1, ItemStack itemstack) -> {
                    EntityItem entityitem = new EntityItem(this.ao(), blockposition.u(), blockposition.v(), blockposition.w(), (ItemStack)itemstack);
                    EntityDropItemEvent event = new EntityDropItemEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (Item)entityitem.getBukkitEntity());
                    Bukkit.getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        return;
                    }
                    entityitem.i();
                    worldserver1.b(entityitem);
                });
                this.a(SoundEffects.BI, 1.0f, 1.0f);
                return;
            }
        }
    }

    private Sniffer a(AnimationState animationstate) {
        boolean flag;
        boolean bl = flag = animationstate.a((float)this.at) > 1700L && animationstate.a((float)this.at) < 6000L;
        if (flag) {
            BlockPosition blockposition = this.gV();
            IBlockData iblockdata = this.ao().a_(blockposition.e());
            if (iblockdata.o() != EnumRenderType.a) {
                for (int i2 = 0; i2 < 30; ++i2) {
                    Vec3D vec3d = Vec3D.b(blockposition).b(0.0, -0.65f, 0.0);
                    this.ao().a(new ParticleParamBlock(Particles.b, iblockdata), vec3d.g, vec3d.h, vec3d.i, 0.0, 0.0, 0.0);
                }
                if (this.at % 10 == 0) {
                    this.ao().a(this.dP(), this.dR(), this.dV(), iblockdata.A().f(), this.dB(), 0.5f, 0.5f, false);
                }
            }
        }
        if (this.at % 10 == 0) {
            this.ao().a(GameEvent.u, this.gV(), GameEvent.a.a(this));
        }
        return this;
    }

    public Sniffer i(BlockPosition blockposition) {
        List list = this.hj().limit(20L).collect(Collectors.toList());
        list.add(0, GlobalPos.a(this.ao().aq(), blockposition));
        this.ev().a(MemoryModuleType.bb, list);
        return this;
    }

    public Stream<GlobalPos> hj() {
        return this.ev().c(MemoryModuleType.bb).stream().flatMap(Collection::stream);
    }

    @Override
    public void u() {
        double d1;
        super.u();
        double d0 = this.cp.c();
        if (d0 > 0.0 && (d1 = this.dN().j()) < 0.01) {
            this.a(0.1f, new Vec3D(0.0, 0.0, 1.0));
        }
    }

    @Override
    public void a(WorldServer worldserver, EntityAnimal entityanimal) {
        ItemStack itemstack = new ItemStack(Items.lj);
        EntityItem entityitem = new EntityItem(worldserver, this.dI().a(), this.dI().b(), this.dI().c(), itemstack);
        entityitem.i();
        this.a(worldserver, entityanimal, (EntityAgeable)null);
        this.a(SoundEffects.BP, 1.0f, (this.as.i() - this.as.i()) * 0.2f + 0.5f);
        worldserver.b(entityitem);
    }

    @Override
    public void a(DamageSource damagesource) {
        this.a(State.a);
        super.a(damagesource);
    }

    @Override
    public void g() {
        switch (this.he().ordinal()) {
            case 4: {
                this.hk();
                break;
            }
            case 5: {
                this.a(this.cz).hi();
            }
        }
        super.g();
    }

    @Override
    public EnumInteractionResult b(EntityHuman entityhuman, EnumHand enumhand) {
        ItemStack itemstack = entityhuman.b(enumhand);
        boolean flag = this.j(itemstack);
        EnumInteractionResult enuminteractionresult = super.b(entityhuman, enumhand);
        if (enuminteractionresult.a() && flag) {
            this.gX();
        }
        return enuminteractionresult;
    }

    @Override
    protected void gX() {
        this.ao().a((Entity)null, this, SoundEffects.BE, SoundCategory.g, 1.0f, MathHelper.b(this.ao().y, 0.8f, 1.2f));
    }

    private void hk() {
        if (this.ao().B_() && this.at % 20 == 0) {
            this.ao().a(this.dP(), this.dR(), this.dV(), SoundEffects.BL, this.dB(), 1.0f, 1.0f, false);
        }
    }

    @Override
    protected void b(BlockPosition blockposition, IBlockData iblockdata) {
        this.a(SoundEffects.BD, 0.15f, 1.0f);
    }

    @Override
    protected SoundEffect W() {
        return Set.of(State.f, State.e).contains((Object)this.he()) ? null : SoundEffects.BF;
    }

    @Override
    protected SoundEffect h(DamageSource damagesource) {
        return SoundEffects.BG;
    }

    @Override
    protected SoundEffect fd() {
        return SoundEffects.BH;
    }

    @Override
    public int ae() {
        return 50;
    }

    @Override
    public void a_(boolean flag) {
        this.d_(flag ? -48000 : 0);
    }

    @Override
    public EntityAgeable a(WorldServer worldserver, EntityAgeable entityageable) {
        return EntityTypes.br.a(worldserver, EntitySpawnReason.e);
    }

    @Override
    public boolean a(EntityAnimal entityanimal) {
        if (!(entityanimal instanceof Sniffer)) {
            return false;
        }
        Sniffer sniffer = (Sniffer)entityanimal;
        Set<State> set = Set.of(State.a, State.c, State.b);
        return set.contains((Object)this.he()) && set.contains((Object)sniffer.he()) && super.a(entityanimal);
    }

    @Override
    public boolean j(ItemStack itemstack) {
        return itemstack.a(TagsItem.aB);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return SnifferAi.a(this.ew().a(dynamic));
    }

    public BehaviorController<Sniffer> ev() {
        return super.ev();
    }

    protected BehaviorController.b<Sniffer> ew() {
        return BehaviorController.a(SnifferAi.b, SnifferAi.a);
    }

    @Override
    protected void a(WorldServer worldserver) {
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("snifferBrain");
        this.ev().a(worldserver, this);
        gameprofilerfiller.b("snifferActivityUpdate");
        SnifferAi.a(this);
        gameprofilerfiller.c();
        super.a(worldserver);
    }

    public static enum State {
        a(0),
        b(1),
        c(2),
        d(3),
        e(4),
        f(5),
        g(6);

        public static final IntFunction<State> h;
        public static final StreamCodec<ByteBuf, State> i;
        private final int j;

        private State(int i2) {
            this.j = i2;
        }

        public int a() {
            return this.j;
        }

        static {
            h = ByIdMap.a(State::a, State.values(), ByIdMap.a.a);
            i = ByteBufCodecs.a(h, State::a);
        }
    }
}

