/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.item;

import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.jspecify.annotations.Nullable;

public class EntityItem
extends Entity
implements TraceableEntity {
    private static final DataWatcherObject<ItemStack> c = DataWatcher.a(EntityItem.class, DataWatcherRegistry.h);
    private static final float d = 0.1f;
    public static final float a = 0.2125f;
    private static final int e = 6000;
    private static final int f = Short.MAX_VALUE;
    private static final int g = Short.MIN_VALUE;
    private static final int h = 5;
    private static final short i = 0;
    private static final short j = 0;
    public int k = 0;
    public int l = 0;
    private int m = 5;
    public @Nullable EntityReference<Entity> n;
    public @Nullable UUID o;
    public final float b;
    private int lastTick = MinecraftServer.currentTick - 1;

    public EntityItem(EntityTypes<? extends EntityItem> entitytypes, World world) {
        super(entitytypes, world);
        this.b = this.as.i() * (float)Math.PI * 2.0f;
        this.v(this.as.i() * 360.0f);
    }

    public EntityItem(World world, double d0, double d1, double d2, ItemStack itemstack) {
        this(world, d0, d1, d2, itemstack, world.y.j() * 0.2 - 0.1, 0.2, world.y.j() * 0.2 - 0.1);
    }

    public EntityItem(World world, double d0, double d1, double d2, ItemStack itemstack, double d3, double d4, double d5) {
        this((EntityTypes<? extends EntityItem>)EntityTypes.av, world);
        this.a_(d0, d1, d2);
        this.m(d3, d4, d5);
        this.a(itemstack);
    }

    @Override
    public boolean bw() {
        return this.e().a(TagsItem.V);
    }

    @Override
    public @Nullable Entity p() {
        return EntityReference.a(this.n, this.ao());
    }

    @Override
    public void y(Entity entity) {
        super.y(entity);
        if (entity instanceof EntityItem) {
            EntityItem entityitem = (EntityItem)entity;
            this.n = entityitem.n;
        }
    }

    @Override
    protected Entity.MovementEmission bv() {
        return Entity.MovementEmission.a;
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        datawatcher_a.a(c, ItemStack.l);
    }

    @Override
    protected double bs() {
        return 0.04;
    }

    @Override
    public void g() {
        if (this.e().f()) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        } else {
            double d0;
            int i2;
            super.g();
            int elapsedTicks = MinecraftServer.currentTick - this.lastTick;
            if (this.l != Short.MAX_VALUE) {
                this.l -= elapsedTicks;
            }
            if (this.k != Short.MIN_VALUE) {
                this.k += elapsedTicks;
            }
            this.lastTick = MinecraftServer.currentTick;
            this.Y = this.dP();
            this.Z = this.dR();
            this.aa = this.dV();
            Vec3D vec3d = this.dN();
            if (this.by() && this.b(TagsFluid.a) > (double)0.1f) {
                this.u();
            } else if (this.bN() && this.b(TagsFluid.b) > (double)0.1f) {
                this.v();
            } else {
                this.bu();
            }
            if (this.ao().B_()) {
                this.ar = false;
            } else {
                boolean bl = this.ar = !this.ao().a((Entity)this, this.dj().h(1.0E-7));
                if (this.ar) {
                    this.k(this.dP(), (this.dj().b + this.dj().e) / 2.0, this.dV());
                }
            }
            if (!this.aV() || this.dN().j() > (double)1.0E-5f || (this.at + this.aA()) % 4 == 0) {
                this.a(EnumMoveType.a, this.dN());
                this.aW();
                float f2 = 0.98f;
                if (this.aV()) {
                    f2 = this.ao().a_(this.bf()).b().g() * 0.98f;
                }
                this.k(this.dN().d(f2, 0.98, f2));
                if (this.aV()) {
                    Vec3D vec3d1 = this.dN();
                    if (vec3d1.h < 0.0) {
                        this.k(vec3d1.d(1.0, -0.5, 1.0));
                    }
                }
            }
            boolean flag = MathHelper.c(this.Y) != MathHelper.c(this.dP()) || MathHelper.c(this.Z) != MathHelper.c(this.dR()) || MathHelper.c(this.aa) != MathHelper.c(this.dV());
            int n2 = i2 = flag ? 2 : 40;
            if (this.at % i2 == 0 && !this.ao().B_() && this.x()) {
                this.w();
            }
            this.aF |= this.bG();
            if (!this.ao().B_() && (d0 = this.dN().d(vec3d).h()) > 0.01) {
                this.aF = true;
            }
            if (!this.ao().B_() && this.k >= this.ao().spigotConfig.itemDespawnRate) {
                if (CraftEventFactory.callItemDespawnEvent(this).isCancelled()) {
                    this.k = 0;
                    return;
                }
                this.discard(EntityRemoveEvent.Cause.DESPAWN);
            }
        }
    }

    @Override
    public void inactiveTick() {
        int elapsedTicks = MinecraftServer.currentTick - this.lastTick;
        if (this.l != Short.MAX_VALUE) {
            this.l -= elapsedTicks;
        }
        if (this.k != Short.MIN_VALUE) {
            this.k += elapsedTicks;
        }
        this.lastTick = MinecraftServer.currentTick;
        if (!this.ao().B_() && this.k >= this.ao().spigotConfig.itemDespawnRate) {
            if (CraftEventFactory.callItemDespawnEvent(this).isCancelled()) {
                this.k = 0;
                return;
            }
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        }
    }

    @Override
    public BlockPosition bf() {
        return this.f(0.999999f);
    }

    private void u() {
        this.i((double)0.99f);
    }

    private void v() {
        this.i((double)0.95f);
    }

    private void i(double d0) {
        Vec3D vec3d = this.dN();
        this.m(vec3d.g * d0, vec3d.h + (double)(vec3d.h < (double)0.06f ? 5.0E-4f : 0.0f), vec3d.i * d0);
    }

    private void w() {
        if (this.x()) {
            double radius = this.ao().spigotConfig.itemMerge;
            for (EntityItem entityitem : this.ao().a(EntityItem.class, this.dj().c(radius, radius - 0.5, radius), (? super T entityitem1) -> entityitem1 != this && entityitem1.x())) {
                if (!entityitem.x()) continue;
                this.a(entityitem);
                if (!this.eh()) continue;
                break;
            }
        }
    }

    private boolean x() {
        ItemStack itemstack = this.e();
        return this.cb() && this.l != Short.MAX_VALUE && this.k != Short.MIN_VALUE && this.k < 6000 && itemstack.N() < itemstack.k();
    }

    private void a(EntityItem entityitem) {
        ItemStack itemstack = this.e();
        ItemStack itemstack1 = entityitem.e();
        if (Objects.equals(this.o, entityitem.o) && EntityItem.a(itemstack, itemstack1)) {
            EntityItem.a(this, itemstack, entityitem, itemstack1);
        }
    }

    public static boolean a(ItemStack itemstack, ItemStack itemstack1) {
        return itemstack1.N() + itemstack.N() > itemstack1.k() ? false : ItemStack.c(itemstack, itemstack1);
    }

    public static ItemStack a(ItemStack itemstack, ItemStack itemstack1, int i2) {
        int j2 = Math.min(Math.min(itemstack.k(), i2) - itemstack.N(), itemstack1.N());
        ItemStack itemstack2 = itemstack.c(itemstack.N() + j2);
        itemstack1.h(j2);
        return itemstack2;
    }

    private static void a(EntityItem entityitem, ItemStack itemstack, ItemStack itemstack1) {
        ItemStack itemstack2 = EntityItem.a(itemstack, itemstack1, 64);
        entityitem.a(itemstack2);
    }

    private static void a(EntityItem entityitem, ItemStack itemstack, EntityItem entityitem1, ItemStack itemstack1) {
        if (!CraftEventFactory.callItemMergeEvent(entityitem1, entityitem)) {
            return;
        }
        EntityItem.a(entityitem, itemstack, itemstack1);
        entityitem.l = Math.max(entityitem.l, entityitem1.l);
        entityitem.k = Math.min(entityitem.k, entityitem1.k);
        if (itemstack1.f()) {
            entityitem1.discard(EntityRemoveEvent.Cause.MERGE);
        }
    }

    @Override
    public boolean bx() {
        return !this.e().a(this.en().a()) || super.bx();
    }

    @Override
    protected boolean aR() {
        return this.m <= 0 ? true : this.at % 10 == 0;
    }

    @Override
    public final boolean b(DamageSource damagesource) {
        return this.d(damagesource) ? false : this.e().a(damagesource);
    }

    @Override
    public final boolean a(WorldServer worldserver, DamageSource damagesource, float f2) {
        if (this.d(damagesource)) {
            return false;
        }
        if (!worldserver.U().a(GameRules.F).booleanValue() && damagesource.d() instanceof EntityInsentient) {
            return false;
        }
        if (!this.e().a(damagesource)) {
            return false;
        }
        if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, damagesource, f2)) {
            return false;
        }
        this.bT();
        this.m = (int)((float)this.m - f2);
        this.a(GameEvent.o, damagesource.d());
        if (this.m <= 0) {
            this.e().a(this);
            this.discard(EntityRemoveEvent.Cause.DEATH);
        }
        return true;
    }

    @Override
    public boolean a(Explosion explosion) {
        return explosion.h() ? super.a(explosion) : true;
    }

    @Override
    protected void a(ValueOutput valueoutput) {
        valueoutput.a("Health", (short)this.m);
        valueoutput.a("Age", (short)this.k);
        valueoutput.a("PickupDelay", (short)this.l);
        EntityReference.a(this.n, valueoutput, "Thrower");
        valueoutput.b("Owner", UUIDUtil.a, this.o);
        if (!this.e().f()) {
            valueoutput.a("Item", ItemStack.b, this.e());
        }
    }

    @Override
    protected void a(ValueInput valueinput) {
        this.m = valueinput.a("Health", (short)5);
        this.k = valueinput.a("Age", (short)0);
        this.l = valueinput.a("PickupDelay", (short)0);
        this.o = valueinput.a("Owner", UUIDUtil.a).orElse(null);
        this.n = EntityReference.a(valueinput, "Thrower");
        this.a(valueinput.a("Item", ItemStack.b).orElse(ItemStack.l));
        if (this.e().f()) {
            this.discard(null);
        }
    }

    @Override
    public void a_(EntityHuman entityhuman) {
        if (!this.ao().B_()) {
            ItemStack itemstack = this.e();
            Item item = itemstack.h();
            int i2 = itemstack.N();
            int canHold = entityhuman.gK().canHold(itemstack);
            int remaining = i2 - canHold;
            if (this.l <= 0 && canHold > 0) {
                EntityPickupItemEvent entityEvent;
                itemstack.e(canHold);
                PlayerPickupItemEvent playerEvent = new PlayerPickupItemEvent((Player)entityhuman.getBukkitEntity(), (org.bukkit.entity.Item)this.getBukkitEntity(), remaining);
                playerEvent.setCancelled(!playerEvent.getPlayer().getCanPickupItems());
                this.ao().getCraftServer().getPluginManager().callEvent((Event)playerEvent);
                if (playerEvent.isCancelled()) {
                    itemstack.e(i2);
                    return;
                }
                entityEvent.setCancelled(!(entityEvent = new EntityPickupItemEvent((LivingEntity)((Player)entityhuman.getBukkitEntity()), (org.bukkit.entity.Item)this.getBukkitEntity(), remaining)).getEntity().getCanPickupItems());
                this.ao().getCraftServer().getPluginManager().callEvent((Event)entityEvent);
                if (entityEvent.isCancelled()) {
                    itemstack.e(i2);
                    return;
                }
                ItemStack current = this.e();
                if (!itemstack.equals(current)) {
                    itemstack = current;
                } else {
                    itemstack.e(canHold + remaining);
                }
                this.l = 0;
            } else if (this.l == 0) {
                this.l = -1;
            }
            if (this.l == 0 && (this.o == null || this.o.equals(entityhuman.cY())) && entityhuman.gK().g(itemstack)) {
                entityhuman.a((Entity)this, i2);
                if (itemstack.f()) {
                    this.discard(EntityRemoveEvent.Cause.PICKUP);
                    itemstack.e(i2);
                }
                entityhuman.a(StatisticList.e.b(item), i2);
                entityhuman.a(this);
            }
        }
    }

    @Override
    public IChatBaseComponent ap() {
        IChatBaseComponent ichatbasecomponent = this.as();
        return ichatbasecomponent != null ? ichatbasecomponent : this.e().A();
    }

    @Override
    public boolean cT() {
        return false;
    }

    @Override
    public @Nullable Entity b(TeleportTransition teleporttransition) {
        Entity entity = super.b(teleporttransition);
        if (!this.ao().B_() && entity instanceof EntityItem) {
            EntityItem entityitem = (EntityItem)entity;
            entityitem.w();
        }
        return entity;
    }

    public ItemStack e() {
        return this.aD().a(c);
    }

    public void a(ItemStack itemstack) {
        this.aD().a(c, itemstack);
    }

    @Override
    public void a(DataWatcherObject<?> datawatcherobject) {
        super.a(datawatcherobject);
        if (c.equals(datawatcherobject)) {
            this.e().a((Entity)this);
        }
    }

    public void b(@Nullable UUID uuid) {
        this.o = uuid;
    }

    public void b(Entity entity) {
        this.n = EntityReference.a(entity);
    }

    public int f() {
        return this.k;
    }

    public void i() {
        this.l = 10;
    }

    public void k() {
        this.l = 0;
    }

    public void m() {
        this.l = Short.MAX_VALUE;
    }

    public void a(int i2) {
        this.l = i2;
    }

    public boolean n() {
        return this.l > 0;
    }

    public void q() {
        this.k = Short.MIN_VALUE;
    }

    public void r() {
        this.k = -6000;
    }

    public void s() {
        this.m();
        this.k = this.ao().spigotConfig.itemDespawnRate - 1;
    }

    public static float f(float f2, float f1) {
        return f2 / 20.0f + f1;
    }

    @Override
    public SoundCategory dB() {
        return SoundCategory.i;
    }

    @Override
    public float ed() {
        return 180.0f - EntityItem.f((float)this.f() + 0.5f, this.b) / ((float)Math.PI * 2) * 360.0f;
    }

    @Override
    public @Nullable SlotAccess a_(int i2) {
        return i2 == 0 ? SlotAccess.a(this::e, this::a) : super.a_(i2);
    }
}

