/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.EnumSet;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeRange;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalUniversalAngerReset;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.monster.EntityEndermite;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.throwableitemprojectile.EntityPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.providers.VanillaEnchantmentProviders;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.event.entity.EntityTargetEvent;
import org.jspecify.annotations.Nullable;

public class EntityEnderman
extends EntityMonster
implements IEntityAngerable {
    private static final MinecraftKey d = MinecraftKey.b("attacking");
    private static final AttributeModifier e = new AttributeModifier(d, 0.15f, AttributeModifier.Operation.a);
    private static final int f = 400;
    private static final int cv = 600;
    private static final DataWatcherObject<Optional<IBlockData>> cw = DataWatcher.a(EntityEnderman.class, DataWatcherRegistry.j);
    private static final DataWatcherObject<Boolean> cx = DataWatcher.a(EntityEnderman.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> cy = DataWatcher.a(EntityEnderman.class, DataWatcherRegistry.k);
    private int cz = Integer.MIN_VALUE;
    private int cA;
    private static final UniformInt cB = TimeRange.a(20, 39);
    private long cC;
    private @Nullable EntityReference<EntityLiving> cD;

    public EntityEnderman(EntityTypes<? extends EntityEnderman> entitytypes, World world) {
        super((EntityTypes<? extends EntityMonster>)entitytypes, world);
        this.a(PathType.j, -1.0f);
    }

    @Override
    protected void D() {
        this.cs.a(0, new PathfinderGoalFloat(this));
        this.cs.a(1, new a(this));
        this.cs.a(2, new PathfinderGoalMeleeAttack(this, 1.0, false));
        this.cs.a(7, new PathfinderGoalRandomStrollLand((EntityCreature)this, 1.0, 0.0f));
        this.cs.a(8, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.cs.a(8, new PathfinderGoalRandomLookaround(this));
        this.cs.a(10, new PathfinderGoalEndermanPlaceBlock(this));
        this.cs.a(11, new PathfinderGoalEndermanPickupBlock(this));
        this.ct.a(1, new PathfinderGoalPlayerWhoLookedAtTarget(this, this::a));
        this.ct.a(2, new PathfinderGoalHurtByTarget(this, new Class[0]));
        this.ct.a(3, new PathfinderGoalNearestAttackableTarget<EntityEndermite>((EntityInsentient)this, EntityEndermite.class, true, false));
        this.ct.a(4, new PathfinderGoalUniversalAngerReset<EntityEnderman>(this, false));
    }

    @Override
    public float a(BlockPosition blockposition, IWorldReader iworldreader) {
        return 0.0f;
    }

    public static AttributeProvider.Builder k() {
        return EntityMonster.gW().a(GenericAttributes.u, 40.0).a(GenericAttributes.x, 0.3f).a(GenericAttributes.d, 7.0).a(GenericAttributes.o, 64.0).a(GenericAttributes.D, 1.0);
    }

    @Override
    public void g(@Nullable EntityLiving entityliving) {
        this.setTarget(entityliving, EntityTargetEvent.TargetReason.UNKNOWN, true);
    }

    @Override
    public boolean setTarget(EntityLiving entityliving, EntityTargetEvent.TargetReason reason, boolean fireEvent) {
        if (!super.setTarget(entityliving, reason, fireEvent)) {
            return false;
        }
        entityliving = this.ag_();
        AttributeModifiable attributemodifiable = this.h(GenericAttributes.x);
        if (entityliving == null) {
            this.cA = 0;
            this.az.a(cx, false);
            this.az.a(cy, false);
            attributemodifiable.c(d);
        } else {
            this.cA = this.at;
            this.az.a(cx, true);
            if (!attributemodifiable.b(d)) {
                attributemodifiable.b(e);
            }
        }
        return true;
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(cw, Optional.empty());
        datawatcher_a.a(cx, false);
        datawatcher_a.a(cy, false);
    }

    @Override
    public void c() {
        this.a(cB.a(this.as));
    }

    @Override
    public void b(long i2) {
        this.cC = i2;
    }

    @Override
    public long a() {
        return this.cC;
    }

    @Override
    public void a(@Nullable EntityReference<EntityLiving> entityreference) {
        this.cD = entityreference;
    }

    @Override
    public @Nullable EntityReference<EntityLiving> b() {
        return this.cD;
    }

    public void p() {
        if (this.at >= this.cz + 400) {
            this.cz = this.at;
            if (!this.bq()) {
                this.ao().a(this.dP(), this.dT(), this.dV(), SoundEffects.jV, this.dB(), 2.5f, 1.0f, false);
            }
        }
    }

    @Override
    public void a(DataWatcherObject<?> datawatcherobject) {
        if (cx.equals(datawatcherobject) && this.gS() && this.ao().B_()) {
            this.p();
        }
        super.a(datawatcherobject);
    }

    @Override
    protected void a(ValueOutput valueoutput) {
        super.a(valueoutput);
        IBlockData iblockdata = this.gQ();
        if (iblockdata != null) {
            valueoutput.a("carriedBlockState", IBlockData.a, iblockdata);
        }
        this.b_(valueoutput);
    }

    @Override
    protected void a(ValueInput valueinput) {
        super.a(valueinput);
        this.c((IBlockData)valueinput.a("carriedBlockState", IBlockData.a).filter(iblockdata -> !iblockdata.l()).orElse(null));
        this.a(this.ao(), valueinput);
    }

    boolean g(EntityHuman entityhuman) {
        return !EntityLiving.bo.test(entityhuman) ? false : this.a(entityhuman, 0.025, true, false, this.dT());
    }

    @Override
    public void d_() {
        if (this.ao().B_()) {
            for (int i2 = 0; i2 < 2; ++i2) {
                this.ao().a(Particles.ag, this.e(0.5), this.dS() - 0.25, this.h(0.5), (this.as.j() - 0.5) * 2.0, -this.as.j(), (this.as.j() - 0.5) * 2.0);
            }
        }
        this.bM = false;
        if (!this.ao().B_()) {
            this.a((WorldServer)this.ao(), true);
        }
        super.d_();
    }

    @Override
    public boolean fR() {
        return true;
    }

    @Override
    protected void a(WorldServer worldserver) {
        float f2;
        if (worldserver.ag() && this.at >= this.cA + 600 && (f2 = this.bO()) > 0.5f && worldserver.k(this.dK()) && this.as.i() * 30.0f < (f2 - 0.4f) * 2.0f) {
            this.g((EntityLiving)null);
            this.gP();
        }
        super.a(worldserver);
    }

    public boolean gP() {
        if (!this.ao().B_() && this.cb()) {
            double d0 = this.dP() + (this.as.j() - 0.5) * 64.0;
            double d1 = this.dR() + (double)(this.as.a(64) - 32);
            double d2 = this.dV() + (this.as.j() - 0.5) * 64.0;
            return this.p(d0, d1, d2);
        }
        return false;
    }

    public boolean H(Entity entity) {
        Vec3D vec3d = new Vec3D(this.dP() - entity.dP(), this.f(0.5) - entity.dT(), this.dV() - entity.dV());
        vec3d = vec3d.d();
        double d0 = 16.0;
        double d1 = this.dP() + (this.as.j() - 0.5) * 8.0 - vec3d.g * 16.0;
        double d2 = this.dR() + (double)(this.as.a(16) - 8) - vec3d.h * 16.0;
        double d3 = this.dV() + (this.as.j() - 0.5) * 8.0 - vec3d.i * 16.0;
        return this.p(d1, d2, d3);
    }

    private boolean p(double d0, double d1, double d2) {
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition(d0, d1, d2);
        while (blockposition_mutableblockposition.v() > this.ao().K_() && !this.ao().a_(blockposition_mutableblockposition).d()) {
            blockposition_mutableblockposition.c(EnumDirection.a);
        }
        IBlockData iblockdata = this.ao().a_(blockposition_mutableblockposition);
        boolean flag = iblockdata.d();
        boolean flag1 = iblockdata.y().a(TagsFluid.a);
        if (flag && !flag1) {
            Vec3D vec3d = this.dI();
            boolean flag2 = this.b(d0, d1, d2, true);
            if (flag2) {
                this.ao().a(GameEvent.R, vec3d, GameEvent.a.a(this));
                if (!this.bq()) {
                    this.ao().a((Entity)null, this.Y, this.Z, this.aa, SoundEffects.jW, this.dB(), 1.0f, 1.0f);
                    this.a(SoundEffects.jW, 1.0f, 1.0f);
                }
            }
            return flag2;
        }
        return false;
    }

    @Override
    protected SoundEffect W() {
        return this.gR() ? SoundEffects.jU : SoundEffects.jR;
    }

    @Override
    protected SoundEffect h(DamageSource damagesource) {
        return SoundEffects.jT;
    }

    @Override
    protected SoundEffect fd() {
        return SoundEffects.jS;
    }

    @Override
    protected void a(WorldServer worldserver, DamageSource damagesource, boolean flag) {
        super.a(worldserver, damagesource, flag);
        IBlockData iblockdata = this.gQ();
        if (iblockdata != null) {
            ItemStack itemstack = new ItemStack(Items.qP);
            EnchantmentManager.a(itemstack, worldserver.J_(), VanillaEnchantmentProviders.g, worldserver.c(this.dK()), this.ep());
            LootParams.a lootparams_a = new LootParams.a((WorldServer)this.ao()).a(LootContextParameters.h, this.dI()).a(LootContextParameters.k, itemstack).b(LootContextParameters.a, this);
            for (ItemStack itemstack1 : iblockdata.a(lootparams_a)) {
                this.a(worldserver, itemstack1);
            }
        }
    }

    public void c(@Nullable IBlockData iblockdata) {
        this.az.a(cw, Optional.ofNullable(iblockdata));
    }

    public @Nullable IBlockData gQ() {
        return this.az.a(cw).orElse(null);
    }

    @Override
    public boolean a(WorldServer worldserver, DamageSource damagesource, float f2) {
        EntityPotion entitypotion1;
        if (this.a(worldserver, damagesource)) {
            return false;
        }
        Entity entity = damagesource.c();
        EntityPotion entitypotion = entity instanceof EntityPotion ? (entitypotion1 = (EntityPotion)entity) : null;
        EntityPotion entitypotion2 = entitypotion;
        if (!damagesource.a(DamageTypeTags.j) && entitypotion2 == null) {
            boolean flag = super.a(worldserver, damagesource, f2);
            if (!(damagesource.d() instanceof EntityLiving) && this.as.a(10) != 0) {
                this.gP();
            }
            return flag;
        }
        boolean flag1 = entitypotion2 != null && this.a(worldserver, damagesource, entitypotion2, f2);
        for (int i2 = 0; i2 < 64; ++i2) {
            if (!this.gP()) continue;
            return true;
        }
        return flag1;
    }

    private boolean a(WorldServer worldserver, DamageSource damagesource, EntityPotion entitypotion, float f2) {
        ItemStack itemstack = entitypotion.e();
        PotionContents potioncontents = itemstack.a(DataComponents.Y, PotionContents.a);
        return potioncontents.a(Potions.a) ? super.a(worldserver, damagesource, f2) : false;
    }

    public boolean gR() {
        return this.az.a(cx);
    }

    public boolean gS() {
        return this.az.a(cy);
    }

    public void gT() {
        this.az.a(cy, true);
    }

    @Override
    public boolean ab() {
        return super.ab() || this.gQ() != null;
    }

    private static class a
    extends PathfinderGoal {
        private final EntityEnderman a;
        private @Nullable EntityLiving b;

        public a(EntityEnderman entityenderman) {
            this.a = entityenderman;
            this.a(EnumSet.of(PathfinderGoal.Type.c, PathfinderGoal.Type.a));
        }

        @Override
        public boolean b() {
            this.b = this.a.ag_();
            EntityLiving entityliving = this.b;
            if (entityliving instanceof EntityHuman) {
                EntityHuman entityhuman = (EntityHuman)entityliving;
                double d0 = this.b.g(this.a);
                return d0 > 256.0 ? false : this.a.g(entityhuman);
            }
            return false;
        }

        @Override
        public void d() {
            this.a.N().n();
        }

        @Override
        public void a() {
            this.a.J().a(this.b.dP(), this.b.dT(), this.b.dV());
        }
    }

    private static class PathfinderGoalEndermanPlaceBlock
    extends PathfinderGoal {
        private final EntityEnderman a;

        public PathfinderGoalEndermanPlaceBlock(EntityEnderman entityenderman) {
            this.a = entityenderman;
        }

        @Override
        public boolean b() {
            return this.a.gQ() == null ? false : (PathfinderGoalEndermanPlaceBlock.a(this.a).U().a(GameRules.F) == false ? false : this.a.ep().a(PathfinderGoalEndermanPlaceBlock.b(2000)) == 0);
        }

        @Override
        public void a() {
            RandomSource randomsource = this.a.ep();
            World world = this.a.ao();
            int i2 = MathHelper.c(this.a.dP() - 1.0 + randomsource.j() * 2.0);
            int j2 = MathHelper.c(this.a.dR() + randomsource.j() * 2.0);
            int k2 = MathHelper.c(this.a.dV() - 1.0 + randomsource.j() * 2.0);
            BlockPosition blockposition = new BlockPosition(i2, j2, k2);
            IBlockData iblockdata = world.a_(blockposition);
            BlockPosition blockposition1 = blockposition.e();
            IBlockData iblockdata1 = world.a_(blockposition1);
            IBlockData iblockdata2 = this.a.gQ();
            if (iblockdata2 != null && this.a(world, blockposition, iblockdata2 = Block.b(iblockdata2, (GeneratorAccess)this.a.ao(), blockposition), iblockdata, iblockdata1, blockposition1) && CraftEventFactory.callEntityChangeBlockEvent(this.a, blockposition, iblockdata2)) {
                world.a(blockposition, iblockdata2, 3);
                world.a(GameEvent.i, blockposition, GameEvent.a.a(this.a, iblockdata2));
                this.a.c((IBlockData)null);
            }
        }

        private boolean a(World world, BlockPosition blockposition, IBlockData iblockdata, IBlockData iblockdata1, IBlockData iblockdata2, BlockPosition blockposition1) {
            return iblockdata1.l() && !iblockdata2.l() && !iblockdata2.a(Blocks.I) && iblockdata2.m(world, blockposition1) && iblockdata.a((IWorldReader)world, blockposition) && world.a_(this.a, AxisAlignedBB.a(Vec3D.a(blockposition))).isEmpty();
        }
    }

    private static class PathfinderGoalEndermanPickupBlock
    extends PathfinderGoal {
        private final EntityEnderman a;

        public PathfinderGoalEndermanPickupBlock(EntityEnderman entityenderman) {
            this.a = entityenderman;
        }

        @Override
        public boolean b() {
            return this.a.gQ() != null ? false : (PathfinderGoalEndermanPickupBlock.a(this.a).U().a(GameRules.F) == false ? false : this.a.ep().a(PathfinderGoalEndermanPickupBlock.b(20)) == 0);
        }

        @Override
        public void a() {
            RandomSource randomsource = this.a.ep();
            World world = this.a.ao();
            int i2 = MathHelper.c(this.a.dP() - 2.0 + randomsource.j() * 4.0);
            int j2 = MathHelper.c(this.a.dR() + randomsource.j() * 3.0);
            int k2 = MathHelper.c(this.a.dV() - 2.0 + randomsource.j() * 4.0);
            BlockPosition blockposition = new BlockPosition(i2, j2, k2);
            IBlockData iblockdata = world.a_(blockposition);
            Vec3D vec3d = new Vec3D((double)this.a.dO() + 0.5, (double)j2 + 0.5, (double)this.a.dU() + 0.5);
            Vec3D vec3d1 = new Vec3D((double)i2 + 0.5, (double)j2 + 0.5, (double)k2 + 0.5);
            MovingObjectPositionBlock movingobjectpositionblock = world.a(new RayTrace(vec3d, vec3d1, RayTrace.BlockCollisionOption.b, RayTrace.FluidCollisionOption.a, this.a));
            boolean flag = movingobjectpositionblock.b().equals(blockposition);
            if (iblockdata.a(TagsBlock.aB) && flag && CraftEventFactory.callEntityChangeBlockEvent(this.a, blockposition, Blocks.a.m())) {
                world.a(blockposition, false);
                world.a(GameEvent.f, blockposition, GameEvent.a.a(this.a, iblockdata));
                this.a.c(iblockdata.b().m());
            }
        }
    }

    private static class PathfinderGoalPlayerWhoLookedAtTarget
    extends PathfinderGoalNearestAttackableTarget<EntityHuman> {
        private final EntityEnderman i;
        private @Nullable EntityHuman j;
        private int k;
        private int l;
        private final PathfinderTargetCondition m;
        private final PathfinderTargetCondition n = PathfinderTargetCondition.a().d();
        private final PathfinderTargetCondition.a o;

        public PathfinderGoalPlayerWhoLookedAtTarget(EntityEnderman entityenderman, @Nullable PathfinderTargetCondition.a pathfindertargetcondition_a) {
            super(entityenderman, EntityHuman.class, 10, false, false, pathfindertargetcondition_a);
            this.i = entityenderman;
            this.o = (entityliving, worldserver) -> (entityenderman.g((EntityHuman)entityliving) || entityenderman.a(entityliving, worldserver)) && !entityenderman.B(entityliving);
            this.m = PathfinderTargetCondition.a().a(this.l()).a(this.o);
        }

        @Override
        public boolean b() {
            this.j = PathfinderGoalPlayerWhoLookedAtTarget.a(this.i).a(this.m.a(this.l()), this.i);
            return this.j != null;
        }

        @Override
        public void d() {
            this.k = this.a(5);
            this.l = 0;
            this.i.gT();
        }

        @Override
        public void e() {
            this.j = null;
            super.e();
        }

        @Override
        public boolean c() {
            if (this.j != null) {
                if (!this.o.test(this.j, PathfinderGoalPlayerWhoLookedAtTarget.a(this.i))) {
                    return false;
                }
                this.i.a((Entity)this.j, 10.0f, 10.0f);
                return true;
            }
            if (this.c != null) {
                if (this.i.B(this.c)) {
                    return false;
                }
                if (this.n.a(PathfinderGoalPlayerWhoLookedAtTarget.a(this.i), this.i, this.c)) {
                    return true;
                }
            }
            return super.c();
        }

        @Override
        public void a() {
            if (this.i.ag_() == null) {
                super.a((EntityLiving)null);
            }
            if (this.j != null) {
                if (--this.k <= 0) {
                    this.c = this.j;
                    this.j = null;
                    super.d();
                }
            } else {
                if (this.c != null && !this.i.cq()) {
                    if (this.i.g((EntityHuman)this.c)) {
                        if (this.c.g(this.i) < 16.0) {
                            this.i.gP();
                        }
                        this.l = 0;
                    } else if (this.c.g(this.i) > 256.0 && this.l++ >= this.a(30) && this.i.H(this.c)) {
                        this.l = 0;
                    }
                }
                super.a();
            }
        }
    }
}

