/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.EnumSet;
import java.util.Optional;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.MathHelper;
import net.minecraft.util.SystemUtils;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.InterpolationHandler;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.EntityAIBodyControl;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.golem.EntityGolem;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityShulkerBullet;
import net.minecraft.world.entity.projectile.arrow.EntityArrow;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftLocation;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.jspecify.annotations.Nullable;

public class EntityShulker
extends EntityGolem
implements IMonster {
    private static final MinecraftKey d = MinecraftKey.b("covered");
    private static final AttributeModifier e = new AttributeModifier(d, 20.0, AttributeModifier.Operation.a);
    protected static final DataWatcherObject<EnumDirection> a = DataWatcher.a(EntityShulker.class, DataWatcherRegistry.q);
    protected static final DataWatcherObject<Byte> b = DataWatcher.a(EntityShulker.class, DataWatcherRegistry.a);
    public static final DataWatcherObject<Byte> c = DataWatcher.a(EntityShulker.class, DataWatcherRegistry.a);
    private static final int f = 6;
    private static final byte cv = 16;
    private static final byte cw = 16;
    private static final int cx = 8;
    private static final int cy = 8;
    private static final int cz = 5;
    private static final float cA = 0.05f;
    private static final byte cB = 0;
    private static final EnumDirection cC = EnumDirection.a;
    static final Vector3f cD = SystemUtils.a(() -> {
        BaseBlockPosition baseblockposition = EnumDirection.d.q();
        return new Vector3f((float)baseblockposition.u(), (float)baseblockposition.v(), (float)baseblockposition.w());
    });
    private static final float cE = 3.0f;
    private float cF;
    private float cG;
    private @Nullable BlockPosition cH;
    private int cI;
    private static final float cJ = 1.0f;

    public EntityShulker(EntityTypes<? extends EntityShulker> entitytypes, World world) {
        super((EntityTypes<? extends EntityGolem>)entitytypes, world);
        this.cn = 5;
        this.co = new d(this);
    }

    @Override
    protected void D() {
        this.cs.a(1, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f, 0.02f, true));
        this.cs.a(4, new a());
        this.cs.a(7, new f());
        this.cs.a(8, new PathfinderGoalRandomLookaround(this));
        this.ct.a(1, new PathfinderGoalHurtByTarget(this, this.getClass()).a(new Class[0]));
        this.ct.a(2, new e(this));
        this.ct.a(3, new c(this));
    }

    @Override
    protected Entity.MovementEmission bv() {
        return Entity.MovementEmission.a;
    }

    @Override
    public SoundCategory dB() {
        return SoundCategory.f;
    }

    @Override
    protected SoundEffect W() {
        return SoundEffects.zS;
    }

    @Override
    public void T() {
        if (!this.gV()) {
            super.T();
        }
    }

    @Override
    protected SoundEffect fd() {
        return SoundEffects.zY;
    }

    @Override
    protected SoundEffect h(DamageSource damagesource) {
        return this.gV() ? SoundEffects.Aa : SoundEffects.zZ;
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(a, cC);
        datawatcher_a.a(b, (byte)0);
        datawatcher_a.a(c, (byte)16);
    }

    public static AttributeProvider.Builder k() {
        return EntityInsentient.E().a(GenericAttributes.u, 30.0);
    }

    @Override
    protected EntityAIBodyControl I() {
        return new b(this);
    }

    @Override
    protected void a(ValueInput valueinput) {
        super.a(valueinput);
        this.a(valueinput.a("AttachFace", EnumDirection.k).orElse(cC));
        this.az.a(b, valueinput.a("Peek", (byte)0));
        this.az.a(c, valueinput.a("Color", (byte)16));
    }

    @Override
    protected void a(ValueOutput valueoutput) {
        super.a(valueoutput);
        valueoutput.a("AttachFace", EnumDirection.k, this.gP());
        valueoutput.a("Peek", this.az.a(b));
        valueoutput.a("Color", this.az.a(c));
    }

    @Override
    public void g() {
        super.g();
        if (!(this.ao().B_() || this.cq() || this.a(this.dK(), this.gP()))) {
            this.gS();
        }
        if (this.gT()) {
            this.gU();
        }
        if (this.ao().B_()) {
            if (this.cI > 0) {
                --this.cI;
            } else {
                this.cH = null;
            }
        }
    }

    private void gS() {
        EnumDirection enumdirection = this.h(this.dK());
        if (enumdirection != null) {
            this.a(enumdirection);
        } else {
            this.p();
        }
    }

    @Override
    protected AxisAlignedBB c(Vec3D vec3d) {
        float f2 = EntityShulker.N(this.cG);
        EnumDirection enumdirection = this.gP().g();
        return EntityShulker.a(this.eF(), enumdirection, f2, vec3d);
    }

    private static float N(float f2) {
        return 0.5f - MathHelper.a((double)((0.5f + f2) * (float)Math.PI)) * 0.5f;
    }

    private boolean gT() {
        this.cF = this.cG;
        float f2 = (float)this.gX() * 0.01f;
        if (this.cG == f2) {
            return false;
        }
        this.cG = this.cG > f2 ? MathHelper.a(this.cG - 0.05f, f2, 1.0f) : MathHelper.a(this.cG + 0.05f, 0.0f, f2);
        return true;
    }

    private void gU() {
        this.aH();
        float f2 = EntityShulker.N(this.cG);
        float f1 = EntityShulker.N(this.cF);
        EnumDirection enumdirection = this.gP().g();
        float f22 = (f2 - f1) * this.eF();
        if (f22 > 0.0f) {
            for (Entity entity : this.ao().a((Entity)this, EntityShulker.a(this.eF(), enumdirection, f1, f2, this.dI()), IEntitySelector.f.and(entity1 -> !entity1.A(this)))) {
                if (entity instanceof EntityShulker || entity.ar) continue;
                entity.a(EnumMoveType.e, new Vec3D(f22 * (float)enumdirection.j(), f22 * (float)enumdirection.k(), f22 * (float)enumdirection.l()));
            }
        }
    }

    public static AxisAlignedBB a(float f2, EnumDirection enumdirection, float f1, Vec3D vec3d) {
        return EntityShulker.a(f2, enumdirection, -1.0f, f1, vec3d);
    }

    public static AxisAlignedBB a(float f2, EnumDirection enumdirection, float f1, float f22, Vec3D vec3d) {
        AxisAlignedBB axisalignedbb = new AxisAlignedBB((double)(-f2) * 0.5, 0.0, (double)(-f2) * 0.5, (double)f2 * 0.5, f2, (double)f2 * 0.5);
        double d0 = Math.max(f1, f22);
        double d1 = Math.min(f1, f22);
        AxisAlignedBB axisalignedbb1 = axisalignedbb.b((double)enumdirection.j() * d0 * (double)f2, (double)enumdirection.k() * d0 * (double)f2, (double)enumdirection.l() * d0 * (double)f2).a((double)(-enumdirection.j()) * (1.0 + d1) * (double)f2, (double)(-enumdirection.k()) * (1.0 + d1) * (double)f2, (double)(-enumdirection.l()) * (1.0 + d1) * (double)f2);
        return axisalignedbb1.d(vec3d.g, vec3d.h, vec3d.i);
    }

    @Override
    public boolean a(Entity entity, boolean flag, boolean flag1) {
        if (this.ao().B_()) {
            this.cH = null;
            this.cI = 0;
        }
        this.a(EnumDirection.a);
        return super.a(entity, flag, flag1);
    }

    @Override
    public void cf() {
        super.cf();
        if (this.ao().B_()) {
            this.cH = this.dK();
        }
        this.bD = 0.0f;
        this.bC = 0.0f;
    }

    @Override
    public @Nullable GroupDataEntity a(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EntitySpawnReason entityspawnreason, @Nullable GroupDataEntity groupdataentity) {
        this.v(0.0f);
        this.bE = this.ec();
        this.bP();
        return super.a(worldaccess, difficultydamagescaler, entityspawnreason, groupdataentity);
    }

    @Override
    public void a(EnumMoveType enummovetype, Vec3D vec3d) {
        if (enummovetype == EnumMoveType.d) {
            this.p();
        } else {
            super.a(enummovetype, vec3d);
        }
    }

    @Override
    public Vec3D dN() {
        return Vec3D.c;
    }

    @Override
    public void k(Vec3D vec3d) {
    }

    @Override
    public void a_(double d0, double d1, double d2) {
        BlockPosition blockposition1;
        BlockPosition blockposition = this.dK();
        if (this.cq()) {
            super.a_(d0, d1, d2);
        } else {
            super.a_((double)MathHelper.c(d0) + 0.5, MathHelper.c(d1 + 0.5), (double)MathHelper.c(d2) + 0.5);
        }
        if (this.at != 0 && !(blockposition1 = this.dK()).equals(blockposition)) {
            this.az.a(b, (byte)0);
            this.aF = true;
            if (this.ao().B_() && !this.cq() && !blockposition1.equals(this.cH)) {
                this.cH = blockposition;
                this.cI = 6;
                this.ao = this.dP();
                this.ap = this.dR();
                this.aq = this.dV();
            }
        }
    }

    protected @Nullable EnumDirection h(BlockPosition blockposition) {
        for (EnumDirection enumdirection : EnumDirection.values()) {
            if (!this.a(blockposition, enumdirection)) continue;
            return enumdirection;
        }
        return null;
    }

    boolean a(BlockPosition blockposition, EnumDirection enumdirection) {
        if (this.i(blockposition)) {
            return false;
        }
        EnumDirection enumdirection1 = enumdirection.g();
        if (!this.ao().a(blockposition.a(enumdirection), this, enumdirection1)) {
            return false;
        }
        AxisAlignedBB axisalignedbb = EntityShulker.a(this.eF(), enumdirection1, 1.0f, blockposition.c()).h(1.0E-6);
        return this.ao().a((Entity)this, axisalignedbb);
    }

    private boolean i(BlockPosition blockposition) {
        IBlockData iblockdata = this.ao().a_(blockposition);
        if (iblockdata.l()) {
            return false;
        }
        boolean flag = iblockdata.a(Blocks.ca) && blockposition.equals(this.dK());
        return !flag;
    }

    protected boolean p() {
        if (!this.gG() && this.cb()) {
            BlockPosition blockposition = this.dK();
            for (int i2 = 0; i2 < 5; ++i2) {
                EnumDirection enumdirection;
                BlockPosition blockposition1 = blockposition.b(MathHelper.b(this.as, -8, 8), MathHelper.b(this.as, -8, 8), MathHelper.b(this.as, -8, 8));
                if (blockposition1.v() <= this.ao().K_() || !this.ao().A(blockposition1) || !this.ao().w().a(blockposition1) || !this.ao().a((Entity)this, new AxisAlignedBB(blockposition1).h(1.0E-6)) || (enumdirection = this.h(blockposition1)) == null) continue;
                EntityTeleportEvent teleportEvent = CraftEventFactory.callEntityTeleportEvent(this, blockposition1.u(), blockposition1.v(), blockposition1.w());
                if (teleportEvent.isCancelled()) {
                    return false;
                }
                blockposition1 = CraftLocation.toBlockPosition(teleportEvent.getTo());
                this.aw();
                this.a(enumdirection);
                this.a(SoundEffects.Ad, 1.0f, 1.0f);
                this.a_((double)blockposition1.u() + 0.5, blockposition1.v(), (double)blockposition1.w() + 0.5);
                this.ao().a(GameEvent.R, blockposition, GameEvent.a.a(this));
                this.az.a(b, (byte)0);
                this.g((EntityLiving)null);
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public InterpolationHandler l_() {
        return null;
    }

    @Override
    public boolean a(WorldServer worldserver, DamageSource damagesource, float f2) {
        Entity entity1;
        Entity entity;
        if (this.gV() && (entity = damagesource.c()) instanceof EntityArrow) {
            return false;
        }
        if (!super.a(worldserver, damagesource, f2)) {
            return false;
        }
        if ((double)this.eZ() < (double)this.fq() * 0.5 && this.as.a(4) == 0) {
            this.p();
        } else if (damagesource.a(DamageTypeTags.j) && (entity1 = damagesource.c()) != null && entity1.ay() == EntityTypes.bl) {
            this.gW();
        }
        return true;
    }

    private boolean gV() {
        return this.gX() == 0;
    }

    private void gW() {
        Vec3D vec3d = this.dI();
        AxisAlignedBB axisalignedbb = this.dj();
        if (!this.gV() && this.p()) {
            EntityShulker entityshulker;
            int i2 = this.ao().a(EntityTypes.bk, axisalignedbb.g(8.0), Entity::cb).size();
            float f2 = (float)(i2 - 1) / 5.0f;
            if (this.ao().y.i() >= f2 && (entityshulker = EntityTypes.bk.a(this.ao(), EntitySpawnReason.e)) != null) {
                entityshulker.a(this.gQ());
                entityshulker.f(vec3d);
                this.ao().addFreshEntity(entityshulker, CreatureSpawnEvent.SpawnReason.BREEDING);
            }
        }
    }

    @Override
    public boolean j(@Nullable Entity entity) {
        return this.cb();
    }

    public EnumDirection gP() {
        return this.az.a(a);
    }

    public void a(EnumDirection enumdirection) {
        this.az.a(a, enumdirection);
    }

    @Override
    public void a(DataWatcherObject<?> datawatcherobject) {
        if (a.equals(datawatcherobject)) {
            this.a(this.aG());
        }
        super.a(datawatcherobject);
    }

    public int gX() {
        return this.az.a(b).byteValue();
    }

    public void a(int i2) {
        if (!this.ao().B_()) {
            this.h(GenericAttributes.b).c(d);
            if (i2 == 0) {
                this.h(GenericAttributes.b).d(e);
                this.a(SoundEffects.zX, 1.0f, 1.0f);
                this.c(GameEvent.j);
            } else {
                this.a(SoundEffects.Ab, 1.0f, 1.0f);
                this.c(GameEvent.k);
            }
        }
        this.az.a(b, (byte)i2);
    }

    public float L(float f2) {
        return MathHelper.h(f2, this.cF, this.cG);
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packetplayoutspawnentity) {
        super.a(packetplayoutspawnentity);
        this.bC = 0.0f;
        this.bD = 0.0f;
    }

    @Override
    public int ac() {
        return 180;
    }

    @Override
    public int ae() {
        return 180;
    }

    @Override
    public void h(Entity entity) {
    }

    public @Nullable Vec3D M(float f2) {
        if (this.cH != null && this.cI > 0) {
            double d0 = (double)((float)this.cI - f2) / 6.0;
            d0 *= d0;
            BlockPosition blockposition = this.dK();
            double d1 = (double)(blockposition.u() - this.cH.u()) * (d0 *= (double)this.eF());
            double d2 = (double)(blockposition.v() - this.cH.v()) * d0;
            double d3 = (double)(blockposition.w() - this.cH.w()) * d0;
            return new Vec3D(-d1, -d2, -d3);
        }
        return null;
    }

    @Override
    protected float c(float f2) {
        return Math.min(f2, 3.0f);
    }

    private void a(Optional<EnumColor> optional) {
        this.az.a(c, optional.map(enumcolor -> (byte)enumcolor.a()).orElse((byte)16));
    }

    public Optional<EnumColor> gQ() {
        return Optional.ofNullable(this.gR());
    }

    public @Nullable EnumColor gR() {
        byte b0 = this.az.a(c);
        return b0 != 16 && b0 <= 15 ? EnumColor.a(b0) : null;
    }

    @Override
    public <T> @Nullable T a(DataComponentType<? extends T> datacomponenttype) {
        return datacomponenttype == DataComponents.ba ? EntityShulker.c(datacomponenttype, this.gR()) : super.a(datacomponenttype);
    }

    @Override
    protected void a(DataComponentGetter datacomponentgetter) {
        this.a(datacomponentgetter, DataComponents.ba);
        super.a(datacomponentgetter);
    }

    @Override
    protected <T> boolean b(DataComponentType<T> datacomponenttype, T t0) {
        if (datacomponenttype == DataComponents.ba) {
            this.a(Optional.of(EntityShulker.c(DataComponents.ba, t0)));
            return true;
        }
        return super.b(datacomponenttype, t0);
    }

    private class d
    extends ControllerLook {
        public d(EntityInsentient entityinsentient) {
            super(entityinsentient);
        }

        @Override
        protected void b() {
        }

        @Override
        protected Optional<Float> i() {
            EnumDirection enumdirection = EntityShulker.this.gP().g();
            Vector3f vector3f = enumdirection.b().transform(new Vector3f((Vector3fc)cD));
            BaseBlockPosition baseblockposition = enumdirection.q();
            Vector3f vector3f1 = new Vector3f((float)baseblockposition.u(), (float)baseblockposition.v(), (float)baseblockposition.w());
            vector3f1.cross((Vector3fc)vector3f);
            double d0 = this.e - this.a.dP();
            double d1 = this.f - this.a.dT();
            double d2 = this.g - this.a.dV();
            Vector3f vector3f2 = new Vector3f((float)d0, (float)d1, (float)d2);
            float f2 = vector3f1.dot((Vector3fc)vector3f2);
            float f1 = vector3f.dot((Vector3fc)vector3f2);
            return Math.abs(f2) <= 1.0E-5f && Math.abs(f1) <= 1.0E-5f ? Optional.empty() : Optional.of(Float.valueOf((float)(MathHelper.d((double)(-f2), (double)f1) * 57.2957763671875)));
        }

        @Override
        protected Optional<Float> h() {
            return Optional.of(Float.valueOf(0.0f));
        }
    }

    private class a
    extends PathfinderGoal {
        private int b;

        public a() {
            this.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.b));
        }

        @Override
        public boolean b() {
            EntityLiving entityliving = EntityShulker.this.ag_();
            return entityliving != null && entityliving.cb() ? EntityShulker.this.ao().av() != EnumDifficulty.a : false;
        }

        @Override
        public void d() {
            this.b = 20;
            EntityShulker.this.a(100);
        }

        @Override
        public void e() {
            EntityShulker.this.a(0);
        }

        @Override
        public boolean X_() {
            return true;
        }

        @Override
        public void a() {
            if (EntityShulker.this.ao().av() != EnumDifficulty.a) {
                --this.b;
                EntityLiving entityliving = EntityShulker.this.ag_();
                if (entityliving != null) {
                    EntityShulker.this.J().a(entityliving, 180.0f, 180.0f);
                    double d0 = EntityShulker.this.g((Entity)entityliving);
                    if (d0 < 400.0) {
                        if (this.b <= 0) {
                            this.b = 20 + EntityShulker.this.as.a(10) * 20 / 2;
                            EntityShulker.this.ao().b(new EntityShulkerBullet(EntityShulker.this.ao(), EntityShulker.this, entityliving, EntityShulker.this.gP().o()));
                            EntityShulker.this.a(SoundEffects.Ac, 2.0f, (EntityShulker.this.as.i() - EntityShulker.this.as.i()) * 0.2f + 1.0f);
                        }
                    } else {
                        EntityShulker.this.g((EntityLiving)null);
                    }
                    super.a();
                }
            }
        }
    }

    private class f
    extends PathfinderGoal {
        private int b;

        f() {
        }

        @Override
        public boolean b() {
            return EntityShulker.this.ag_() == null && EntityShulker.this.as.a(net.minecraft.world.entity.monster.EntityShulker$f.b(40)) == 0 && EntityShulker.this.a(EntityShulker.this.dK(), EntityShulker.this.gP());
        }

        @Override
        public boolean c() {
            return EntityShulker.this.ag_() == null && this.b > 0;
        }

        @Override
        public void d() {
            this.b = this.a(20 * (1 + EntityShulker.this.as.a(3)));
            EntityShulker.this.a(30);
        }

        @Override
        public void e() {
            if (EntityShulker.this.ag_() == null) {
                EntityShulker.this.a(0);
            }
        }

        @Override
        public void a() {
            --this.b;
        }
    }

    private class e
    extends PathfinderGoalNearestAttackableTarget<EntityHuman> {
        public e(EntityShulker entityshulker) {
            super((EntityInsentient)entityshulker, EntityHuman.class, true);
        }

        @Override
        public boolean b() {
            return EntityShulker.this.ao().av() == EnumDifficulty.a ? false : super.b();
        }

        @Override
        protected AxisAlignedBB a(double d0) {
            EnumDirection enumdirection = ((EntityShulker)this.e).gP();
            return enumdirection.o() == EnumDirection.EnumAxis.a ? this.e.dj().c(4.0, d0, d0) : (enumdirection.o() == EnumDirection.EnumAxis.c ? this.e.dj().c(d0, d0, 4.0) : this.e.dj().c(d0, 4.0, d0));
        }
    }

    private static class c
    extends PathfinderGoalNearestAttackableTarget<EntityLiving> {
        public c(EntityShulker entityshulker) {
            super(entityshulker, EntityLiving.class, 10, true, false, (entityliving, worldserver) -> entityliving instanceof IMonster);
        }

        @Override
        public boolean b() {
            return this.e.cI() == null ? false : super.b();
        }

        @Override
        protected AxisAlignedBB a(double d0) {
            EnumDirection enumdirection = ((EntityShulker)this.e).gP();
            return enumdirection.o() == EnumDirection.EnumAxis.a ? this.e.dj().c(4.0, d0, d0) : (enumdirection.o() == EnumDirection.EnumAxis.c ? this.e.dj().c(d0, d0, 4.0) : this.e.dj().c(d0, 4.0, d0));
        }
    }

    private static class b
    extends EntityAIBodyControl {
        public b(EntityInsentient entityinsentient) {
            super(entityinsentient);
        }

        @Override
        public void a() {
        }
    }
}

