/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.EnumSet;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.ClimbOnTopOfPowderSnowGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStroll;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockMonsterEggs;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gamerules.GameRules;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.jspecify.annotations.Nullable;

public class EntitySilverfish
extends EntityMonster {
    private @Nullable PathfinderGoalSilverfishWakeOthers a;

    public EntitySilverfish(EntityTypes<? extends EntitySilverfish> entitytypes, World world) {
        super((EntityTypes<? extends EntityMonster>)entitytypes, world);
    }

    @Override
    protected void D() {
        this.a = new PathfinderGoalSilverfishWakeOthers(this);
        this.cs.a(1, new PathfinderGoalFloat(this));
        this.cs.a(1, new ClimbOnTopOfPowderSnowGoal(this, this.ao()));
        this.cs.a(3, this.a);
        this.cs.a(4, new PathfinderGoalMeleeAttack(this, 1.0, false));
        this.cs.a(5, new PathfinderGoalSilverfishHideInBlock(this));
        this.ct.a(1, new PathfinderGoalHurtByTarget(this, new Class[0]).a(new Class[0]));
        this.ct.a(2, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
    }

    public static AttributeProvider.Builder k() {
        return EntityMonster.gW().a(GenericAttributes.u, 8.0).a(GenericAttributes.x, 0.25).a(GenericAttributes.d, 1.0);
    }

    @Override
    protected Entity.MovementEmission bv() {
        return Entity.MovementEmission.c;
    }

    @Override
    protected SoundEffect W() {
        return SoundEffects.Ae;
    }

    @Override
    protected SoundEffect h(DamageSource damagesource) {
        return SoundEffects.Ag;
    }

    @Override
    protected SoundEffect fd() {
        return SoundEffects.Af;
    }

    @Override
    protected void b(BlockPosition blockposition, IBlockData iblockdata) {
        this.a(SoundEffects.Ah, 0.15f, 1.0f);
    }

    @Override
    public boolean a(WorldServer worldserver, DamageSource damagesource, float f2) {
        if (this.a(worldserver, damagesource)) {
            return false;
        }
        if ((damagesource.d() != null || damagesource.a(DamageTypeTags.x)) && this.a != null) {
            this.a.h();
        }
        return super.a(worldserver, damagesource, f2);
    }

    @Override
    public void g() {
        this.bC = this.ec();
        super.g();
    }

    @Override
    public void s(float f2) {
        this.v(f2);
        super.s(f2);
    }

    @Override
    public float a(BlockPosition blockposition, IWorldReader iworldreader) {
        return BlockMonsterEggs.p(iworldreader.a_(blockposition.e())) ? 10.0f : super.a(blockposition, iworldreader);
    }

    public static boolean b(EntityTypes<EntitySilverfish> entitytypes, GeneratorAccess generatoraccess, EntitySpawnReason entityspawnreason, BlockPosition blockposition, RandomSource randomsource) {
        if (!EntitySilverfish.c(entitytypes, generatoraccess, entityspawnreason, blockposition, randomsource)) {
            return false;
        }
        if (EntitySpawnReason.a(entityspawnreason)) {
            return true;
        }
        EntityHuman entityhuman = generatoraccess.a((double)blockposition.u() + 0.5, (double)blockposition.v() + 0.5, (double)blockposition.w() + 0.5, 5.0, true);
        return entityhuman == null;
    }

    private static class PathfinderGoalSilverfishWakeOthers
    extends PathfinderGoal {
        private final EntitySilverfish a;
        private int b;

        public PathfinderGoalSilverfishWakeOthers(EntitySilverfish entitysilverfish) {
            this.a = entitysilverfish;
        }

        public void h() {
            if (this.b == 0) {
                this.b = this.a(20);
            }
        }

        @Override
        public boolean b() {
            return this.b > 0;
        }

        @Override
        public void a() {
            --this.b;
            if (this.b <= 0) {
                World world = this.a.ao();
                RandomSource randomsource = this.a.ep();
                BlockPosition blockposition = this.a.dK();
                int i2 = 0;
                while (i2 <= 5 && i2 >= -5) {
                    int j2 = 0;
                    while (j2 <= 10 && j2 >= -10) {
                        int k2 = 0;
                        while (k2 <= 10 && k2 >= -10) {
                            BlockPosition blockposition1 = blockposition.b(j2, i2, k2);
                            IBlockData iblockdata = world.a_(blockposition1);
                            Block block = iblockdata.b();
                            if (block instanceof BlockMonsterEggs && CraftEventFactory.callEntityChangeBlockEvent(this.a, blockposition1, Blocks.a.m())) {
                                if (PathfinderGoalSilverfishWakeOthers.a(world).U().a(GameRules.F).booleanValue()) {
                                    world.a(blockposition1, true, this.a);
                                } else {
                                    world.a(blockposition1, ((BlockMonsterEggs)block).r(world.a_(blockposition1)), 3);
                                }
                                if (randomsource.h()) {
                                    return;
                                }
                            }
                            k2 = (k2 <= 0 ? 1 : 0) - k2;
                        }
                        j2 = (j2 <= 0 ? 1 : 0) - j2;
                    }
                    i2 = (i2 <= 0 ? 1 : 0) - i2;
                }
            }
        }
    }

    private static class PathfinderGoalSilverfishHideInBlock
    extends PathfinderGoalRandomStroll {
        private @Nullable EnumDirection i;
        private boolean j;

        public PathfinderGoalSilverfishHideInBlock(EntitySilverfish entitysilverfish) {
            super(entitysilverfish, 1.0, 10);
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean b() {
            if (this.b.ag_() != null) {
                return false;
            }
            if (!this.b.N().l()) {
                return false;
            }
            RandomSource randomsource = this.b.ep();
            if (PathfinderGoalSilverfishHideInBlock.a(this.b).U().a(GameRules.F).booleanValue() && randomsource.a(PathfinderGoalSilverfishHideInBlock.b(10)) == 0) {
                this.i = EnumDirection.b(randomsource);
                BlockPosition blockposition = BlockPosition.a(this.b.dP(), this.b.dR() + 0.5, this.b.dV()).a(this.i);
                IBlockData iblockdata = this.b.ao().a_(blockposition);
                if (BlockMonsterEggs.p(iblockdata)) {
                    this.j = true;
                    return true;
                }
            }
            this.j = false;
            return super.b();
        }

        @Override
        public boolean c() {
            return this.j ? false : super.c();
        }

        @Override
        public void d() {
            if (!this.j) {
                super.d();
            } else {
                BlockPosition blockposition;
                World generatoraccess = this.b.ao();
                IBlockData iblockdata = generatoraccess.a_(blockposition = BlockPosition.a(this.b.dP(), this.b.dR() + 0.5, this.b.dV()).a(this.i));
                if (BlockMonsterEggs.p(iblockdata)) {
                    if (!CraftEventFactory.callEntityChangeBlockEvent(this.b, blockposition, BlockMonsterEggs.q(iblockdata))) {
                        return;
                    }
                    generatoraccess.a(blockposition, BlockMonsterEggs.q(iblockdata), 3);
                    this.b.U();
                    this.b.discard(EntityRemoveEvent.Cause.ENTER_BLOCK);
                }
            }
        }
    }
}

