/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.EnumSet;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.attribute.EnvironmentAttributes;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.ConversionType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.golem.EntityIronGolem;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.ScoreboardTeam;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.entity.Slime;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.entity.SlimeSplitEvent;
import org.jspecify.annotations.Nullable;

public class EntitySlime
extends EntityInsentient
implements IMonster {
    private static final DataWatcherObject<Integer> cu = DataWatcher.a(EntitySlime.class, DataWatcherRegistry.b);
    public static final int a = 1;
    public static final int b = 127;
    public static final int c = 4;
    private static final boolean cv = false;
    public float d;
    public float e;
    public float f;
    private boolean cw = false;

    public EntitySlime(EntityTypes<? extends EntitySlime> entitytypes, World world) {
        super((EntityTypes<? extends EntityInsentient>)entitytypes, world);
        this.df();
        this.cp = new ControllerMoveSlime(this);
    }

    @Override
    protected void D() {
        this.cs.a(1, new PathfinderGoalSlimeRandomJump(this));
        this.cs.a(2, new PathfinderGoalSlimeNearestPlayer(this));
        this.cs.a(3, new PathfinderGoalSlimeRandomDirection(this));
        this.cs.a(5, new PathfinderGoalSlimeIdle(this));
        this.ct.a(1, new PathfinderGoalNearestAttackableTarget<EntityHuman>(this, EntityHuman.class, 10, true, false, (entityliving, worldserver) -> Math.abs(entityliving.dR() - this.dR()) <= 4.0));
        this.ct.a(3, new PathfinderGoalNearestAttackableTarget<EntityIronGolem>((EntityInsentient)this, EntityIronGolem.class, true));
    }

    @Override
    public SoundCategory dB() {
        return SoundCategory.f;
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(cu, 1);
    }

    @VisibleForTesting
    public void a(int i2, boolean flag) {
        int j2 = MathHelper.a(i2, 1, 127);
        this.az.a(cu, j2);
        this.aH();
        this.j_();
        this.h(GenericAttributes.u).a(j2 * j2);
        this.h(GenericAttributes.x).a(0.2f + 0.1f * (float)j2);
        this.h(GenericAttributes.d).a(j2);
        if (flag) {
            this.x(this.fq());
        }
        this.cn = j2;
    }

    public int gR() {
        return this.az.a(cu);
    }

    @Override
    protected void a(ValueOutput valueoutput) {
        super.a(valueoutput);
        valueoutput.a("Size", this.gR() - 1);
        valueoutput.a("wasOnGround", this.cw);
    }

    @Override
    protected void a(ValueInput valueinput) {
        this.a(valueinput.a("Size", 0) + 1, false);
        super.a(valueinput);
        this.cw = valueinput.a("wasOnGround", false);
    }

    public boolean gS() {
        return this.gR() <= 1;
    }

    protected ParticleParam p() {
        return Particles.Y;
    }

    @Override
    public void g() {
        this.f = this.e;
        this.e += (this.d - this.e) * 0.5f;
        super.g();
        if (this.aV() && !this.cw) {
            float f2 = this.a(this.aF()).a() * 2.0f;
            float f1 = f2 / 2.0f;
            int i2 = 0;
            while ((float)i2 < f2 * 16.0f) {
                float f22 = this.as.i() * ((float)Math.PI * 2);
                float f3 = this.as.i() * 0.5f + 0.5f;
                float f4 = MathHelper.a((double)f22) * f1 * f3;
                float f5 = MathHelper.b((double)f22) * f1 * f3;
                this.ao().a(this.p(), this.dP() + (double)f4, this.dR(), this.dV() + (double)f5, 0.0, 0.0, 0.0);
                ++i2;
            }
            this.a(this.gP(), this.fC(), ((this.as.i() - this.as.i()) * 0.2f + 1.0f) / 0.8f);
            this.d = -0.5f;
        } else if (!this.aV() && this.cw) {
            this.d = 1.0f;
        }
        this.cw = this.aV();
        this.gM();
    }

    protected void gM() {
        this.d *= 0.6f;
    }

    protected int gL() {
        return this.as.a(20) + 10;
    }

    @Override
    public void j_() {
        double d0 = this.dP();
        double d1 = this.dR();
        double d2 = this.dV();
        super.j_();
        this.a_(d0, d1, d2);
    }

    @Override
    public void a(DataWatcherObject<?> datawatcherobject) {
        if (cu.equals(datawatcherobject)) {
            this.j_();
            this.v(this.bE);
            this.bC = this.bE;
            if (this.by() && this.as.a(20) == 0) {
                this.bI();
            }
        }
        super.a(datawatcherobject);
    }

    public EntityTypes<? extends EntitySlime> ay() {
        return super.ay();
    }

    @Override
    public void a(Entity.RemovalReason entity_removalreason) {
        this.remove(entity_removalreason, null);
    }

    @Override
    public void remove(Entity.RemovalReason entity_removalreason, EntityRemoveEvent.Cause cause) {
        int i2 = this.gR();
        if (!this.ao().B_() && i2 > 1 && this.fa()) {
            float f2 = this.a(this.aF()).a();
            float f1 = f2 / 2.0f;
            int j2 = i2 / 2;
            int k2 = 2 + this.as.a(3);
            ScoreboardTeam scoreboardteam = this.cI();
            SlimeSplitEvent event = new SlimeSplitEvent((Slime)this.getBukkitEntity(), k2);
            this.ao().getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled() || event.getCount() <= 0) {
                super.remove(entity_removalreason, cause);
                return;
            }
            k2 = event.getCount();
            ArrayList<EntityLiving> slimes = new ArrayList<EntityLiving>(j2);
            for (int l2 = 0; l2 < k2; ++l2) {
                float f22 = ((float)(l2 % 2) - 0.5f) * f1;
                float f3 = ((float)(l2 / 2) - 0.5f) * f1;
                EntitySlime converted = this.convertTo(this.ay(), new ConversionParams(ConversionType.b, false, false, scoreboardteam), EntitySpawnReason.k, entityslime -> {
                    entityslime.a(j2, true);
                    entityslime.b(this.dP() + (double)f22, this.dR() + 0.5, this.dV() + (double)f3, this.as.i() * 360.0f, 0.0f);
                }, null, null);
                if (converted == null) continue;
                slimes.add(converted);
            }
            if (CraftEventFactory.callEntityTransformEvent((EntityLiving)this, slimes, EntityTransformEvent.TransformReason.SPLIT).isCancelled()) {
                super.remove(entity_removalreason, cause);
                return;
            }
            for (EntityLiving living : slimes) {
                this.ao().addFreshEntity(living, CreatureSpawnEvent.SpawnReason.SLIME_SPLIT);
            }
        }
        super.remove(entity_removalreason, cause);
    }

    @Override
    public void h(Entity entity) {
        super.h(entity);
        if (entity instanceof EntityIronGolem && this.gN()) {
            this.i((EntityLiving)entity);
        }
    }

    @Override
    public void a_(EntityHuman entityhuman) {
        if (this.gN()) {
            this.i(entityhuman);
        }
    }

    protected void i(EntityLiving entityliving) {
        World world = this.ao();
        if (world instanceof WorldServer) {
            DamageSource damagesource;
            WorldServer worldserver = (WorldServer)world;
            if (this.cb() && this.h(entityliving) && this.G(entityliving) && entityliving.a(worldserver, damagesource = this.en().b(this), this.gO())) {
                this.a(SoundEffects.Aw, 1.0f, (this.as.i() - this.as.i()) * 0.2f + 1.0f);
                EnchantmentManager.a(worldserver, (Entity)entityliving, damagesource);
            }
        }
    }

    @Override
    protected Vec3D a(Entity entity, EntitySize entitysize, float f2) {
        return new Vec3D(0.0, (double)entitysize.b() - 0.015625 * (double)this.gR() * (double)f2, 0.0);
    }

    protected boolean gN() {
        return !this.gS() && this.dy();
    }

    protected float gO() {
        return (float)this.i(GenericAttributes.d);
    }

    @Override
    protected SoundEffect h(DamageSource damagesource) {
        return this.gS() ? SoundEffects.By : SoundEffects.Ay;
    }

    @Override
    protected SoundEffect fd() {
        return this.gS() ? SoundEffects.Bx : SoundEffects.Ax;
    }

    protected SoundEffect gP() {
        return this.gS() ? SoundEffects.BA : SoundEffects.AA;
    }

    public static boolean c(EntityTypes<EntitySlime> entitytypes, GeneratorAccess generatoraccess, EntitySpawnReason entityspawnreason, BlockPosition blockposition, RandomSource randomsource) {
        if (generatoraccess.av() != EnumDifficulty.a) {
            boolean flag;
            if (EntitySpawnReason.a(entityspawnreason)) {
                return EntitySlime.a(entitytypes, generatoraccess, entityspawnreason, blockposition, randomsource);
            }
            if (generatoraccess.z(blockposition).a(BiomeTags.an) && blockposition.v() > 50 && blockposition.v() < 70) {
                float f2 = generatoraccess.ad().a(EnvironmentAttributes.M, blockposition).floatValue();
                if (randomsource.i() < f2 && generatoraccess.G(blockposition) <= randomsource.a(8)) {
                    return EntitySlime.a(entitytypes, generatoraccess, entityspawnreason, blockposition, randomsource);
                }
            }
            if (!(generatoraccess instanceof GeneratorAccessSeed)) {
                return false;
            }
            ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(blockposition);
            boolean bl = flag = SeededRandom.a(chunkcoordintpair.h, chunkcoordintpair.i, ((GeneratorAccessSeed)generatoraccess).J(), generatoraccess.getMinecraftWorld().spigotConfig.slimeSeed).a(10) == 0;
            if (randomsource.a(10) == 0 && flag && blockposition.v() < 40) {
                return EntitySlime.a(entitytypes, generatoraccess, entityspawnreason, blockposition, randomsource);
            }
        }
        return false;
    }

    @Override
    protected float fC() {
        return 0.4f * (float)this.gR();
    }

    @Override
    public int ac() {
        return 0;
    }

    protected boolean gT() {
        return this.gR() > 0;
    }

    @Override
    public void u() {
        Vec3D vec3d = this.dN();
        this.m(vec3d.g, this.fF(), vec3d.i);
        this.aF = true;
    }

    @Override
    public @Nullable GroupDataEntity a(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EntitySpawnReason entityspawnreason, @Nullable GroupDataEntity groupdataentity) {
        RandomSource randomsource = worldaccess.G_();
        int i2 = randomsource.a(3);
        if (i2 < 2 && randomsource.i() < 0.5f * difficultydamagescaler.d()) {
            ++i2;
        }
        int j2 = 1 << i2;
        this.a(j2, true);
        return super.a(worldaccess, difficultydamagescaler, entityspawnreason, groupdataentity);
    }

    float k() {
        float f2 = this.gS() ? 1.4f : 0.8f;
        return ((this.as.i() - this.as.i()) * 0.2f + 1.0f) * f2;
    }

    protected SoundEffect gQ() {
        return this.gS() ? SoundEffects.Bz : SoundEffects.Az;
    }

    @Override
    public EntitySize b(EntityPose entitypose) {
        return super.b(entitypose).a(this.gR());
    }

    private static class ControllerMoveSlime
    extends ControllerMove {
        private float l;
        private int m;
        private final EntitySlime n;
        private boolean o;

        public ControllerMoveSlime(EntitySlime entityslime) {
            super(entityslime);
            this.n = entityslime;
            this.l = 180.0f * entityslime.ec() / (float)Math.PI;
        }

        public void a(float f2, boolean flag) {
            this.l = f2;
            this.o = flag;
        }

        public void a(double d0) {
            this.h = d0;
            this.k = ControllerMove.Operation.b;
        }

        @Override
        public void a() {
            this.d.v(this.b(this.d.ec(), this.l, 90.0f));
            this.d.bE = this.d.ec();
            this.d.bC = this.d.ec();
            if (this.k != ControllerMove.Operation.b) {
                this.d.I(0.0f);
            } else {
                this.k = ControllerMove.Operation.a;
                if (this.d.aV()) {
                    this.d.C((float)(this.h * this.d.i(GenericAttributes.x)));
                    if (this.m-- <= 0) {
                        this.m = this.n.gL();
                        if (this.o) {
                            this.m /= 3;
                        }
                        this.n.L().a();
                        if (this.n.gT()) {
                            this.n.a(this.n.gQ(), this.n.fC(), this.n.k());
                        }
                    } else {
                        this.n.bN = 0.0f;
                        this.n.bP = 0.0f;
                        this.d.C(0.0f);
                    }
                } else {
                    this.d.C((float)(this.h * this.d.i(GenericAttributes.x)));
                }
            }
        }
    }

    private static class PathfinderGoalSlimeRandomJump
    extends PathfinderGoal {
        private final EntitySlime a;

        public PathfinderGoalSlimeRandomJump(EntitySlime entityslime) {
            this.a = entityslime;
            this.a(EnumSet.of(PathfinderGoal.Type.c, PathfinderGoal.Type.a));
            entityslime.N().a(true);
        }

        @Override
        public boolean b() {
            return (this.a.by() || this.a.bN()) && this.a.K() instanceof ControllerMoveSlime;
        }

        @Override
        public boolean X_() {
            return true;
        }

        @Override
        public void a() {
            ControllerMove controllermove;
            if (this.a.ep().i() < 0.8f) {
                this.a.L().a();
            }
            if ((controllermove = this.a.K()) instanceof ControllerMoveSlime) {
                ControllerMoveSlime entityslime_controllermoveslime = (ControllerMoveSlime)controllermove;
                entityslime_controllermoveslime.a(1.2);
            }
        }
    }

    private static class PathfinderGoalSlimeNearestPlayer
    extends PathfinderGoal {
        private final EntitySlime a;
        private int b;

        public PathfinderGoalSlimeNearestPlayer(EntitySlime entityslime) {
            this.a = entityslime;
            this.a(EnumSet.of(PathfinderGoal.Type.b));
        }

        @Override
        public boolean b() {
            EntityLiving entityliving = this.a.ag_();
            return entityliving == null ? false : (!this.a.c(entityliving) ? false : this.a.K() instanceof ControllerMoveSlime);
        }

        @Override
        public void d() {
            this.b = PathfinderGoalSlimeNearestPlayer.b(300);
            super.d();
        }

        @Override
        public boolean c() {
            EntityLiving entityliving = this.a.ag_();
            return entityliving == null ? false : (!this.a.c(entityliving) ? false : --this.b > 0);
        }

        @Override
        public boolean X_() {
            return true;
        }

        @Override
        public void a() {
            ControllerMove controllermove;
            EntityLiving entityliving = this.a.ag_();
            if (entityliving != null) {
                this.a.a((Entity)entityliving, 10.0f, 10.0f);
            }
            if ((controllermove = this.a.K()) instanceof ControllerMoveSlime) {
                ControllerMoveSlime entityslime_controllermoveslime = (ControllerMoveSlime)controllermove;
                entityslime_controllermoveslime.a(this.a.ec(), this.a.gN());
            }
        }
    }

    private static class PathfinderGoalSlimeRandomDirection
    extends PathfinderGoal {
        private final EntitySlime a;
        private float b;
        private int c;

        public PathfinderGoalSlimeRandomDirection(EntitySlime entityslime) {
            this.a = entityslime;
            this.a(EnumSet.of(PathfinderGoal.Type.b));
        }

        @Override
        public boolean b() {
            return this.a.ag_() == null && (this.a.aV() || this.a.by() || this.a.bN() || this.a.d(MobEffects.y)) && this.a.K() instanceof ControllerMoveSlime;
        }

        @Override
        public void a() {
            ControllerMove controllermove;
            if (--this.c <= 0) {
                this.c = this.a(40 + this.a.ep().a(60));
                this.b = this.a.ep().a(360);
            }
            if ((controllermove = this.a.K()) instanceof ControllerMoveSlime) {
                ControllerMoveSlime entityslime_controllermoveslime = (ControllerMoveSlime)controllermove;
                entityslime_controllermoveslime.a(this.b, false);
            }
        }
    }

    private static class PathfinderGoalSlimeIdle
    extends PathfinderGoal {
        private final EntitySlime a;

        public PathfinderGoalSlimeIdle(EntitySlime entityslime) {
            this.a = entityslime;
            this.a(EnumSet.of(PathfinderGoal.Type.c, PathfinderGoal.Type.a));
        }

        @Override
        public boolean b() {
            return !this.a.cq();
        }

        @Override
        public void a() {
            ControllerMove controllermove = this.a.K();
            if (controllermove instanceof ControllerMoveSlime) {
                ControllerMoveSlime entityslime_controllermoveslime = (ControllerMoveSlime)controllermove;
                entityslime_controllermoveslime.a(1.0);
            }
        }
    }
}

