/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ISteerable;
import net.minecraft.world.entity.SaddleStorage;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalGotoTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStroll;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.monster.zombie.EntityZombie;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.DismountUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.BlockFluids;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.Pathfinder;
import net.minecraft.world.level.pathfinder.PathfinderNormal;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.jspecify.annotations.Nullable;

public class EntityStrider
extends EntityAnimal
implements ISteerable {
    private static final MinecraftKey cv = MinecraftKey.b("suffocating");
    private static final AttributeModifier cw = new AttributeModifier(cv, -0.34f, AttributeModifier.Operation.b);
    private static final float cx = 0.35f;
    private static final float cz = 0.55f;
    private static final DataWatcherObject<Integer> cA = DataWatcher.a(EntityStrider.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Boolean> cB = DataWatcher.a(EntityStrider.class, DataWatcherRegistry.k);
    public final SaddleStorage cC;
    private @Nullable PathfinderGoalTempt cD;

    public EntityStrider(EntityTypes<? extends EntityStrider> entitytypes, World world) {
        super((EntityTypes<? extends EntityAnimal>)entitytypes, world);
        this.cC = new SaddleStorage(this.az, cA);
        this.W = true;
        this.a(PathType.j, -1.0f);
        this.a(PathType.i, 0.0f);
        this.a(PathType.n, 0.0f);
        this.a(PathType.o, 0.0f);
    }

    public static boolean c(EntityTypes<EntityStrider> entitytypes, GeneratorAccess generatoraccess, EntitySpawnReason entityspawnreason, BlockPosition blockposition, RandomSource randomsource) {
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = blockposition.k();
        do {
            blockposition_mutableblockposition.c(EnumDirection.b);
        } while (generatoraccess.b_(blockposition_mutableblockposition).a(TagsFluid.b));
        return generatoraccess.a_(blockposition_mutableblockposition).l();
    }

    @Override
    public void a(DataWatcherObject<?> datawatcherobject) {
        if (cA.equals(datawatcherobject) && this.ao().B_()) {
            this.cC.a();
        }
        super.a(datawatcherobject);
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(cA, 0);
        datawatcher_a.a(cB, false);
    }

    @Override
    public boolean e(EnumItemSlot enumitemslot) {
        return enumitemslot != EnumItemSlot.h ? super.e(enumitemslot) : this.cb() && !this.e_();
    }

    @Override
    protected boolean f(EnumItemSlot enumitemslot) {
        return enumitemslot == EnumItemSlot.h || super.f(enumitemslot);
    }

    @Override
    protected Holder<SoundEffect> a(EnumItemSlot enumitemslot, ItemStack itemstack, Equippable equippable) {
        return enumitemslot == EnumItemSlot.h ? SoundEffects.Bw : super.a(enumitemslot, itemstack, equippable);
    }

    @Override
    protected void D() {
        this.cs.a(1, new PathfinderGoalPanic(this, 1.65));
        this.cs.a(2, new PathfinderGoalBreed(this, 1.0));
        this.cD = new PathfinderGoalTempt(this, 1.4, itemstack -> itemstack.a(TagsItem.bd), false);
        this.cs.a(3, this.cD);
        this.cs.a(4, new a(this, 1.0));
        this.cs.a(5, new PathfinderGoalFollowParent(this, 1.0));
        this.cs.a(7, new PathfinderGoalRandomStroll(this, 1.0, 60));
        this.cs.a(8, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.cs.a(8, new PathfinderGoalRandomLookaround(this));
        this.cs.a(9, new PathfinderGoalLookAtPlayer(this, EntityStrider.class, 8.0f));
    }

    public void x(boolean flag) {
        this.az.a(cB, flag);
        AttributeModifiable attributemodifiable = this.h(GenericAttributes.x);
        if (attributemodifiable != null) {
            if (flag) {
                attributemodifiable.a(cw);
            } else {
                attributemodifiable.c(cv);
            }
        }
    }

    public boolean p() {
        return this.az.a(cB);
    }

    @Override
    public boolean a(Fluid fluid) {
        return fluid.a(TagsFluid.b);
    }

    @Override
    protected Vec3D a(Entity entity, EntitySize entitysize, float f2) {
        if (!this.ao().B_()) {
            return super.a(entity, entitysize, f2);
        }
        float f1 = Math.min(0.25f, this.bB.b());
        float f22 = this.bB.c();
        float f3 = 0.12f * MathHelper.b((double)(f22 * 1.5f)) * 2.0f * f1;
        return super.a(entity, entitysize, f2).b(0.0, f3 * f2, 0.0);
    }

    @Override
    public boolean a(IWorldReader iworldreader) {
        return iworldreader.f(this);
    }

    @Override
    public @Nullable EntityLiving dl() {
        EntityHuman entityhuman;
        Entity entity;
        if (this.al() && (entity = this.do()) instanceof EntityHuman && (entityhuman = (EntityHuman)entity).b(Items.po)) {
            return entityhuman;
        }
        return super.dl();
    }

    @Override
    public Vec3D b(EntityLiving entityliving) {
        Vec3D[] avec3d = new Vec3D[]{EntityStrider.a(this.dF(), (double)entityliving.dF(), entityliving.ec()), EntityStrider.a(this.dF(), (double)entityliving.dF(), entityliving.ec() - 22.5f), EntityStrider.a(this.dF(), (double)entityliving.dF(), entityliving.ec() + 22.5f), EntityStrider.a(this.dF(), (double)entityliving.dF(), entityliving.ec() - 45.0f), EntityStrider.a(this.dF(), (double)entityliving.dF(), entityliving.ec() + 45.0f)};
        LinkedHashSet set = Sets.newLinkedHashSet();
        double d0 = this.dj().e;
        double d1 = this.dj().b - 0.5;
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        for (Vec3D vec3d : avec3d) {
            blockposition_mutableblockposition.b(this.dP() + vec3d.g, d0, this.dV() + vec3d.i);
            for (double d2 = d0; d2 > d1; d2 -= 1.0) {
                set.add(blockposition_mutableblockposition.j());
                blockposition_mutableblockposition.c(EnumDirection.a);
            }
        }
        for (BlockPosition blockposition : set) {
            double d3;
            if (this.ao().b_(blockposition).a(TagsFluid.b) || !DismountUtil.a(d3 = this.ao().m(blockposition))) continue;
            Vec3D vec3d1 = Vec3D.a(blockposition, d3);
            for (EntityPose entitypose : entityliving.go()) {
                AxisAlignedBB axisalignedbb = entityliving.f(entitypose);
                if (!DismountUtil.a(this.ao(), entityliving, axisalignedbb.c(vec3d1))) continue;
                entityliving.c(entitypose);
                return vec3d1;
            }
        }
        return new Vec3D(this.dP(), this.dj().e, this.dV());
    }

    @Override
    protected void a(EntityHuman entityhuman, Vec3D vec3d) {
        this.a(entityhuman.ec(), entityhuman.ee() * 0.5f);
        this.bC = this.bE = this.ec();
        this.ab = this.bE;
        this.cC.b();
        super.a(entityhuman, vec3d);
    }

    @Override
    protected Vec3D b(EntityHuman entityhuman, Vec3D vec3d) {
        return new Vec3D(0.0, 0.0, 1.0);
    }

    @Override
    protected float f(EntityHuman entityhuman) {
        return (float)(this.i(GenericAttributes.x) * (double)(this.p() ? 0.35f : 0.55f) * (double)this.cC.c());
    }

    @Override
    protected float bj() {
        return this.al + 0.6f;
    }

    @Override
    protected void b(BlockPosition blockposition, IBlockData iblockdata) {
        this.a(this.bN() ? SoundEffects.Bu : SoundEffects.Bt, 1.0f, 1.0f);
    }

    @Override
    public boolean a() {
        return this.cC.a(this.ep());
    }

    @Override
    protected void a(double d0, boolean flag, IBlockData iblockdata, BlockPosition blockposition) {
        if (this.bN()) {
            this.l();
        } else {
            super.a(d0, flag, iblockdata, blockposition);
        }
    }

    @Override
    public void g() {
        if (this.gQ() && this.as.a(140) == 0) {
            this.b(SoundEffects.Bp);
        } else if (this.gM() && this.as.a(60) == 0) {
            this.b(SoundEffects.Bq);
        }
        if (!this.gG()) {
            boolean suffocating;
            EntityStrider entitystrider;
            IBlockData iblockdata = this.ao().a_(this.dK());
            IBlockData iblockdata1 = this.bJ();
            boolean flag = iblockdata.a(TagsBlock.bg) || iblockdata1.a(TagsBlock.bg) || this.b(TagsFluid.b) > 0.0;
            Entity entity = this.dz();
            boolean flag1 = entity instanceof EntityStrider && (entitystrider = (EntityStrider)entity).p();
            boolean flag2 = flag1;
            boolean bl = suffocating = !flag || flag2;
            if (suffocating ^ this.p() && CraftEventFactory.callStriderTemperatureChangeEvent(this, suffocating)) {
                this.x(suffocating);
            }
        }
        super.g();
        this.gR();
    }

    private boolean gQ() {
        return this.cD != null && this.cD.k();
    }

    @Override
    protected boolean F() {
        return true;
    }

    private void gR() {
        if (this.bN()) {
            VoxelShapeCollision voxelshapecollision = VoxelShapeCollision.a(this);
            if (voxelshapecollision.a(BlockFluids.d, this.dK(), true) && !this.ao().b_(this.dK().d()).a(TagsFluid.b)) {
                this.e(true);
            } else {
                this.k(this.dN().c(0.5).b(0.0, 0.05, 0.0));
            }
        }
    }

    public static AttributeProvider.Builder gP() {
        return EntityAnimal.gW().a(GenericAttributes.x, 0.175f);
    }

    @Override
    protected @Nullable SoundEffect W() {
        return !this.gM() && !this.gQ() ? SoundEffects.Bo : null;
    }

    @Override
    protected SoundEffect h(DamageSource damagesource) {
        return SoundEffects.Bs;
    }

    @Override
    protected SoundEffect fd() {
        return SoundEffects.Br;
    }

    @Override
    protected boolean s(Entity entity) {
        return !this.cr() && !((Entity)this).a(TagsFluid.b);
    }

    @Override
    public boolean fR() {
        return true;
    }

    @Override
    public boolean cp() {
        return false;
    }

    @Override
    protected NavigationAbstract b(World world) {
        return new b(this, world);
    }

    @Override
    public float a(BlockPosition blockposition, IWorldReader iworldreader) {
        return iworldreader.a_(blockposition).y().a(TagsFluid.b) ? 10.0f : (this.bN() ? Float.NEGATIVE_INFINITY : 0.0f);
    }

    public @Nullable EntityStrider b(WorldServer worldserver, EntityAgeable entityageable) {
        return EntityTypes.bB.a(worldserver, EntitySpawnReason.e);
    }

    @Override
    public boolean j(ItemStack itemstack) {
        return itemstack.a(TagsItem.bc);
    }

    @Override
    public EnumInteractionResult b(EntityHuman entityhuman, EnumHand enumhand) {
        boolean flag = this.j(entityhuman.b(enumhand));
        if (!flag && this.al() && !this.cr() && !entityhuman.gA()) {
            if (!this.ao().B_()) {
                entityhuman.o(this);
            }
            return EnumInteractionResult.a;
        }
        EnumInteractionResult enuminteractionresult = super.b(entityhuman, enumhand);
        if (!enuminteractionresult.a()) {
            ItemStack itemstack = entityhuman.b(enumhand);
            return this.a(itemstack, EnumItemSlot.h) ? itemstack.a(entityhuman, (EntityLiving)this, enumhand) : EnumInteractionResult.e;
        }
        if (flag && !this.bq()) {
            this.ao().a((Entity)null, this.dP(), this.dR(), this.dV(), SoundEffects.Bv, this.dB(), 1.0f, 1.0f + (this.as.i() - this.as.i()) * 0.2f);
        }
        return enuminteractionresult;
    }

    @Override
    public Vec3D B() {
        return new Vec3D(0.0, 0.6f * this.dk(), this.dF() * 0.4f);
    }

    @Override
    public @Nullable GroupDataEntity a(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EntitySpawnReason entityspawnreason, @Nullable GroupDataEntity groupdataentity) {
        if (this.e_()) {
            return super.a(worldaccess, difficultydamagescaler, entityspawnreason, groupdataentity);
        }
        RandomSource randomsource = worldaccess.G_();
        if (randomsource.a(30) == 0) {
            EntityInsentient entityinsentient = EntityTypes.ca.a(worldaccess.a(), EntitySpawnReason.g);
            if (entityinsentient != null) {
                groupdataentity = this.a(worldaccess, difficultydamagescaler, entityinsentient, (GroupDataEntity)new EntityZombie.GroupDataZombie(EntityZombie.a(randomsource), false));
                entityinsentient.a(EnumItemSlot.a, new ItemStack(Items.po));
                this.a(EnumItemSlot.h, new ItemStack(Items.oR));
                this.g(EnumItemSlot.h);
            }
        } else if (randomsource.a(10) == 0) {
            EntityAgeable entityageable = EntityTypes.bB.a(worldaccess.a(), EntitySpawnReason.g);
            if (entityageable != null) {
                entityageable.d_(-24000);
                groupdataentity = this.a(worldaccess, difficultydamagescaler, entityageable, (GroupDataEntity)null);
            }
        } else {
            groupdataentity = new EntityAgeable.a(0.5f);
        }
        return super.a(worldaccess, difficultydamagescaler, entityspawnreason, groupdataentity);
    }

    private GroupDataEntity a(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EntityInsentient entityinsentient, @Nullable GroupDataEntity groupdataentity) {
        entityinsentient.b(this.dP(), this.dR(), this.dV(), this.ec(), 0.0f);
        entityinsentient.a(worldaccess, difficultydamagescaler, EntitySpawnReason.g, groupdataentity);
        entityinsentient.a((Entity)this, true, false);
        return new EntityAgeable.a(0.0f);
    }

    private static class a
    extends PathfinderGoalGotoTarget {
        private final EntityStrider g;

        a(EntityStrider entitystrider, double d0) {
            super(entitystrider, d0, 8, 2);
            this.g = entitystrider;
        }

        @Override
        public BlockPosition k() {
            return this.e;
        }

        @Override
        public boolean c() {
            return !this.g.bN() && this.a(this.g.ao(), this.e);
        }

        @Override
        public boolean b() {
            return !this.g.bN() && super.b();
        }

        @Override
        public boolean l() {
            return this.d % 20 == 0;
        }

        @Override
        protected boolean a(IWorldReader iworldreader, BlockPosition blockposition) {
            return iworldreader.a_(blockposition).a(Blocks.K) && iworldreader.a_(blockposition.d()).a(PathMode.a);
        }
    }

    private static class b
    extends Navigation {
        b(EntityStrider entitystrider, World world) {
            super(entitystrider, world);
        }

        @Override
        protected Pathfinder a(int i2) {
            this.o = new PathfinderNormal();
            return new Pathfinder(this.o, i2);
        }

        @Override
        protected boolean a(PathType pathtype) {
            return pathtype != PathType.i && pathtype != PathType.o && pathtype != PathType.n ? super.a(pathtype) : true;
        }

        @Override
        public boolean a(BlockPosition blockposition) {
            return this.b.a_(blockposition).a(Blocks.K) || super.a(blockposition);
        }
    }
}

