/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.zombie;

import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SpecialDates;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntityPositionTypes;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreakDoor;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMoveThroughVillage;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRemoveBlock;
import net.minecraft.world.entity.ai.goal.PathfinderGoalZombieAttack;
import net.minecraft.world.entity.ai.goal.SpearUseGoal;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.chicken.EntityChicken;
import net.minecraft.world.entity.animal.golem.EntityIronGolem;
import net.minecraft.world.entity.animal.turtle.EntityTurtle;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.zombie.EntityPigZombie;
import net.minecraft.world.entity.monster.zombie.EntityZombieVillager;
import net.minecraft.world.entity.npc.villager.EntityVillager;
import net.minecraft.world.entity.npc.villager.EntityVillagerAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.bukkit.entity.Zombie;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.jspecify.annotations.Nullable;

public class EntityZombie
extends EntityMonster {
    private static final MinecraftKey a = MinecraftKey.b("baby");
    private static final AttributeModifier f = new AttributeModifier(a, 0.5, AttributeModifier.Operation.b);
    private static final MinecraftKey cv = MinecraftKey.b("reinforcement_caller_charge");
    private static final AttributeModifier cw = new AttributeModifier(MinecraftKey.b("reinforcement_callee_charge"), -0.05f, AttributeModifier.Operation.a);
    private static final MinecraftKey cx = MinecraftKey.b("leader_zombie_bonus");
    private static final MinecraftKey cy = MinecraftKey.b("zombie_random_spawn_bonus");
    private static final DataWatcherObject<Boolean> cz = DataWatcher.a(EntityZombie.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Integer> cA = DataWatcher.a(EntityZombie.class, DataWatcherRegistry.b);
    public static final DataWatcherObject<Boolean> cB = DataWatcher.a(EntityZombie.class, DataWatcherRegistry.k);
    public static final float b = 0.05f;
    public static final int c = 50;
    public static final int d = 40;
    public static final int e = 7;
    private static final int cC = -1;
    private static final EntitySize cD = EntityTypes.bW.n().a(0.5f).b(0.93f);
    private static final float cE = 0.1f;
    private static final Predicate<EnumDifficulty> cF = enumdifficulty -> enumdifficulty == EnumDifficulty.d;
    private static final boolean cG = false;
    private static final boolean cH = false;
    private static final int cI = 0;
    private final PathfinderGoalBreakDoor cJ;
    private boolean cK = false;
    private int cL = 0;
    public int cM;
    private int lastTick = MinecraftServer.currentTick;

    public EntityZombie(EntityTypes<? extends EntityZombie> entitytypes, World world) {
        super((EntityTypes<? extends EntityMonster>)entitytypes, world);
        this.cJ = new PathfinderGoalBreakDoor(this, cF);
    }

    public EntityZombie(World world) {
        this((EntityTypes<? extends EntityZombie>)EntityTypes.bW, world);
    }

    @Override
    protected void D() {
        this.cs.a(4, new a((EntityCreature)this, 1.0, 3));
        this.cs.a(8, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.cs.a(8, new PathfinderGoalRandomLookaround(this));
        this.p();
    }

    protected void p() {
        this.cs.a(2, new SpearUseGoal<EntityZombie>(this, 1.0, 1.0, 10.0f, 2.0f));
        this.cs.a(3, new PathfinderGoalZombieAttack(this, 1.0, false));
        this.cs.a(6, new PathfinderGoalMoveThroughVillage(this, 1.0, true, 4, this::gX));
        this.cs.a(7, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.ct.a(1, new PathfinderGoalHurtByTarget(this, new Class[0]).a(EntityPigZombie.class));
        this.ct.a(2, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
        if (this.ao().spigotConfig.zombieAggressiveTowardsVillager) {
            this.ct.a(3, new PathfinderGoalNearestAttackableTarget<EntityVillagerAbstract>((EntityInsentient)this, EntityVillagerAbstract.class, false));
        }
        this.ct.a(3, new PathfinderGoalNearestAttackableTarget<EntityIronGolem>((EntityInsentient)this, EntityIronGolem.class, true));
        this.ct.a(5, new PathfinderGoalNearestAttackableTarget<EntityTurtle>(this, EntityTurtle.class, 10, true, false, EntityTurtle.cv));
    }

    public static AttributeProvider.Builder gT() {
        return EntityMonster.gW().a(GenericAttributes.o, 35.0).a(GenericAttributes.x, 0.23f).a(GenericAttributes.d, 3.0).a(GenericAttributes.b, 2.0).a(GenericAttributes.C);
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(cz, false);
        datawatcher_a.a(cA, 0);
        datawatcher_a.a(cB, false);
    }

    public boolean gU() {
        return this.aD().a(cB);
    }

    public boolean gX() {
        return this.cK;
    }

    public void y(boolean flag) {
        if (this.cr.c()) {
            if (this.cK != flag) {
                this.cK = flag;
                this.cr.e(flag);
                if (flag) {
                    this.cs.a(1, this.cJ);
                } else {
                    this.cs.a(this.cJ);
                }
            }
        } else if (this.cK) {
            this.cs.a(this.cJ);
            this.cK = false;
        }
    }

    @Override
    public boolean e_() {
        return this.aD().a(cz);
    }

    @Override
    protected int f(WorldServer worldserver) {
        if (this.e_()) {
            this.cn = (int)((double)this.cn * 2.5);
        }
        return super.f(worldserver);
    }

    @Override
    public void a_(boolean flag) {
        this.aD().a(cz, flag);
        if (this.ao() != null && !this.ao().B_()) {
            AttributeModifiable attributemodifiable = this.h(GenericAttributes.x);
            attributemodifiable.c(a);
            if (flag) {
                attributemodifiable.b(f);
            }
        }
    }

    @Override
    public void a(DataWatcherObject<?> datawatcherobject) {
        if (cz.equals(datawatcherobject)) {
            this.j_();
        }
        super.a(datawatcherobject);
    }

    protected boolean gR() {
        return true;
    }

    @Override
    public void g() {
        World world = this.ao();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            if (this.cb() && !this.gG()) {
                if (this.gU()) {
                    int elapsedTicks = MinecraftServer.currentTick - this.lastTick;
                    this.cM -= elapsedTicks;
                    if (this.cM < 0) {
                        this.h(worldserver);
                    }
                } else if (this.gR()) {
                    if (((Entity)this).a(TagsFluid.a)) {
                        ++this.cL;
                        if (this.cL >= 600) {
                            this.d(300);
                        }
                    } else {
                        this.cL = -1;
                    }
                }
            }
        }
        super.g();
        this.lastTick = MinecraftServer.currentTick;
    }

    public void d(int i2) {
        this.lastTick = MinecraftServer.currentTick;
        this.cM = i2;
        this.aD().a(cB, true);
    }

    protected void h(WorldServer worldserver) {
        this.a(worldserver, EntityTypes.O);
        if (!this.bq()) {
            worldserver.a((Entity)null, 1040, this.dK(), 0);
        }
    }

    protected void a(WorldServer worldserver, EntityTypes<? extends EntityZombie> entitytypes) {
        EntityZombie converted = this.convertTo(entitytypes, ConversionParams.a(this, true, true), entityzombie -> entityzombie.L(worldserver.c(entityzombie.dK()).d()), EntityTransformEvent.TransformReason.DROWNED, CreatureSpawnEvent.SpawnReason.DROWNED);
        if (converted == null) {
            ((Zombie)this.getBukkitEntity()).setConversionTime(-1);
        }
    }

    @VisibleForTesting
    public boolean a(WorldServer worldserver, EntityVillager entityvillager) {
        return EntityZombie.convertVillagerToZombieVillager(worldserver, entityvillager, this.dK(), this.bq(), EntityTransformEvent.TransformReason.INFECTION, CreatureSpawnEvent.SpawnReason.INFECTION) != null;
    }

    public static EntityZombieVillager convertVillagerToZombieVillager(WorldServer worldserver, EntityVillager entityvillager, BlockPosition blockPosition, boolean silent, EntityTransformEvent.TransformReason transformReason, CreatureSpawnEvent.SpawnReason spawnReason) {
        EntityZombieVillager entityzombievillager = entityvillager.convertTo(EntityTypes.bZ, ConversionParams.a(entityvillager, true, true), entityzombievillager1 -> {
            entityzombievillager1.a((WorldAccess)worldserver, worldserver.c(entityzombievillager1.dK()), EntitySpawnReason.i, new GroupDataZombie(false, true));
            entityzombievillager1.a(entityvillager.gZ());
            entityzombievillager1.a(entityvillager.he().d());
            entityzombievillager1.a(entityvillager.b().a());
            entityzombievillager1.r(entityvillager.d());
            if (!silent) {
                worldserver.a((Entity)null, 1026, blockPosition, 0);
            }
        }, transformReason, spawnReason);
        return entityzombievillager;
    }

    protected boolean af_() {
        return true;
    }

    @Override
    public boolean a(WorldServer worldserver, DamageSource damagesource, float f2) {
        if (!super.a(worldserver, damagesource, f2)) {
            return false;
        }
        EntityLiving entityliving = this.ag_();
        if (entityliving == null && damagesource.d() instanceof EntityLiving) {
            entityliving = (EntityLiving)damagesource.d();
        }
        if (entityliving != null && worldserver.av() == EnumDifficulty.d && (double)this.as.i() < this.i(GenericAttributes.C) && worldserver.O()) {
            int i2 = MathHelper.c(this.dP());
            int j2 = MathHelper.c(this.dR());
            int k2 = MathHelper.c(this.dV());
            EntityTypes<? extends EntityZombie> entitytypes = this.ay();
            EntityZombie entityzombie = entitytypes.a(worldserver, EntitySpawnReason.j);
            if (entityzombie == null) {
                return true;
            }
            for (int l2 = 0; l2 < 50; ++l2) {
                int k1;
                int j1;
                int i1 = i2 + MathHelper.a(this.as, 7, 40) * MathHelper.a(this.as, -1, 1);
                BlockPosition blockposition = new BlockPosition(i1, j1 = j2 + MathHelper.a(this.as, 7, 40) * MathHelper.a(this.as, -1, 1), k1 = k2 + MathHelper.a(this.as, 7, 40) * MathHelper.a(this.as, -1, 1));
                if (!EntityPositionTypes.a(entitytypes, worldserver, blockposition) || !EntityPositionTypes.a(entitytypes, worldserver, EntitySpawnReason.j, blockposition, worldserver.y)) continue;
                entityzombie.a_(i1, j1, k1);
                if (worldserver.a((double)i1, (double)j1, (double)k1, 7.0) || !worldserver.f(entityzombie) || !worldserver.g(entityzombie) || !entityzombie.gQ() && worldserver.d(entityzombie.dj())) continue;
                entityzombie.setTarget(entityliving, EntityTargetEvent.TargetReason.REINFORCEMENT_TARGET, true);
                entityzombie.a((WorldAccess)worldserver, worldserver.c(entityzombie.dK()), EntitySpawnReason.j, (GroupDataEntity)null);
                worldserver.addFreshEntityWithPassengers(entityzombie, CreatureSpawnEvent.SpawnReason.REINFORCEMENTS);
                AttributeModifiable attributemodifiable = this.h(GenericAttributes.C);
                AttributeModifier attributemodifier = attributemodifiable.a(cv);
                double d0 = attributemodifier != null ? attributemodifier.b() : 0.0;
                attributemodifiable.c(cv);
                attributemodifiable.d(new AttributeModifier(cv, d0 - 0.05, AttributeModifier.Operation.a));
                entityzombie.h(GenericAttributes.C).d(cw);
                break;
            }
        }
        return true;
    }

    @Override
    public boolean c(WorldServer worldserver, Entity entity) {
        boolean flag = super.c(worldserver, entity);
        if (flag) {
            float f2 = worldserver.c(this.dK()).b();
            if (this.fx().f() && this.cp() && this.as.i() < f2 * 0.3f) {
                EntityCombustByEntityEvent event = new EntityCombustByEntityEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (org.bukkit.entity.Entity)entity.getBukkitEntity(), (float)(2 * (int)f2));
                this.ao().getCraftServer().getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    entity.igniteForSeconds(event.getDuration(), false);
                }
            }
        }
        return flag;
    }

    @Override
    protected SoundEffect W() {
        return SoundEffects.GG;
    }

    @Override
    protected SoundEffect h(DamageSource damagesource) {
        return SoundEffects.GS;
    }

    @Override
    protected SoundEffect fd() {
        return SoundEffects.GL;
    }

    protected SoundEffect gP() {
        return SoundEffects.Hk;
    }

    @Override
    protected void b(BlockPosition blockposition, IBlockData iblockdata) {
        this.a(this.gP(), 0.15f, 1.0f);
    }

    public EntityTypes<? extends EntityZombie> ay() {
        return super.ay();
    }

    protected boolean gQ() {
        return false;
    }

    @Override
    protected void a(RandomSource randomsource, DifficultyDamageScaler difficultydamagescaler) {
        super.a(randomsource, difficultydamagescaler);
        float f2 = randomsource.i();
        float f3 = this.ao().av() == EnumDifficulty.d ? 0.05f : 0.01f;
        if (f2 < f3) {
            int i2 = randomsource.a(6);
            if (i2 == 0) {
                this.a(EnumItemSlot.a, new ItemStack(Items.qH));
            } else if (i2 == 1) {
                this.a(EnumItemSlot.a, new ItemStack(Items.xL));
            } else {
                this.a(EnumItemSlot.a, new ItemStack(Items.qI));
            }
        }
    }

    @Override
    protected void a(ValueOutput valueoutput) {
        super.a(valueoutput);
        valueoutput.a("IsBaby", this.e_());
        valueoutput.a("CanBreakDoors", this.gX());
        valueoutput.a("InWaterTime", this.by() ? this.cL : -1);
        valueoutput.a("DrownedConversionTime", this.gU() ? this.cM : -1);
    }

    @Override
    protected void a(ValueInput valueinput) {
        super.a(valueinput);
        this.a_(valueinput.a("IsBaby", false));
        this.y(valueinput.a("CanBreakDoors", false));
        this.cL = valueinput.a("InWaterTime", 0);
        int i2 = valueinput.a("DrownedConversionTime", -1);
        if (i2 != -1) {
            this.d(i2);
        } else {
            this.aD().a(cB, false);
        }
    }

    @Override
    public boolean a(WorldServer worldserver, EntityLiving entityliving, DamageSource damagesource) {
        boolean flag = super.a(worldserver, entityliving, damagesource);
        if ((worldserver.av() == EnumDifficulty.c || worldserver.av() == EnumDifficulty.d) && entityliving instanceof EntityVillager) {
            EntityVillager entityvillager = (EntityVillager)entityliving;
            if (worldserver.av() != EnumDifficulty.d && this.as.h()) {
                return flag;
            }
            if (this.a(worldserver, entityvillager)) {
                flag = false;
            }
        }
        return flag;
    }

    @Override
    public EntitySize b(EntityPose entitypose) {
        return this.e_() ? cD : super.b(entitypose);
    }

    @Override
    public boolean h(ItemStack itemstack) {
        return itemstack.a(TagsItem.az) && this.e_() && this.cq() ? false : super.h(itemstack);
    }

    @Override
    public boolean c(WorldServer worldserver, ItemStack itemstack) {
        return itemstack.a(Items.tk) ? false : super.c(worldserver, itemstack);
    }

    @Override
    public @Nullable GroupDataEntity a(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EntitySpawnReason entityspawnreason, @Nullable GroupDataEntity groupdataentity) {
        RandomSource randomsource = worldaccess.G_();
        groupdataentity = super.a(worldaccess, difficultydamagescaler, entityspawnreason, groupdataentity);
        float f2 = difficultydamagescaler.d();
        if (entityspawnreason != EntitySpawnReason.i) {
            this.b_(randomsource.i() < 0.55f * f2);
        }
        if (groupdataentity == null) {
            groupdataentity = new GroupDataZombie(EntityZombie.a(randomsource), true);
        }
        if (groupdataentity instanceof GroupDataZombie) {
            GroupDataZombie entityzombie_groupdatazombie = (GroupDataZombie)groupdataentity;
            if (entityzombie_groupdatazombie.b) {
                this.a_(true);
                if (entityzombie_groupdatazombie.c) {
                    EntityChicken entitychicken1;
                    if ((double)randomsource.i() < 0.05) {
                        List<Entity> list = worldaccess.a(EntityChicken.class, this.dj().c(5.0, 3.0, 5.0), IEntitySelector.c);
                        if (!list.isEmpty()) {
                            EntityChicken entitychicken = (EntityChicken)list.get(0);
                            entitychicken.x(true);
                            this.a((Entity)entitychicken, false, false);
                        }
                    } else if ((double)randomsource.i() < 0.05 && (entitychicken1 = EntityTypes.C.a(this.ao(), EntitySpawnReason.g)) != null) {
                        entitychicken1.b(this.dP(), this.dR(), this.dV(), this.ec(), 0.0f);
                        entitychicken1.a(worldaccess, difficultydamagescaler, EntitySpawnReason.g, (GroupDataEntity)null);
                        entitychicken1.x(true);
                        this.a((Entity)entitychicken1, false, false);
                        worldaccess.addFreshEntity(entitychicken1, CreatureSpawnEvent.SpawnReason.MOUNT);
                    }
                }
            }
            this.y(randomsource.i() < f2 * 0.1f);
            if (entityspawnreason != EntitySpawnReason.i) {
                this.a(randomsource, difficultydamagescaler);
                this.a(worldaccess, randomsource, difficultydamagescaler);
            }
        }
        if (this.a(EnumItemSlot.f).f() && SpecialDates.b() && randomsource.i() < 0.25f) {
            this.a(EnumItemSlot.f, new ItemStack(randomsource.i() < 0.1f ? Blocks.eK : Blocks.eJ));
            this.a(EnumItemSlot.f, 0.0f);
        }
        this.L(f2);
        return groupdataentity;
    }

    @VisibleForTesting
    public void a(int i2) {
        this.cL = i2;
    }

    @VisibleForTesting
    public void b(int i2) {
        this.cM = i2;
    }

    public static boolean a(RandomSource randomsource) {
        return randomsource.i() < 0.05f;
    }

    protected void L(float f2) {
        this.gY();
        this.h(GenericAttributes.r).c(new AttributeModifier(ch, this.as.j() * (double)0.05f, AttributeModifier.Operation.a));
        double d0 = this.as.j() * 1.5 * (double)f2;
        if (d0 > 1.0) {
            this.h(GenericAttributes.o).c(new AttributeModifier(cy, d0, AttributeModifier.Operation.c));
        }
        if (this.as.i() < f2 * 0.05f) {
            this.h(GenericAttributes.C).c(new AttributeModifier(cx, this.as.j() * 0.25 + 0.5, AttributeModifier.Operation.a));
            this.h(GenericAttributes.u).c(new AttributeModifier(cx, this.as.j() * 3.0 + 1.0, AttributeModifier.Operation.c));
            this.y(true);
        }
    }

    protected void gY() {
        this.h(GenericAttributes.C).a(this.as.j() * (double)0.1f);
    }

    private class a
    extends PathfinderGoalRemoveBlock {
        a(EntityCreature entitycreature, double d0, int i2) {
            super(Blocks.nb, entitycreature, d0, i2);
        }

        @Override
        public void a(GeneratorAccess generatoraccess, BlockPosition blockposition) {
            generatoraccess.a((Entity)null, blockposition, SoundEffects.GM, SoundCategory.f, 0.5f, 0.9f + EntityZombie.this.as.i() * 0.2f);
        }

        @Override
        public void a(World world, BlockPosition blockposition) {
            world.a((Entity)null, blockposition, SoundEffects.DA, SoundCategory.e, 0.7f, 0.9f + world.y.i() * 0.2f);
        }

        @Override
        public double i() {
            return 1.14;
        }
    }

    public static class GroupDataZombie
    implements GroupDataEntity {
        public final boolean b;
        public final boolean c;

        public GroupDataZombie(boolean flag, boolean flag1) {
            this.b = flag;
            this.c = flag1;
        }
    }
}

