/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.npc.villager;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.SpawnUtil;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.attribute.EnvironmentAttributes;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ReputationHandler;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.Behaviors;
import net.minecraft.world.entity.ai.gossip.Reputation;
import net.minecraft.world.entity.ai.gossip.ReputationType;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorGolemLastSeen;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.ai.village.ReputationEvent;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceType;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityWitch;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.npc.villager.EntityVillagerAbstract;
import net.minecraft.world.entity.npc.villager.VillagerData;
import net.minecraft.world.entity.npc.villager.VillagerDataHolder;
import net.minecraft.world.entity.npc.villager.VillagerProfession;
import net.minecraft.world.entity.npc.villager.VillagerTrades;
import net.minecraft.world.entity.npc.villager.VillagerType;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftVillager;
import org.bukkit.entity.AbstractVillager;
import org.bukkit.entity.Villager;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.entity.VillagerReplenishTradeEvent;
import org.bukkit.inventory.MerchantRecipe;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class EntityVillager
extends EntityVillagerAbstract
implements ReputationHandler,
VillagerDataHolder {
    private static final Logger cB = LogUtils.getLogger();
    private static final DataWatcherObject<VillagerData> cC = DataWatcher.a(EntityVillager.class, DataWatcherRegistry.t);
    public static final int cx = 12;
    public static final Map<Item, Integer> cy = ImmutableMap.of((Object)Items.rd, (Object)4, (Object)Items.ws, (Object)1, (Object)Items.wr, (Object)1, (Object)Items.xz, (Object)1);
    private static final int cD = 2;
    private static final int cE = 10;
    private static final int cF = 1200;
    private static final int cG = 24000;
    private static final int cH = 10;
    private static final int cI = 5;
    private static final long cJ = 24000L;
    @VisibleForTesting
    public static final float cz = 0.5f;
    private static final int cK = 0;
    private static final byte cL = 0;
    private static final int cM = 0;
    private static final int cN = 0;
    private static final int cO = 0;
    private static final boolean cP = false;
    private int cQ;
    private boolean cR;
    private @Nullable EntityHuman cU;
    private boolean cV;
    private int cW = 0;
    private final Reputation cX = new Reputation(this);
    private long cY;
    private long cZ = 0L;
    private int da = 0;
    private long db = 0L;
    private int dc = 0;
    private long dd;
    private boolean de = false;
    private static final ImmutableList<MemoryModuleType<?>> df = ImmutableList.of(MemoryModuleType.b, MemoryModuleType.c, MemoryModuleType.d, MemoryModuleType.e, MemoryModuleType.g, MemoryModuleType.h, MemoryModuleType.i, MemoryModuleType.j, MemoryModuleType.k, MemoryModuleType.l, MemoryModuleType.M, MemoryModuleType.ba, (Object[])new MemoryModuleType[]{MemoryModuleType.n, MemoryModuleType.o, MemoryModuleType.r, MemoryModuleType.s, MemoryModuleType.u, MemoryModuleType.w, MemoryModuleType.x, MemoryModuleType.y, MemoryModuleType.z, MemoryModuleType.B, MemoryModuleType.f, MemoryModuleType.D, MemoryModuleType.E, MemoryModuleType.F, MemoryModuleType.I, MemoryModuleType.J, MemoryModuleType.K, MemoryModuleType.G});
    private static final ImmutableList<SensorType<? extends Sensor<? super EntityVillager>>> dg = ImmutableList.of(SensorType.c, SensorType.d, SensorType.b, SensorType.e, SensorType.f, SensorType.g, SensorType.h, SensorType.i, SensorType.j);
    public static final Map<MemoryModuleType<GlobalPos>, BiPredicate<EntityVillager, Holder<VillagePlaceType>>> cA = ImmutableMap.of(MemoryModuleType.b, (entityvillager, holder) -> holder.a(PoiTypes.n), MemoryModuleType.c, (entityvillager, holder) -> entityvillager.gZ().b().a().b().test((Holder<VillagePlaceType>)holder), MemoryModuleType.d, (entityvillager, holder) -> VillagerProfession.a.test((Holder<VillagePlaceType>)holder), MemoryModuleType.e, (entityvillager, holder) -> holder.a(PoiTypes.o));
    public long gossipDecayInterval = 24000L;

    public EntityVillager(EntityTypes<? extends EntityVillager> entitytypes, World world) {
        this(entitytypes, world, VillagerType.c);
    }

    public EntityVillager(EntityTypes<? extends EntityVillager> entitytypes, World world, ResourceKey<VillagerType> resourcekey) {
        this(entitytypes, world, world.J_().d(resourcekey));
    }

    public EntityVillager(EntityTypes<? extends EntityVillager> entitytypes, World world, Holder<VillagerType> holder) {
        super((EntityTypes<? extends EntityVillagerAbstract>)entitytypes, world);
        this.N().e(true);
        this.N().a(true);
        this.N().a(48.0f);
        this.b_(true);
        this.a(this.gZ().a(holder).b(world.J_(), VillagerProfession.b));
    }

    public BehaviorController<EntityVillager> ev() {
        return super.ev();
    }

    protected BehaviorController.b<EntityVillager> ew() {
        return BehaviorController.a(df, dg);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        BehaviorController<EntityVillager> behaviorcontroller = this.ew().a(dynamic);
        this.a(behaviorcontroller);
        return behaviorcontroller;
    }

    public void i(WorldServer worldserver) {
        BehaviorController<EntityVillager> behaviorcontroller = this.ev();
        behaviorcontroller.b(worldserver, this);
        this.ca = behaviorcontroller.h();
        this.a(this.ev());
    }

    private void a(BehaviorController<EntityVillager> behaviorcontroller) {
        Holder<VillagerProfession> holder = this.gZ().b();
        if (this.e_()) {
            behaviorcontroller.a(EnvironmentAttributes.S);
            behaviorcontroller.a(Activity.d, Behaviors.a(0.5f));
        } else {
            behaviorcontroller.a(EnvironmentAttributes.R);
            behaviorcontroller.a(Activity.c, (ImmutableList<Pair<Integer, BehaviorControl<EntityVillager>>>)Behaviors.b(holder, 0.5f), (Set<Pair<MemoryModuleType<?>, MemoryStatus>>)ImmutableSet.of((Object)Pair.of(MemoryModuleType.c, (Object)((Object)MemoryStatus.a))));
        }
        behaviorcontroller.a(Activity.a, Behaviors.a(holder, 0.5f));
        behaviorcontroller.a(Activity.f, (ImmutableList<Pair<Integer, BehaviorControl<EntityVillager>>>)Behaviors.d(holder, 0.5f), (Set<Pair<MemoryModuleType<?>, MemoryStatus>>)ImmutableSet.of((Object)Pair.of(MemoryModuleType.e, (Object)((Object)MemoryStatus.a))));
        behaviorcontroller.a(Activity.e, Behaviors.c(holder, 0.5f));
        behaviorcontroller.a(Activity.b, Behaviors.e(holder, 0.5f));
        behaviorcontroller.a(Activity.g, Behaviors.f(holder, 0.5f));
        behaviorcontroller.a(Activity.i, Behaviors.g(holder, 0.5f));
        behaviorcontroller.a(Activity.h, Behaviors.h(holder, 0.5f));
        behaviorcontroller.a(Activity.j, Behaviors.i(holder, 0.5f));
        behaviorcontroller.a((Set<Activity>)ImmutableSet.of((Object)Activity.a));
        behaviorcontroller.b(Activity.b);
        behaviorcontroller.a(Activity.b);
        behaviorcontroller.a(this.ao().c(), this.ao().au(), this.dI());
    }

    @Override
    protected void h() {
        super.h();
        if (this.ao() instanceof WorldServer) {
            this.i((WorldServer)this.ao());
        }
    }

    public static AttributeProvider.Builder gT() {
        return EntityInsentient.E().a(GenericAttributes.x, 0.5);
    }

    public boolean gU() {
        return this.de;
    }

    @Override
    public void inactiveTick() {
        if (this.ao().spigotConfig.tickInactiveVillagers && this.dy()) {
            this.a((WorldServer)this.ao());
        }
        super.inactiveTick();
    }

    @Override
    protected void a(WorldServer worldserver) {
        Raid raid;
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("villagerBrain");
        this.ev().a(worldserver, this);
        gameprofilerfiller.c();
        if (this.de) {
            this.de = false;
        }
        if (!this.gQ() && this.cQ > 0) {
            --this.cQ;
            if (this.cQ <= 0) {
                if (this.cR) {
                    this.k(worldserver);
                    this.cR = false;
                }
                this.addEffect(new MobEffect(MobEffects.j, 200, 0), EntityPotionEffectEvent.Cause.VILLAGER_TRADE);
            }
        }
        if (this.cU != null) {
            worldserver.a(ReputationEvent.e, (Entity)this.cU, this);
            worldserver.a((Entity)this, (byte)14);
            this.cU = null;
        }
        if (!this.gG() && this.as.a(100) == 0 && (raid = worldserver.f(this.dK())) != null && raid.r() && !raid.a()) {
            worldserver.a((Entity)this, (byte)42);
        }
        if (this.gZ().b().a(VillagerProfession.b) && this.gQ()) {
            this.gS();
        }
        super.a(worldserver);
    }

    @Override
    public void g() {
        super.g();
        if (this.p() > 0) {
            this.r(this.p() - 1);
        }
        this.hr();
    }

    @Override
    public EnumInteractionResult b(EntityHuman entityhuman, EnumHand enumhand) {
        ItemStack itemstack = entityhuman.b(enumhand);
        if (!itemstack.a(Items.vm) && this.cb() && !this.gQ() && !this.gr()) {
            if (this.e_()) {
                this.hf();
                return EnumInteractionResult.a;
            }
            if (!this.ao().B_()) {
                boolean flag = this.b().isEmpty();
                if (enumhand == EnumHand.a) {
                    if (flag) {
                        this.hf();
                    }
                    entityhuman.a(StatisticList.U);
                }
                if (flag) {
                    return EnumInteractionResult.c;
                }
                this.h(entityhuman);
            }
            return EnumInteractionResult.a;
        }
        return super.b(entityhuman, enumhand);
    }

    public void hf() {
        this.r(40);
        if (!this.ao().B_()) {
            this.b(SoundEffects.Eo);
        }
    }

    private void h(EntityHuman entityhuman) {
        this.i(entityhuman);
        this.a(entityhuman);
        this.a(entityhuman, this.R_(), this.gZ().c());
    }

    @Override
    public void a(@Nullable EntityHuman entityhuman) {
        boolean flag = this.a() != null && entityhuman == null;
        super.a(entityhuman);
        if (flag) {
            this.gS();
        }
    }

    @Override
    protected void gS() {
        super.gS();
        this.hg();
    }

    private void hg() {
        if (!this.ao().B_()) {
            for (net.minecraft.world.item.trading.MerchantRecipe merchantrecipe : this.b()) {
                merchantrecipe.n();
            }
        }
    }

    @Override
    public boolean gV() {
        return true;
    }

    public void gW() {
        this.hl();
        for (net.minecraft.world.item.trading.MerchantRecipe merchantrecipe : this.b()) {
            VillagerReplenishTradeEvent event = new VillagerReplenishTradeEvent((AbstractVillager)((Villager)this.getBukkitEntity()), (MerchantRecipe)merchantrecipe.asBukkit());
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) continue;
            merchantrecipe.j();
        }
        this.hh();
        this.db = this.ao().au();
        ++this.dc;
    }

    private void hh() {
        MerchantRecipeList merchantrecipelist = this.b();
        EntityHuman entityhuman = this.a();
        if (entityhuman != null && !merchantrecipelist.isEmpty()) {
            entityhuman.a(entityhuman.cn.l, merchantrecipelist, this.gZ().c(), this.d(), this.e(), this.gV());
        }
    }

    private boolean hi() {
        for (net.minecraft.world.item.trading.MerchantRecipe merchantrecipe : this.b()) {
            if (!merchantrecipe.t()) continue;
            return true;
        }
        return false;
    }

    private boolean hj() {
        return this.dc == 0 || this.dc < 2 && this.ao().au() > this.db + 2400L;
    }

    public boolean j(WorldServer worldserver) {
        long i2 = this.db + 12000L;
        long j2 = this.ao().au();
        boolean flag = j2 > i2;
        long k2 = worldserver.e();
        boolean bl = this.dd > 0L && k2 > this.dd;
        this.dd = k2;
        if (flag |= bl) {
            this.db = j2;
            this.hs();
        }
        return this.hj() && this.hi();
    }

    private void hk() {
        int i2 = 2 - this.dc;
        if (i2 > 0) {
            for (net.minecraft.world.item.trading.MerchantRecipe merchantrecipe : this.b()) {
                VillagerReplenishTradeEvent event = new VillagerReplenishTradeEvent((AbstractVillager)((Villager)this.getBukkitEntity()), (MerchantRecipe)merchantrecipe.asBukkit());
                Bukkit.getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) continue;
                merchantrecipe.j();
            }
        }
        for (int j2 = 0; j2 < i2; ++j2) {
            this.hl();
        }
        this.hh();
    }

    private void hl() {
        for (net.minecraft.world.item.trading.MerchantRecipe merchantrecipe : this.b()) {
            merchantrecipe.g();
        }
    }

    private void i(EntityHuman entityhuman) {
        int i2 = this.g(entityhuman);
        if (i2 != 0) {
            for (net.minecraft.world.item.trading.MerchantRecipe merchantrecipe : this.b()) {
                merchantrecipe.a(-MathHelper.b((float)i2 * merchantrecipe.p()));
            }
        }
        if (entityhuman.d(MobEffects.F)) {
            MobEffect mobeffect = entityhuman.e(MobEffects.F);
            int j2 = mobeffect.e();
            for (net.minecraft.world.item.trading.MerchantRecipe merchantrecipe1 : this.b()) {
                double d0 = 0.3 + 0.0625 * (double)j2;
                int k2 = (int)Math.floor(d0 * (double)merchantrecipe1.a().N());
                merchantrecipe1.a(-Math.max(k2, 1));
            }
        }
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(cC, EntityVillager.gX());
    }

    public static VillagerData gX() {
        return new VillagerData(BuiltInRegistries.x.b(VillagerType.c), BuiltInRegistries.y.b(VillagerProfession.b), 1);
    }

    @Override
    protected void a(ValueOutput valueoutput) {
        super.a(valueoutput);
        valueoutput.a("VillagerData", VillagerData.c, this.gZ());
        valueoutput.a("FoodLevel", (byte)this.cW);
        valueoutput.a("Gossips", Reputation.a, this.cX);
        valueoutput.a("Xp", this.da);
        valueoutput.a("LastRestock", this.db);
        valueoutput.a("LastGossipDecay", this.cZ);
        valueoutput.a("RestocksToday", this.dc);
        if (this.de) {
            valueoutput.a("AssignProfessionWhenSpawned", true);
        }
    }

    @Override
    protected void a(ValueInput valueinput) {
        super.a(valueinput);
        this.az.a(cC, valueinput.a("VillagerData", VillagerData.c).orElseGet(EntityVillager::gX));
        this.cW = valueinput.a("FoodLevel", (byte)0);
        this.cX.c();
        Optional<Reputation> optional = valueinput.a("Gossips", Reputation.a);
        Reputation reputation = this.cX;
        Objects.requireNonNull(this.cX);
        optional.ifPresent(reputation::a);
        this.da = valueinput.a("Xp", 0);
        this.db = valueinput.a("LastRestock", 0L);
        this.cZ = valueinput.a("LastGossipDecay", 0L);
        if (this.ao() instanceof WorldServer) {
            this.i((WorldServer)this.ao());
        }
        this.dc = valueinput.a("RestocksToday", 0);
        this.de = valueinput.a("AssignProfessionWhenSpawned", false);
    }

    @Override
    public boolean i(double d0) {
        return false;
    }

    @Override
    protected @Nullable SoundEffect W() {
        return this.gr() ? null : (this.gQ() ? SoundEffects.Ep : SoundEffects.Ek);
    }

    @Override
    protected SoundEffect h(DamageSource damagesource) {
        return SoundEffects.En;
    }

    @Override
    protected SoundEffect fd() {
        return SoundEffects.Em;
    }

    public void gY() {
        this.b(this.gZ().b().a().f());
    }

    @Override
    public void a(VillagerData villagerdata) {
        VillagerData villagerdata1 = this.gZ();
        if (!villagerdata1.b().equals(villagerdata.b())) {
            this.cw = null;
        }
        this.az.a(cC, villagerdata);
    }

    @Override
    public VillagerData gZ() {
        return this.az.a(cC);
    }

    @Override
    protected void b(net.minecraft.world.item.trading.MerchantRecipe merchantrecipe) {
        int i2 = 3 + this.as.a(4);
        this.da += merchantrecipe.q();
        this.cU = this.a();
        if (this.hp()) {
            this.cQ = 40;
            this.cR = true;
            i2 += 5;
        }
        if (merchantrecipe.u()) {
            this.ao().b(new EntityExperienceOrb(this.ao(), this.dP(), this.dR() + 0.5, this.dV(), i2));
        }
    }

    @Override
    public void a(@Nullable EntityLiving entityliving) {
        if (entityliving != null && this.ao() instanceof WorldServer) {
            ((WorldServer)this.ao()).a(ReputationEvent.c, (Entity)entityliving, this);
            if (this.cb() && entityliving instanceof EntityHuman) {
                this.ao().a((Entity)this, (byte)13);
            }
        }
        super.a(entityliving);
    }

    @Override
    public void a(DamageSource damagesource) {
        Entity entity;
        if (SpigotConfig.logVillagerDeaths) {
            cB.info("Villager {} died, message: '{}'", (Object)this, (Object)damagesource.a(this).getString());
        }
        if ((entity = damagesource.d()) != null) {
            this.H(entity);
        }
        this.hm();
        super.a(damagesource);
    }

    public void hm() {
        this.a(MemoryModuleType.b);
        this.a(MemoryModuleType.c);
        this.a(MemoryModuleType.d);
        this.a(MemoryModuleType.e);
    }

    private void H(Entity entity) {
        World world = this.ao();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            Optional<NearestVisibleLivingEntities> optional = this.ca.c(MemoryModuleType.h);
            if (!optional.isEmpty()) {
                NearestVisibleLivingEntities nearestvisiblelivingentities = optional.get();
                Objects.requireNonNull(ReputationHandler.class);
                nearestvisiblelivingentities.b(ReputationHandler.class::isInstance).forEach(entityliving -> worldserver.a(ReputationEvent.d, entity, (ReputationHandler)((Object)entityliving)));
            }
        }
    }

    public void a(MemoryModuleType<GlobalPos> memorymoduletype) {
        if (this.ao() instanceof WorldServer) {
            MinecraftServer minecraftserver = ((WorldServer)this.ao()).s();
            this.ca.c(memorymoduletype).ifPresent(globalpos -> {
                WorldServer worldserver = minecraftserver.a(globalpos.a());
                if (worldserver != null) {
                    VillagePlace villageplace = worldserver.F();
                    Optional<Holder<VillagePlaceType>> optional = villageplace.c(globalpos.b());
                    BiPredicate<EntityVillager, Holder<VillagePlaceType>> bipredicate = cA.get(memorymoduletype);
                    if (optional.isPresent() && bipredicate.test(this, optional.get())) {
                        villageplace.b(globalpos.b());
                        worldserver.W().b(globalpos.b());
                    }
                }
            });
        }
    }

    @Override
    public boolean Y_() {
        return this.cW + this.hq() >= 12 && !this.gr() && this.Z_() == 0;
    }

    private boolean hn() {
        return this.cW < 12;
    }

    private void ho() {
        if (this.hn() && this.hq() != 0) {
            for (int i2 = 0; i2 < this.gP().b(); ++i2) {
                int j2;
                Integer integer;
                ItemStack itemstack = this.gP().a(i2);
                if (itemstack.f() || (integer = cy.get(itemstack.h())) == null) continue;
                for (int k2 = j2 = itemstack.N(); k2 > 0; --k2) {
                    this.cW += integer.intValue();
                    this.gP().a(i2, 1);
                    if (this.hn()) continue;
                    return;
                }
            }
        }
    }

    public int g(EntityHuman entityhuman) {
        return this.cX.a(entityhuman.cY(), (ReputationType reputationtype) -> true);
    }

    private void t(int i2) {
        this.cW -= i2;
    }

    public void ha() {
        this.ho();
        this.t(12);
    }

    public void b(MerchantRecipeList merchantrecipelist) {
        this.cw = merchantrecipelist;
    }

    private boolean hp() {
        int i2 = this.gZ().c();
        return VillagerData.d(i2) && this.da >= VillagerData.c(i2);
    }

    public void k(WorldServer worldserver) {
        this.a(this.gZ().a(this.gZ().c() + 1));
        this.h(worldserver);
    }

    @Override
    protected IChatBaseComponent cR() {
        return this.gZ().b().a().a();
    }

    @Override
    public void b(byte b0) {
        if (b0 == 12) {
            this.a(Particles.T);
        } else if (b0 == 13) {
            this.a(Particles.a);
        } else if (b0 == 14) {
            this.a(Particles.R);
        } else if (b0 == 42) {
            this.a(Particles.aq);
        } else {
            super.b(b0);
        }
    }

    @Override
    public @Nullable GroupDataEntity a(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EntitySpawnReason entityspawnreason, @Nullable GroupDataEntity groupdataentity) {
        if (entityspawnreason == EntitySpawnReason.e) {
            this.a(this.gZ().b(worldaccess.J_(), VillagerProfession.b));
        }
        if (entityspawnreason == EntitySpawnReason.n || entityspawnreason == EntitySpawnReason.m || EntitySpawnReason.a(entityspawnreason) || entityspawnreason == EntitySpawnReason.o) {
            this.a(this.gZ().a(worldaccess.J_(), VillagerType.a(worldaccess.z(this.dK()))));
        }
        if (entityspawnreason == EntitySpawnReason.d) {
            this.de = true;
        }
        return super.a(worldaccess, difficultydamagescaler, entityspawnreason, groupdataentity);
    }

    public @Nullable EntityVillager b(WorldServer worldserver, EntityAgeable entityageable) {
        double d0 = this.as.j();
        Holder<VillagerType> holder = d0 < 0.5 ? worldserver.J_().d(VillagerType.a(worldserver.z(this.dK()))) : (d0 < 0.75 ? this.gZ().a() : ((EntityVillager)entityageable).gZ().a());
        EntityVillager entityvillager = new EntityVillager(EntityTypes.bL, (World)worldserver, holder);
        entityvillager.a((WorldAccess)worldserver, worldserver.c(entityvillager.dK()), EntitySpawnReason.e, (GroupDataEntity)null);
        return entityvillager;
    }

    @Override
    public void a(WorldServer worldserver, EntityLightning entitylightning) {
        if (worldserver.av() != EnumDifficulty.a) {
            cB.info("Villager {} was struck by lightning {}.", (Object)this, (Object)entitylightning);
            EntityWitch entitywitch = this.convertTo(EntityTypes.bQ, ConversionParams.a(this, false, false), entitywitch1 -> {
                entitywitch1.a((WorldAccess)worldserver, worldserver.c(entitywitch1.dK()), EntitySpawnReason.i, (GroupDataEntity)null);
                entitywitch1.gz();
                this.hm();
            }, EntityTransformEvent.TransformReason.LIGHTNING, CreatureSpawnEvent.SpawnReason.LIGHTNING);
            if (entitywitch == null) {
                super.a(worldserver, entitylightning);
            }
        } else {
            super.a(worldserver, entitylightning);
        }
    }

    @Override
    protected void a(WorldServer worldserver, EntityItem entityitem) {
        InventoryCarrier.a(worldserver, this, this, entityitem);
    }

    @Override
    public boolean c(WorldServer worldserver, ItemStack itemstack) {
        Item item = itemstack.h();
        return (itemstack.a(TagsItem.ci) || this.gZ().b().a().d().contains((Object)item)) && this.gP().c(itemstack);
    }

    public boolean hb() {
        return this.hq() >= 24;
    }

    public boolean hc() {
        return this.hq() < 12;
    }

    private int hq() {
        InventorySubcontainer inventorysubcontainer = this.gP();
        return cy.entrySet().stream().mapToInt(entry -> inventorysubcontainer.a_((Item)entry.getKey()) * (Integer)entry.getValue()).sum();
    }

    public boolean hd() {
        return this.gP().a_((ItemStack itemstack) -> itemstack.a(TagsItem.ch));
    }

    @Override
    protected void h(WorldServer worldserver) {
        VillagerTrades.IMerchantRecipeOption[] avillagertrades_imerchantrecipeoption;
        Int2ObjectMap<VillagerTrades.IMerchantRecipeOption[]> int2objectmap1;
        Int2ObjectMap<VillagerTrades.IMerchantRecipeOption[]> int2objectmap;
        VillagerData villagerdata = this.gZ();
        ResourceKey resourcekey = villagerdata.b().e().orElse(null);
        if (resourcekey != null && (int2objectmap = this.ao().Q().b(FeatureFlags.b) ? ((int2objectmap1 = VillagerTrades.c.get(resourcekey)) != null ? int2objectmap1 : VillagerTrades.a.get(resourcekey)) : VillagerTrades.a.get(resourcekey)) != null && !int2objectmap.isEmpty() && (avillagertrades_imerchantrecipeoption = (VillagerTrades.IMerchantRecipeOption[])int2objectmap.get(villagerdata.c())) != null) {
            MerchantRecipeList merchantrecipelist = this.b();
            this.a(worldserver, merchantrecipelist, avillagertrades_imerchantrecipeoption, 2);
            if (SharedConstants.af && villagerdata.c() < int2objectmap.size()) {
                this.k(worldserver);
            }
        }
    }

    public void a(WorldServer worldserver, EntityVillager entityvillager, long i2) {
        if (!(i2 >= this.cY && i2 < this.cY + 1200L || i2 >= entityvillager.cY && i2 < entityvillager.cY + 1200L)) {
            this.cX.a(entityvillager.cX, this.as, 10);
            this.cY = i2;
            entityvillager.cY = i2;
            this.a(worldserver, i2, 5);
        }
    }

    private void hr() {
        long i2 = this.ao().au();
        if (this.cZ == 0L) {
            this.cZ = i2;
        } else if (i2 >= this.cZ + this.gossipDecayInterval) {
            this.cX.b();
            this.cZ = i2;
        }
    }

    public void a(WorldServer worldserver, long i2, int j2) {
        AxisAlignedBB axisalignedbb;
        List<EntityVillager> list;
        List<EntityVillager> list1;
        if (this.a(i2) && (list1 = (list = worldserver.a(EntityVillager.class, axisalignedbb = this.dj().c(10.0, 10.0, 10.0))).stream().filter(entityvillager -> entityvillager.a(i2)).limit(5L).toList()).size() >= j2 && !SpawnUtil.trySpawnMob(EntityTypes.au, EntitySpawnReason.f, worldserver, this.dK(), 10, 8, 6, SpawnUtil.a.a, false, CreatureSpawnEvent.SpawnReason.VILLAGE_DEFENSE).isEmpty()) {
            list.forEach(SensorGolemLastSeen::b);
        }
    }

    public boolean a(long i2) {
        return !this.b(this.ao().au()) ? false : !this.ca.a(MemoryModuleType.G);
    }

    @Override
    public void a(ReputationEvent reputationevent, Entity entity) {
        Villager.ReputationEvent bukkitReputationEvent = CraftVillager.CraftReputationEvent.minecraftToBukkit(reputationevent);
        if (reputationevent == ReputationEvent.a) {
            this.cX.add(entity.cY(), ReputationType.d, 20, bukkitReputationEvent);
            this.cX.add(entity.cY(), ReputationType.c, 25, bukkitReputationEvent);
        } else if (reputationevent == ReputationEvent.e) {
            this.cX.add(entity.cY(), ReputationType.e, 2, bukkitReputationEvent);
        } else if (reputationevent == ReputationEvent.c) {
            this.cX.add(entity.cY(), ReputationType.b, 25, bukkitReputationEvent);
        } else if (reputationevent == ReputationEvent.d) {
            this.cX.add(entity.cY(), ReputationType.a, 25, bukkitReputationEvent);
        }
    }

    @Override
    public int d() {
        return this.da;
    }

    public void s(int i2) {
        this.da = i2;
    }

    private void hs() {
        this.hk();
        this.dc = 0;
    }

    public Reputation he() {
        return this.cX;
    }

    public void a(Reputation reputation) {
        this.cX.a(reputation);
    }

    @Override
    public void b(BlockPosition blockposition) {
        super.b(blockposition);
        this.ca.a(MemoryModuleType.I, this.ao().au());
        this.ca.b(MemoryModuleType.n);
        this.ca.b(MemoryModuleType.F);
    }

    @Override
    public void gs() {
        super.gs();
        this.ca.a(MemoryModuleType.J, this.ao().au());
    }

    private boolean b(long i2) {
        Optional<Long> optional = this.ca.c(MemoryModuleType.I);
        return optional.filter(olong -> i2 - olong < 24000L).isPresent();
    }

    @Override
    public <T> @Nullable T a(DataComponentType<? extends T> datacomponenttype) {
        return datacomponenttype == DataComponents.aC ? EntityVillager.c(datacomponenttype, this.gZ().a()) : super.a(datacomponenttype);
    }

    @Override
    protected void a(DataComponentGetter datacomponentgetter) {
        this.a(datacomponentgetter, DataComponents.aC);
        super.a(datacomponentgetter);
    }

    @Override
    protected <T> boolean b(DataComponentType<T> datacomponenttype, T t0) {
        if (datacomponenttype == DataComponents.aC) {
            Holder<VillagerType> holder = EntityVillager.c(DataComponents.aC, t0);
            this.a(this.gZ().a(holder));
            return true;
        }
        return super.b(datacomponenttype, t0);
    }
}

