/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.player;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.math.IntMath;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Either;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Predicate;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.ChatClickable;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.game.PacketPlayOutEntityVelocity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.dialog.Dialog;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.permissions.PermissionSet;
import net.minecraft.server.permissions.Permissions;
import net.minecraft.server.players.NameAndId;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.Statistic;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsEntity;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.SystemUtils;
import net.minecraft.util.Unit;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.IInventory;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.ItemStackWithSlot;
import net.minecraft.world.attribute.EnvironmentAttributes;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Avatar;
import net.minecraft.world.entity.ContainerUser;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityEquipment;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.animal.equine.EntityHorseAbstract;
import net.minecraft.world.entity.animal.nautilus.AbstractNautilus;
import net.minecraft.world.entity.animal.parrot.EntityParrot;
import net.minecraft.world.entity.boss.enderdragon.EntityComplexPart;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.warden.WardenSpawnTracker;
import net.minecraft.world.entity.player.PlayerAbilities;
import net.minecraft.world.entity.player.PlayerEquipment;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.entity.projectile.EntityFishingHook;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.entity.vehicle.minecart.EntityMinecartCommandBlock;
import net.minecraft.world.food.FoodMetaData;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerPlayer;
import net.minecraft.world.inventory.InventoryEnderChest;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldown;
import net.minecraft.world.item.ItemProjectileWeapon;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.BlocksAttacks;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.TestBlockEntity;
import net.minecraft.world.level.block.entity.TestInstanceBlockEntity;
import net.minecraft.world.level.block.entity.TileEntityCommand;
import net.minecraft.world.level.block.entity.TileEntityJigsaw;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.entity.TileEntityStructure;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.ScoreboardTeam;
import org.bukkit.OfflinePlayer;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftVector;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityExhaustionEvent;
import org.bukkit.event.entity.EntityKnockbackEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerBedEnterEvent;
import org.bukkit.event.player.PlayerVelocityEvent;
import org.bukkit.scoreboard.Team;
import org.bukkit.util.Vector;
import org.jspecify.annotations.Nullable;

public abstract class EntityHuman
extends Avatar
implements ContainerUser {
    public static final int cc = 20;
    public static final int cd = 100;
    public static final int ce = 10;
    public static final int cf = 200;
    public static final int cg = 499;
    public static final int ch = 500;
    public static final float ci = 4.5f;
    public static final float cj = 3.0f;
    private static final int a = 40;
    private static final DataWatcherObject<Float> b = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.d);
    private static final DataWatcherObject<Integer> c = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<OptionalInt> d = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.u);
    private static final DataWatcherObject<OptionalInt> e = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.u);
    private static final short f = 0;
    private static final float g = 0.0f;
    private static final int h = 0;
    private static final int i = 0;
    private static final int j = 0;
    private static final int k = 0;
    private static final int cB = 0;
    private static final boolean cC = false;
    private static final int cD = 0;
    public static final float ck = 2.0f;
    final PlayerInventory cE;
    protected InventoryEnderChest cl = new InventoryEnderChest(this);
    public final ContainerPlayer cm;
    public Container cn;
    protected FoodMetaData co = new FoodMetaData();
    protected int cp;
    public int cq;
    public int cF = 0;
    protected boolean cr;
    private final PlayerAbilities cG = new PlayerAbilities();
    public int cs = 0;
    public int ct = 0;
    public float cu = 0.0f;
    public int cv = 0;
    protected final float cw = 0.02f;
    private int cH;
    private final GameProfile cI;
    private boolean cJ;
    private ItemStack cK = ItemStack.l;
    private final ItemCooldown cL = this.f();
    private Optional<GlobalPos> cM = Optional.empty();
    public @Nullable EntityFishingHook cx;
    protected float cy;
    public @Nullable Vec3D cz;
    public @Nullable Entity cA;
    private boolean cN = false;
    private int cO = 0;
    public boolean fauxSleeping;
    public int oldLevel = -1;

    @Override
    public CraftHumanEntity getBukkitEntity() {
        return (CraftHumanEntity)super.getBukkitEntity();
    }

    public EntityHuman(World world, GameProfile gameprofile) {
        super((EntityTypes<? extends EntityLiving>)EntityTypes.cb, world);
        this.a(gameprofile.id());
        this.cI = gameprofile;
        this.cE = new PlayerInventory(this, this.cb);
        this.cm = new ContainerPlayer(this.cE, !world.B_(), this);
        this.cn = this.cm;
    }

    @Override
    protected EntityEquipment eu() {
        return new PlayerEquipment(this);
    }

    public boolean a(World world, BlockPosition blockposition, EnumGamemode enumgamemode) {
        if (!enumgamemode.f()) {
            return false;
        }
        if (enumgamemode == EnumGamemode.d) {
            return true;
        }
        if (this.gY()) {
            return false;
        }
        ItemStack itemstack = this.fx();
        return itemstack.f() || !itemstack.b(new ShapeDetectorBlock(world, blockposition, false));
    }

    public static AttributeProvider.Builder gz() {
        return EntityLiving.ex().a(GenericAttributes.d, 1.0).a(GenericAttributes.x, 0.1f).a(GenericAttributes.f).a(GenericAttributes.s).a(GenericAttributes.h, 4.5).a(GenericAttributes.l, 3.0).a(GenericAttributes.g).a(GenericAttributes.E).a(GenericAttributes.B).a(GenericAttributes.v).a(GenericAttributes.F).a(GenericAttributes.I, 6.0E7).a(GenericAttributes.J, 6.0E7);
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(b, Float.valueOf(0.0f));
        datawatcher_a.a(c, 0);
        datawatcher_a.a(d, OptionalInt.empty());
        datawatcher_a.a(e, OptionalInt.empty());
    }

    @Override
    public void g() {
        this.ar = this.au();
        if (this.au() || this.cq()) {
            this.e(false);
        }
        if (this.cq > 0) {
            --this.cq;
        }
        if (this.gr()) {
            ++this.cF;
            if (this.cF > 100) {
                this.cF = 100;
            }
            if (!this.ao().B_() && !this.ao().c().a(EnvironmentAttributes.C, this.dI()).a(this.ao())) {
                this.a(false, true);
            }
        } else if (this.cF > 0) {
            ++this.cF;
            if (this.cF >= 110) {
                this.cF = 0;
            }
        }
        this.gD();
        super.g();
        int i2 = 29999999;
        double d0 = MathHelper.a(this.dP(), -2.9999999E7, 2.9999999E7);
        double d1 = MathHelper.a(this.dV(), -2.9999999E7, 2.9999999E7);
        if (d0 != this.dP() || d1 != this.dV()) {
            this.a_(d0, this.dR(), d1);
        }
        ++this.bz;
        ++this.bA;
        ItemStack itemstack = this.fx();
        if (!ItemStack.a(this.cK, itemstack)) {
            if (!ItemStack.b(this.cK, itemstack)) {
                this.hf();
            }
            this.cK = itemstack.v();
        }
        if (!((Entity)this).a(TagsFluid.a) && this.c(Items.pP)) {
            this.m();
        }
        this.cL.a();
        this.gE();
        if (this.cO > 0) {
            --this.cO;
        }
    }

    @Override
    protected float fP() {
        return this.gg() ? 15.0f : super.fP();
    }

    public boolean gA() {
        return this.cu();
    }

    protected boolean gB() {
        return this.cu();
    }

    protected boolean gC() {
        return this.cu();
    }

    protected boolean gD() {
        this.cr = ((Entity)this).a(TagsFluid.a);
        return this.cr;
    }

    @Override
    public void a(boolean flag, BlockPosition blockposition) {
        if (!this.gL().b) {
            super.a(flag, blockposition);
        }
    }

    @Override
    public void m(boolean flag) {
        if (!this.gL().b) {
            super.m(flag);
        }
    }

    private void m() {
        this.addEffect(new MobEffect(MobEffects.m, 200, 0, false, false, true), EntityPotionEffectEvent.Cause.TURTLE_HELMET);
    }

    private boolean c(Item item) {
        for (EnumItemSlot enumitemslot : EnumItemSlot.j) {
            ItemStack itemstack = this.a(enumitemslot);
            Equippable equippable = itemstack.a(DataComponents.H);
            if (!itemstack.a(item) || equippable == null || equippable.b() != enumitemslot) continue;
            return true;
        }
        return false;
    }

    protected ItemCooldown f() {
        return new ItemCooldown();
    }

    protected void gE() {
        if (this.h(EntityPose.d)) {
            EntityPose entitypose = this.n();
            EntityPose entitypose1 = !(this.au() || this.cq() || this.h(entitypose)) ? (this.h(EntityPose.f) ? EntityPose.f : EntityPose.d) : entitypose;
            this.c(entitypose1);
        }
    }

    private EntityPose n() {
        return this.gr() ? EntityPose.c : (this.cB() ? EntityPose.d : (this.gj() ? EntityPose.b : (this.fW() ? EntityPose.e : (this.cu() && !this.cG.b ? EntityPose.f : EntityPose.a))));
    }

    protected boolean h(EntityPose entitypose) {
        return this.ao().a((Entity)this, this.a(entitypose).a(this.dI()).h(1.0E-7));
    }

    @Override
    protected SoundEffect bk() {
        return SoundEffects.xg;
    }

    @Override
    protected SoundEffect bl() {
        return SoundEffects.xe;
    }

    @Override
    protected SoundEffect bm() {
        return SoundEffects.xf;
    }

    @Override
    public int co() {
        return 10;
    }

    @Override
    public void a(SoundEffect soundeffect, float f2, float f1) {
        this.ao().a((Entity)this, this.dP(), this.dR(), this.dV(), soundeffect, this.dB(), f2, f1);
    }

    @Override
    public SoundCategory dB() {
        return SoundCategory.h;
    }

    @Override
    public int dC() {
        return 20;
    }

    @Override
    public void b(byte b0) {
        if (b0 == 9) {
            this.Q_();
        } else if (b0 == 23) {
            this.v(false);
        } else if (b0 == 22) {
            this.v(true);
        } else {
            super.b(b0);
        }
    }

    public void r() {
        this.cn = this.cm;
    }

    protected void s() {
    }

    @Override
    public void t() {
        if (!this.ao().B_() && this.gB() && this.cq()) {
            this.cf();
            if (!this.cq()) {
                this.h(false);
                return;
            }
        }
        super.t();
    }

    @Override
    public void d_() {
        if (this.cp > 0) {
            --this.cp;
        }
        this.i();
        this.cE.m();
        if (this.cG.b && !this.cq()) {
            this.l();
        }
        super.d_();
        this.fv();
        this.bE = this.ec();
        this.C((float)this.i(GenericAttributes.x));
        if (this.eZ() > 0.0f && !this.au()) {
            AxisAlignedBB axisalignedbb = this.cq() && !this.dz().eh() ? this.dj().b(this.dz().dj()).c(1.0, 0.0, 1.0) : this.dj().c(1.0, 0.5, 1.0);
            List<Entity> list = this.ao().a_(this, axisalignedbb);
            ArrayList list1 = Lists.newArrayList();
            for (Entity entity : list) {
                if (entity.ay() == EntityTypes.Z) {
                    list1.add(entity);
                    continue;
                }
                if (entity.eh()) continue;
                this.d(entity);
            }
            if (!list1.isEmpty()) {
                this.d((Entity)SystemUtils.a(list1, this.as));
            }
        }
        this.j();
    }

    protected void i() {
    }

    public void j() {
    }

    protected void k() {
    }

    private void d(Entity entity) {
        entity.a_(this);
    }

    public int gF() {
        return this.az.a(c);
    }

    public void q(int i2) {
        this.az.a(c, i2);
    }

    public void r(int i2) {
        int j2 = this.gF();
        this.az.a(c, j2 + i2);
    }

    public void a(int i2, float f2, ItemStack itemstack) {
        this.bW = i2;
        this.bX = f2;
        this.bY = itemstack;
        if (!this.ao().B_()) {
            this.k();
            this.c(4, true);
        }
    }

    @Override
    public ItemStack eq() {
        return this.fW() && this.bY != null ? this.bY : super.eq();
    }

    @Override
    public void a(DamageSource damagesource) {
        World world;
        super.a(damagesource);
        this.aH();
        if (!this.au() && (world = this.ao()) instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            this.b(worldserver, damagesource);
        }
        if (damagesource != null) {
            this.m(-MathHelper.b((double)((this.fg() + this.ec()) * ((float)Math.PI / 180))) * 0.1f, 0.1f, -MathHelper.a((double)((this.fg() + this.ec()) * ((float)Math.PI / 180))) * 0.1f);
        } else {
            this.m(0.0, 0.1, 0.0);
        }
        this.a(StatisticList.P);
        this.a(StatisticList.i.b(StatisticList.m));
        this.a(StatisticList.i.b(StatisticList.n));
        this.aT();
        this.d(false);
        this.d(Optional.of(GlobalPos.a(this.ao().aq(), this.dK())));
    }

    @Override
    protected void g(WorldServer worldserver) {
        super.g(worldserver);
        if (!worldserver.U().a(GameRules.s).booleanValue()) {
            this.gG();
            this.cE.n();
        }
    }

    protected void gG() {
        for (int i2 = 0; i2 < this.cE.b(); ++i2) {
            ItemStack itemstack = this.cE.a(i2);
            if (itemstack.f() || !EnchantmentManager.a(itemstack, EnchantmentEffectComponents.E)) continue;
            this.cE.b(i2);
        }
    }

    @Override
    protected SoundEffect h(DamageSource damagesource) {
        return damagesource.k().d().a();
    }

    @Override
    protected SoundEffect fd() {
        return SoundEffects.wW;
    }

    public void g(ItemStack itemstack) {
    }

    public @Nullable EntityItem a(ItemStack itemstack, boolean flag) {
        return this.a(itemstack, false, flag);
    }

    public float c(IBlockData iblockdata) {
        float f2 = this.cE.h().a(iblockdata);
        if (f2 > 1.0f) {
            f2 += (float)this.i(GenericAttributes.v);
        }
        if (MobEffectUtil.a(this)) {
            f2 *= 1.0f + (float)(MobEffectUtil.b(this) + 1) * 0.2f;
        }
        if (this.d(MobEffects.d)) {
            float f22 = switch (this.e(MobEffects.d).e()) {
                case 0 -> 0.3f;
                case 1 -> 0.09f;
                case 2 -> 0.0027f;
                default -> 8.1E-4f;
            };
            f2 *= f22;
        }
        f2 *= (float)this.i(GenericAttributes.g);
        if (((Entity)this).a(TagsFluid.a)) {
            f2 *= (float)this.h(GenericAttributes.E).g();
        }
        if (!this.aV()) {
            f2 /= 5.0f;
        }
        return f2;
    }

    public boolean d(IBlockData iblockdata) {
        return !iblockdata.C() || this.cE.h().b(iblockdata);
    }

    @Override
    protected void a(ValueInput valueinput) {
        super.a(valueinput);
        this.a(this.cI.id());
        this.cE.a(valueinput.c("Inventory", ItemStackWithSlot.a));
        this.cE.d(valueinput.a("SelectedItemSlot", 0));
        this.cF = valueinput.a("SleepTimer", (short)0);
        this.cu = valueinput.a("XpP", 0.0f);
        this.cs = valueinput.a("XpLevel", 0);
        this.ct = valueinput.a("XpTotal", 0);
        this.cv = valueinput.a("XpSeed", 0);
        if (this.cv == 0) {
            this.cv = this.as.f();
        }
        this.q(valueinput.a("Score", 0));
        this.co.a(valueinput);
        Optional<PlayerAbilities.a> optional = valueinput.a("abilities", PlayerAbilities.a.a);
        PlayerAbilities playerabilities = this.cG;
        Objects.requireNonNull(this.cG);
        optional.ifPresent(playerabilities::a);
        this.h(GenericAttributes.x).a(this.cG.b());
        this.cl.b(valueinput.c("EnderItems", ItemStackWithSlot.a));
        this.d(valueinput.a("LastDeathLocation", GlobalPos.b));
        this.cz = valueinput.a("current_explosion_impact_pos", Vec3D.a).orElse(null);
        this.cN = valueinput.a("ignore_fall_damage_from_current_explosion", false);
        this.cO = valueinput.a("current_impulse_context_reset_grace_time", 0);
    }

    @Override
    protected void a(ValueOutput valueoutput) {
        super.a(valueoutput);
        GameProfileSerializer.a(valueoutput);
        this.cE.a(valueoutput.a("Inventory", ItemStackWithSlot.a));
        valueoutput.a("SelectedItemSlot", this.cE.g());
        valueoutput.a("SleepTimer", (short)this.cF);
        valueoutput.a("XpP", this.cu);
        valueoutput.a("XpLevel", this.cs);
        valueoutput.a("XpTotal", this.ct);
        valueoutput.a("XpSeed", this.cv);
        valueoutput.a("Score", this.gF());
        this.co.a(valueoutput);
        valueoutput.a("abilities", PlayerAbilities.a.a, this.cG.c());
        this.cl.b(valueoutput.a("EnderItems", ItemStackWithSlot.a));
        this.cM.ifPresent(globalpos -> valueoutput.a("LastDeathLocation", GlobalPos.b, globalpos));
        valueoutput.b("current_explosion_impact_pos", Vec3D.a, this.cz);
        valueoutput.a("ignore_fall_damage_from_current_explosion", this.cN);
        valueoutput.a("current_impulse_context_reset_grace_time", this.cO);
    }

    @Override
    public boolean a(WorldServer worldserver, DamageSource damagesource) {
        return super.a(worldserver, damagesource) ? true : (damagesource.a(DamageTypeTags.n) ? !worldserver.U().a(GameRules.h).booleanValue() : (damagesource.a(DamageTypeTags.m) ? !worldserver.U().a(GameRules.l).booleanValue() : (damagesource.a(DamageTypeTags.i) ? !worldserver.U().a(GameRules.m).booleanValue() : (damagesource.a(DamageTypeTags.o) ? !worldserver.U().a(GameRules.p).booleanValue() : false))));
    }

    @Override
    public boolean a(WorldServer worldserver, DamageSource damagesource, float f2) {
        boolean damaged;
        if (this.a(worldserver, damagesource)) {
            return false;
        }
        if (this.cG.a && !damagesource.a(DamageTypeTags.d)) {
            return false;
        }
        this.bK = 0;
        if (this.fa()) {
            return false;
        }
        if (damagesource.g()) {
            if (worldserver.av() == EnumDifficulty.a) {
                return false;
            }
            if (worldserver.av() == EnumDifficulty.b) {
                f2 = Math.min(f2 / 2.0f + 1.0f, f2);
            }
            if (worldserver.av() == EnumDifficulty.d) {
                f2 = f2 * 3.0f / 2.0f;
            }
        }
        if (damaged = super.a(worldserver, damagesource, f2)) {
            this.k();
        }
        return damaged;
    }

    @Override
    protected void a(WorldServer worldserver, EntityLiving entityliving) {
        super.a(worldserver, entityliving);
        ItemStack itemstack = this.gh();
        BlocksAttacks blocksattacks = itemstack != null ? itemstack.a(DataComponents.M) : null;
        float f2 = entityliving.gu();
        if (f2 > 0.0f && blocksattacks != null) {
            blocksattacks.a(worldserver, this, f2, itemstack);
        }
    }

    @Override
    public boolean eS() {
        return !this.gL().a && super.eS();
    }

    public boolean a(EntityHuman entityhuman) {
        Team team;
        if (entityhuman instanceof EntityPlayer) {
            EntityPlayer thatPlayer = (EntityPlayer)entityhuman;
            team = thatPlayer.getBukkitEntity().getScoreboard().getPlayerTeam((OfflinePlayer)thatPlayer.getBukkitEntity());
            if (team == null || team.allowFriendlyFire()) {
                return true;
            }
        } else {
            OfflinePlayer thisPlayer = entityhuman.ao().getCraftServer().getOfflinePlayer(entityhuman.da());
            team = entityhuman.ao().getCraftServer().getScoreboardManager().getMainScoreboard().getPlayerTeam(thisPlayer);
            if (team == null || team.allowFriendlyFire()) {
                return true;
            }
        }
        if (this instanceof EntityPlayer) {
            return !team.hasPlayer((OfflinePlayer)((EntityPlayer)this).getBukkitEntity());
        }
        return !team.hasPlayer(this.ao().getCraftServer().getOfflinePlayer(this.da()));
    }

    @Override
    protected void c(DamageSource damagesource, float f2) {
        this.a(damagesource, f2, EnumItemSlot.c, EnumItemSlot.d, EnumItemSlot.e, EnumItemSlot.f);
    }

    @Override
    protected void d(DamageSource damagesource, float f2) {
        this.a(damagesource, f2, EnumItemSlot.f);
    }

    @Override
    protected boolean actuallyHurt(WorldServer worldserver, DamageSource damagesource, float f2, EntityDamageEvent event) {
        return super.actuallyHurt(worldserver, damagesource, f2, event);
    }

    public boolean Z() {
        return false;
    }

    public void a(TileEntitySign tileentitysign, boolean flag) {
    }

    public void a(EntityMinecartCommandBlock entityminecartcommandblock) {
    }

    public void a(TileEntityCommand tileentitycommand) {
    }

    public void a(TileEntityStructure tileentitystructure) {
    }

    public void a(TestBlockEntity testblockentity) {
    }

    public void a(TestInstanceBlockEntity testinstanceblockentity) {
    }

    public void a(TileEntityJigsaw tileentityjigsaw) {
    }

    public void a(EntityHorseAbstract entityhorseabstract, IInventory iinventory) {
    }

    public void a(AbstractNautilus abstractnautilus, IInventory iinventory) {
    }

    public OptionalInt a(@Nullable ITileInventory itileinventory) {
        return OptionalInt.empty();
    }

    public void b(Holder<Dialog> holder) {
    }

    public void a(int i2, MerchantRecipeList merchantrecipelist, int j2, int k2, boolean flag, boolean flag1) {
    }

    public void a(ItemStack itemstack, EnumHand enumhand) {
    }

    public EnumInteractionResult a(Entity entity, EnumHand enumhand) {
        if (this.au()) {
            if (entity instanceof ITileInventory) {
                this.a((ITileInventory)((Object)entity));
            }
            return EnumInteractionResult.e;
        }
        ItemStack itemstack = this.b(enumhand);
        ItemStack itemstack1 = itemstack.v();
        EnumInteractionResult enuminteractionresult = entity.a(this, enumhand);
        if (enuminteractionresult.a()) {
            if (this.gv() && itemstack == this.b(enumhand) && itemstack.N() < itemstack1.N()) {
                itemstack.e(itemstack1.N());
            }
            return enuminteractionresult;
        }
        if (!itemstack.f() && entity instanceof EntityLiving) {
            EnumInteractionResult enuminteractionresult1;
            if (this.gv()) {
                itemstack = itemstack1;
            }
            if ((enuminteractionresult1 = itemstack.a(this, (EntityLiving)entity, enumhand)).a()) {
                this.ao().a(GameEvent.r, entity.dI(), GameEvent.a.a(this));
                if (itemstack.f() && !this.gv()) {
                    this.a(enumhand, ItemStack.l);
                }
                return enuminteractionresult1;
            }
        }
        return EnumInteractionResult.e;
    }

    @Override
    public void ad() {
        super.ad();
        this.X = 0;
    }

    @Override
    protected boolean fE() {
        return super.fE() || this.gr();
    }

    @Override
    public boolean eG() {
        return !this.cG.b;
    }

    @Override
    protected Vec3D a(Vec3D vec3d, EnumMoveType enummovetype) {
        float f2 = this.eg();
        if (!this.cG.b && vec3d.h <= 0.0 && (enummovetype == EnumMoveType.a || enummovetype == EnumMoveType.b) && this.gC() && this.K(f2)) {
            double d0;
            double d1 = vec3d.i;
            double d2 = 0.05;
            double d3 = Math.signum(d0) * 0.05;
            double d4 = Math.signum(d1) * 0.05;
            for (d0 = vec3d.g; d0 != 0.0 && this.p(d0, 0.0, f2); d0 -= d3) {
                if (!(Math.abs(d0) <= 0.05)) continue;
                d0 = 0.0;
                break;
            }
            while (d1 != 0.0 && this.p(0.0, d1, f2)) {
                if (Math.abs(d1) <= 0.05) {
                    d1 = 0.0;
                    break;
                }
                d1 -= d4;
            }
            while (d0 != 0.0 && d1 != 0.0 && this.p(d0, d1, f2)) {
                d0 = Math.abs(d0) <= 0.05 ? 0.0 : (d0 -= d3);
                if (Math.abs(d1) <= 0.05) {
                    d1 = 0.0;
                    continue;
                }
                d1 -= d4;
            }
            return new Vec3D(d0, vec3d.h, d1);
        }
        return vec3d;
    }

    private boolean K(float f2) {
        return this.aV() || this.an < (double)f2 && !this.p(0.0, 0.0, (double)f2 - this.an);
    }

    private boolean p(double d0, double d1, double d2) {
        AxisAlignedBB axisalignedbb = this.dj();
        return this.ao().a((Entity)this, new AxisAlignedBB(axisalignedbb.a + 1.0E-7 + d0, axisalignedbb.b - d2 - 1.0E-7, axisalignedbb.c + 1.0E-7 + d1, axisalignedbb.d - 1.0E-7 + d0, axisalignedbb.b, axisalignedbb.f - 1.0E-7 + d1));
    }

    public void e(Entity entity) {
        if (!this.H(entity)) {
            float f2 = this.fW() ? this.bX : (float)this.i(GenericAttributes.d);
            ItemStack itemstack = this.eq();
            DamageSource damagesource = this.i(itemstack);
            float f1 = this.I(0.5f);
            float f22 = f1 * (this.a(entity, f2, damagesource) - f2);
            f2 *= this.p();
            this.fO();
            if (!this.deflectProjectile(entity, damagesource, f22)) {
                if (f2 > 0.0f || f22 > 0.0f) {
                    boolean flag2;
                    boolean flag1;
                    boolean flag;
                    boolean bl = flag = f1 > 0.9f;
                    if (this.cA() && flag) {
                        this.c(SoundEffects.wO);
                        flag1 = true;
                    } else {
                        flag1 = false;
                    }
                    f2 += itemstack.h().a(entity, f2, damagesource);
                    boolean bl2 = flag2 = flag && this.J(entity);
                    if (flag2) {
                        f2 *= 1.5f;
                    }
                    float f3 = f2 + f22;
                    boolean flag3 = this.a(flag, flag2, flag1);
                    float f4 = 0.0f;
                    if (entity instanceof EntityLiving) {
                        EntityLiving entityliving = (EntityLiving)entity;
                        f4 = entityliving.eZ();
                    }
                    Vec3D vec3d = entity.dN();
                    boolean flag4 = entity.b(damagesource, f3);
                    if (flag4) {
                        this.a(entity, this.b(entity, damagesource) + (flag1 ? 0.5f : 0.0f), vec3d);
                        if (flag3) {
                            this.a(entity, f2, damagesource, f1);
                        }
                        this.a(entity, flag2, flag3, flag, false, f22);
                        this.C(entity);
                        this.a(entity, itemstack, damagesource, true);
                        this.a(entity, f4);
                        this.a(0.1f);
                    } else {
                        this.c(SoundEffects.wP);
                        if (this instanceof EntityPlayer) {
                            ((EntityPlayer)this).getBukkitEntity().updateInventory();
                        }
                    }
                }
                this.fi();
            }
        }
    }

    private void c(SoundEffect soundeffect) {
        this.ao().a((Entity)null, this.dP(), this.dR(), this.dV(), soundeffect, this.dB(), 1.0f, 1.0f);
    }

    private DamageSource i(ItemStack itemstack) {
        return itemstack.a((EntityLiving)this, () -> this.en().a(this));
    }

    private boolean H(Entity entity) {
        return !entity.cT() ? true : entity.w(this);
    }

    private boolean deflectProjectile(Entity entity, DamageSource damagesource, float f1) {
        if (entity.ay().a(TagsEntity.I) && entity instanceof IProjectile) {
            IProjectile iprojectile = (IProjectile)entity;
            if (CraftEventFactory.handleNonLivingEntityDamageEvent(entity, damagesource, f1, false)) {
                return true;
            }
            if (iprojectile.a(ProjectileDeflection.c, this, EntityReference.a(this), true)) {
                this.ao().a((Entity)null, this.dP(), this.dR(), this.dV(), SoundEffects.wP, this.dB());
                return true;
            }
        }
        return false;
    }

    private boolean J(Entity entity) {
        return this.an > 0.0 && !this.aV() && !this.fl() && !this.by() && !this.hl() && !this.cq() && entity instanceof EntityLiving && !this.cA();
    }

    private boolean a(boolean flag, boolean flag1, boolean flag2) {
        double d1;
        double d0;
        if (flag && !flag1 && !flag2 && this.aV() && (d0 = this.ag().j()) < MathHelper.n(d1 = (double)this.fM() * 2.5)) {
            return this.b(EnumHand.a).a(TagsItem.ca);
        }
        return false;
    }

    private void a(Entity entity, boolean flag, boolean flag1, boolean flag2, boolean flag3, float f2) {
        if (flag) {
            this.c(SoundEffects.wN);
            this.b(entity);
        }
        if (!(flag || flag1 || flag3)) {
            this.c(flag2 ? SoundEffects.wQ : SoundEffects.wS);
        }
        if (f2 > 0.0f) {
            this.c(entity);
        }
    }

    private void a(Entity entity, float f2) {
        if (entity instanceof EntityLiving) {
            float f1 = f2 - ((EntityLiving)entity).eZ();
            this.a(StatisticList.I, Math.round(f1 * 10.0f));
            if (this.ao() instanceof WorldServer && f1 > 2.0f) {
                int i2 = (int)((double)f1 * 0.5);
                ((WorldServer)this.ao()).a(Particles.h, entity.dP(), entity.f(0.5), entity.dV(), i2, 0.1, 0.0, 0.1, 0.2);
            }
        }
    }

    private void a(Entity entity, ItemStack itemstack, DamageSource damagesource, boolean flag) {
        Entity entity1 = entity;
        if (entity instanceof EntityComplexPart) {
            entity1 = ((EntityComplexPart)entity).a;
        }
        boolean flag1 = false;
        World world = this.ao();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            if (entity1 instanceof EntityLiving) {
                EntityLiving entityliving = (EntityLiving)entity1;
                flag1 = itemstack.a(entityliving, (EntityLiving)this);
            }
            if (flag) {
                EnchantmentManager.a(worldserver, entity, damagesource, itemstack);
            }
        }
        if (!this.ao().B_() && !itemstack.f() && entity1 instanceof EntityLiving) {
            if (flag1) {
                itemstack.b((EntityLiving)entity1, (EntityLiving)this);
            }
            if (itemstack.f()) {
                if (itemstack == this.fx()) {
                    this.a(EnumHand.a, ItemStack.l);
                } else {
                    this.a(EnumHand.b, ItemStack.l);
                }
            }
        }
    }

    @Override
    public void a(Entity entity, float f2, Vec3D vec3d) {
        if (f2 > 0.0f) {
            if (entity instanceof EntityLiving) {
                EntityLiving entityliving = (EntityLiving)entity;
                entityliving.knockback(f2, MathHelper.a((double)(this.ec() * ((float)Math.PI / 180))), -MathHelper.b((double)(this.ec() * ((float)Math.PI / 180))), this, EntityKnockbackEvent.KnockbackCause.ENTITY_ATTACK);
            } else {
                entity.i(-MathHelper.a((double)(this.ec() * ((float)Math.PI / 180))) * f2, 0.1, MathHelper.b((double)(this.ec() * ((float)Math.PI / 180))) * f2);
            }
            this.k(this.dN().d(0.6, 1.0, 0.6));
            this.i(false);
        }
        if (entity instanceof EntityPlayer && entity.ah) {
            boolean cancelled = false;
            Player player = (Player)entity.getBukkitEntity();
            Vector velocity = CraftVector.toBukkit(vec3d);
            PlayerVelocityEvent event = new PlayerVelocityEvent(player, velocity.clone());
            this.ao().getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                cancelled = true;
            } else if (!velocity.equals((Object)event.getVelocity())) {
                player.setVelocity(event.getVelocity());
            }
            if (!cancelled) {
                ((EntityPlayer)entity).g.b(new PacketPlayOutEntityVelocity(entity));
                entity.ah = false;
                entity.k(vec3d);
            }
        }
    }

    @Override
    public float fD() {
        return 1.0f;
    }

    private void a(Entity entity, float f2, DamageSource damagesource, float f1) {
        this.c(SoundEffects.wR);
        World world = this.ao();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            float f22 = 1.0f + (float)this.i(GenericAttributes.F) * f2;
            for (EntityLiving entityliving : this.ao().a(EntityLiving.class, entity.dj().c(1.0, 0.25, 1.0))) {
                float f3;
                EntityArmorStand entityarmorstand;
                if (entityliving == this || entityliving == entity || this.t(entityliving) || entityliving instanceof EntityArmorStand && (entityarmorstand = (EntityArmorStand)entityliving).r() || !(this.g(entityliving) < 9.0) || !entityliving.a(worldserver, damagesource, f3 = this.a((Entity)entityliving, f22, damagesource) * f1)) continue;
                entityliving.knockback(0.4f, MathHelper.a((double)(this.ec() * ((float)Math.PI / 180))), -MathHelper.b((double)(this.ec() * ((float)Math.PI / 180))), this, EntityKnockbackEvent.KnockbackCause.SWEEP_ATTACK);
                EnchantmentManager.a(worldserver, (Entity)entityliving, damagesource);
            }
            double d0 = -MathHelper.a((double)(this.ec() * ((float)Math.PI / 180)));
            double d1 = MathHelper.b((double)(this.ec() * ((float)Math.PI / 180)));
            worldserver.a(Particles.an, this.dP() + d0, this.f(0.5), this.dV() + d1, 0, d0, 0.0, d1, 0.0);
        }
    }

    protected float a(Entity entity, float f2, DamageSource damagesource) {
        return f2;
    }

    @Override
    protected void f(EntityLiving entityliving) {
        this.e((Entity)entityliving);
    }

    public void b(Entity entity) {
    }

    private float p() {
        float f2 = this.I(0.5f);
        return 0.2f + f2 * f2 * 0.8f;
    }

    @Override
    public boolean a(EnumItemSlot enumitemslot, Entity entity, float f2, boolean flag, boolean flag1, boolean flag2) {
        boolean flag3;
        if (this.H(entity)) {
            return false;
        }
        ItemStack itemstack = this.a(enumitemslot);
        DamageSource damagesource = this.i(itemstack);
        float f1 = this.a(entity, f2, damagesource) - f2;
        if (!this.fZ() || this.ga().a() != enumitemslot) {
            f1 *= this.I(0.5f);
            f2 *= this.p();
        }
        if (flag1 && this.deflectProjectile(entity, damagesource, f1)) {
            return true;
        }
        float f22 = flag ? f2 + f1 : 0.0f;
        float f3 = 0.0f;
        if (entity instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)entity;
            f3 = entityliving.eZ();
        }
        Vec3D vec3d = entity.dN();
        boolean bl = flag3 = flag && entity.b(damagesource, f22);
        if (flag1) {
            this.a(entity, 0.4f + this.b(entity, damagesource), vec3d);
        }
        boolean flag4 = false;
        if (flag2 && entity.cq()) {
            flag4 = true;
            entity.cf();
        }
        if (!(flag3 || flag1 || flag4)) {
            return false;
        }
        this.a(entity, false, false, flag, true, f1);
        this.C(entity);
        this.a(entity, itemstack, damagesource, flag3);
        this.a(entity, f3);
        this.causeFoodExhaustion(this.ao().spigotConfig.combatExhaustion, EntityExhaustionEvent.ExhaustionReason.ATTACK);
        return true;
    }

    public void c(Entity entity) {
    }

    @Override
    public void a(Entity.RemovalReason entity_removalreason) {
        this.remove(entity_removalreason, null);
    }

    @Override
    public void remove(Entity.RemovalReason entity_removalreason, EntityRemoveEvent.Cause cause) {
        super.remove(entity_removalreason, cause);
        this.cm.a(this);
        if (this.gN()) {
            this.s();
        }
    }

    @Override
    public boolean aa_() {
        return true;
    }

    @Override
    protected boolean dw() {
        return this.gH();
    }

    public boolean gH() {
        return false;
    }

    @Override
    public boolean dx() {
        return !this.ao().B_() || this.gH();
    }

    @Override
    public boolean dy() {
        return !this.ao().B_() || this.gH();
    }

    public GameProfile gI() {
        return this.cI;
    }

    public NameAndId gJ() {
        return new NameAndId(this.cI);
    }

    public PlayerInventory gK() {
        return this.cE;
    }

    public PlayerAbilities gL() {
        return this.cG;
    }

    @Override
    public boolean gv() {
        return this.cG.d;
    }

    public boolean gM() {
        return this.cG.d;
    }

    public void a(ItemStack itemstack, ItemStack itemstack1, ClickAction clickaction) {
    }

    public boolean gN() {
        return this.cn != this.cm;
    }

    public boolean gO() {
        return true;
    }

    public Either<EnumBedResult, Unit> a(BlockPosition blockposition) {
        return this.startSleepInBed(blockposition, false);
    }

    public Either<EnumBedResult, Unit> startSleepInBed(BlockPosition blockposition, boolean force) {
        this.b(blockposition);
        this.cF = 0;
        return Either.right((Object)((Object)Unit.a));
    }

    public void a(boolean flag, boolean flag1) {
        super.gs();
        if (this.ao() instanceof WorldServer && flag1) {
            ((WorldServer)this.ao()).h();
        }
        this.cF = flag ? 0 : 100;
    }

    @Override
    public void gs() {
        this.a(true, true);
    }

    public boolean gP() {
        return this.gr() && this.cF >= 100;
    }

    public int gQ() {
        return this.cF;
    }

    public void a(IChatBaseComponent ichatbasecomponent, boolean flag) {
    }

    public void a(MinecraftKey minecraftkey) {
        this.b(StatisticList.i.b(minecraftkey));
    }

    public void a(MinecraftKey minecraftkey, int i2) {
        this.a(StatisticList.i.b(minecraftkey), i2);
    }

    public void b(Statistic<?> statistic) {
        this.a(statistic, 1);
    }

    public void a(Statistic<?> statistic, int i2) {
    }

    public void a(Statistic<?> statistic) {
    }

    public int a(Collection<RecipeHolder<?>> collection) {
        return 0;
    }

    public void a(RecipeHolder<?> recipeholder, List<ItemStack> list) {
    }

    public void b(List<ResourceKey<IRecipe<?>>> list) {
    }

    public int b(Collection<RecipeHolder<?>> collection) {
        return 0;
    }

    @Override
    public void m(Vec3D vec3d) {
        if (this.cq()) {
            super.m(vec3d);
        } else {
            if (this.cB()) {
                double d1;
                double d0 = this.cj().h;
                double d2 = d1 = d0 < -0.2 ? 0.085 : 0.06;
                if (d0 <= 0.0 || this.bM || !this.ao().b_(BlockPosition.a(this.dP(), this.dR() + 1.0 - 0.1, this.dV())).c()) {
                    Vec3D vec3d1 = this.dN();
                    this.k(vec3d1.b(0.0, (d0 - vec3d1.h) * d1, 0.0));
                }
            }
            if (this.gL().b) {
                double d2 = this.dN().h;
                super.m(vec3d);
                this.k(this.dN().a(EnumDirection.EnumAxis.b, d2 * 0.6));
            } else {
                super.m(vec3d);
            }
        }
    }

    @Override
    protected boolean fU() {
        return !this.cG.b && super.fU();
    }

    @Override
    public void bF() {
        if (this.cG.b) {
            this.j(false);
        } else {
            super.bF();
        }
    }

    protected boolean h(BlockPosition blockposition) {
        return !this.ao().a_(blockposition).j(this.ao(), blockposition);
    }

    @Override
    public float fM() {
        return (float)this.i(GenericAttributes.x);
    }

    @Override
    public boolean a(double d0, float f2, DamageSource damagesource) {
        double d1;
        boolean flag;
        if (this.cG.c) {
            return false;
        }
        if (d0 >= 2.0) {
            this.a(StatisticList.t, (int)Math.round(d0 * 100.0));
        }
        boolean bl = flag = this.cz != null && this.cN;
        if (flag) {
            boolean flag1;
            d1 = Math.min(d0, this.cz.h - this.dR());
            boolean bl2 = flag1 = d1 <= 0.0;
            if (flag1) {
                this.hr();
            } else {
                this.hp();
            }
        } else {
            d1 = d0;
        }
        if (d1 > 0.0 && super.a(d1, f2, damagesource)) {
            this.hr();
            return true;
        }
        this.b(d0, f2, damagesource);
        return false;
    }

    public boolean gR() {
        if (!this.gj() && this.fU() && !this.by()) {
            this.gS();
            return true;
        }
        return false;
    }

    public void gS() {
        if (!CraftEventFactory.callToggleGlideEvent(this, true).isCancelled()) {
            this.b(7, true);
        } else {
            this.b(7, true);
            this.b(7, false);
        }
    }

    @Override
    protected void bI() {
        if (!this.au()) {
            super.bI();
        }
    }

    @Override
    protected void b(BlockPosition blockposition, IBlockData iblockdata) {
        if (this.by()) {
            this.bn();
            this.b(iblockdata);
        } else {
            BlockPosition blockposition1 = this.e(blockposition);
            if (!blockposition.equals(blockposition1)) {
                IBlockData iblockdata1 = this.ao().a_(blockposition1);
                if (iblockdata1.a(TagsBlock.bB)) {
                    this.a(iblockdata1, iblockdata);
                } else {
                    super.b(blockposition1, iblockdata1);
                }
            } else {
                super.b(blockposition, iblockdata);
            }
        }
    }

    @Override
    public EntityLiving.a fj() {
        return new EntityLiving.a(SoundEffects.xd, SoundEffects.wT);
    }

    @Override
    public boolean a(WorldServer worldserver, EntityLiving entityliving, DamageSource damagesource) {
        this.b(StatisticList.g.b(entityliving.ay()));
        return true;
    }

    @Override
    public void a(IBlockData iblockdata, Vec3D vec3d) {
        if (!this.cG.b) {
            super.a(iblockdata, vec3d);
        }
        this.hp();
    }

    public void d(int i2) {
        this.r(i2);
        this.cu += (float)i2 / (float)this.gU();
        this.ct = MathHelper.a(this.ct + i2, 0, Integer.MAX_VALUE);
        while (this.cu < 0.0f) {
            float f2 = this.cu * (float)this.gU();
            if (this.cs > 0) {
                this.c(-1);
                this.cu = 1.0f + f2 / (float)this.gU();
                continue;
            }
            this.c(-1);
            this.cu = 0.0f;
        }
        while (this.cu >= 1.0f) {
            this.cu = (this.cu - 1.0f) * (float)this.gU();
            this.c(1);
            this.cu /= (float)this.gU();
        }
    }

    public int gT() {
        return this.cv;
    }

    public void a(ItemStack itemstack, int i2) {
        this.cs -= i2;
        if (this.cs < 0) {
            this.cs = 0;
            this.cu = 0.0f;
            this.ct = 0;
        }
        this.cv = this.as.f();
    }

    public void c(int i2) {
        this.cs = IntMath.saturatedAdd((int)this.cs, (int)i2);
        if (this.cs < 0) {
            this.cs = 0;
            this.cu = 0.0f;
            this.ct = 0;
        }
        if (i2 > 0 && this.cs % 5 == 0 && (float)this.cH < (float)this.at - 100.0f) {
            float f2 = this.cs > 30 ? 1.0f : (float)this.cs / 30.0f;
            this.ao().a((Entity)null, this.dP(), this.dR(), this.dV(), SoundEffects.xc, this.dB(), f2 * 0.75f, 1.0f);
            this.cH = this.at;
        }
    }

    public int gU() {
        return this.cs >= 30 ? 112 + (this.cs - 30) * 9 : (this.cs >= 15 ? 37 + (this.cs - 15) * 5 : 7 + this.cs * 2);
    }

    public void a(float f2) {
        this.causeFoodExhaustion(f2, EntityExhaustionEvent.ExhaustionReason.UNKNOWN);
    }

    public void causeFoodExhaustion(float f2, EntityExhaustionEvent.ExhaustionReason reason) {
        EntityExhaustionEvent event;
        if (!(this.cG.a || this.ao().B_() || (event = CraftEventFactory.callPlayerExhaustionEvent(this, reason, f2)).isCancelled())) {
            this.co.a(event.getExhaustion());
        }
    }

    @Override
    public void fi() {
        if (this.gV()) {
            super.fi();
        }
    }

    protected boolean gV() {
        return this.gW().b() || this.gL().c;
    }

    public Optional<WardenSpawnTracker> ab() {
        return Optional.empty();
    }

    public FoodMetaData gW() {
        return this.co;
    }

    public boolean u(boolean flag) {
        return this.cG.a || flag || this.co.c();
    }

    public boolean gX() {
        return this.eZ() > 0.0f && this.eZ() < this.fq();
    }

    public boolean gY() {
        return this.cG.e;
    }

    public boolean a(BlockPosition blockposition, EnumDirection enumdirection, ItemStack itemstack) {
        if (this.cG.e) {
            return true;
        }
        BlockPosition blockposition1 = blockposition.a(enumdirection.g());
        ShapeDetectorBlock shapedetectorblock = new ShapeDetectorBlock(this.ao(), blockposition1, false);
        return itemstack.a(shapedetectorblock);
    }

    @Override
    protected int f(WorldServer worldserver) {
        return worldserver.U().a(GameRules.s) == false && !this.au() ? Math.min(this.cs * 7, 100) : 0;
    }

    @Override
    protected boolean eJ() {
        return true;
    }

    @Override
    public boolean de() {
        return true;
    }

    @Override
    protected Entity.MovementEmission bv() {
        return this.cG.b || this.aV() && this.cx() ? Entity.MovementEmission.a : Entity.MovementEmission.d;
    }

    public void z() {
    }

    @Override
    public IChatBaseComponent ap() {
        return IChatBaseComponent.b(this.cI.name());
    }

    @Override
    public String aq() {
        return this.cI.name();
    }

    public InventoryEnderChest gZ() {
        return this.cl;
    }

    @Override
    protected boolean b(EnumItemSlot enumitemslot) {
        return enumitemslot.a() == EnumItemSlot.Function.b;
    }

    public boolean h(ItemStack itemstack) {
        return this.cE.g(itemstack);
    }

    public abstract @Nullable EnumGamemode a();

    @Override
    public boolean au() {
        return this.a() == EnumGamemode.d;
    }

    @Override
    public boolean bW() {
        return !this.au() && super.bW();
    }

    @Override
    public boolean cB() {
        return !this.cG.b && !this.au() && super.cB();
    }

    public boolean ha() {
        return this.a() == EnumGamemode.b;
    }

    @Override
    public boolean db() {
        return !this.cG.b;
    }

    @Override
    public IChatBaseComponent R_() {
        IChatMutableComponent ichatmutablecomponent = ScoreboardTeam.a(this.cI(), this.ap());
        return this.a(ichatmutablecomponent);
    }

    private IChatMutableComponent a(IChatMutableComponent ichatmutablecomponent) {
        String s2 = this.gI().name();
        return ichatmutablecomponent.a(chatmodifier -> chatmodifier.a(new ChatClickable.SuggestCommand("/tell " + s2 + " ")).a(this.di()).a(s2));
    }

    @Override
    public String da() {
        return this.gI().name();
    }

    @Override
    protected void G(float f2) {
        this.aD().a(b, Float.valueOf(f2));
    }

    @Override
    public float fX() {
        return this.aD().a(b).floatValue();
    }

    @Override
    public @Nullable SlotAccess a_(int i2) {
        if (i2 == 499) {
            return new SlotAccess(){

                @Override
                public ItemStack a() {
                    return EntityHuman.this.cn.g();
                }

                @Override
                public boolean a(ItemStack itemstack) {
                    EntityHuman.this.cn.a(itemstack);
                    return true;
                }
            };
        }
        final int j2 = i2 - 500;
        if (j2 >= 0 && j2 < 4) {
            return new SlotAccess(){

                @Override
                public ItemStack a() {
                    return EntityHuman.this.cm.r().a(j2);
                }

                @Override
                public boolean a(ItemStack itemstack) {
                    EntityHuman.this.cm.r().a(j2, itemstack);
                    EntityHuman.this.cm.a(EntityHuman.this.cE);
                    return true;
                }
            };
        }
        if (i2 >= 0 && i2 < this.cE.j().size()) {
            return this.cE.a_(i2);
        }
        int k2 = i2 - 200;
        return k2 >= 0 && k2 < this.cl.b() ? this.cl.a_(k2) : super.a_(i2);
    }

    public boolean hb() {
        return this.cJ;
    }

    public void v(boolean flag) {
        this.cJ = flag;
    }

    @Override
    public void h(int i2) {
        super.h(this.cG.a ? Math.min(i2, 1) : i2);
    }

    protected static Optional<EntityParrot.Variant> d(NBTTagCompound nbttagcompound) {
        EntityTypes entitytypes;
        if (!nbttagcompound.j() && (entitytypes = (EntityTypes)nbttagcompound.a("id", EntityTypes.a).orElse(null)) == EntityTypes.aW) {
            return nbttagcompound.a("Variant", EntityParrot.Variant.h);
        }
        return Optional.empty();
    }

    protected static OptionalInt a(Optional<EntityParrot.Variant> optional) {
        return optional.map(entityparrot_variant -> OptionalInt.of(entityparrot_variant.a())).orElse(OptionalInt.empty());
    }

    private static Optional<EntityParrot.Variant> a(OptionalInt optionalint) {
        return optionalint.isPresent() ? Optional.of(EntityParrot.Variant.a(optionalint.getAsInt())) : Optional.empty();
    }

    public void b(Optional<EntityParrot.Variant> optional) {
        this.az.a(d, EntityHuman.a(optional));
    }

    public Optional<EntityParrot.Variant> hc() {
        return EntityHuman.a(this.az.a(d));
    }

    public void c(Optional<EntityParrot.Variant> optional) {
        this.az.a(e, EntityHuman.a(optional));
    }

    public Optional<EntityParrot.Variant> hd() {
        return EntityHuman.a(this.az.a(e));
    }

    public float he() {
        return (float)(1.0 / this.i(GenericAttributes.f) * 20.0);
    }

    public boolean c(ItemStack itemstack, int i2) {
        float f2 = itemstack.a(DataComponents.i, Float.valueOf(0.0f)).floatValue();
        float f1 = (float)(this.bz + i2) / this.he();
        return f2 > 0.0f && f1 < f2;
    }

    public float I(float f2) {
        return MathHelper.a(((float)this.bz + f2) / this.he(), 0.0f, 1.0f);
    }

    public float J(float f2) {
        return MathHelper.a(((float)this.bA + f2) / this.he(), 0.0f, 1.0f);
    }

    public void hf() {
        this.bz = 0;
        this.bA = 0;
    }

    @Override
    public void fO() {
        super.fO();
    }

    public void hg() {
        this.bz = 0;
    }

    public ItemCooldown hh() {
        return this.cL;
    }

    @Override
    protected float bi() {
        return !this.cG.b && !this.gj() ? super.bi() : 1.0f;
    }

    @Override
    public float eB() {
        return (float)this.i(GenericAttributes.s);
    }

    public boolean hi() {
        return this.cG.d && this.I().hasPermission(Permissions.b);
    }

    public PermissionSet I() {
        return PermissionSet.g;
    }

    @Override
    public ImmutableList<EntityPose> go() {
        return ImmutableList.of((Object)EntityPose.a, (Object)EntityPose.f, (Object)EntityPose.d);
    }

    @Override
    public ItemStack d(ItemStack itemstack) {
        if (!(itemstack.h() instanceof ItemProjectileWeapon)) {
            return ItemStack.l;
        }
        Predicate<ItemStack> predicate = ((ItemProjectileWeapon)itemstack.h()).c();
        ItemStack itemstack1 = ItemProjectileWeapon.a(this, predicate);
        if (!itemstack1.f()) {
            return itemstack1;
        }
        predicate = ((ItemProjectileWeapon)itemstack.h()).a();
        for (int i2 = 0; i2 < this.cE.b(); ++i2) {
            ItemStack itemstack2 = this.cE.a(i2);
            if (!predicate.test(itemstack2)) continue;
            return itemstack2;
        }
        return this.gv() ? new ItemStack(Items.pX) : ItemStack.l;
    }

    @Override
    public Vec3D u(float f2) {
        float f3;
        double d0 = 0.22 * (this.at() == EnumMainHand.b ? -1.0 : 1.0);
        float f1 = MathHelper.h(f2 * 0.5f, this.ee(), this.ac) * ((float)Math.PI / 180);
        float f22 = MathHelper.h(f2, this.bD, this.bC) * ((float)Math.PI / 180);
        if (!this.gj() && !this.fW()) {
            if (this.cC()) {
                return this.p(f2).e(new Vec3D(d0, 0.2, -0.15).a(-f1).b(-f22));
            }
            double d1 = this.dj().c() - 1.0;
            double d2 = this.cz() ? -0.2 : 0.07;
            return this.p(f2).e(new Vec3D(d0, d1, d2).b(-f22));
        }
        Vec3D vec3d = this.h(f2);
        Vec3D vec3d1 = this.dN();
        double d3 = vec3d1.j();
        double d4 = vec3d.j();
        if (d3 > 0.0 && d4 > 0.0) {
            double d5 = (vec3d1.g * vec3d.g + vec3d1.i * vec3d.i) / Math.sqrt(d3 * d4);
            double d6 = vec3d1.g * vec3d.i - vec3d1.i * vec3d.g;
            f3 = (float)(Math.signum(d6) * Math.acos(d5));
        } else {
            f3 = 0.0f;
        }
        return this.p(f2).e(new Vec3D(d0, -0.11, 0.85).c(-f3).a(-f1).b(-f22));
    }

    @Override
    public boolean el() {
        return true;
    }

    public boolean hj() {
        return this.fZ() && this.gb().a(Items.tb);
    }

    @Override
    public boolean ek() {
        return false;
    }

    public Optional<GlobalPos> hk() {
        return this.cM;
    }

    public void d(Optional<GlobalPos> optional) {
        this.cM = optional;
    }

    @Override
    public float fg() {
        return this.cy;
    }

    @Override
    public void q(float f2) {
        super.q(f2);
        this.cy = f2;
    }

    public boolean hl() {
        return this.d(MobEffects.o);
    }

    @Override
    public boolean ef() {
        return true;
    }

    @Override
    protected float fL() {
        return this.cG.b && !this.cq() ? (this.cA() ? this.cG.a() * 2.0f : this.cG.a()) : (this.cA() ? 0.025999999f : 0.02f);
    }

    @Override
    public boolean a(ContainerOpenersCounter containeropenerscounter, BlockPosition blockposition) {
        return containeropenerscounter.a(this);
    }

    @Override
    public double ar() {
        return this.hm();
    }

    public double hm() {
        return this.i(GenericAttributes.h);
    }

    public double hn() {
        return this.i(GenericAttributes.l);
    }

    public boolean b(Entity entity, double d0) {
        return entity.eh() ? false : this.a(entity.dj(), d0);
    }

    public boolean a(AxisAlignedBB axisalignedbb, double d0) {
        double d1 = this.hn() + d0;
        double d2 = axisalignedbb.e(this.bV());
        return d2 < d1 * d1;
    }

    public boolean b(AxisAlignedBB axisalignedbb, double d0) {
        return this.fz().a((EntityLiving)this, axisalignedbb, d0);
    }

    public boolean a(BlockPosition blockposition, double d0) {
        double d1 = this.hm() + d0;
        return new AxisAlignedBB(blockposition).e(this.bV()) < d1 * d1;
    }

    public void w(boolean flag) {
        this.cN = flag;
        if (flag) {
            this.s(40);
        } else {
            this.cO = 0;
        }
    }

    public void s(int i2) {
        this.cO = Math.max(this.cO, i2);
    }

    public boolean ho() {
        return this.cN;
    }

    public void hp() {
        if (this.cO == 0) {
            this.hr();
        }
    }

    public boolean hq() {
        return this.cO > 0;
    }

    public void hr() {
        this.cO = 0;
        this.cA = null;
        this.cz = null;
        this.cN = false;
    }

    public boolean hs() {
        return false;
    }

    @Override
    public boolean fl() {
        return this.cG.b ? false : super.fl();
    }

    public String ht() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.aq()).add("id", this.aA()).add("pos", (Object)this.dI()).add("mode", (Object)this.a()).add("permission", (Object)this.I()).toString();
    }

    public static final class EnumBedResult
    extends Record {
        private final @Nullable IChatBaseComponent e;
        private final PlayerBedEnterEvent.BedEnterResult bukkit;
        public static final EnumBedResult a = new EnumBedResult(IChatBaseComponent.c("block.minecraft.bed.too_far_away"), PlayerBedEnterEvent.BedEnterResult.TOO_FAR_AWAY);
        public static final EnumBedResult b = new EnumBedResult(IChatBaseComponent.c("block.minecraft.bed.obstructed"), PlayerBedEnterEvent.BedEnterResult.OTHER_PROBLEM);
        public static final EnumBedResult c = new EnumBedResult(null, PlayerBedEnterEvent.BedEnterResult.OTHER_PROBLEM);
        public static final EnumBedResult d = new EnumBedResult(IChatBaseComponent.c("block.minecraft.bed.not_safe"), PlayerBedEnterEvent.BedEnterResult.NOT_SAFE);

        public EnumBedResult(@Nullable IChatBaseComponent message) {
            this(message, PlayerBedEnterEvent.BedEnterResult.OTHER_PROBLEM);
        }

        public EnumBedResult(@Nullable IChatBaseComponent message, PlayerBedEnterEvent.BedEnterResult bukkit) {
            this.e = message;
            this.bukkit = bukkit;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{EnumBedResult.class, "message;bukkit", "e", "bukkit"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{EnumBedResult.class, "message;bukkit", "e", "bukkit"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{EnumBedResult.class, "message;bukkit", "e", "bukkit"}, this, o2);
        }

        public @Nullable IChatBaseComponent a() {
            return this.e;
        }

        public PlayerBedEnterEvent.BedEnterResult bukkit() {
            return this.bukkit;
        }
    }
}

