/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.DependantName;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.SystemUtils;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.flag.FeatureElement;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.food.FoodInfo;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.EitherHolder;
import net.minecraft.world.item.EnumItemRarity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.JukeboxPlayable;
import net.minecraft.world.item.JukeboxSong;
import net.minecraft.world.item.SwingAnimationType;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.AttackRange;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.item.component.Consumables;
import net.minecraft.world.item.component.DamageResistant;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.KineticWeapon;
import net.minecraft.world.item.component.PiercingWeapon;
import net.minecraft.world.item.component.ProvidesTrimMaterial;
import net.minecraft.world.item.component.SwingAnimation;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.component.TypedEntityData;
import net.minecraft.world.item.component.UseCooldown;
import net.minecraft.world.item.component.UseEffects;
import net.minecraft.world.item.component.UseRemainder;
import net.minecraft.world.item.component.Weapon;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.item.enchantment.Enchantable;
import net.minecraft.world.item.enchantment.Repairable;
import net.minecraft.world.item.equipment.ArmorMaterial;
import net.minecraft.world.item.equipment.ArmorType;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.item.equipment.trim.TrimMaterial;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class Item
implements FeatureElement,
IMaterial {
    public static final Codec<Holder<Item>> e = BuiltInRegistries.h.r().validate(var0 -> var0.a(Items.a.e()) ? DataResult.error(() -> "Item must not be minecraft:air") : DataResult.success((Object)var0));
    public static final StreamCodec<RegistryFriendlyByteBuf, Holder<Item>> f = ByteBufCodecs.b(Registries.R);
    private static final Logger a = LogUtils.getLogger();
    public static final Map<Block, Item> g = Maps.newHashMap();
    public static final MinecraftKey h = MinecraftKey.b("base_attack_damage");
    public static final MinecraftKey i = MinecraftKey.b("base_attack_speed");
    public static final int j = 64;
    public static final int k = 99;
    public static final int l = 13;
    protected static final int m = 72000;
    private final Holder.c<Item> b = BuiltInRegistries.h.f(this);
    private final DataComponentMap c;
    private final @Nullable Item d;
    protected final String n;
    private final FeatureFlagSet o;

    public static int a(Item var0) {
        return var0 == null ? 0 : BuiltInRegistries.h.a(var0);
    }

    public static Item b(int var0) {
        return BuiltInRegistries.h.a(var0);
    }

    @Deprecated
    public static Item a(Block var0) {
        return g.getOrDefault(var0, Items.a);
    }

    public Item(Info var0) {
        String var1;
        this.n = var0.d();
        this.c = var0.a(IChatBaseComponent.c(this.n), var0.e());
        this.d = var0.d;
        this.o = var0.e;
        if (SharedConstants.aX && !(var1 = this.getClass().getSimpleName()).endsWith("Item")) {
            a.error("Item classes should end with Item and {} doesn't.", (Object)var1);
        }
    }

    @Deprecated
    public Holder.c<Item> e() {
        return this.b;
    }

    public DataComponentMap f() {
        return this.c;
    }

    public int g() {
        return this.c.a(DataComponents.c, 1);
    }

    public void a(World var0, EntityLiving var1, ItemStack var2, int var3) {
    }

    public void a(EntityItem var0) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean a(ItemStack var0, IBlockData var1, World var2, BlockPosition var3, EntityLiving var4) {
        Tool var5 = var0.a(DataComponents.D);
        if (var5 == null) return true;
        if (var5.d()) return true;
        if (!(var4 instanceof EntityHuman)) return true;
        EntityHuman var6 = (EntityHuman)var4;
        if (var6.gL().d) return false;
        return true;
    }

    @Override
    public Item h() {
        return this;
    }

    public EnumInteractionResult a(ItemActionContext var0) {
        return EnumInteractionResult.e;
    }

    public float a(ItemStack var0, IBlockData var1) {
        Tool var2 = var0.a(DataComponents.D);
        return var2 != null ? var2.a(var1) : 1.0f;
    }

    public EnumInteractionResult a(World var0, EntityHuman var1, EnumHand var2) {
        ItemStack var3 = var1.b(var2);
        Consumable var4 = var3.a(DataComponents.z);
        if (var4 != null) {
            return var4.a(var1, var3, var2);
        }
        Equippable var5 = var3.a(DataComponents.H);
        if (var5 != null && var5.h()) {
            return var5.a(var3, var1);
        }
        if (var3.c(DataComponents.M)) {
            var1.c(var2);
            return EnumInteractionResult.c;
        }
        KineticWeapon var6 = var3.a(DataComponents.O);
        if (var6 != null) {
            var1.c(var2);
            var6.b(var1);
            return EnumInteractionResult.c;
        }
        return EnumInteractionResult.e;
    }

    public ItemStack a(ItemStack var0, World var1, EntityLiving var2) {
        Consumable var3 = var0.a(DataComponents.z);
        if (var3 != null) {
            return var3.a(var1, var2, var0);
        }
        return var0;
    }

    public boolean d(ItemStack var0) {
        return var0.n();
    }

    public int e(ItemStack var0) {
        return MathHelper.a(Math.round(13.0f - (float)var0.o() * 13.0f / (float)var0.p()), 0, 13);
    }

    public int f(ItemStack var0) {
        int var1 = var0.p();
        float var2 = Math.max(0.0f, ((float)var1 - (float)var0.o()) / (float)var1);
        return MathHelper.g(var2 / 3.0f, 1.0f, 1.0f);
    }

    public boolean a(ItemStack var0, Slot var1, ClickAction var2, EntityHuman var3) {
        return false;
    }

    public boolean a(ItemStack var0, ItemStack var1, Slot var2, ClickAction var3, EntityHuman var4, SlotAccess var5) {
        return false;
    }

    public float a(Entity var0, float var1, DamageSource var2) {
        return 0.0f;
    }

    @Deprecated
    public @Nullable DamageSource a(EntityLiving var0) {
        return null;
    }

    public void a(ItemStack var0, EntityLiving var1, EntityLiving var2) {
    }

    public void b(ItemStack var0, EntityLiving var1, EntityLiving var2) {
    }

    public boolean a(ItemStack var0, World var1, IBlockData var2, BlockPosition var3, EntityLiving var4) {
        Tool var5 = var0.a(DataComponents.D);
        if (var5 == null) {
            return false;
        }
        if (!var1.B_() && var2.e(var1, var3) != 0.0f && var5.c() > 0) {
            var0.a(var5.c(), var4, EnumItemSlot.a);
        }
        return true;
    }

    public boolean b(ItemStack var0, IBlockData var1) {
        Tool var2 = var0.a(DataComponents.D);
        return var2 != null && var2.b(var1);
    }

    public EnumInteractionResult a(ItemStack var0, EntityHuman var1, EntityLiving var2, EnumHand var3) {
        return EnumInteractionResult.e;
    }

    public String toString() {
        return BuiltInRegistries.h.e(this).g();
    }

    public final ItemStack i() {
        return this.d == null ? ItemStack.l : new ItemStack(this.d);
    }

    public void a(ItemStack var0, WorldServer var1, Entity var2, @Nullable EnumItemSlot var3) {
    }

    public void c(ItemStack var0, EntityHuman var1) {
        this.a(var0, var1.ao());
    }

    public void a(ItemStack var0, World var1) {
    }

    public ItemUseAnimation b(ItemStack var0) {
        Consumable var1 = var0.a(DataComponents.z);
        if (var1 != null) {
            return var1.d();
        }
        if (var0.c(DataComponents.M)) {
            return ItemUseAnimation.d;
        }
        if (var0.c(DataComponents.O)) {
            return ItemUseAnimation.l;
        }
        return ItemUseAnimation.a;
    }

    public int a(ItemStack var0, EntityLiving var1) {
        Consumable var2 = var0.a(DataComponents.z);
        if (var2 != null) {
            return var2.a();
        }
        if (var0.c(DataComponents.M) || var0.c(DataComponents.O)) {
            return 72000;
        }
        return 0;
    }

    public boolean a(ItemStack var0, World var1, EntityLiving var2, int var3) {
        return false;
    }

    @Deprecated
    public void a(ItemStack var0, b var1, TooltipDisplay var2, Consumer<IChatBaseComponent> var3, TooltipFlag var4) {
    }

    public Optional<TooltipComponent> k(ItemStack var0) {
        return Optional.empty();
    }

    @VisibleForTesting
    public final String j() {
        return this.n;
    }

    public final IChatBaseComponent l() {
        return this.c.a(DataComponents.k, CommonComponents.a);
    }

    public IChatBaseComponent a(ItemStack var0) {
        return var0.a().a(DataComponents.k, CommonComponents.a);
    }

    public boolean d_(ItemStack var0) {
        return var0.F();
    }

    protected static MovingObjectPositionBlock a(World var0, EntityHuman var1, RayTrace.FluidCollisionOption var2) {
        Vec3D var3 = var1.bV();
        Vec3D var4 = var3.e(var1.c(var1.ee(), var1.ec()).c(var1.hm()));
        return var0.a(new RayTrace(var3, var4, RayTrace.BlockCollisionOption.b, var2, var1));
    }

    public boolean e_(ItemStack var0) {
        return false;
    }

    public ItemStack m() {
        return new ItemStack(this);
    }

    public boolean d() {
        return true;
    }

    @Override
    public FeatureFlagSet k() {
        return this.o;
    }

    public boolean a(ItemStack var0, @Nullable EntityHuman var1) {
        return false;
    }

    public static class Info {
        private static final DependantName<Item, String> a = var0 -> SystemUtils.a("block", var0.a());
        private static final DependantName<Item, String> b = var0 -> SystemUtils.a("item", var0.a());
        private final DataComponentMap.a c = DataComponentMap.a().a(DataComponents.bb);
        @Nullable Item d;
        FeatureFlagSet e = FeatureFlags.g;
        private @Nullable ResourceKey<Item> f;
        private DependantName<Item, String> g = b;
        private final DependantName<Item, MinecraftKey> h = ResourceKey::a;

        public Info a(FoodInfo var0) {
            return this.a(var0, Consumables.a);
        }

        public Info a(FoodInfo var0, Consumable var1) {
            return this.a(DataComponents.y, var0).a(DataComponents.z, var1);
        }

        public Info a(Item var0) {
            return this.a(DataComponents.A, new UseRemainder(new ItemStack(var0)));
        }

        public Info a(float var0) {
            return this.a(DataComponents.B, new UseCooldown(var0));
        }

        public Info a(int var0) {
            return this.a(DataComponents.c, var0);
        }

        public Info b(int var0) {
            this.a(DataComponents.d, var0);
            this.a(DataComponents.c, 1);
            this.a(DataComponents.e, 0);
            return this;
        }

        public Info b(Item var0) {
            this.d = var0;
            return this;
        }

        public Info a(EnumItemRarity var0) {
            return this.a(DataComponents.n, var0);
        }

        public Info a() {
            return this.a(DataComponents.C, new DamageResistant(DamageTypeTags.i));
        }

        public Info a(ResourceKey<JukeboxSong> var0) {
            return this.a(DataComponents.al, new JukeboxPlayable(new EitherHolder<JukeboxSong>(var0)));
        }

        public Info c(int var0) {
            return this.a(DataComponents.G, new Enchantable(var0));
        }

        public Info c(Item var0) {
            return this.a(DataComponents.I, new Repairable(HolderSet.a(var0.e())));
        }

        public Info a(TagKey<Item> var0) {
            HolderGetter<Item> var1 = BuiltInRegistries.a(BuiltInRegistries.h);
            return this.a(DataComponents.I, new Repairable(var1.b(var0)));
        }

        public Info a(EnumItemSlot var0) {
            return this.a(DataComponents.H, Equippable.a(var0).a());
        }

        public Info b(EnumItemSlot var0) {
            return this.a(DataComponents.H, Equippable.a(var0).b(false).a());
        }

        public Info a(ToolMaterial var0, TagKey<Block> var1, float var2, float var3, float var4) {
            return var0.a(this, var1, var2, var3, var4);
        }

        public Info a(ToolMaterial var0, float var1, float var2) {
            return this.a(var0, TagsBlock.bP, var1, var2, 0.0f);
        }

        public Info b(ToolMaterial var0, float var1, float var2) {
            return this.a(var0, TagsBlock.bN, var1, var2, 5.0f);
        }

        public Info c(ToolMaterial var0, float var1, float var2) {
            return this.a(var0, TagsBlock.bO, var1, var2, 0.0f);
        }

        public Info d(ToolMaterial var0, float var1, float var2) {
            return this.a(var0, TagsBlock.bQ, var1, var2, 0.0f);
        }

        public Info e(ToolMaterial var0, float var1, float var2) {
            return var0.a(this, var1, var2);
        }

        public Info a(ToolMaterial var0, float var1, float var2, float var3, float var4, float var5, float var6, float var7, float var8, float var9) {
            return this.b(var0.b()).a(var0.f()).c(var0.e()).a(DataComponents.j, new EitherHolder<DamageType>(DamageTypes.E)).a(DataComponents.O, new KineticWeapon(10, (int)(var3 * 20.0f), KineticWeapon.a.a((int)(var4 * 20.0f), var5), KineticWeapon.a.a((int)(var6 * 20.0f), var7), KineticWeapon.a.b((int)(var8 * 20.0f), var9), 0.38f, var2, Optional.of(var0 == ToolMaterial.a ? SoundEffects.Bg : SoundEffects.Bd), Optional.of(var0 == ToolMaterial.a ? SoundEffects.Bh : SoundEffects.Be))).a(DataComponents.N, new PiercingWeapon(true, false, Optional.of(var0 == ToolMaterial.a ? SoundEffects.Bi : SoundEffects.Bf), Optional.of(var0 == ToolMaterial.a ? SoundEffects.Bh : SoundEffects.Be))).a(DataComponents.F, new AttackRange(2.0f, 4.5f, 2.0f, 6.5f, 0.125f, 0.5f)).a(DataComponents.i, Float.valueOf(1.0f)).a(DataComponents.P, new SwingAnimation(SwingAnimationType.c, (int)(var1 * 20.0f))).a(ItemAttributeModifiers.a().a(GenericAttributes.d, new AttributeModifier(h, 0.0f + var0.d(), AttributeModifier.Operation.a), EquipmentSlotGroup.b).a(GenericAttributes.f, new AttributeModifier(i, (double)(1.0f / var1) - 4.0, AttributeModifier.Operation.a), EquipmentSlotGroup.b).a()).a(DataComponents.g, new UseEffects(true, false, 1.0f)).a(DataComponents.E, new Weapon(1));
        }

        public Info a(EntityTypes<?> var0) {
            return this.a(DataComponents.af, TypedEntityData.a(var0, new NBTTagCompound()));
        }

        public Info a(ArmorMaterial var0, ArmorType var1) {
            return this.b(var1.a(var0.a())).a(var0.a(var1)).c(var0.c()).a(DataComponents.H, Equippable.a(var1.a()).a(var0.d()).a(var0.h()).a()).a(var0.g());
        }

        public Info a(ArmorMaterial var0) {
            return this.b(ArmorType.e.a(var0.a())).a(var0.a(ArmorType.e)).a(var0.g()).a(DataComponents.H, Equippable.a(EnumItemSlot.g).a(var0.d()).a(var0.h()).a(HolderSet.a(EntityTypes.bU.r())).e(true).b(BuiltInRegistries.b.e(SoundEffects.aA)).a()).a(DataComponents.aB, SoundEffects.Gb).a(1);
        }

        public Info b(ArmorMaterial var0) {
            HolderGetter<EntityTypes<?>> var1 = BuiltInRegistries.a(BuiltInRegistries.g);
            return this.a(var0.a(ArmorType.e)).a(DataComponents.H, Equippable.a(EnumItemSlot.g).a(SoundEffects.oG).a(var0.h()).a(var1.b(TagsEntity.M)).c(false).e(true).b(SoundEffects.oH).a()).a(1);
        }

        public Info c(ArmorMaterial var0) {
            HolderGetter<EntityTypes<?>> var1 = BuiltInRegistries.a(BuiltInRegistries.g);
            return this.a(var0.a(ArmorType.e)).a(DataComponents.H, Equippable.a(EnumItemSlot.g).a(SoundEffects.aB).a(var0.h()).a(var1.b(TagsEntity.N)).c(false).d(true).e(true).b(SoundEffects.aC).a()).a(1);
        }

        public Info b(ResourceKey<TrimMaterial> var0) {
            return this.a(DataComponents.aj, new ProvidesTrimMaterial(var0));
        }

        public Info a(FeatureFlag ... var0) {
            this.e = FeatureFlags.e.a(var0);
            return this;
        }

        public Info c(ResourceKey<Item> var0) {
            this.f = var0;
            return this;
        }

        public Info a(String var0) {
            this.g = DependantName.fixed(var0);
            return this;
        }

        public Info b() {
            this.g = a;
            return this;
        }

        public Info c() {
            this.g = b;
            return this;
        }

        protected String d() {
            return this.g.get(Objects.requireNonNull(this.f, "Item id not set"));
        }

        public MinecraftKey e() {
            return this.h.get(Objects.requireNonNull(this.f, "Item id not set"));
        }

        public <T> Info a(DataComponentType<T> var0, T var1) {
            this.c.a(var0, var1);
            return this;
        }

        public Info a(ItemAttributeModifiers var0) {
            return this.a(DataComponents.r, var0);
        }

        DataComponentMap a(IChatBaseComponent var0, MinecraftKey var1) {
            DataComponentMap var2 = this.c.a(DataComponents.k, var0).a(DataComponents.l, var1).a();
            if (var2.c(DataComponents.e) && var2.a(DataComponents.c, 1) > 1) {
                throw new IllegalStateException("Item cannot have both durability and be stackable");
            }
            return var2;
        }
    }

    public static interface b {
        public static final b a = new b(){

            @Override
            public @Nullable HolderLookup.a a() {
                return null;
            }

            @Override
            public float b() {
                return 20.0f;
            }

            @Override
            public @Nullable WorldMap a(MapId var0) {
                return null;
            }

            @Override
            public boolean c() {
                return false;
            }
        };

        public @Nullable HolderLookup.a a();

        public float b();

        public @Nullable WorldMap a(MapId var1);

        public boolean c();

        public static b a(final @Nullable World var0) {
            if (var0 == null) {
                return a;
            }
            return new b(){

                @Override
                public HolderLookup.a a() {
                    return var0.J_();
                }

                @Override
                public float b() {
                    return var0.y().f();
                }

                @Override
                public WorldMap a(MapId var02) {
                    return var0.a(var02);
                }

                @Override
                public boolean c() {
                    return var0.av() == EnumDifficulty.a;
                }
            };
        }

        public static b a(final HolderLookup.a var0) {
            return new b(){

                @Override
                public HolderLookup.a a() {
                    return var0;
                }

                @Override
                public float b() {
                    return 20.0f;
                }

                @Override
                public @Nullable WorldMap a(MapId var02) {
                    return null;
                }

                @Override
                public boolean c() {
                    return false;
                }
            };
        }
    }
}

